/*
 * Decompiled with CFR 0.152.
 */
package com.citrus.debug;

import android.util.Log;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class DebugLogConfig {
    static DalvikLogHandler activeHandler;

    public static void enable() {
        try {
            String config = "org.apache.http.impl.conn.level = FINEST\norg.apache.http.impl.client.level = FINEST\norg.apache.http.client.level = FINEST\norg.apache.http.level = FINEST";
            ByteArrayInputStream in = new ByteArrayInputStream(config.getBytes());
            LogManager.getLogManager().readConfiguration(in);
        }
        catch (IOException e) {
            Log.w((String)DebugLogConfig.class.getSimpleName(), (String)"Can't read configuration file for logging");
        }
        Logger rootLogger = LogManager.getLogManager().getLogger("");
        activeHandler = new DalvikLogHandler();
        activeHandler.setLevel(Level.ALL);
        rootLogger.addHandler(activeHandler);
    }

    protected static class DalvikLogHandler
    extends Handler {
        private static final String LOG_TAG = "HttpClient";

        protected DalvikLogHandler() {
        }

        @Override
        public void close() {
        }

        @Override
        public void flush() {
        }

        @Override
        public void publish(LogRecord record) {
            if (record.getLoggerName().startsWith("org.apache")) {
                Log.d((String)LOG_TAG, (String)record.getMessage());
            }
        }
    }
}

