/*
 * Decompiled with CFR 0.152.
 */
package com.citrus.sdk.payment;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import com.citrus.card.DateUtils;
import com.citrus.sdk.classes.Month;
import com.citrus.sdk.classes.PGHealth;
import com.citrus.sdk.classes.Utils;
import com.citrus.sdk.classes.Year;
import com.citrus.sdk.payment.PaymentOption;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class CardOption
extends PaymentOption {
    protected String cardHolderName = null;
    protected String cardNumber = null;
    protected String cardCVV = null;
    protected String cardExpiry = null;
    protected String cardExpiryMonth = null;
    protected String cardExpiryYear = null;
    protected CardScheme cardScheme = null;
    protected String nickName = null;

    CardOption(String cardHolderName, String cardNumber, String cardCVV, Month cardExpiryMonth, Year cardExpiryYear) {
        this.cardHolderName = !TextUtils.isEmpty((CharSequence)cardHolderName) ? Utils.removeSpecialCharacters(cardHolderName) : "Card Holder Name";
        this.cardNumber = CardOption.normalizeCardNumber(cardNumber);
        this.cardCVV = cardCVV;
        this.cardScheme = CardScheme.getCardSchemeUsingNumber(cardNumber);
        if (cardExpiryMonth != null) {
            this.cardExpiryMonth = cardExpiryMonth.toString();
        }
        if (cardExpiryYear != null) {
            this.cardExpiryYear = cardExpiryYear.toString();
        }
        if (!TextUtils.isEmpty((CharSequence)this.cardExpiryMonth) && !TextUtils.isEmpty((CharSequence)this.cardExpiryYear)) {
            this.cardExpiry = (Object)((Object)cardExpiryMonth) + "/" + (Object)((Object)cardExpiryYear);
        }
    }

    CardOption(String token, String cardCVV) {
        this.token = token;
        this.cardCVV = cardCVV;
    }

    CardOption(String cardNumber, CardScheme cardScheme) {
        this.cardNumber = cardNumber;
        this.cardScheme = cardScheme;
    }

    CardOption() {
    }

    CardOption(String name, String token, String cardHolderName, String cardNumber, CardScheme cardScheme, String cardExpiry) {
        super(name, token);
        this.cardHolderName = !TextUtils.isEmpty((CharSequence)cardHolderName) ? Utils.removeSpecialCharacters(cardHolderName) : "Card Holder Name";
        this.cardNumber = CardOption.normalizeCardNumber(cardNumber);
        this.cardExpiry = cardExpiry;
        this.cardScheme = cardScheme;
        if (!TextUtils.isEmpty((CharSequence)cardExpiry)) {
            this.cardExpiryMonth = TextUtils.substring((CharSequence)cardExpiry, (int)0, (int)2);
            this.cardExpiryYear = TextUtils.substring((CharSequence)cardExpiry, (int)2, (int)cardExpiry.length());
        }
    }

    public abstract String getCardType();

    public String getCardHolderName() {
        return this.cardHolderName;
    }

    public String getNickName() {
        return this.getName();
    }

    public String getCardExpiryYear() {
        return this.cardExpiryYear;
    }

    public String getCardExpiry() {
        return this.cardExpiry;
    }

    public String getCardExpiryMonth() {
        return this.cardExpiryMonth;
    }

    public String getCardCVV() {
        return this.cardCVV;
    }

    public void setCardCVV(String cardCVV) {
        this.cardCVV = cardCVV;
    }

    public String getCardNumber() {
        return this.cardNumber;
    }

    public CardScheme getCardScheme() {
        return this.cardScheme;
    }

    public void setNickName(String nickName) {
        this.nickName = Utils.removeSpecialCharacters(nickName);
    }

    @Override
    public PGHealth getPgHealth() {
        return PGHealth.GOOD;
    }

    private static String normalizeCardNumber(String number) {
        if (number == null) {
            return null;
        }
        return number.trim().replaceAll("\\s+|-", "");
    }

    public String getLast4Digits() {
        int length;
        String last4Digits = null;
        if (!TextUtils.isEmpty((CharSequence)this.cardNumber) && (length = this.cardNumber.length()) - 4 > 0) {
            last4Digits = this.cardNumber.substring(length - 4, length);
        }
        return last4Digits;
    }

    @Override
    public Drawable getOptionIcon(Context context) {
        Drawable drawable2 = null;
        int resourceId = 0;
        if (this.cardScheme == CardScheme.VISA) {
            resourceId = context.getResources().getIdentifier("visa", "drawable", context.getPackageName());
        } else if (this.cardScheme == CardScheme.MASTER_CARD) {
            resourceId = context.getResources().getIdentifier("mcrd", "drawable", context.getPackageName());
        } else if (this.cardScheme == CardScheme.MAESTRO) {
            resourceId = context.getResources().getIdentifier("mtro", "drawable", context.getPackageName());
        } else if (this.cardScheme == CardScheme.DINERS) {
            resourceId = context.getResources().getIdentifier("dinerclub", "drawable", context.getPackageName());
        } else if (this.cardScheme == CardScheme.JCB) {
            resourceId = context.getResources().getIdentifier("jcb", "drawable", context.getPackageName());
        } else if (this.cardScheme == CardScheme.AMEX) {
            resourceId = context.getResources().getIdentifier("amex", "drawable", context.getPackageName());
        } else if (this.cardScheme == CardScheme.DISCOVER) {
            resourceId = context.getResources().getIdentifier("discover", "drawable", context.getPackageName());
        }
        if (resourceId == 0) {
            resourceId = context.getResources().getIdentifier("default_card", "drawable", context.getPackageName());
            if (resourceId != 0) {
                drawable2 = context.getResources().getDrawable(resourceId);
            }
        } else {
            drawable2 = context.getResources().getDrawable(resourceId);
        }
        return drawable2;
    }

    @Override
    public String toString() {
        return super.toString() + "CardOption{" + "cardHolderName='" + this.cardHolderName + '\'' + ", cardNumber='" + this.cardNumber + '\'' + ", cardCVV='" + this.cardCVV + '\'' + ", cardExpiry='" + this.cardExpiry + '\'' + ", cardExpiryMonth='" + this.cardExpiryMonth + '\'' + ", cardExpiryYear='" + this.cardExpiryYear + '\'' + ", cardScheme='" + (Object)((Object)this.cardScheme) + '\'' + '}';
    }

    public int getCVVLength() {
        int cvvLength = 3;
        if (this.cardScheme == CardScheme.AMEX) {
            cvvLength = 4;
        }
        return cvvLength;
    }

    public boolean validateCard() {
        if (!TextUtils.isEmpty((CharSequence)this.token)) {
            return this.validateCVV();
        }
        if (this.cardScheme == CardScheme.MAESTRO) {
            return this.validateCardNumber();
        }
        return this.validateCardNumber() && this.validateExpiryDate() && this.validateCVV();
    }

    public boolean validateForSaveCard() {
        if (this.cardScheme == CardScheme.MAESTRO) {
            return this.validateCardNumber();
        }
        return this.validateCardNumber() && this.validateExpiryDate();
    }

    public boolean validateCardNumber() {
        if (TextUtils.isEmpty((CharSequence)this.cardNumber)) {
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)this.cardNumber) || !TextUtils.isDigitsOnly((CharSequence)this.cardNumber) || !this.isValidLuhnNumber(this.cardNumber)) {
            return false;
        }
        return !(this.cardScheme == CardScheme.AMEX ? this.cardNumber.length() != 15 : (this.cardScheme == CardScheme.VISA ? this.cardNumber.length() != 13 && this.cardNumber.length() != 16 : (this.cardScheme != CardScheme.MAESTRO ? this.cardNumber.length() != 16 : this.cardNumber.length() < 12 || this.cardNumber.length() > 19)));
    }

    public boolean validateExpiryDate() {
        if (!this.validateExpMonth()) {
            return false;
        }
        if (!this.validateExpYear()) {
            return false;
        }
        return !DateUtils.hasMonthPassed(Integer.valueOf(this.cardExpiryYear), Integer.valueOf(this.cardExpiryMonth));
    }

    private boolean validateExpMonth() {
        if (this.cardExpiryMonth == null) {
            return false;
        }
        return Integer.valueOf(this.cardExpiryMonth) >= 1 && Integer.valueOf(this.cardExpiryMonth) <= 12;
    }

    private boolean validateExpYear() {
        if (this.cardExpiryYear == null) {
            return false;
        }
        return !DateUtils.hasYearPassed(Integer.valueOf(this.cardExpiryYear));
    }

    public boolean validateCVV() {
        if (TextUtils.isEmpty((CharSequence)this.cardCVV)) {
            return false;
        }
        if (this.cardScheme == CardScheme.AMEX) {
            return this.cardCVV.length() == 4;
        }
        return this.cardCVV.length() == 3;
    }

    public String getCardValidityFailureReasons() {
        String reason = null;
        if (!this.validateCard()) {
            StringBuilder builder = new StringBuilder();
            if (TextUtils.isEmpty((CharSequence)this.token) && !this.validateCardNumber()) {
                builder.append(" Invalid Card Number. ");
            }
            if (TextUtils.isEmpty((CharSequence)this.token) && !this.validateExpiryDate()) {
                builder.append(" Invalid Expiry Date. ");
            }
            if (!this.validateCVV()) {
                builder.append(" Invalid CVV. ");
            }
            reason = builder.toString();
        }
        return reason;
    }

    @Override
    public String getSavePaymentOptionObject() {
        JSONObject object = null;
        try {
            object = new JSONObject();
            JSONArray paymentOptions = new JSONArray();
            JSONObject option = new JSONObject();
            option.put("owner", (Object)this.cardHolderName);
            if (!TextUtils.isEmpty((CharSequence)this.nickName)) {
                option.put("name", (Object)this.nickName);
            }
            option.put("number", (Object)this.cardNumber);
            option.put("scheme", (Object)this.cardScheme.toString());
            option.put("expiryDate", (Object)this.cardExpiry);
            option.put("type", (Object)this.getCardType());
            paymentOptions.put((Object)option);
            object.put("paymentOptions", (Object)paymentOptions);
            object.put("type", (Object)"payment");
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return object.toString();
    }

    private boolean isValidLuhnNumber(String number) {
        boolean isOdd = true;
        int sum = 0;
        for (int index = number.length() - 1; index >= 0; --index) {
            char c = number.charAt(index);
            if (!Character.isDigit(c)) {
                return false;
            }
            int digitInteger = Integer.parseInt("" + c);
            boolean bl = isOdd = !isOdd;
            if (isOdd) {
                digitInteger *= 2;
            }
            if (digitInteger > 9) {
                digitInteger -= 9;
            }
            sum += digitInteger;
        }
        return sum % 10 == 0;
    }

    public static enum CardScheme {
        VISA{

            @Override
            public String getName() {
                return "visa";
            }
        }
        ,
        MASTER_CARD{

            @Override
            public String getName() {
                return "mcrd";
            }
        }
        ,
        MAESTRO{

            @Override
            public String getName() {
                return "mtro";
            }
        }
        ,
        DINERS{

            @Override
            public String getName() {
                return "DINERS";
            }
        }
        ,
        JCB{

            @Override
            public String getName() {
                return "jcb";
            }
        }
        ,
        AMEX{

            @Override
            public String getName() {
                return "amex";
            }
        }
        ,
        DISCOVER{

            @Override
            public String getName() {
                return "DISCOVER";
            }
        };


        public static CardScheme getCardScheme(String cardScheme) {
            if ("visa".equalsIgnoreCase(cardScheme)) {
                return VISA;
            }
            if ("mcrd".equalsIgnoreCase(cardScheme)) {
                return MASTER_CARD;
            }
            if ("mtro".equalsIgnoreCase(cardScheme)) {
                return MAESTRO;
            }
            if ("DINERS".equalsIgnoreCase(cardScheme)) {
                return DINERS;
            }
            if ("jcb".equalsIgnoreCase(cardScheme)) {
                return JCB;
            }
            if ("amex".equalsIgnoreCase(cardScheme)) {
                return AMEX;
            }
            if ("DISCOVER".equalsIgnoreCase(cardScheme)) {
                return DISCOVER;
            }
            return null;
        }

        public static CardScheme getCardSchemeUsingNumber(String cardNumber) {
            com.citrus.card.CardType cardType = com.citrus.card.CardType.typeOf(CardOption.normalizeCardNumber(cardNumber));
            CardScheme cardScheme = null;
            if (cardType != null) {
                switch (cardType) {
                    case VISA: {
                        cardScheme = VISA;
                        break;
                    }
                    case MCRD: {
                        cardScheme = MASTER_CARD;
                        break;
                    }
                    case MTRO: {
                        cardScheme = MAESTRO;
                        break;
                    }
                    case DINERS: {
                        cardScheme = DINERS;
                        break;
                    }
                    case DISCOVER: {
                        cardScheme = DISCOVER;
                        break;
                    }
                    case AMEX: {
                        cardScheme = AMEX;
                        break;
                    }
                    case JCB: {
                        cardScheme = JCB;
                    }
                }
            }
            return cardScheme;
        }

        public static int getCVVLength(String cardNumber) {
            CardScheme scheme = CardScheme.getCardSchemeUsingNumber(cardNumber);
            if (scheme == AMEX) {
                return 4;
            }
            return 3;
        }

        public abstract String getName();
    }

    public static enum CardType {
        DEBIT{

            @Override
            public String getCardType() {
                return "debit";
            }
        }
        ,
        CREDIT{

            @Override
            public String getCardType() {
                return "credit";
            }
        };


        public abstract String getCardType();
    }
}

