/*
 * Decompiled with CFR 0.152.
 */
package com.citrus.sdk;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.AlertDialog;
import android.app.ProgressDialog;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.net.http.SslError;
import android.os.Build;
import android.os.Bundle;
import android.os.CountDownTimer;
import android.os.Handler;
import android.os.Parcelable;
import android.support.v4.content.LocalBroadcastManager;
import android.support.v7.app.ActionBar;
import android.support.v7.app.ActionBarActivity;
import android.text.Html;
import android.text.TextUtils;
import android.text.method.PasswordTransformationMethod;
import android.text.method.TransformationMethod;
import android.view.View;
import android.view.Window;
import android.view.inputmethod.InputMethodManager;
import android.webkit.CookieManager;
import android.webkit.JavascriptInterface;
import android.webkit.SslErrorHandler;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.EditText;
import android.widget.ImageView;
import com.citrus.analytics.EventsManager;
import com.citrus.analytics.WebViewEvents;
import com.citrus.cash.LoadMoney;
import com.citrus.cash.PersistentConfig;
import com.citrus.cash.Prepaid;
import com.citrus.library.R;
import com.citrus.mobile.Config;
import com.citrus.payment.Bill;
import com.citrus.payment.PG;
import com.citrus.payment.UserDetails;
import com.citrus.sdk.Callback;
import com.citrus.sdk.CitrusClient;
import com.citrus.sdk.CitrusUser;
import com.citrus.sdk.PaymentParams;
import com.citrus.sdk.TransactionResponse;
import com.citrus.sdk.classes.Amount;
import com.citrus.sdk.classes.BinServiceResponse;
import com.citrus.sdk.classes.CitrusConfig;
import com.citrus.sdk.classes.Utils;
import com.citrus.sdk.dynamicPricing.DynamicPricingResponse;
import com.citrus.sdk.otp.NetBankForOTP;
import com.citrus.sdk.otp.OTPPopupView;
import com.citrus.sdk.otp.OTPViewListener;
import com.citrus.sdk.otp.SMSReceiver;
import com.citrus.sdk.payment.CardOption;
import com.citrus.sdk.payment.NetbankingOption;
import com.citrus.sdk.payment.PaymentBill;
import com.citrus.sdk.payment.PaymentOption;
import com.citrus.sdk.payment.PaymentType;
import com.citrus.sdk.response.CitrusError;
import com.citrus.sdk.response.CitrusResponse;
import com.orhanobut.logger.Logger;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class CitrusActivity
extends ActionBarActivity
implements OTPViewListener {
    private final int WAIT_TIME = 300;
    private final String WAIT_MESSAGE = "Processing Payment. Please Wait...";
    private final String CANCEL_MESSAGE = "Cancelling Transaction. Please Wait...";
    private WebView mPaymentWebview = null;
    private Context mContext = this;
    private ProgressDialog mProgressDialog = null;
    @Deprecated
    private PaymentParams mPaymentParams = null;
    private PaymentType mPaymentType = null;
    private PaymentOption mPaymentOption = null;
    private String mTransactionId = null;
    private ActionBar mActionBar = null;
    private String mColorPrimary = null;
    private String mColorPrimaryDark = null;
    private String mTextColorPrimary = null;
    private CitrusConfig mCitrusConfig = null;
    private CitrusUser mCitrusUser = null;
    private String sessionCookie;
    private CookieManager cookieManager;
    private String mpiServletUrl = null;
    private Map<String, String> customParametersOriginalMap = null;
    private CitrusClient mCitrusClient = null;
    private String mActivityTitle = null;
    private int mRequestCode = -1;
    private CountDownTimer mTimer = null;
    private boolean mLoading = false;
    private boolean mShowingDialog = false;
    private boolean isBackKeyPressedByUser = false;
    private boolean passwordPromptShown = false;
    private DynamicPricingResponse dynamicPricingResponse = null;
    private SMSReceiver mSMSReceiver = null;
    private BroadcastReceiver mAutoOtpSMSReceiveListener = null;
    private OTPPopupView mOTPPopupView = null;
    private String otpProcessTransactionJS = null;
    private ImageView otpPopupCancelImgView = null;
    private boolean autoOTPEnabled = false;
    private NetBankForOTP netBankForOTP = NetBankForOTP.UNKNOWN;
    private String otp;
    private static final long OTP_READ_TIMEOUT = 45000L;
    private boolean transactionProcessed = false;
    private boolean mMultipartSendOTPJS = false;
    private boolean mMultipartEnterPasswordJS = false;

    protected void onCreate(Bundle savedInstanceState) {
        this.mPaymentType = (PaymentType)this.getIntent().getParcelableExtra("INTENT_EXTRA_PAYMENT_TYPE");
        this.mRequestCode = this.getIntent().getIntExtra("INTENT_EXTRA_REQUEST_CODE_PAYMENT", -1);
        this.mCitrusClient = CitrusClient.getInstance(this.mContext);
        this.autoOTPEnabled = this.mCitrusClient.isAutoOtpReading();
        if (!(this.mPaymentType instanceof PaymentType.CitrusCash)) {
            this.setTheme(R.style.Base_Theme_AppCompat_Light_DarkActionBar);
        }
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_citrus);
        this.mOTPPopupView = (OTPPopupView)this.findViewById(R.id.otpPopupViewId);
        this.otpPopupCancelImgView = (ImageView)this.findViewById(R.id.otpPopupCancelImgViewId);
        this.otpPopupCancelImgView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (CitrusActivity.this.mOTPPopupView.getOtpViewToggleStatus()) {
                    CitrusActivity.this.mOTPPopupView.setVisibility(0);
                    CitrusActivity.this.mOTPPopupView.setOtpViewToggleStatus(false);
                    CitrusActivity.this.otpPopupCancelImgView.setBackgroundResource(R.drawable.arrow_down_icon);
                    CitrusActivity.this.findViewById(R.id.otpPopupSeparatorId).setVisibility(0);
                    CitrusActivity.this.findViewById(R.id.otpPopupOverlayId).setVisibility(0);
                } else {
                    CitrusActivity.this.mOTPPopupView.setVisibility(8);
                    CitrusActivity.this.mOTPPopupView.setOtpViewToggleStatus(true);
                    CitrusActivity.this.otpPopupCancelImgView.setBackgroundResource(R.drawable.arrow_up_icon);
                    CitrusActivity.this.findViewById(R.id.otpPopupSeparatorId).setVisibility(8);
                    CitrusActivity.this.findViewById(R.id.otpPopupOverlayId).setVisibility(8);
                }
            }
        });
        this.mOTPPopupView.setListener(this);
        this.mSMSReceiver = new SMSReceiver();
        this.mAutoOtpSMSReceiveListener = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                CitrusActivity.this.autoOtpReceived(intent);
            }
        };
        this.dynamicPricingResponse = (DynamicPricingResponse)this.getIntent().getParcelableExtra("INTENT_EXTRA_DYNAMIC_PRICING_RESPONSE");
        this.mPaymentParams = (PaymentParams)this.getIntent().getParcelableExtra("INTENT_EXTRA_PAYMENT_PARAMS");
        this.mCitrusConfig = CitrusConfig.getInstance();
        this.mActivityTitle = this.mCitrusConfig.getCitrusActivityTitle();
        this.initializeTimer();
        if (this.mPaymentParams != null) {
            this.mPaymentType = this.mPaymentParams.getPaymentType();
            this.mPaymentOption = this.mPaymentParams.getPaymentOption();
            this.mCitrusUser = this.mPaymentParams.getUser();
            this.mColorPrimary = this.mPaymentParams.getColorPrimary();
            this.mColorPrimaryDark = this.mPaymentParams.getColorPrimaryDark();
            this.mTextColorPrimary = this.mPaymentParams.getTextColorPrimary();
        } else if (this.mPaymentType != null) {
            this.mPaymentOption = this.mPaymentType.getPaymentOption();
            this.mCitrusUser = this.mPaymentType.getCitrusUser();
            this.mColorPrimary = this.mCitrusConfig.getColorPrimary();
            this.mColorPrimaryDark = this.mCitrusConfig.getColorPrimaryDark();
            this.mTextColorPrimary = this.mCitrusConfig.getTextColorPrimary();
        } else {
            throw new IllegalArgumentException("Payment Type Should not be null");
        }
        this.registerSMSReceivers();
        String emailId = this.mCitrusClient.getUserEmailId();
        String mobileNo = this.mCitrusClient.getUserMobileNumber();
        if (this.mPaymentType instanceof PaymentType.LoadMoney || this.mPaymentType instanceof PaymentType.CitrusCash) {
            if (this.mCitrusClient.getCitrusUser() != null) {
                this.mCitrusUser = this.mCitrusClient.getCitrusUser();
            } else if (this.mCitrusUser == null) {
                this.mCitrusUser = new CitrusUser(emailId, mobileNo);
            }
        } else if (this.mCitrusUser == null) {
            this.mCitrusUser = new CitrusUser(emailId, mobileNo);
        }
        this.mActionBar = this.getSupportActionBar();
        this.mProgressDialog = new ProgressDialog(this.mContext);
        this.mPaymentWebview = (WebView)this.findViewById(R.id.payment_webview);
        this.mPaymentWebview.getSettings().setLayoutAlgorithm(WebSettings.LayoutAlgorithm.NORMAL);
        this.mPaymentWebview.getSettings().setJavaScriptEnabled(true);
        if (this.mPaymentOption instanceof NetbankingOption && ("CID032".equalsIgnoreCase(((NetbankingOption)this.mPaymentOption).getBankCID()) || "CID051".equalsIgnoreCase(((NetbankingOption)this.mPaymentOption).getBankCID()))) {
            this.mPaymentWebview.getSettings().setUseWideViewPort(true);
        }
        if (Build.VERSION.SDK_INT >= 21) {
            this.mPaymentWebview.getSettings().setMixedContentMode(0);
        }
        this.mPaymentWebview.addJavascriptInterface((Object)new JsInterface(), "CitrusResponse");
        this.mPaymentWebview.setWebChromeClient(new WebChromeClient());
        this.mPaymentWebview.setWebViewClient((WebViewClient)new CitrusWebClient());
        if (this.mPaymentType instanceof PaymentType.CitrusCash) {
            this.mPaymentWebview.setVisibility(8);
        }
        if (TextUtils.isEmpty((CharSequence)this.mActivityTitle)) {
            this.mActivityTitle = "Processing...";
        }
        if (this.mCitrusClient.isShowDummyScreenWhilePayments()) {
            this.setTitle((CharSequence)Html.fromHtml((String)("<font color=\"" + this.mTextColorPrimary + "\">" + this.mActivityTitle + "</font>")));
        }
        this.setActionBarBackground();
        if (this.autoOTPEnabled && this.mPaymentOption instanceof CardOption) {
            this.fetchBinRequestData((CardOption)this.mPaymentOption);
        }
        if (this.mRequestCode == 10000 && this.mPaymentOption instanceof CardOption && !((CardOption)this.mPaymentOption).validateCard()) {
            this.sendResult(new TransactionResponse(TransactionResponse.TransactionStatus.FAILED, ((CardOption)this.mPaymentOption).getCardValidityFailureReasons(), null));
            return;
        }
        if (this.mPaymentType instanceof PaymentType.PGPayment || this.mPaymentType instanceof PaymentType.CitrusCash) {
            if (this.mPaymentType.getPaymentBill() != null) {
                if (PaymentBill.toJSONObject(this.mPaymentType.getPaymentBill()) != null) {
                    this.proceedToPayment(PaymentBill.toJSONObject(this.mPaymentType.getPaymentBill()).toString());
                }
            } else {
                if (this.mCitrusClient.isShowDummyScreenWhilePayments()) {
                    this.mPaymentWebview.loadData("<html><body><h5><center>Processing, please wait...<center></h5></body></html>", "text/html", "utf-8");
                }
                this.showDialog("Processing Payment. Please Wait...", true);
                this.fetchBill();
            }
        } else {
            Amount amount = this.mPaymentType.getAmount();
            LoadMoney loadMoney = new LoadMoney(amount.getValue(), this.mPaymentType.getUrl());
            PG paymentgateway = new PG(this.mPaymentOption, loadMoney, new UserDetails(CitrusUser.toJSONObject(this.mCitrusUser)));
            this.showDialog("Processing Payment. Please Wait...", true);
            paymentgateway.load((Activity)this, new com.citrus.mobile.Callback(){

                @Override
                public void onTaskexecuted(String success, String error) {
                    CitrusActivity.this.processresponse(success, error);
                }
            });
        }
        if (TextUtils.isEmpty((CharSequence)this.mActivityTitle)) {
            this.mActivityTitle = "Processing...";
        }
        this.setTitle((CharSequence)Html.fromHtml((String)("<font color=\"" + this.mTextColorPrimary + "\">" + this.mActivityTitle + "</font>")));
        this.setActionBarBackground();
        this.enableWebContentDebugging();
    }

    protected void onResume() {
        super.onResume();
        this.registerSMSReceivers();
    }

    protected void onPause() {
        super.onPause();
        if (this.mAutoOtpSMSReceiveListener != null) {
            this.unregisterSMSReceivers();
        }
    }

    private void initializeTimer() {
        this.mTimer = new CountDownTimer(300L, 100L){

            public void onTick(long millisUntilFinished) {
            }

            public void onFinish() {
                if (!CitrusActivity.this.mLoading) {
                    CitrusActivity.this.dismissDialog();
                    if (!CitrusActivity.this.transactionProcessed && !CitrusActivity.this.mMultipartEnterPasswordJS) {
                        CitrusActivity.this.displayOtpPopup();
                    }
                    if (CitrusActivity.this.mMultipartSendOTPJS) {
                        CitrusActivity.this.mPaymentWebview.loadUrl(CitrusActivity.this.netBankForOTP.getMultiPartSendOTPJS());
                        CitrusActivity.this.mMultipartSendOTPJS = false;
                    }
                    if (CitrusActivity.this.mMultipartEnterPasswordJS) {
                        CitrusActivity.this.mPaymentWebview.loadUrl(CitrusActivity.this.netBankForOTP.getMultiPartEnterPasswordJS());
                        CitrusActivity.this.mMultipartEnterPasswordJS = false;
                    }
                }
            }
        };
    }

    @TargetApi(value=21)
    private void setActionBarBackground() {
        if (this.mColorPrimary != null && this.mActionBar != null) {
            this.mActionBar.setBackgroundDrawable((Drawable)new ColorDrawable(Color.parseColor((String)this.mColorPrimary)));
        }
        if (Build.VERSION.SDK_INT >= 21 && this.mColorPrimaryDark != null) {
            Window window = this.getWindow();
            window.addFlags(Integer.MIN_VALUE);
            window.setStatusBarColor(Color.parseColor((String)this.mColorPrimaryDark));
        }
    }

    private void fetchBill() {
        String billUrl = this.mPaymentType.getUrl();
        billUrl = billUrl.contains("?") ? billUrl + "&amount=" + this.mPaymentType.getAmount().getValue() : billUrl + "?amount=" + this.mPaymentType.getAmount().getValue();
        this.mCitrusClient.getBill(billUrl, this.mPaymentType.getAmount(), new Callback<PaymentBill>(){

            @Override
            public void success(PaymentBill paymentBill) {
                CitrusActivity.this.customParametersOriginalMap = paymentBill.getCustomParametersMap();
                JSONObject billJson = PaymentBill.toJSONObject(paymentBill);
                if (billJson != null) {
                    CitrusActivity.this.proceedToPayment(billJson.toString());
                } else {
                    TransactionResponse transactionResponse = new TransactionResponse(TransactionResponse.TransactionStatus.FAILED, "Invalid bill received from server.", CitrusActivity.this.mTransactionId);
                    CitrusActivity.this.sendResult(transactionResponse);
                }
            }

            @Override
            public void error(CitrusError error) {
                TransactionResponse transactionResponse = new TransactionResponse(TransactionResponse.TransactionStatus.FAILED, error.getMessage(), CitrusActivity.this.mTransactionId);
                CitrusActivity.this.sendResult(transactionResponse);
            }
        });
    }

    private void proceedToPayment(String billJSON) {
        if (this.mPaymentType instanceof PaymentType.CitrusCash) {
            UserDetails userDetails = new UserDetails(CitrusUser.toJSONObject(this.mCitrusUser));
            Prepaid prepaid = new Prepaid(userDetails.getEmail());
            Bill bill = new Bill(billJSON);
            this.mTransactionId = bill.getTxnId();
            PG paymentgateway = new PG(prepaid, bill, userDetails);
            if (bill.getCustomParameters() != null) {
                paymentgateway.setCustomParameters(bill.getCustomParameters());
            }
            paymentgateway.charge(new com.citrus.mobile.Callback(){

                @Override
                public void onTaskexecuted(String success, String error) {
                    CitrusActivity.this.prepaidPayment(success, error);
                }
            });
        } else {
            UserDetails userDetails = new UserDetails(CitrusUser.toJSONObject(this.mCitrusUser));
            Bill bill = new Bill(billJSON);
            this.mTransactionId = bill.getTxnId();
            PG paymentgateway = new PG(this.mPaymentOption, bill, userDetails, this.dynamicPricingResponse);
            paymentgateway.charge(new com.citrus.mobile.Callback(){

                @Override
                public void onTaskexecuted(String success, String error) {
                    CitrusActivity.this.processresponse(success, error);
                }
            });
        }
    }

    private void processresponse(String response, String error) {
        block6: {
            TransactionResponse transactionResponse = null;
            if (!TextUtils.isEmpty((CharSequence)response)) {
                try {
                    JSONObject redirect = new JSONObject(response);
                    this.mpiServletUrl = redirect.optString("redirectUrl");
                    if (!TextUtils.isEmpty((CharSequence)this.mpiServletUrl)) {
                        this.mPaymentWebview.loadUrl(this.mpiServletUrl);
                        if (this.mPaymentOption != null) {
                            EventsManager.logWebViewEvents((Context)this, WebViewEvents.OPEN, this.mPaymentOption.getAnalyticsPaymentType());
                        }
                        break block6;
                    }
                    transactionResponse = new TransactionResponse(TransactionResponse.TransactionStatus.FAILED, response, this.mTransactionId);
                    this.sendResult(transactionResponse);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            } else {
                transactionResponse = new TransactionResponse(TransactionResponse.TransactionStatus.FAILED, error, this.mTransactionId);
                this.sendResult(transactionResponse);
            }
        }
    }

    private void prepaidPayment(String response, String error) {
        block6: {
            TransactionResponse transactionResponse = null;
            if (!TextUtils.isEmpty((CharSequence)response)) {
                try {
                    JSONObject redirect = new JSONObject(response);
                    if (!TextUtils.isEmpty((CharSequence)redirect.getString("redirectUrl"))) {
                        this.setCookie();
                        this.mPaymentWebview.loadUrl(redirect.getString("redirectUrl"));
                        if (this.mPaymentOption != null) {
                            EventsManager.logWebViewEvents((Context)this, WebViewEvents.OPEN, this.mPaymentOption.getAnalyticsPaymentType());
                        }
                        break block6;
                    }
                    transactionResponse = new TransactionResponse(TransactionResponse.TransactionStatus.FAILED, response, this.mTransactionId);
                    this.sendResult(transactionResponse);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            } else {
                transactionResponse = new TransactionResponse(TransactionResponse.TransactionStatus.FAILED, error, this.mTransactionId);
                this.sendResult(transactionResponse);
            }
        }
    }

    private void showDialog(String message, boolean cancelable) {
        if (this.mProgressDialog != null) {
            this.mProgressDialog.setCanceledOnTouchOutside(false);
            this.mProgressDialog.setCancelable(cancelable);
            this.mProgressDialog.setMessage((CharSequence)message);
            this.mProgressDialog.show();
            this.mShowingDialog = true;
        }
    }

    private void dismissDialog() {
        if (this.mProgressDialog != null) {
            this.mProgressDialog.dismiss();
            this.mShowingDialog = false;
        }
    }

    private void registerSMSReceivers() {
        if (this.autoOTPEnabled && this.mPaymentOption instanceof CardOption) {
            Logger.d((String)"Registering SMS receivers", (Object[])new Object[0]);
            if (this.mSMSReceiver == null) {
                this.mSMSReceiver = new SMSReceiver();
            }
            if (this.mAutoOtpSMSReceiveListener == null) {
                this.mAutoOtpSMSReceiveListener = new BroadcastReceiver(){

                    public void onReceive(Context context, Intent intent) {
                        CitrusActivity.this.autoOtpReceived(intent);
                    }
                };
            }
            IntentFilter intentFilter = new IntentFilter("android.provider.Telephony.SMS_RECEIVED");
            intentFilter.setPriority(999);
            this.registerReceiver(this.mSMSReceiver, intentFilter);
            LocalBroadcastManager.getInstance((Context)this).registerReceiver(this.mAutoOtpSMSReceiveListener, new IntentFilter("com.citrus.sdk.otp.AUTO_READ_OTP"));
        }
    }

    private void unregisterSMSReceivers() {
        if (this.autoOTPEnabled && this.mPaymentOption instanceof CardOption) {
            Logger.d((String)"Unregistering SMS receivers", (Object[])new Object[0]);
            if (this.mSMSReceiver != null) {
                this.unregisterReceiver(this.mSMSReceiver);
                this.mSMSReceiver = null;
            }
            if (this.mAutoOtpSMSReceiveListener != null) {
                LocalBroadcastManager.getInstance((Context)this).unregisterReceiver(this.mAutoOtpSMSReceiveListener);
                this.mAutoOtpSMSReceiveListener = null;
            }
        }
    }

    private void autoOtpReceived(Intent intent) {
        this.otp = intent.getStringExtra("INTENT_EXTRA_AUTO_OTP");
        this.otpProcessTransactionJS = String.format(this.netBankForOTP.getTransactionJS(), this.otp);
        Logger.d((String)"OTP : %s, js : %s", (Object[])new Object[]{this.otp, this.otpProcessTransactionJS});
        this.mOTPPopupView.setOTP(this.otp);
    }

    private void displayOtpPopup() {
        if (this.autoOTPEnabled && this.mPaymentOption instanceof CardOption && this.netBankForOTP != NetBankForOTP.UNKNOWN) {
            this.getWindow().addFlags(128);
            this.otpPopupCancelImgView.setVisibility(0);
            this.mOTPPopupView.setVisibility(0);
            this.findViewById(R.id.otpPopupOverlayId).setVisibility(0);
            if (this.netBankForOTP.isBypassEnterPasswordButton()) {
                this.mOTPPopupView.enableEnterPasswordButton(false);
            }
            if (this.netBankForOTP.isBypassSendOTPButton()) {
                this.mOTPPopupView.displayOtpAutoDetectPopup();
                this.startOtpReadTimer();
            }
        }
    }

    private void dismissOtpPopup() {
        this.otpPopupCancelImgView.setVisibility(8);
        this.findViewById(R.id.otpPopupSeparatorId).setVisibility(8);
        this.findViewById(R.id.otpPopupOverlayId).setVisibility(8);
        this.mOTPPopupView.setVisibility(8);
    }

    private void fetchBinRequestData(CardOption cardOption) {
        this.mCitrusClient.getBINDetails(cardOption, new Callback<BinServiceResponse>(){

            @Override
            public void success(BinServiceResponse binServiceResponse) {
                CitrusActivity.this.netBankForOTP = binServiceResponse.getNetBankForOTP();
                Logger.d((String)("netbankForOTP : " + (Object)((Object)CitrusActivity.this.netBankForOTP)), (Object[])new Object[0]);
                CitrusActivity.this.mOTPPopupView.setOtpEditTextLength(CitrusActivity.this.netBankForOTP.getOTPLength());
            }

            @Override
            public void error(CitrusError error) {
            }
        });
    }

    private void enableWebContentDebugging() {
        if (Build.VERSION.SDK_INT >= 19 && 0 != (this.getApplicationInfo().flags &= 2)) {
            WebView.setWebContentsDebuggingEnabled((boolean)true);
        }
    }

    public void onBackPressed() {
        this.handleCancelTransaction();
    }

    private void handleCancelTransaction() {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
        builder.setPositiveButton((CharSequence)"Yes", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int id2) {
                dialog.dismiss();
                CitrusActivity.this.isBackKeyPressedByUser = true;
                if (CitrusActivity.this.mPaymentType instanceof PaymentType.CitrusCash || !Utils.isNetworkConnected(CitrusActivity.this.mContext)) {
                    TransactionResponse transactionResponse = new TransactionResponse(TransactionResponse.TransactionStatus.CANCELLED, "Cancelled By User", CitrusActivity.this.mTransactionId);
                    CitrusActivity.this.sendResult(transactionResponse);
                } else {
                    CitrusActivity.this.mPaymentWebview.loadUrl(CitrusActivity.this.mpiServletUrl);
                    CitrusActivity.this.dismissOtpPopup();
                }
            }
        });
        builder.setNegativeButton((CharSequence)"No", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int id2) {
            }
        });
        builder.setMessage((CharSequence)"Do you want to cancel the transaction?").setTitle((CharSequence)"Cancel Transaction?");
        AlertDialog dialog = builder.create();
        dialog.setCanceledOnTouchOutside(false);
        dialog.show();
    }

    private void setCookie() {
        this.cookieManager = CookieManager.getInstance();
        this.sessionCookie = new PersistentConfig((Context)this).getCookieString();
        this.cookieManager.setCookie(Config.getBaseURL(), this.sessionCookie);
    }

    private static void removeCookies() {
        String setCookie = CookieManager.getInstance().getCookie(Config.getBaseURL());
        CookieManager.getInstance().setCookie(Config.getBaseURL(), "prepaiduser-payauth=''");
    }

    private void sendResult(TransactionResponse transactionResponse) {
        if (this.mPaymentOption != null) {
            if (this.isBackKeyPressedByUser) {
                EventsManager.logWebViewEvents((Context)this, WebViewEvents.BACK_KEY, this.mPaymentOption.getAnalyticsPaymentType());
            } else {
                EventsManager.logWebViewEvents((Context)this, WebViewEvents.CLOSE, this.mPaymentOption.getAnalyticsPaymentType());
            }
            if (transactionResponse.getTransactionStatus() == TransactionResponse.TransactionStatus.FAILED) {
                EventsManager.logPaymentEvents((Context)this, this.mPaymentOption.getAnalyticsPaymentType(), transactionResponse.getMessage());
            } else {
                EventsManager.logPaymentEvents((Context)this, this.mPaymentOption.getAnalyticsPaymentType(), transactionResponse.getAnalyticsTransactionType());
            }
        }
        Intent intent = new Intent();
        intent.putExtra("INTENT_EXTRA_TRANSACTION_RESPONSE", (Parcelable)transactionResponse);
        intent.setAction(this.mPaymentType.getIntentAction());
        if (this.mRequestCode != 10000) {
            LocalBroadcastManager.getInstance((Context)this.mContext).sendBroadcast(intent);
        }
        this.setResult(-1, intent);
        this.finish();
    }

    protected void onStop() {
        super.onStop();
        this.dismissDialog();
    }

    public void onDestroy() {
        super.onDestroy();
        if (this.mPaymentWebview != null) {
            this.mPaymentWebview.stopLoading();
            this.mPaymentWebview.destroy();
        }
        this.mPaymentWebview = null;
        this.mPaymentType = null;
        this.mPaymentParams = null;
        this.mCitrusConfig = null;
        this.mCitrusUser = null;
        this.mTransactionId = null;
        this.dismissDialog();
        this.netBankForOTP = NetBankForOTP.UNKNOWN;
        this.mProgressDialog = null;
        this.mPaymentOption = null;
        this.mActivityTitle = null;
        this.transactionProcessed = false;
        this.mMultipartSendOTPJS = false;
    }

    @Override
    public void onSendOtpClicked() {
        this.mMultipartSendOTPJS = this.netBankForOTP.isMultipartSendOTPJS();
        this.mPaymentWebview.loadUrl(this.netBankForOTP.getSendOTPJS());
        this.mOTPPopupView.displayOtpAutoDetectPopup();
        this.startOtpReadTimer();
    }

    @Override
    public void onEnterPasswordClicked() {
        this.mMultipartEnterPasswordJS = this.netBankForOTP.isMultipartEnterPasswordJS();
        String enterPwdJS = this.netBankForOTP.getEnterPasswordJS();
        this.mPaymentWebview.loadUrl(enterPwdJS);
        this.dismissOtpPopup();
    }

    @Override
    public void onCancelClicked() {
        this.handleCancelTransaction();
    }

    @Override
    public void onProcessTransactionClicked(String otp) {
        this.mPaymentWebview.loadUrl(this.netBankForOTP.getSetOTPJS(otp));
        String js = String.format(this.netBankForOTP.getTransactionJS(), otp);
        this.mPaymentWebview.loadUrl(js);
        this.transactionProcessed = true;
        this.dismissOtpPopup();
    }

    @Override
    public void onResendOTPClicked() {
        this.mPaymentWebview.loadUrl(this.netBankForOTP.getReSendOTPJS());
        this.registerSMSReceivers();
        this.startOtpReadTimer();
    }

    @Override
    public void startOtpReadTimer() {
        this.mOTPPopupView.handleResendOTP();
        Handler handler = new Handler();
        handler.postDelayed(new Runnable(){

            @Override
            public void run() {
                CitrusActivity.this.unregisterSMSReceivers();
                CitrusActivity.this.mOTPPopupView.otpReadTimeout();
            }
        }, 45000L);
    }

    private void showPrompt() {
        AlertDialog.Builder alert = new AlertDialog.Builder(this.mContext);
        String message = null;
        String title = null;
        if (this.passwordPromptShown) {
            message = "Incorrect Password.";
            title = "Please Enter Password Again.";
        } else {
            message = "Please Enter Your Password For Citrus Account.";
            title = "Enter Password";
        }
        String positiveButtonText = "Pay";
        alert.setTitle((CharSequence)title);
        alert.setMessage((CharSequence)message);
        final EditText input = new EditText(this.mContext);
        input.setTransformationMethod((TransformationMethod)PasswordTransformationMethod.getInstance());
        alert.setView((View)input);
        alert.setPositiveButton((CharSequence)positiveButtonText, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int whichButton) {
                String password = input.getText().toString();
                if (!TextUtils.isEmpty((CharSequence)password)) {
                    CitrusActivity.this.mPaymentWebview.loadUrl("javascript:(function() { document.getElementById('password').value='" + password + "';" + "document.getElementById(\"verify\").submit();" + "}) ()");
                    input.clearFocus();
                    InputMethodManager imm = (InputMethodManager)CitrusActivity.this.getSystemService("input_method");
                    imm.hideSoftInputFromWindow(input.getWindowToken(), 0);
                    String emailId = CitrusActivity.this.mCitrusClient.getUserEmailId();
                    CitrusActivity.this.getCookie(emailId, password);
                    dialog.dismiss();
                }
            }
        });
        alert.setNegativeButton((CharSequence)"Cancel", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int whichButton) {
                CitrusActivity.this.onBackPressed();
            }
        });
        input.requestFocus();
        alert.show();
    }

    private void getCookie(String emailId, String password) {
        this.mCitrusClient.getCookie(emailId, password, new Callback<CitrusResponse>(){

            @Override
            public void success(CitrusResponse citrusResponse) {
            }

            @Override
            public void error(CitrusError error) {
            }
        });
    }

    private class JsInterface {
        private JsInterface() {
        }

        @JavascriptInterface
        public void pgResponse(String response) {
            Logger.d((String)("PG Response :: " + response), (Object[])new Object[0]);
            if (CitrusActivity.this.mPaymentType instanceof PaymentType.CitrusCash) {
                CitrusActivity.removeCookies();
            }
            TransactionResponse transactionResponse = TransactionResponse.fromJSON(response, CitrusActivity.this.customParametersOriginalMap);
            CitrusActivity.this.sendResult(transactionResponse);
        }

        @JavascriptInterface
        public void loadWalletResponse(String response) {
            Logger.d((String)("Wallet response :: " + response), (Object[])new Object[0]);
            TransactionResponse transactionResponse = TransactionResponse.parseLoadMoneyResponse(response);
            CitrusActivity.this.sendResult(transactionResponse);
        }

        @JavascriptInterface
        public void rawPGResponse(String response) {
            Logger.d((String)("rawPGResponse :: " + response), (Object[])new Object[0]);
            TransactionResponse transactionResponse = new TransactionResponse(TransactionResponse.TransactionStatus.SUCCESSFUL, "", null);
            transactionResponse.setJsonResponse(response);
            CitrusActivity.this.sendResult(transactionResponse);
        }
    }

    private class CitrusWebClient
    extends WebViewClient {
        private CitrusWebClient() {
        }

        public boolean shouldOverrideUrlLoading(WebView view, String url) {
            if (url.contains("/prepaid/pg/verify/")) {
                CitrusActivity.this.showPrompt();
                CitrusActivity.this.passwordPromptShown = true;
                return false;
            }
            view.loadUrl(url);
            return true;
        }

        public void onPageStarted(WebView view, String url, Bitmap favicon) {
            super.onPageStarted(view, url, favicon);
            if (CitrusActivity.this.isBackKeyPressedByUser) {
                CitrusActivity.this.showDialog("Cancelling Transaction. Please Wait...", true);
            } else if (!CitrusActivity.this.mShowingDialog) {
                CitrusActivity.this.showDialog("Processing Payment. Please Wait...", true);
            }
            CitrusActivity.this.mTimer.cancel();
        }

        public void onPageFinished(WebView view, String url) {
            super.onPageFinished(view, url);
            CitrusActivity.this.mTimer.start();
        }

        public void onReceivedSslError(WebView view, SslErrorHandler handler, SslError error) {
            CitrusActivity.this.dismissDialog();
            handler.cancel();
        }
    }
}

