/*
 * Decompiled with CFR 0.152.
 */
package com.citrus.widgets;

import android.content.Context;
import android.text.Editable;
import android.text.InputFilter;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.widget.EditText;
import com.citrus.card.CardType;
import com.citrus.sdk.payment.CardOption;
import com.citrus.widgets.FilterLength;
import java.util.regex.Pattern;

public class CardNumberEditText
extends EditText {
    public static final Pattern CODE_PATTERN = Pattern.compile("([0-9]{0,4})|([0-9]{4}-)+|([0-9]{4}-[0-9]{0,4})+");
    public static final Pattern EXP_PATTERN = Pattern.compile("^((0[1-9])|(1[0-2]))//((2009)|(20[1-2][0-9]))$");
    public Context context;
    private TextWatcher customTextWatcher = new TextWatcher(){

        public void onTextChanged(CharSequence s, int start, int before, int count) {
            String testString = "";
            testString = s.toString().contains(" ") ? s.toString().replace(" ", "") : s.toString();
            try {
                String cardType = CardType.typeOf(testString).toString();
                String length = FilterLength.valueOf(cardType).getLength();
                CardNumberEditText.this.setFilters(new InputFilter[]{new InputFilter.LengthFilter(Integer.valueOf(length).intValue())});
                int id2 = CardNumberEditText.this.context.getResources().getIdentifier(cardType.toLowerCase(), "drawable", CardNumberEditText.this.context.getPackageName());
                CardNumberEditText.this.setCompoundDrawablesWithIntrinsicBounds(null, null, CardNumberEditText.this.getResources().getDrawable(id2), null);
                CardNumberEditText.this.setError(null);
            }
            catch (Exception e) {
                CardNumberEditText.this.setCompoundDrawablesWithIntrinsicBounds(null, null, null, null);
            }
        }

        public void beforeTextChanged(CharSequence s, int start, int count, int after) {
        }

        public void afterTextChanged(Editable s) {
            if (s.length() > 0 && !CODE_PATTERN.matcher((CharSequence)s).matches()) {
                String input = s.toString();
                String numbersOnly = CardNumberEditText.this.keepNumbersOnly(input);
                String code = CardNumberEditText.this.formatNumbersAsCode(numbersOnly);
                CardNumberEditText.this.removeTextChangedListener(this);
                CardNumberEditText.this.setText(code);
                CardNumberEditText.this.setSelection(code.length());
                CardNumberEditText.this.addTextChangedListener(this);
            }
        }
    };

    public CardNumberEditText(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.context = context;
        this.init();
    }

    public CardNumberEditText(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.context = context;
        this.init();
    }

    public CardNumberEditText(Context context) {
        super(context);
        this.context = context;
        this.init();
    }

    private void init() {
        this.addTextChangedListener(this.customTextWatcher);
    }

    private String keepNumbersOnly(CharSequence s) {
        return s.toString().replaceAll("[^0-9]", "");
    }

    private String formatNumbersAsCode(CharSequence s) {
        int groupDigits = 0;
        String tmp = "";
        for (int i = 0; i < s.length(); ++i) {
            tmp = tmp + s.charAt(i);
            if (++groupDigits != 4) continue;
            tmp = tmp + " ";
            groupDigits = 0;
        }
        try {
            if (tmp.charAt(tmp.length() - 1) == ' ') {
                tmp = tmp.substring(0, tmp.length() - 1);
            }
        }
        catch (Exception e) {
            tmp = "";
        }
        return tmp;
    }

    public int getCVVLength() {
        String cardNumber = this.keepNumbersOnly((CharSequence)this.getText());
        return CardOption.CardScheme.getCVVLength(cardNumber);
    }

    public CardOption.CardScheme getCardScheme() {
        String cardNumber = this.keepNumbersOnly((CharSequence)this.getText());
        return CardOption.CardScheme.getCardSchemeUsingNumber(cardNumber);
    }
}

