/*
 * Decompiled with CFR 0.152.
 */
package com.citrus.sdk.payment;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Build;
import com.citrus.analytics.PaymentType;
import com.citrus.sdk.payment.PaymentOption;

public final class CitrusCash
extends PaymentOption {
    private String amount = null;

    private CitrusCash() {
    }

    public CitrusCash(String name, String token) {
        super(name, token);
    }

    public CitrusCash(String amount) {
        this.amount = amount;
        this.name = "Citrus Cash : \u20b9 " + amount;
    }

    @Override
    public Drawable getOptionIcon(Context context) {
        if (Build.VERSION.SDK_INT >= 21) {
            return context.getResources().getDrawable(context.getResources().getIdentifier("citrus_cash", "drawable", context.getPackageName()), null);
        }
        return context.getResources().getDrawable(context.getResources().getIdentifier("citrus_cash", "drawable", context.getPackageName()));
    }

    public String getAmount() {
        return this.amount;
    }

    @Override
    public String getSavePaymentOptionObject() {
        return null;
    }

    @Override
    public PaymentType getAnalyticsPaymentType() {
        return PaymentType.CITRUS_CASH;
    }

    @Override
    public String getDynamicPricingPaymentMode() {
        return "PREPAID_CARD";
    }

    @Override
    public String getSaveDefaultPaymentOptionObject() {
        return null;
    }

    @Override
    public String toString() {
        return super.toString() + "CitrusCash{" + "amount='" + this.amount + '\'' + '}';
    }

    public void setName(String name) {
        this.name = name;
    }
}

