/*
 * Decompiled with CFR 0.152.
 */
package com.citrus.sdk.dynamicPricing;

import com.citrus.sdk.CitrusUser;
import com.citrus.sdk.classes.Amount;
import com.citrus.sdk.dynamicPricing.DynamicPricingRequestType;
import com.citrus.sdk.payment.CardOption;
import com.citrus.sdk.payment.NetbankingOption;
import com.citrus.sdk.payment.PaymentBill;
import com.citrus.sdk.payment.PaymentOption;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class DynamicPricingRequest {
    private DynamicPricingRequestType dynamicPricingRequestType;
    private PaymentBill paymentBill;

    public DynamicPricingRequest(DynamicPricingRequestType dynamicPricingRequestType, PaymentBill paymentBill) {
        this.dynamicPricingRequestType = dynamicPricingRequestType;
        this.paymentBill = paymentBill;
    }

    public DynamicPricingRequestType getDynamicPricingRequestType() {
        return this.dynamicPricingRequestType;
    }

    public PaymentBill getPaymentBill() {
        return this.paymentBill;
    }

    public static String toJSON(DynamicPricingRequest request) {
        String response = null;
        if (request != null) {
            JSONObject jsonObject = new JSONObject();
            DynamicPricingRequestType dynamicPricingRequestType = request.getDynamicPricingRequestType();
            Amount originalAmount = dynamicPricingRequestType.getOriginalAmount();
            CitrusUser user = dynamicPricingRequestType.getCitrusUser();
            PaymentOption paymentOption = dynamicPricingRequestType.getPaymentOption();
            PaymentBill paymentBill = request.getPaymentBill();
            Map<String, String> extraParamsMap = dynamicPricingRequestType.getExtraParameters();
            try {
                jsonObject.put("email", (Object)(user != null ? user.getEmailId() : null));
                jsonObject.put("phone", (Object)(user != null ? user.getMobileNo() : null));
                jsonObject.put("merchantTransactionId", (Object)paymentBill.getMerchantTransactionId());
                jsonObject.put("merchantAccessKey", (Object)paymentBill.getMerchantAccessKey());
                jsonObject.put("signature", (Object)paymentBill.getDpSignature());
                jsonObject.put("originalAmount", (Object)Amount.toJSONObject(originalAmount));
                jsonObject.put("paymentInfo", (Object)DynamicPricingRequest.getPaymentInformation(paymentOption));
                JSONObject extraParams = new JSONObject();
                if (extraParamsMap != null) {
                    for (String key : extraParamsMap.keySet()) {
                        extraParams.put(key, (Object)extraParamsMap.get(key));
                    }
                }
                extraParams.put("operation", (Object)dynamicPricingRequestType.getDPOperationName());
                jsonObject.put("extraParams", (Object)extraParams);
                if (dynamicPricingRequestType instanceof DynamicPricingRequestType.CalculatePrice) {
                    jsonObject.put("ruleName", (Object)((DynamicPricingRequestType.CalculatePrice)dynamicPricingRequestType).getRuleName());
                } else if (dynamicPricingRequestType instanceof DynamicPricingRequestType.ValidateRule) {
                    Amount alteredAmount = ((DynamicPricingRequestType.ValidateRule)dynamicPricingRequestType).getAlteredAmount();
                    jsonObject.put("ruleName", (Object)((DynamicPricingRequestType.ValidateRule)dynamicPricingRequestType).getRuleName());
                    jsonObject.put("alteredAmount", (Object)Amount.toJSONObject(alteredAmount));
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            response = jsonObject.toString();
        }
        return response;
    }

    private static JSONObject getPaymentInformation(PaymentOption paymentOption) {
        JSONObject jsonObject = new JSONObject();
        try {
            if (paymentOption != null) {
                if (paymentOption.getToken() != null) {
                    jsonObject.put("paymentToken", (Object)paymentOption.getToken());
                } else if (paymentOption instanceof NetbankingOption) {
                    jsonObject.put("issuerId", (Object)((NetbankingOption)paymentOption).getBankCID());
                } else if (paymentOption instanceof CardOption) {
                    jsonObject.put("cardNo", (Object)((CardOption)paymentOption).getCardNumber());
                    jsonObject.put("cardType", (Object)((CardOption)paymentOption).getCardScheme().getName().toUpperCase());
                }
                jsonObject.put("paymentMode", (Object)paymentOption.getDynamicPricingPaymentMode());
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return jsonObject;
    }
}

