/*
 * Decompiled with CFR 0.152.
 */
package com.citrus.analytics;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import com.citrus.analytics.ConnectionType;

public class ConnectionManager {
    public static ConnectionType getNetworkClass(Context context) {
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo info = cm.getActiveNetworkInfo();
        if (info == null || !info.isConnected()) {
            return ConnectionType.NOT_CONNECTED;
        }
        if (info.getType() == 1) {
            return ConnectionType.WIFI;
        }
        if (info.getType() == 0) {
            int networkType = info.getSubtype();
            switch (networkType) {
                case 1: 
                case 2: 
                case 4: 
                case 7: 
                case 11: {
                    return ConnectionType.MOBILE_2G;
                }
                case 3: 
                case 5: 
                case 6: 
                case 8: 
                case 9: 
                case 10: 
                case 12: 
                case 14: 
                case 15: {
                    return ConnectionType.MOBILE_3G;
                }
                case 13: {
                    return ConnectionType.MOBILE_4G;
                }
            }
            return ConnectionType.UNKNOWN;
        }
        return ConnectionType.UNKNOWN;
    }
}

