/*
 * Decompiled with CFR 0.152.
 */
package com.citrus.sdk;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.citrus.analytics.TransactionType;
import com.citrus.sdk.CitrusUser;
import com.citrus.sdk.classes.Amount;
import com.orhanobut.logger.Logger;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

public final class TransactionResponse
implements Parcelable {
    private Amount balanceAmount = null;
    private Amount transactionAmount = null;
    private String message = null;
    private String responseCode = null;
    private TransactionStatus transactionStatus = null;
    private TransactionDetails transactionDetails = null;
    private CitrusUser citrusUser = null;
    private PaymentMode paymentMode = null;
    private String issuerCode = null;
    private String impsMobileNumber = null;
    private String impsMmid = null;
    private String authIdCode = null;
    private String signature = null;
    private String maskedCardNumber = null;
    private boolean COD = false;
    private Map<String, String> customParamsMap = null;
    private String jsonResponse = null;
    private Amount originalAmount = null;
    private Amount adjustedAmount = null;
    private String dpRuleName = null;
    private String couponCode = null;
    private String dpRuleType = null;
    public static final Parcelable.Creator<TransactionResponse> CREATOR = new Parcelable.Creator<TransactionResponse>(){

        public TransactionResponse createFromParcel(Parcel source) {
            return new TransactionResponse(source);
        }

        public TransactionResponse[] newArray(int size) {
            return new TransactionResponse[size];
        }
    };

    private TransactionResponse() {
    }

    TransactionResponse(TransactionStatus transactionStatus, String message, String transactionId) {
        this.transactionStatus = transactionStatus;
        this.message = message;
        this.transactionDetails = new TransactionDetails(transactionId);
    }

    private TransactionResponse(Amount transactionAmount, String message, String responseCode, TransactionStatus transactionStatus, TransactionDetails transactionDetails, CitrusUser citrusUser, PaymentMode paymentMode, String issuerCode, String impsMobileNumber, String impsMmid, String authIdCode, String signature, boolean COD, String maskedCardNumber, Map<String, String> customParamsMap) {
        this.transactionAmount = transactionAmount;
        this.message = message;
        this.responseCode = responseCode;
        this.transactionStatus = transactionStatus;
        this.transactionDetails = transactionDetails;
        this.citrusUser = citrusUser;
        this.paymentMode = paymentMode;
        this.issuerCode = issuerCode;
        this.impsMobileNumber = impsMobileNumber;
        this.impsMmid = impsMmid;
        this.authIdCode = authIdCode;
        this.signature = signature;
        this.COD = COD;
        this.maskedCardNumber = maskedCardNumber;
        this.customParamsMap = customParamsMap;
    }

    private TransactionResponse(Amount transactionAmount, String message, String responseCode, TransactionStatus transactionStatus, TransactionDetails transactionDetails, CitrusUser citrusUser, PaymentMode paymentMode, String issuerCode, String impsMobileNumber, String impsMmid, String authIdCode, String signature, boolean COD, String maskedCardNumber, Map<String, String> customParamsMap, Amount originalAmount, Amount adjustedAmount, String dpRuleName, String couponCode, String dpRuleType) {
        this.transactionAmount = transactionAmount;
        this.message = message;
        this.responseCode = responseCode;
        this.transactionStatus = transactionStatus;
        this.transactionDetails = transactionDetails;
        this.citrusUser = citrusUser;
        this.paymentMode = paymentMode;
        this.issuerCode = issuerCode;
        this.impsMobileNumber = impsMobileNumber;
        this.impsMmid = impsMmid;
        this.authIdCode = authIdCode;
        this.signature = signature;
        this.maskedCardNumber = maskedCardNumber;
        this.COD = COD;
        this.customParamsMap = customParamsMap;
        this.originalAmount = originalAmount;
        this.adjustedAmount = adjustedAmount;
        this.dpRuleName = dpRuleName;
        this.couponCode = couponCode;
        this.dpRuleType = dpRuleType;
    }

    public static TransactionResponse fromJSON(String response, Map<String, String> customParamsOriginalMap) {
        TransactionResponse transactionResponse = null;
        try {
            JSONObject jsonObject = new JSONObject(response);
            transactionResponse = TransactionResponse.fromJSONObject(jsonObject, customParamsOriginalMap);
        }
        catch (JSONException ex) {
            ex.printStackTrace();
            transactionResponse = new TransactionResponse();
            transactionResponse.setJsonResponse(response);
        }
        return transactionResponse;
    }

    public static TransactionResponse fromJSON(String response) {
        return TransactionResponse.fromJSON(response, null);
    }

    public static TransactionResponse fromJSONObject(JSONObject jsonObject, Map<String, String> customParamsOriginalMap) {
        TransactionResponse transactionResponse = null;
        if (jsonObject != null) {
            if (jsonObject.optString("Error", null) != null) {
                String reason = jsonObject.optString("Reason", "Transaction Failed");
                transactionResponse = new TransactionResponse(TransactionStatus.FAILED, reason, null);
            } else {
                PaymentMode paymentMode = PaymentMode.getPaymentMode(jsonObject.optString("paymentMode"));
                TransactionStatus transactionStatus = TransactionStatus.getTransactionStatus(jsonObject.optString("TxStatus"));
                String currency = jsonObject.optString("currency");
                String amount = jsonObject.optString("amount");
                String responseCode = jsonObject.optString("pgRespCode");
                String message = transactionStatus == TransactionStatus.CANCELLED ? "Transaction Cancelled." : jsonObject.optString("TxMsg");
                String isCOD = jsonObject.optString("isCOD");
                String signature = jsonObject.optString("signature");
                String issuerCode = jsonObject.optString("issuerCode");
                String impsMmid = jsonObject.optString("impsMmid");
                String impsMobileNumber = jsonObject.optString("impsMobileNumber");
                String authIdCode = jsonObject.optString("authIdCode");
                String maskedcardNumber = jsonObject.optString("maskedcardNumber");
                HashMap<String, String> customParamsMap = null;
                if (customParamsOriginalMap != null) {
                    Set<String> keys = customParamsOriginalMap.keySet();
                    for (String key : keys) {
                        if (customParamsMap == null) {
                            customParamsMap = new HashMap<String, String>();
                        }
                        customParamsMap.put(key, jsonObject.optString(key));
                    }
                }
                TransactionDetails transactionDetails = TransactionDetails.fromJSONObject(jsonObject);
                CitrusUser citrusUser = CitrusUser.fromJSONObject(jsonObject);
                boolean cod = "true".equalsIgnoreCase(isCOD);
                Amount transactionAmount = new Amount(amount, currency);
                transactionResponse = new TransactionResponse(transactionAmount, message, responseCode, transactionStatus, transactionDetails, citrusUser, paymentMode, issuerCode, impsMobileNumber, impsMmid, authIdCode, signature, cod, maskedcardNumber, customParamsMap);
                transactionResponse.setJsonResponse(jsonObject.toString());
            }
        }
        return transactionResponse;
    }

    public TransactionStatus getTransactionStatus() {
        return this.transactionStatus;
    }

    public String getTransactionId() {
        if (this.transactionDetails != null) {
            return this.transactionDetails.getTransactionId();
        }
        return null;
    }

    public CitrusUser getCitrusUser() {
        return this.citrusUser;
    }

    public Amount getTransactionAmount() {
        return this.transactionAmount;
    }

    public Amount getBalanceAmount() {
        return this.balanceAmount;
    }

    public String getMessage() {
        return this.message;
    }

    public String getResponseCode() {
        return this.responseCode;
    }

    public PaymentMode getPaymentMode() {
        return this.paymentMode;
    }

    public TransactionDetails getTransactionDetails() {
        return this.transactionDetails;
    }

    public boolean isCOD() {
        return this.COD;
    }

    public String getImpsMobileNumber() {
        return this.impsMobileNumber;
    }

    public String getIssuerCode() {
        return this.issuerCode;
    }

    public String getImpsMmid() {
        return this.impsMmid;
    }

    public String getAuthIdCode() {
        return this.authIdCode;
    }

    public String getSignature() {
        return this.signature;
    }

    public String getMaskedCardNumber() {
        return this.maskedCardNumber;
    }

    public Amount getOriginalAmount() {
        return this.originalAmount;
    }

    public Amount getAdjustedAmount() {
        return this.adjustedAmount;
    }

    public String getDpRuleName() {
        return this.dpRuleName;
    }

    public String getCouponCode() {
        return this.couponCode;
    }

    public String getDpRuleType() {
        return this.dpRuleType;
    }

    public Map<String, String> getCustomParamsMap() {
        return this.customParamsMap;
    }

    public TransactionType getAnalyticsTransactionType() {
        if (this.transactionStatus == TransactionStatus.SUCCESSFUL) {
            return TransactionType.SUCCESS;
        }
        if (this.transactionStatus == TransactionStatus.CANCELLED) {
            return TransactionType.CANCELLED;
        }
        return TransactionType.FAIL;
    }

    public String getJsonResponse() {
        return this.jsonResponse;
    }

    private void setJsonResponse(String jsonResponse) {
        this.jsonResponse = jsonResponse;
    }

    public String toString() {
        return "CitrusTransactionResponse{transactionAmount='" + (this.transactionAmount != null ? this.transactionAmount.toString() : "") + '\'' + "balanceAmount='" + (this.balanceAmount != null ? this.balanceAmount.toString() : "") + '\'' + ", message='" + this.message + '\'' + ", responseCode='" + this.responseCode + '\'' + ", transactionStatus=" + (Object)((Object)this.transactionStatus) + ", transactionDetails=" + this.transactionDetails + ", citrusUser=" + this.citrusUser + ", paymentMode=" + (Object)((Object)this.paymentMode) + ", issuerCode='" + this.issuerCode + '\'' + ", impsMobileNumber='" + this.impsMobileNumber + '\'' + ", impsMmid='" + this.impsMmid + '\'' + ", authIdCode='" + this.authIdCode + '\'' + ", signature='" + this.signature + '\'' + ", maskedCardNumber='" + this.maskedCardNumber + '\'' + ", COD=" + this.COD + ", customParamsMap=" + this.customParamsMap + ", jsonResponse='" + this.jsonResponse + '\'' + ", originalAmount=" + this.originalAmount + ", adjustedAmount=" + this.adjustedAmount + ", dpRuleName='" + this.dpRuleName + '\'' + ", couponCode='" + this.couponCode + '\'' + ", dpRuleType='" + this.dpRuleType + '\'' + '}';
    }

    public static TransactionResponse parseLoadMoneyResponse(String response) {
        TransactionResponse transactionResponse;
        Logger.d((String)("parseLoadMoneyResponse :: " + response), (Object[])new Object[0]);
        if (response.contains("#")) {
            String[] token = response.split("#");
            if (token != null && token.length == 2) {
                String[] decodeResp = token[1].split(":");
                if (decodeResp.length > 1) {
                    String transactionId = decodeResp[1];
                    String balanceValue = decodeResp[2];
                    String balanceCurrency = decodeResp[3];
                    String dateTime = decodeResp[4];
                    String transactionValue = decodeResp[5];
                    String transactionCurrency = decodeResp[6];
                    transactionResponse = TextUtils.equals((CharSequence)decodeResp[0], (CharSequence)"SUCCESSFUL") ? new TransactionResponse(TransactionStatus.SUCCESSFUL, "Citrus Cash Wallet loaded successfully", transactionId) : new TransactionResponse(TransactionStatus.FAILED, "Failed to load money into Citrus Cash", transactionId);
                    transactionResponse.transactionAmount = new Amount(transactionValue, transactionCurrency);
                    transactionResponse.balanceAmount = new Amount(balanceValue, balanceCurrency);
                    transactionResponse.transactionDetails.transactionDateTime = dateTime;
                } else {
                    transactionResponse = new TransactionResponse(TransactionStatus.FAILED, "Failed to load money into Citrus Cash", null);
                }
            } else {
                transactionResponse = new TransactionResponse(TransactionStatus.FAILED, "Failed to load money into Citrus Cash", null);
            }
        } else {
            transactionResponse = new TransactionResponse(TransactionStatus.FAILED, "Failed to load money into Citrus Cash", null);
        }
        return transactionResponse;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeParcelable((Parcelable)this.balanceAmount, 0);
        dest.writeParcelable((Parcelable)this.transactionAmount, 0);
        dest.writeString(this.message);
        dest.writeString(this.responseCode);
        dest.writeInt(this.transactionStatus == null ? -1 : this.transactionStatus.ordinal());
        dest.writeParcelable((Parcelable)this.transactionDetails, 0);
        dest.writeParcelable((Parcelable)this.citrusUser, 0);
        dest.writeInt(this.paymentMode == null ? -1 : this.paymentMode.ordinal());
        dest.writeString(this.issuerCode);
        dest.writeString(this.impsMobileNumber);
        dest.writeString(this.impsMmid);
        dest.writeString(this.authIdCode);
        dest.writeString(this.signature);
        dest.writeString(this.maskedCardNumber);
        dest.writeByte(this.COD ? (byte)1 : 0);
        dest.writeMap(this.customParamsMap);
        dest.writeString(this.jsonResponse);
    }

    private TransactionResponse(Parcel in) {
        this.balanceAmount = (Amount)in.readParcelable(Amount.class.getClassLoader());
        this.transactionAmount = (Amount)in.readParcelable(Amount.class.getClassLoader());
        this.message = in.readString();
        this.responseCode = in.readString();
        int tmpTransactionStatus = in.readInt();
        this.transactionStatus = tmpTransactionStatus == -1 ? null : TransactionStatus.values()[tmpTransactionStatus];
        this.transactionDetails = (TransactionDetails)in.readParcelable(TransactionDetails.class.getClassLoader());
        this.citrusUser = (CitrusUser)in.readParcelable(CitrusUser.class.getClassLoader());
        int tmpPaymentMode = in.readInt();
        this.paymentMode = tmpPaymentMode == -1 ? null : PaymentMode.values()[tmpPaymentMode];
        this.issuerCode = in.readString();
        this.impsMobileNumber = in.readString();
        this.impsMmid = in.readString();
        this.authIdCode = in.readString();
        this.signature = in.readString();
        this.maskedCardNumber = in.readString();
        this.COD = in.readByte() != 0;
        this.customParamsMap = in.readHashMap(String.class.getClassLoader());
        this.jsonResponse = in.readString();
    }

    public static class TransactionDetails
    implements Parcelable {
        public static final Parcelable.Creator<TransactionDetails> CREATOR = new Parcelable.Creator<TransactionDetails>(){

            public TransactionDetails createFromParcel(Parcel source) {
                return new TransactionDetails(source);
            }

            public TransactionDetails[] newArray(int size) {
                return new TransactionDetails[size];
            }
        };
        private String transactionId = null;
        private String txRefNo = null;
        private String pgTxnNo = null;
        private String issuerRefNo = null;
        private String transactionGateway = null;
        private String transactionDateTime = null;

        TransactionDetails(String transactionId) {
            this.transactionId = transactionId;
        }

        public TransactionDetails(String transactionId, String txRefNo, String pgTxnNo, String issuerRefNo, String transactionGateway, String transactionDateTime) {
            this.transactionId = transactionId;
            this.txRefNo = txRefNo;
            this.pgTxnNo = pgTxnNo;
            this.issuerRefNo = issuerRefNo;
            this.transactionGateway = transactionGateway;
            this.transactionDateTime = transactionDateTime;
        }

        private TransactionDetails(Parcel in) {
            this.transactionId = in.readString();
            this.txRefNo = in.readString();
            this.pgTxnNo = in.readString();
            this.issuerRefNo = in.readString();
            this.transactionGateway = in.readString();
            this.transactionDateTime = in.readString();
        }

        public static TransactionDetails fromJSONObject(JSONObject response) {
            TransactionDetails transactionDetails = null;
            if (response != null) {
                String txRefNo = response.optString("TxRefNo");
                String pgTxnNo = response.optString("pgTxnNo");
                String issuerRefNo = response.optString("issuerRefNo");
                String txGateway = response.optString("TxGateway");
                String txnDateTime = response.optString("txnDateTime");
                String txId = response.optString("TxId");
                transactionDetails = new TransactionDetails(txId, txRefNo, pgTxnNo, issuerRefNo, txGateway, txnDateTime);
            }
            return transactionDetails;
        }

        public String getTransactionId() {
            return this.transactionId;
        }

        public String getTxRefNo() {
            return this.txRefNo;
        }

        public String getPgTxnNo() {
            return this.pgTxnNo;
        }

        public String getIssuerRefNo() {
            return this.issuerRefNo;
        }

        public String getTransactionGateway() {
            return this.transactionGateway;
        }

        public String getTransactionDateTime() {
            return this.transactionDateTime;
        }

        public String toString() {
            return "TransactionDetails{transactionId='" + this.transactionId + '\'' + ", txRefNo='" + this.txRefNo + '\'' + ", pgTxnNo='" + this.pgTxnNo + '\'' + ", issuerRefNo='" + this.issuerRefNo + '\'' + ", transactionGateway='" + this.transactionGateway + '\'' + ", transactionDateTime='" + this.transactionDateTime + '\'' + '}';
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeString(this.transactionId);
            dest.writeString(this.txRefNo);
            dest.writeString(this.pgTxnNo);
            dest.writeString(this.issuerRefNo);
            dest.writeString(this.transactionGateway);
            dest.writeString(this.transactionDateTime);
        }
    }

    public static enum TransactionStatus {
        SUCCESSFUL,
        FAILED,
        CANCELLED,
        PG_REJECTED,
        UNKNOWN;


        public static TransactionStatus getTransactionStatus(String transactionStatus) {
            TransactionStatus status = UNKNOWN;
            if (TextUtils.equals((CharSequence)transactionStatus, (CharSequence)"SUCCESS") || TextUtils.equals((CharSequence)transactionStatus, (CharSequence)"SUCCESSFUL")) {
                status = SUCCESSFUL;
            } else if (TextUtils.equals((CharSequence)transactionStatus, (CharSequence)"FAIL")) {
                status = FAILED;
            } else if (TextUtils.equals((CharSequence)transactionStatus, (CharSequence)"CANCELED")) {
                status = CANCELLED;
            } else if (TextUtils.equals((CharSequence)transactionStatus, (CharSequence)"PG_REJECTED")) {
                status = PG_REJECTED;
            }
            return status;
        }
    }

    public static enum PaymentMode {
        NET_BANKING,
        CREDIT_CARD,
        DEBIT_CARD,
        PREPAID_CARD;


        public static PaymentMode getPaymentMode(String paymentMode) {
            PaymentMode mode = null;
            if (TextUtils.equals((CharSequence)paymentMode, (CharSequence)"NET_BANKING")) {
                mode = NET_BANKING;
            } else if (TextUtils.equals((CharSequence)paymentMode, (CharSequence)"CREDIT_CARD")) {
                mode = CREDIT_CARD;
            } else if (TextUtils.equals((CharSequence)paymentMode, (CharSequence)"DEBIT_CARD")) {
                mode = DEBIT_CARD;
            } else if (TextUtils.equals((CharSequence)paymentMode, (CharSequence)"PREPAID_CARD")) {
                mode = PREPAID_CARD;
            }
            return mode;
        }
    }
}

