/*
 * Decompiled with CFR 0.152.
 */
package com.citrus.sdk;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.citrus.mobile.Config;
import com.citrus.sdk.CitrusUser;
import com.citrus.sdk.classes.Amount;
import com.citrus.sdk.payment.NetbankingOption;
import com.citrus.sdk.payment.PaymentOption;
import com.citrus.sdk.payment.PaymentType;
import java.util.ArrayList;

@Deprecated
public final class PaymentParams
implements Parcelable {
    public static final Parcelable.Creator<PaymentParams> CREATOR = new Parcelable.Creator<PaymentParams>(){

        public PaymentParams createFromParcel(Parcel source) {
            return new PaymentParams(source);
        }

        public PaymentParams[] newArray(int size) {
            return new PaymentParams[size];
        }
    };
    final Amount transactionAmount;
    ArrayList<NetbankingOption> netbankingOptionList = new ArrayList();
    ArrayList<NetbankingOption> topNetbankingOptions = new ArrayList();
    ArrayList<PaymentOption> userSavedOptionList = new ArrayList();
    CitrusUser user;
    String merchantOrTitleName;
    private String colorPrimaryDark = "#E7961D";
    private String colorPrimary = "#F9A323";
    private String textColorPrimary = "#ffffff";
    private String accentColor;
    private String jsonKeyStore;
    private String vanity;
    private String accessKey;
    private String signinId;
    private String signinSecret;
    private String signupId;
    private String signupSecret;
    private PaymentType paymentType = null;
    private Environment environment = Environment.SANDBOX;
    private PaymentOption paymentOption = null;

    private PaymentParams(Amount amount, PaymentType paymentType, PaymentOption paymentOption) {
        if (!(amount != null && paymentType != null && (paymentType instanceof PaymentType.CitrusCash && paymentOption == null || paymentOption != null && (paymentType instanceof PaymentType.PGPayment || paymentType instanceof PaymentType.LoadMoney)))) {
            throw new IllegalArgumentException("Please make sure to pass amount, paymentType and selected paymentOption");
        }
        this.transactionAmount = amount;
        this.paymentType = paymentType;
        this.paymentOption = paymentOption;
        this.environment(Environment.SANDBOX);
    }

    private PaymentParams(Parcel in) {
        this.netbankingOptionList = (ArrayList)in.readSerializable();
        this.topNetbankingOptions = (ArrayList)in.readSerializable();
        this.userSavedOptionList = (ArrayList)in.readSerializable();
        this.user = (CitrusUser)in.readParcelable(CitrusUser.class.getClassLoader());
        this.colorPrimaryDark = in.readString();
        this.colorPrimary = in.readString();
        this.textColorPrimary = in.readString();
        this.accentColor = in.readString();
        this.transactionAmount = (Amount)in.readParcelable(Amount.class.getClassLoader());
        this.merchantOrTitleName = in.readString();
        this.jsonKeyStore = in.readString();
        this.vanity = in.readString();
        this.accessKey = in.readString();
        this.signinId = in.readString();
        this.signinSecret = in.readString();
        this.signupId = in.readString();
        this.signupSecret = in.readString();
        this.paymentType = (PaymentType)in.readParcelable(PaymentType.class.getClassLoader());
        int tmpEnvironment = in.readInt();
        this.environment = tmpEnvironment == -1 ? null : Environment.values()[tmpEnvironment];
        this.paymentOption = (PaymentOption)in.readParcelable(PaymentOption.class.getClassLoader());
    }

    public static PaymentParams builder(Amount transactionAmount, PaymentType paymentType, PaymentOption paymentOption) {
        return new PaymentParams(transactionAmount, paymentType, paymentOption);
    }

    public PaymentParams colorPrimaryDark(String colorPrimaryDark) {
        if (!TextUtils.isEmpty((CharSequence)colorPrimaryDark)) {
            this.colorPrimaryDark = colorPrimaryDark;
        }
        return this;
    }

    public PaymentParams colorPrimary(String colorPrimary) {
        if (!TextUtils.isEmpty((CharSequence)colorPrimary)) {
            this.colorPrimary = colorPrimary;
        }
        return this;
    }

    public PaymentParams textColorPrimary(String textColorPrimary) {
        if (!TextUtils.isEmpty((CharSequence)textColorPrimary)) {
            this.textColorPrimary = textColorPrimary;
        }
        return this;
    }

    public PaymentParams merchantOrTitleName(String merchantOrTitleName) {
        this.merchantOrTitleName = merchantOrTitleName;
        return this;
    }

    public PaymentParams user(CitrusUser user) {
        this.user = user;
        return this;
    }

    public PaymentParams environment(Environment environment) {
        this.environment = environment;
        if (environment == Environment.PRODUCTION) {
            Config.setEnv("production");
        } else if (environment == Environment.SANDBOX) {
            Config.setEnv("sandbox");
        }
        return this;
    }

    public PaymentParams paymentType(PaymentType paymentType) {
        this.paymentType = paymentType;
        return this;
    }

    public PaymentParams vanity(String vanity) {
        this.vanity = vanity;
        return this;
    }

    public CitrusUser getUser() {
        if (this.user == null) {
            this.user = CitrusUser.DEFAULT_USER;
        }
        return this.user;
    }

    public String getColorPrimaryDark() {
        return this.colorPrimaryDark;
    }

    public String getColorPrimary() {
        return this.colorPrimary;
    }

    public String getTextColorPrimary() {
        return this.textColorPrimary;
    }

    public String getAccentColor() {
        return this.accentColor;
    }

    public Amount getTransactionAmount() {
        return this.transactionAmount;
    }

    public String getMerchantOrTitleName() {
        return this.merchantOrTitleName;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public PaymentType getPaymentType() {
        return this.paymentType;
    }

    public PaymentOption getPaymentOption() {
        return this.paymentOption;
    }

    public String getVanity() {
        return this.vanity;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public String getSigninId() {
        return this.signinId;
    }

    public String getSigninSecret() {
        return this.signinSecret;
    }

    public String getSignupId() {
        return this.signupId;
    }

    public String getSignupSecret() {
        return this.signupSecret;
    }

    public String getJsonKeyStore() {
        return this.jsonKeyStore;
    }

    public PaymentParams build() {
        return this;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeSerializable(this.netbankingOptionList);
        dest.writeSerializable(this.topNetbankingOptions);
        dest.writeSerializable(this.userSavedOptionList);
        dest.writeParcelable((Parcelable)this.user, 0);
        dest.writeString(this.colorPrimaryDark);
        dest.writeString(this.colorPrimary);
        dest.writeString(this.textColorPrimary);
        dest.writeString(this.accentColor);
        dest.writeParcelable((Parcelable)this.transactionAmount, 0);
        dest.writeString(this.merchantOrTitleName);
        dest.writeString(this.jsonKeyStore);
        dest.writeString(this.vanity);
        dest.writeString(this.accessKey);
        dest.writeString(this.signinId);
        dest.writeString(this.signinSecret);
        dest.writeString(this.signupId);
        dest.writeString(this.signupSecret);
        dest.writeParcelable((Parcelable)this.paymentType, 0);
        dest.writeInt(this.environment == null ? -1 : this.environment.ordinal());
        dest.writeParcelable((Parcelable)this.paymentOption, 0);
    }

    public static enum Environment {
        PRODUCTION,
        SANDBOX;

    }
}

