/*
 * Decompiled with CFR 0.152.
 */
package com.citrus.analytics;

import android.content.Context;
import android.os.Build;
import com.citrus.analytics.CitrusLibraryApp;
import com.citrus.analytics.ConnectionManager;
import com.citrus.analytics.ConnectionType;
import com.citrus.analytics.PaymentType;
import com.citrus.analytics.TransactionType;
import com.citrus.analytics.WebViewEvents;
import com.citrus.retrofit.API;
import com.citrus.retrofit.RetroFitClient;
import com.citrus.sdk.CitrusClient;
import com.citrus.sdk.Environment;
import com.google.android.gms.analytics.HitBuilders;
import com.google.android.gms.analytics.Tracker;
import retrofit.Callback;
import retrofit.RetrofitError;
import retrofit.client.Response;
import retrofit.mime.TypedByteArray;

public class EventsManager {
    private static final String WEBVIEW_EVENTS = "WEBVIEW_EVENTS";
    private static final String PAYMENT_EVENTS = "PAYMENT_EVENTS";
    private static final String INIT_EVENTS = "SDK_VERSION";

    public static void logWebViewEvents(Context context, WebViewEvents webViewEvents, PaymentType paymentType) {
        CitrusClient citrusClient = CitrusClient.getInstance(context);
        ConnectionType connectionType = ConnectionManager.getNetworkClass(context);
        Tracker t = CitrusLibraryApp.getTracker(CitrusLibraryApp.TrackerName.APP_TRACKER, context);
        t.send(new HitBuilders.EventBuilder().setCategory(citrusClient.getVanity()).setAction(WEBVIEW_EVENTS).setLabel(EventsManager.getWebViewEventLabel(webViewEvents, connectionType, paymentType)).setValue(EventsManager.getWebViewEventValue(webViewEvents, connectionType, paymentType)).build());
    }

    public static void logPaymentEvents(Context context, PaymentType paymentType, TransactionType transactionType) {
        CitrusClient citrusClient = CitrusClient.getInstance(context);
        ConnectionType connectionType = ConnectionManager.getNetworkClass(context);
        Tracker t = CitrusLibraryApp.getTracker(CitrusLibraryApp.TrackerName.APP_TRACKER, context);
        t.send(new HitBuilders.EventBuilder().setCategory(citrusClient.getVanity()).setAction(PAYMENT_EVENTS).setLabel(EventsManager.getPaymentEventLabel(connectionType, paymentType, transactionType)).setValue(EventsManager.getPaymentEventValue(connectionType, paymentType, transactionType)).build());
    }

    public static void logPaymentEvents(Context context, PaymentType paymentType, String failureReason) {
        CitrusClient citrusClient = CitrusClient.getInstance(context);
        ConnectionType connectionType = ConnectionManager.getNetworkClass(context);
        Tracker t = CitrusLibraryApp.getTracker(CitrusLibraryApp.TrackerName.APP_TRACKER, context);
        t.send(new HitBuilders.EventBuilder().setCategory(citrusClient.getVanity()).setAction(PAYMENT_EVENTS).setLabel(EventsManager.getPaymentEventLabel(connectionType, paymentType, failureReason)).setValue(EventsManager.getPaymentEventValue(connectionType, paymentType, TransactionType.FAIL)).build());
    }

    public static void logInitSDKEvents(final Context context) {
        final CitrusClient client = CitrusClient.getInstance(context);
        Environment environment = client.getEnvironment();
        if (environment != null) {
            API citrusBaseURLClient = RetroFitClient.getClientWithUrl(client.getEnvironment().getBaseCitrusUrl());
            citrusBaseURLClient.getMerchantName(client.getVanity(), new Callback<Response>(){

                public void success(Response s, Response response) {
                    String merchantName = new String(((TypedByteArray)response.getBody()).getBytes());
                    Tracker t = CitrusLibraryApp.getTracker(CitrusLibraryApp.TrackerName.APP_TRACKER, context);
                    t.send(new HitBuilders.EventBuilder().setCategory(merchantName).setAction(EventsManager.INIT_EVENTS).setLabel(String.valueOf(3)).setValue(Long.valueOf(3L).longValue()).build());
                }

                public void failure(RetrofitError error) {
                    Tracker t = CitrusLibraryApp.getTracker(CitrusLibraryApp.TrackerName.APP_TRACKER, context);
                    t.send(new HitBuilders.EventBuilder().setCategory(client.getVanity()).setAction(EventsManager.INIT_EVENTS).setLabel(String.valueOf(3)).setValue(Long.valueOf(3L).longValue()).build());
                }
            });
        }
    }

    private static long getWebViewEventValue(WebViewEvents webViewEvents, ConnectionType connectionType, PaymentType paymentType) {
        switch (webViewEvents) {
            case OPEN: {
                return 1L;
            }
            case BACK_KEY: {
                return 2L;
            }
            case CLOSE: {
                return 3L;
            }
        }
        return 0L;
    }

    private static long getPaymentEventValue(ConnectionType connectionType, PaymentType paymentType, TransactionType transactionType) {
        switch (transactionType) {
            case SUCCESS: {
                return 4L;
            }
            case FAIL: {
                return 5L;
            }
        }
        return 0L;
    }

    public static String getWebViewEventLabel(WebViewEvents webViewEvents, ConnectionType connectionType, PaymentType paymentType) {
        String eventLabel = null;
        eventLabel = paymentType == PaymentType.NET_BANKING ? (paymentType.getName() != null ? webViewEvents.toString() + "_" + connectionType.toString() + "_" + paymentType.toString() + "_" + paymentType.getName() + "_" + String.valueOf(Build.VERSION.SDK_INT) + "_" + String.valueOf(3) : webViewEvents.toString() + "_" + connectionType.toString() + "_" + paymentType.toString() + "_" + String.valueOf(Build.VERSION.SDK_INT) + "_" + String.valueOf(3)) : webViewEvents.toString() + "_" + connectionType.toString() + "_" + paymentType.toString() + "_" + String.valueOf(Build.VERSION.SDK_INT) + "_" + String.valueOf(3);
        return eventLabel;
    }

    public static String getPaymentEventLabel(ConnectionType connectionType, PaymentType paymentType, TransactionType transactionType) {
        String eventLabel = null;
        eventLabel = paymentType == PaymentType.NET_BANKING ? (paymentType.getName() != null ? connectionType.toString() + "_" + paymentType.toString() + "_" + paymentType.getName() + "_" + String.valueOf(Build.VERSION.SDK_INT) + "_" + transactionType.toString() + "_" + String.valueOf(3) : connectionType.toString() + "_" + paymentType.toString() + "_" + String.valueOf(Build.VERSION.SDK_INT) + "_" + transactionType.toString() + "_" + String.valueOf(3)) : connectionType.toString() + "_" + paymentType.toString() + "_" + String.valueOf(Build.VERSION.SDK_INT) + "_" + transactionType.toString() + "_" + String.valueOf(3);
        return eventLabel;
    }

    public static String getPaymentEventLabel(ConnectionType connectionType, PaymentType paymentType, String failureReason) {
        String eventLabel = null;
        eventLabel = paymentType == PaymentType.NET_BANKING ? (paymentType.getName() != null ? connectionType.toString() + "_" + paymentType.toString() + "_" + paymentType.getName() + "_" + String.valueOf(Build.VERSION.SDK_INT) + "_" + TransactionType.FAIL.toString() + "_" + failureReason + "_" + String.valueOf(3) : connectionType.toString() + "_" + paymentType.toString() + "_" + String.valueOf(Build.VERSION.SDK_INT) + "_" + TransactionType.FAIL.toString() + "_" + failureReason + "_" + String.valueOf(3)) : connectionType.toString() + "_" + paymentType.toString() + "_" + String.valueOf(Build.VERSION.SDK_INT) + "_" + TransactionType.FAIL.toString() + "_" + failureReason + "_" + String.valueOf(3);
        return eventLabel;
    }
}

