/*
 * Decompiled with CFR 0.152.
 */
package com.citrus.sdk.classes;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class Amount
implements Parcelable {
    private final String value;
    private final String currency;
    public static final Parcelable.Creator<Amount> CREATOR = new Parcelable.Creator<Amount>(){

        public Amount createFromParcel(Parcel source) {
            return new Amount(source);
        }

        public Amount[] newArray(int size) {
            return new Amount[size];
        }
    };

    public Amount(String value) {
        this.value = value;
        this.currency = "INR";
    }

    public Amount(String value, String currency) {
        this.value = value;
        this.currency = currency;
    }

    public String getValue() {
        if (!TextUtils.isEmpty((CharSequence)this.value)) {
            return this.value.replaceFirst("^0+(?!$)", "");
        }
        return this.value;
    }

    public String getCurrency() {
        return this.currency;
    }

    public double getValueAsDouble() throws NumberFormatException {
        double value = 0.0;
        if (!TextUtils.isEmpty((CharSequence)this.value)) {
            value = Double.parseDouble(this.value);
        }
        return value;
    }

    public static Amount fromJSON(String response) {
        Amount amount = null;
        JSONObject jsonObject = null;
        if (!TextUtils.isEmpty((CharSequence)response)) {
            try {
                jsonObject = new JSONObject(response);
                amount = Amount.fromJSONObject(jsonObject);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return amount;
    }

    public static Amount fromJSONObject(JSONObject amountObject) {
        Amount amount = null;
        if (amountObject != null) {
            String value = amountObject.optString("value");
            String currency = amountObject.optString("currency");
            if (!TextUtils.isEmpty((CharSequence)value) && !TextUtils.isEmpty((CharSequence)currency)) {
                amount = new Amount(value, currency);
            }
        }
        return amount;
    }

    public static JSONObject toJSONObject(Amount amount) {
        JSONObject billObject = null;
        if (amount != null) {
            try {
                billObject = new JSONObject();
                billObject.put("value", (Object)amount.value);
                billObject.put("currency", (Object)amount.currency);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return billObject;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.value);
        dest.writeString(this.currency);
    }

    private Amount(Parcel in) {
        this.value = in.readString();
        this.currency = in.readString();
    }

    public String toString() {
        return "Amount{value='" + this.value + '\'' + ", currency='" + this.currency + '\'' + '}';
    }
}

