/*
 * Decompiled with CFR 0.152.
 */
package com.citrus.widgets;

import android.content.Context;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.widget.EditText;
import com.citrus.sdk.classes.Month;
import com.citrus.sdk.classes.Year;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;

public class ExpiryDate
extends EditText {
    private String mLastInput = "";
    private TextWatcher customWatcher = new TextWatcher(){

        public void onTextChanged(CharSequence s, int start, int before, int count) {
        }

        public void beforeTextChanged(CharSequence s, int start, int count, int after) {
        }

        public void afterTextChanged(Editable s) {
            String input = s.toString();
            SimpleDateFormat formatter = new SimpleDateFormat("MM/yy", Locale.GERMANY);
            Calendar expiryDateDate = Calendar.getInstance();
            try {
                expiryDateDate.setTime(formatter.parse(input));
            }
            catch (ParseException e) {
                int month;
                if (s.length() == 2 && !ExpiryDate.this.mLastInput.endsWith("/")) {
                    int month2 = Integer.parseInt(input);
                    if (month2 <= 12) {
                        ExpiryDate.this.setText(ExpiryDate.this.getText().toString() + "/");
                        ExpiryDate.this.setSelection(ExpiryDate.this.getText().toString().length());
                    } else {
                        ExpiryDate.this.setText("");
                        ExpiryDate.this.setSelection(ExpiryDate.this.getText().toString().length());
                    }
                } else if (s.length() == 2 && ExpiryDate.this.mLastInput.endsWith("/")) {
                    int month3 = Integer.parseInt(input);
                    if (month3 <= 12) {
                        ExpiryDate.this.setText(ExpiryDate.this.getText().toString().substring(0, 1));
                        ExpiryDate.this.setSelection(ExpiryDate.this.getText().toString().length());
                    } else {
                        ExpiryDate.this.setText("");
                        ExpiryDate.this.setSelection(ExpiryDate.this.getText().toString().length());
                    }
                } else if (s.length() == 1 && (month = Integer.parseInt(input)) > 1) {
                    ExpiryDate.this.setText("0" + ExpiryDate.this.getText().toString() + "/");
                    ExpiryDate.this.setSelection(ExpiryDate.this.getText().toString().length());
                }
                ExpiryDate.this.mLastInput = ExpiryDate.this.getText().toString();
                return;
            }
        }
    };

    public ExpiryDate(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    public ExpiryDate(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public ExpiryDate(Context context) {
        super(context);
        this.init();
    }

    public Month getMonth() {
        String[] expiry;
        String cardExpiry = this.getText().toString();
        Month month = null;
        if (!TextUtils.isEmpty((CharSequence)cardExpiry) && (expiry = cardExpiry.split("/")).length == 2) {
            month = Month.getMonth(expiry[0]);
        }
        return month;
    }

    public Year getYear() {
        String[] expiry;
        String cardExpiry = this.getText().toString();
        Year year = null;
        if (!TextUtils.isEmpty((CharSequence)cardExpiry) && (expiry = cardExpiry.split("/")).length == 2) {
            year = Year.getYear(expiry[1]);
        }
        return year;
    }

    private void init() {
        this.addTextChangedListener(this.customWatcher);
    }
}

