/*
 * Decompiled with CFR 0.152.
 */
package com.citrus.sdk.response;

import android.os.Parcel;
import android.os.Parcelable;
import com.citrus.sdk.CitrusUser;
import com.citrus.sdk.classes.Amount;
import com.citrus.sdk.response.CitrusResponse;
import com.google.gson.annotations.SerializedName;

public class PaymentResponse
extends CitrusResponse
implements Parcelable {
    @SerializedName(value="id")
    protected String transactionId = null;
    @SerializedName(value="amount")
    protected Amount transactionAmount = null;
    @SerializedName(value="balance")
    protected Amount balanceAmount = null;
    @SerializedName(value="cutsomer")
    protected String customer = null;
    @SerializedName(value="merchant")
    protected String merchantName = null;
    @SerializedName(value="date")
    protected String date = null;
    protected CitrusUser user = null;
    public static final Parcelable.Creator<PaymentResponse> CREATOR = new Parcelable.Creator<PaymentResponse>(){

        public PaymentResponse createFromParcel(Parcel source) {
            return new PaymentResponse(source);
        }

        public PaymentResponse[] newArray(int size) {
            return new PaymentResponse[size];
        }
    };

    PaymentResponse() {
    }

    public PaymentResponse(String message, CitrusResponse.Status status, String transactionId, Amount transactionAmount, Amount balanceAmount, CitrusUser user) {
        super(message, status);
        this.transactionId = transactionId;
        this.transactionAmount = transactionAmount;
        this.balanceAmount = balanceAmount;
        this.user = user;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public Amount getTransactionAmount() {
        return this.transactionAmount;
    }

    public Amount getBalanceAmount() {
        return this.balanceAmount;
    }

    public CitrusUser getUser() {
        return this.user;
    }

    public String getMerchantName() {
        return this.merchantName;
    }

    public String getDate() {
        return this.date;
    }

    public String getCustomer() {
        return this.customer;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.transactionId);
        dest.writeParcelable((Parcelable)this.transactionAmount, 0);
        dest.writeParcelable((Parcelable)this.balanceAmount, 0);
        dest.writeParcelable((Parcelable)this.user, 0);
        dest.writeString(this.merchantName);
        dest.writeString(this.date);
        dest.writeString(this.message);
        dest.writeInt(this.status == null ? -1 : this.status.ordinal());
    }

    private PaymentResponse(Parcel in) {
        this.transactionId = in.readString();
        this.transactionAmount = (Amount)in.readParcelable(Amount.class.getClassLoader());
        this.balanceAmount = (Amount)in.readParcelable(Amount.class.getClassLoader());
        this.user = (CitrusUser)in.readParcelable(CitrusUser.class.getClassLoader());
        this.merchantName = in.readString();
        this.date = in.readString();
        this.message = in.readString();
        int tmpStatus = in.readInt();
        this.status = tmpStatus == -1 ? null : CitrusResponse.Status.values()[tmpStatus];
    }

    public String toString() {
        return "PaymentResponse{transactionId='" + this.transactionId + '\'' + ", transactionAmount=" + this.transactionAmount + ", balanceAmount=" + this.balanceAmount + ", user=" + this.user + ", merchantName='" + this.merchantName + '\'' + ", date='" + this.date + '\'' + '}';
    }
}

