/*
 * Decompiled with CFR 0.152.
 */
package com.citrus.sdk.payment;

import android.text.TextUtils;
import com.citrus.sdk.classes.PGHealth;
import com.citrus.sdk.payment.CardOption;
import com.citrus.sdk.payment.NetbankingOption;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class MerchantPaymentOption {
    private Set<CardOption.CardScheme> creditCardSchemeSet = null;
    private Set<CardOption.CardScheme> debitCardSchemeSet = null;
    private ArrayList<NetbankingOption> netbankingOptionList = null;

    private MerchantPaymentOption(Set<CardOption.CardScheme> creditCardSchemeSet, Set<CardOption.CardScheme> debitCardSchemeSet, ArrayList<NetbankingOption> netbankingOptionList) {
        this.creditCardSchemeSet = creditCardSchemeSet;
        this.debitCardSchemeSet = debitCardSchemeSet;
        this.netbankingOptionList = netbankingOptionList;
    }

    public Set<CardOption.CardScheme> getCreditCardSchemeSet() {
        return this.creditCardSchemeSet;
    }

    public Set<CardOption.CardScheme> getDebitCardSchemeSet() {
        return this.debitCardSchemeSet;
    }

    public ArrayList<NetbankingOption> getNetbankingOptionList() {
        return this.netbankingOptionList;
    }

    public static MerchantPaymentOption getMerchantPaymentOptions(JsonObject merchantPaymentOptionsObj) {
        return MerchantPaymentOption.getMerchantPaymentOptions(merchantPaymentOptionsObj, null);
    }

    public static MerchantPaymentOption getMerchantPaymentOptions(JsonObject merchantPaymentOptionsObj, Map<String, PGHealth> pgHealthMap) {
        String cardScheme;
        JsonElement element;
        int i;
        HashSet<CardOption.CardScheme> debitCardSchemeSet = null;
        HashSet<CardOption.CardScheme> creditCardSchemeSet = null;
        ArrayList<NetbankingOption> netbankingOptionList = null;
        JsonArray bankArray = merchantPaymentOptionsObj.getAsJsonArray("netBanking");
        JsonArray creditCardArray = merchantPaymentOptionsObj.getAsJsonArray("creditCard");
        JsonArray debitCardArray = merchantPaymentOptionsObj.getAsJsonArray("debitCard");
        int size = -1;
        size = creditCardArray.size();
        for (i = 0; i < size; ++i) {
            element = creditCardArray.get(i);
            cardScheme = element.getAsString();
            if (creditCardSchemeSet == null) {
                creditCardSchemeSet = new HashSet<CardOption.CardScheme>();
            }
            if (MerchantPaymentOption.getCardScheme(cardScheme) == null) continue;
            creditCardSchemeSet.add(MerchantPaymentOption.getCardScheme(cardScheme));
        }
        size = debitCardArray.size();
        for (i = 0; i < size; ++i) {
            element = debitCardArray.get(i);
            cardScheme = element.getAsString();
            if (debitCardSchemeSet == null) {
                debitCardSchemeSet = new HashSet<CardOption.CardScheme>();
            }
            if (MerchantPaymentOption.getCardScheme(cardScheme) == null) continue;
            debitCardSchemeSet.add(MerchantPaymentOption.getCardScheme(cardScheme));
        }
        size = bankArray.size();
        for (i = 0; i < size; ++i) {
            element = bankArray.get(i);
            if (!element.isJsonObject()) continue;
            JsonObject bankOption = element.getAsJsonObject();
            element = bankOption.get("bankName");
            String bankName = element.getAsString();
            element = bankOption.get("issuerCode");
            String issuerCode = element.getAsString();
            if (TextUtils.isEmpty((CharSequence)bankName) || TextUtils.isEmpty((CharSequence)issuerCode)) continue;
            NetbankingOption netbankingOption = new NetbankingOption(bankName, issuerCode);
            if (pgHealthMap != null) {
                netbankingOption.setPgHealth(pgHealthMap.get(issuerCode));
            }
            if (netbankingOptionList == null) {
                netbankingOptionList = new ArrayList<NetbankingOption>();
            }
            netbankingOptionList.add(netbankingOption);
        }
        MerchantPaymentOption merchantPaymentOption = new MerchantPaymentOption(creditCardSchemeSet, debitCardSchemeSet, netbankingOptionList);
        return merchantPaymentOption;
    }

    private static CardOption.CardScheme getCardScheme(String cardScheme) {
        if ("Visa".equalsIgnoreCase(cardScheme)) {
            return CardOption.CardScheme.VISA;
        }
        if ("Master Card".equalsIgnoreCase(cardScheme)) {
            return CardOption.CardScheme.MASTER_CARD;
        }
        if ("Amex".equalsIgnoreCase(cardScheme)) {
            return CardOption.CardScheme.AMEX;
        }
        if ("Maestro Card".equalsIgnoreCase(cardScheme)) {
            return CardOption.CardScheme.MAESTRO;
        }
        if ("Diners".equalsIgnoreCase(cardScheme)) {
            return CardOption.CardScheme.DINERS;
        }
        return null;
    }

    public String toString() {
        return "MerchantPaymentOption{creditCardSchemeSet=" + this.creditCardSchemeSet + ", debitCardSchemeSet=" + this.debitCardSchemeSet + ", netbankingOptionList=" + this.netbankingOptionList + '}';
    }
}

