/*
 * Decompiled with CFR 0.152.
 */
package com.citrus.citrususer;

import com.citrus.citrususer.PasswordGenerator;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class RandomPassword
implements PasswordGenerator {
    private MessageDigest md5;

    public RandomPassword() {
        try {
            this.md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException nsax) {
            throw new RuntimeException(nsax);
        }
    }

    @Override
    public String generate(String email, String mobile) {
        PseudoRandomNumberGenerator ran = new PseudoRandomNumberGenerator(this.generateSeed(email));
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < 8; ++i) {
            builder.append(ran.nextLetter());
        }
        return builder.toString();
    }

    public int generateSeed(String data) {
        byte[] hash = this.md5.digest(data.getBytes());
        this.md5.reset();
        hash = RandomPassword.rangeCopy(hash, hash.length - 3, hash.length);
        return new BigInteger(1, hash).intValue();
    }

    public static byte[] rangeCopy(byte[] original, int from, int to) {
        int lengthNew = to - from;
        if (lengthNew < 0) {
            throw new IllegalArgumentException(from + " > " + to);
        }
        byte[] hash = new byte[lengthNew];
        System.arraycopy(original, from, hash, 0, Math.min(original.length - from, lengthNew));
        return hash;
    }

    public static class PseudoRandomNumberGenerator {
        private int state;

        public PseudoRandomNumberGenerator(int seed) {
            this.state = seed;
        }

        public int nextInt(int max) {
            this.state = 7 * this.state % 3001;
            return (this.state - 1) % max;
        }

        public char nextLetter() {
            int n;
            return (char)(n + ((n = this.nextInt(52)) < 26 ? 65 : 71));
        }
    }
}

