/*
 * Decompiled with CFR 0.152.
 */
package com.citrus.retrofit;

import com.citrus.sdk.classes.AccessToken;
import com.citrus.sdk.classes.Amount;
import com.citrus.sdk.classes.BindPOJO;
import com.citrus.sdk.classes.CitrusPrepaidBill;
import com.citrus.sdk.classes.CitrusUMResponse;
import com.citrus.sdk.classes.LinkUserResponse;
import com.citrus.sdk.classes.PGHealthResponse;
import com.citrus.sdk.classes.StructResponsePOJO;
import com.citrus.sdk.classes.UpdateMobileResponse;
import com.citrus.sdk.classes.VerifyMobileResponse;
import com.citrus.sdk.response.CitrusResponse;
import com.citrus.sdk.response.PaymentResponse;
import com.google.gson.JsonElement;
import retrofit.Callback;
import retrofit.ResponseCallback;
import retrofit.client.Response;
import retrofit.http.Body;
import retrofit.http.DELETE;
import retrofit.http.Field;
import retrofit.http.FormUrlEncoded;
import retrofit.http.GET;
import retrofit.http.Header;
import retrofit.http.Headers;
import retrofit.http.POST;
import retrofit.http.PUT;
import retrofit.http.Path;
import retrofit.mime.TypedString;

public interface API {
    @FormUrlEncoded
    @POST(value="/oauth/token")
    public void getSignUpToken(@Field(value="client_id") String var1, @Field(value="client_secret") String var2, @Field(value="grant_type") String var3, Callback<AccessToken> var4);

    @FormUrlEncoded
    @POST(value="/service/v2/identity/bind")
    public void getBindResponse(@Header(value="Authorization") String var1, @Field(value="email") String var2, @Field(value="mobile") String var3, Callback<BindPOJO> var4);

    @Headers(value={"Content-Type: application/json"})
    @POST(value="/service/um/link/user")
    public void linkUser(@Header(value="Authorization") String var1, @Body TypedString var2, Callback<LinkUserResponse> var3);

    @FormUrlEncoded
    @POST(value="/oauth/token")
    public void getSignInToken(@Field(value="client_id") String var1, @Field(value="client_secret") String var2, @Field(value="username") String var3, @Field(value="grant_type") String var4, Callback<AccessToken> var5);

    @FormUrlEncoded
    @POST(value="/oauth/token")
    public void getSignInWithPasswordResponse(@Field(value="client_id") String var1, @Field(value="client_secret") String var2, @Field(value="username") String var3, @Field(value="password") String var4, @Field(value="grant_type") String var5, Callback<AccessToken> var6);

    @FormUrlEncoded
    @POST(value="/oauth/token")
    public void getSignInWithOTP(@Field(value="client_id") String var1, @Field(value="client_secret") String var2, @Field(value="username") String var3, @Field(value="password") String var4, @Field(value="grant_type") String var5, Callback<AccessToken> var6);

    @FormUrlEncoded
    @POST(value="/prepaid/pg/_verify")
    public void getCookie(@Field(value="email") String var1, @Field(value="password") String var2, @Field(value="rmcookie") String var3, Callback<String> var4);

    @FormUrlEncoded
    @PUT(value="/service/v2/identity/me/password")
    public void setPasswordResponse(@Header(value="Authorization") String var1, @Field(value="old") String var2, @Field(value="new") String var3, Callback<ResponseCallback> var4);

    @FormUrlEncoded
    @POST(value="/oauth/token")
    public AccessToken getRefreshToken(@Field(value="client_id") String var1, @Field(value="client_secret") String var2, @Field(value="grant_type") String var3, @Field(value="refresh_token") String var4);

    @FormUrlEncoded
    @POST(value="/oauth/token")
    public void getRefreshTokenAsync(@Field(value="client_id") String var1, @Field(value="client_secret") String var2, @Field(value="grant_type") String var3, @Field(value="refresh_token") String var4, Callback<AccessToken> var5);

    @FormUrlEncoded
    @POST(value="/service/um/identity/bind/mobile")
    public void bindUserByMobile(@Header(value="Authorization") String var1, @Field(value="email") String var2, @Field(value="mobile") String var3, Callback<BindPOJO> var4);

    @Headers(value={"Content-Type: application/json"})
    @POST(value="/service/um/profile/memberInfo")
    public void getMemberInfo(@Header(value="Authorization") String var1, @Body TypedString var2, Callback<JsonElement> var3);

    @FormUrlEncoded
    @POST(value="/service/v2/identity/passwords/reset")
    public void resetPassword(@Header(value="Authorization") String var1, @Field(value="username") String var2, Callback<JsonElement> var3);

    @Headers(value={"Content-Type: application/json"})
    @POST(value="/service/moto/authorize/struct/payment")
    public void getPaymentResponse(@Body TypedString var1, Callback<StructResponsePOJO> var2);

    @Headers(value={"Content-Type: application/json"})
    @POST(value="/service/um/mobileverification/sendCode")
    public void updateMobile(@Header(value="Authorization") String var1, @Body TypedString var2, Callback<UpdateMobileResponse> var3);

    @Headers(value={"Content-Type: application/json"})
    @POST(value="/service/um/mobileverification/verifyCode")
    public void verifyMobile(@Header(value="Authorization") String var1, @Body TypedString var2, Callback<VerifyMobileResponse> var3);

    @FormUrlEncoded
    @POST(value="/service/v1/merchant/pgsetting")
    public void getMerchantPaymentOptions(@Field(value="vanity") String var1, Callback<JsonElement> var2);

    @GET(value="/service/v2/profile/me/payment")
    public void getWallet(@Header(value="Authorization") String var1, Callback<JsonElement> var2);

    @GET(value="/service/v2/prepayment/balance")
    public void activatePrepaidUser(@Header(value="Authorization") String var1, Callback<Amount> var2);

    @POST(value="/service/v2/mycard/balance")
    @FormUrlEncoded
    public void getBalance(@Header(value="Authorization") String var1, @Field(value="dummy") String var2, Callback<Amount> var3);

    @GET(value="/{path}")
    public void getBill(@Path(value="path", encode=false) String var1, Callback<JsonElement> var2);

    @Headers(value={"Content-Type: application/json"})
    @PUT(value="/service/v2/profile/me/payment")
    public void savePaymentOption(@Header(value="Authorization") String var1, @Body TypedString var2, Callback<CitrusResponse> var3);

    @FormUrlEncoded
    @POST(value="/service/v2/prepayment/transfer")
    public void sendMoneyByEmail(@Header(value="Authorization") String var1, @Field(value="amount") String var2, @Field(value="currency") String var3, @Field(value="message") String var4, @Field(value="to") String var5, Callback<PaymentResponse> var6);

    @FormUrlEncoded
    @POST(value="/service/v2/prepayment/transfer/extended")
    public void sendMoneyByMobile(@Header(value="Authorization") String var1, @Field(value="amount") String var2, @Field(value="currency") String var3, @Field(value="message") String var4, @Field(value="to") String var5, Callback<PaymentResponse> var6);

    @FormUrlEncoded
    @POST(value="/service/v2/prepayment/load")
    public void getPrepaidBill(@Header(value="Authorization") String var1, @Field(value="amount") String var2, @Field(value="redirect") String var3, @Field(value="currency") String var4, Callback<CitrusPrepaidBill> var5);

    @GET(value="/utility/{path}/merchantName")
    public void getMerchantName(@Path(value="path") String var1, Callback<Response> var2);

    @FormUrlEncoded
    @POST(value="/service/v2/prepayment/cashout")
    public void cashout(@Header(value="Authorization") String var1, @Field(value="amount") String var2, @Field(value="currency") String var3, @Field(value="owner") String var4, @Field(value="account") String var5, @Field(value="ifsc") String var6, Callback<PaymentResponse> var7);

    @GET(value="/service/v2/profile/me/prepaid")
    public void getCashoutInfo(@Header(value="Authorization") String var1, Callback<JsonElement> var2);

    @Headers(value={"Content-Type: application/json"})
    @PUT(value="/service/v2/profile/me/prepaid")
    public void saveCashoutInfo(@Header(value="Authorization") String var1, @Body TypedString var2, Callback<CitrusResponse> var3);

    @FormUrlEncoded
    @POST(value="/utility/{path}/pgHealth")
    public void getPGHealth(@Path(value="path") String var1, @Field(value="bankCode") String var2, Callback<PGHealthResponse> var3);

    @FormUrlEncoded
    @POST(value="/utility/{path}/pgHealth")
    public void getPGHealthForAllBanks(@Path(value="path") String var1, @Field(value="bankCode") String var2, Callback<JsonElement> var3);

    @DELETE(value="/service/v2/profile/me/payment/{last4Digits}:{scheme}")
    public void deleteCard(@Header(value="Authorization") String var1, @Path(value="last4Digits") String var2, @Path(value="scheme") String var3, Callback<CitrusResponse> var4);

    @DELETE(value="/service/v2/profile/me/payment/{bankToken}")
    public void deleteBank(@Header(value="Authorization") String var1, @Path(value="bankToken") String var2, Callback<CitrusResponse> var3);

    @GET(value="/service/um/profile/profileInfo")
    public void getProfileInfo(@Header(value="Authorization") String var1, Callback<JsonElement> var2);

    @Headers(value={"Content-Type: application/json"})
    @PUT(value="/service/v2/profile/me/payment")
    public void setDefaultPaymentOption(@Header(value="Authorization") String var1, @Body TypedString var2, Callback<CitrusResponse> var3);

    @FormUrlEncoded
    @POST(value="/service/um/user/reset/password")
    public void resetUMPassword(@Header(value="Authorization") String var1, @Field(value="username") String var2, Callback<CitrusUMResponse> var3);

    @FormUrlEncoded
    @POST(value="/service/um/user/signup")
    public void signUpUser(@Header(value="Authorization") String var1, @Field(value="email") String var2, @Field(value="mobile") String var3, @Field(value="password") String var4, @Field(value="firstName") String var5, @Field(value="lastName") String var6, @Field(value="sourceType") String var7, @Field(value="markMobileVerified") String var8, @Field(value="markEmailVerified") String var9, Callback<CitrusUMResponse> var10);

    @FormUrlEncoded
    @PUT(value="/service/um/user/change/password")
    public void changePassword(@Header(value="Authorization") String var1, @Field(value="old") String var2, @Field(value="new") String var3, Callback<CitrusUMResponse> var4);

    @Headers(value={"Content-Type: application/json"})
    @PUT(value="/service/um/profile/update")
    public void updateUserProfileDetails(@Header(value="Authorization") String var1, @Body TypedString var2, Callback<CitrusUMResponse> var3);

    @Headers(value={"Content-Type: application/json"})
    @POST(value="/service/um/otp/generate")
    public void sendOneTimePassword(@Body TypedString var1, Callback<CitrusUMResponse> var2);

    @GET(value="/binservice/v2/bin/{first6Digits}")
    public void getCardType(@Path(value="first6Digits") String var1, Callback<JsonElement> var2);
}

