/*
 * Decompiled with CFR 0.152.
 */
package com.citrus.mobile;

import android.app.Activity;
import android.content.Context;
import android.webkit.CookieManager;
import android.webkit.CookieSyncManager;
import com.citrus.cash.PersistentConfig;
import com.citrus.mobile.Config;
import com.citrus.mobile.OauthToken;
import com.citrus.mobile.RESTclient;
import com.citrus.mobile.SuccessCall;
import java.io.IOException;
import org.json.JSONException;
import org.json.JSONObject;

public class User {
    public static final String SIGNIN_TOKEN = "signin_token";
    public static final String SIGNUP_TOKEN = "signup_token";
    public static final String PREPAID_TOKEN = "prepaid_token";
    private Activity activity;
    private String base_url;

    public User(Activity activity) {
        this.activity = activity;
        this.base_url = Config.getEnv();
    }

    private JSONObject getSignupToken(String email, String mobile) {
        JSONObject response = new JSONObject();
        JSONObject userJson = new JSONObject();
        try {
            userJson.put("client_id", (Object)Config.getSignupId());
            userJson.put("client_secret", (Object)Config.getSignupSecret());
            userJson.put("grant_type", (Object)"implicit");
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        JSONObject headers = new JSONObject();
        try {
            headers.put("Content-Type", (Object)"application/x-www-form-urlencoded");
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        RESTclient restclient = new RESTclient("signup", this.base_url, userJson, headers);
        try {
            response = restclient.makePostrequest();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (response.has("access_token")) {
            OauthToken signuptoken = new OauthToken(this.activity, SIGNUP_TOKEN);
            signuptoken.createToken(response);
            return this.signupuser(email, mobile, response);
        }
        return response;
    }

    public JSONObject binduser(String email, String mobile) {
        return this.getSignupToken(email, mobile);
    }

    private JSONObject signupuser(String email, String mobile, JSONObject token) {
        JSONObject signupJson = new JSONObject();
        JSONObject response = new JSONObject();
        try {
            signupJson.put("email", (Object)email);
            signupJson.put("mobile", (Object)mobile);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        JSONObject headers = new JSONObject();
        try {
            headers.put("Content-Type", (Object)"application/x-www-form-urlencoded");
            headers.put("Authorization", (Object)("Bearer " + token.getString("access_token")));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        RESTclient restclient = new RESTclient("bind", this.base_url, signupJson, headers);
        try {
            response = restclient.makePostrequest();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (response.has("username")) {
            return this.signinUser(email);
        }
        return response;
    }

    public JSONObject signinUser(String email) {
        JSONObject response = new JSONObject();
        JSONObject userJson = new JSONObject();
        try {
            userJson.put("client_id", (Object)Config.getSigninId());
            userJson.put("client_secret", (Object)Config.getSigninSecret());
            userJson.put("grant_type", (Object)"username");
            userJson.put("username", (Object)email);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        JSONObject headers = new JSONObject();
        try {
            headers.put("Content-Type", (Object)"application/x-www-form-urlencoded");
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        RESTclient restclient = new RESTclient("signin", this.base_url, userJson, headers);
        try {
            response = restclient.makePostrequest();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (response.has("access_token")) {
            OauthToken token = new OauthToken(this.activity, SIGNIN_TOKEN);
            token.createToken(response);
            return SuccessCall.successMessage("user bound", null);
        }
        return response;
    }

    public static final boolean logoutUser(Activity activity) {
        CookieSyncManager.createInstance((Context)activity);
        CookieManager.getInstance().setCookie(Config.getBaseURL(), "prepaiduser-payauth=''");
        new PersistentConfig((Context)activity).clearToken();
        OauthToken token = new OauthToken(activity, "");
        return token.clearToken();
    }

    public static final boolean logoutUser(Context context) {
        CookieSyncManager.createInstance((Context)context);
        String setCookie = CookieManager.getInstance().getCookie(Config.getBaseURL());
        CookieManager.getInstance().setCookie(Config.getBaseURL(), "prepaiduser-payauth=''");
        new PersistentConfig(context).clearToken();
        OauthToken token = new OauthToken(context, "");
        return token.clearToken();
    }

    public static final boolean isUserLoggedIn(Activity activity) {
        OauthToken token = new OauthToken(activity, PREPAID_TOKEN);
        return token.getuserToken() != null;
    }
}

