/*
 * Decompiled with CFR 0.152.
 */
package com.citi.gradle.plugins.helm.publishing.publishers;

import com.citi.gradle.plugins.helm.dsl.credentials.internal.SerializableCertificateCredentials;
import com.citi.gradle.plugins.helm.dsl.credentials.internal.SerializableCredentials;
import com.citi.gradle.plugins.helm.dsl.credentials.internal.SerializablePasswordCredentials;
import com.citi.gradle.plugins.helm.publishing.publishers.HelmChartPublisher;
import com.citi.gradle.plugins.helm.publishing.publishers.HttpResponseException;
import java.io.Closeable;
import java.io.File;
import java.net.URI;
import java.security.cert.X509Certificate;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.Credentials;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.tls.HandshakeCertificates;
import okhttp3.tls.HeldCertificate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b \u0018\u0000 \"2\u00020\u0001:\u0001\"B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J,\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u000f2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\u0018\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000bH\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\u001e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\u0018\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000bH$J\f\u0010\u001c\u001a\u00020\u001d*\u00020\u001eH\u0002J\f\u0010\u001f\u001a\u00020 *\u00020!H\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u00020\u000bX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/citi/gradle/plugins/helm/publishing/publishers/AbstractHttpHelmChartPublisher;", "Lcom/citi/gradle/plugins/helm/publishing/publishers/HelmChartPublisher;", "url", "Ljava/net/URI;", "credentials", "Lcom/citi/gradle/plugins/helm/dsl/credentials/internal/SerializableCredentials;", "(Ljava/net/URI;Lcom/citi/gradle/plugins/helm/dsl/credentials/internal/SerializableCredentials;)V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "uploadMethod", "", "getUploadMethod", "()Ljava/lang/String;", "additionalHeaders", "", "chartName", "chartVersion", "chartFile", "Ljava/io/File;", "buildFullUploadUrl", "createHttpClient", "Lokhttp3/OkHttpClient;", "publish", "", "requestBody", "Lokhttp3/RequestBody;", "uploadPath", "createAuthInterceptor", "Lokhttp3/Interceptor;", "Lcom/citi/gradle/plugins/helm/dsl/credentials/internal/SerializablePasswordCredentials;", "createHeldCertificate", "Lokhttp3/tls/HeldCertificate;", "Lcom/citi/gradle/plugins/helm/dsl/credentials/internal/SerializableCertificateCredentials;", "Companion", "helm-publish-plugin"})
public abstract class AbstractHttpHelmChartPublisher
implements HelmChartPublisher {
    @NotNull
    protected static final Companion Companion = new Companion(null);
    @NotNull
    private final URI url;
    @Nullable
    private final SerializableCredentials credentials;
    private final Logger logger;
    @NotNull
    private static final MediaType MEDIA_TYPE_GZIP = MediaType.Companion.get("application/x-gzip");

    public AbstractHttpHelmChartPublisher(@NotNull URI url, @Nullable SerializableCredentials credentials) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this.url = url;
        this.credentials = credentials;
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    public /* synthetic */ AbstractHttpHelmChartPublisher(URI uRI, SerializableCredentials serializableCredentials, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            serializableCredentials = null;
        }
        this(uRI, serializableCredentials);
    }

    @NotNull
    protected abstract String getUploadMethod();

    @NotNull
    protected abstract String uploadPath(@NotNull String var1, @NotNull String var2);

    @NotNull
    protected Map<String, String> additionalHeaders(@NotNull String chartName, @NotNull String chartVersion, @NotNull File chartFile) {
        Intrinsics.checkNotNullParameter((Object)chartName, (String)"chartName");
        Intrinsics.checkNotNullParameter((Object)chartVersion, (String)"chartVersion");
        Intrinsics.checkNotNullParameter((Object)chartFile, (String)"chartFile");
        return MapsKt.emptyMap();
    }

    @NotNull
    protected RequestBody requestBody(@NotNull File chartFile) {
        Intrinsics.checkNotNullParameter((Object)chartFile, (String)"chartFile");
        return RequestBody.Companion.create(chartFile, MEDIA_TYPE_GZIP);
    }

    private final String buildFullUploadUrl(String chartName, String chartVersion) {
        StringBuilder stringBuilder;
        String path = StringsKt.removePrefix((String)this.uploadPath(chartName, chartVersion), (CharSequence)"/");
        StringBuilder $this$buildFullUploadUrl_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$buildFullUploadUrl_u24lambda_u240.append(this.url.toString());
        if (!StringsKt.endsWith$default((CharSequence)$this$buildFullUploadUrl_u24lambda_u240, (char)'/', (boolean)false, (int)2, null) && ((CharSequence)path).length() > 0) {
            $this$buildFullUploadUrl_u24lambda_u240.append('/');
        }
        $this$buildFullUploadUrl_u24lambda_u240.append(path);
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void publish(@NotNull String chartName, @NotNull String chartVersion, @NotNull File chartFile) {
        Intrinsics.checkNotNullParameter((Object)chartName, (String)"chartName");
        Intrinsics.checkNotNullParameter((Object)chartVersion, (String)"chartVersion");
        Intrinsics.checkNotNullParameter((Object)chartFile, (String)"chartFile");
        String uploadUrl = this.buildFullUploadUrl(chartName, chartVersion);
        Object[] objectArray = new Object[]{chartFile, this.getUploadMethod(), uploadUrl};
        this.logger.info("Uploading chart file {} via {} to repository URL {}", objectArray);
        OkHttpClient httpClient = this.createHttpClient();
        Request.Builder $this$publish_u24lambda_u241 = new Request.Builder();
        boolean bl = false;
        $this$publish_u24lambda_u241.url(HttpUrl.Companion.get(uploadUrl));
        $this$publish_u24lambda_u241.method(this.getUploadMethod(), this.requestBody(chartFile));
        Request request = $this$publish_u24lambda_u241.build();
        Closeable closeable = (Closeable)httpClient.newCall(request).execute();
        Throwable throwable = null;
        try {
            Response response = (Response)closeable;
            boolean bl2 = false;
            if (!response.isSuccessful()) {
                throw new HttpResponseException(this.getUploadMethod(), uploadUrl, response.code(), response.message());
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final OkHttpClient createHttpClient() {
        OkHttpClient.Builder $this$createHttpClient_u24lambda_u243 = new OkHttpClient.Builder();
        boolean bl = false;
        if (this.credentials != null) {
            SerializableCredentials serializableCredentials = this.credentials;
            if (serializableCredentials instanceof SerializablePasswordCredentials) {
                $this$createHttpClient_u24lambda_u243.addInterceptor(this.createAuthInterceptor((SerializablePasswordCredentials)this.credentials));
            } else if (serializableCredentials instanceof SerializableCertificateCredentials) {
                HandshakeCertificates handshakeCertificates = new HandshakeCertificates.Builder().heldCertificate(this.createHeldCertificate((SerializableCertificateCredentials)this.credentials), new X509Certificate[0]).addPlatformTrustedCertificates().build();
                $this$createHttpClient_u24lambda_u243.sslSocketFactory(handshakeCertificates.sslSocketFactory(), handshakeCertificates.trustManager());
            }
        }
        return $this$createHttpClient_u24lambda_u243.build();
    }

    private final Interceptor createAuthInterceptor(SerializablePasswordCredentials $this$createAuthInterceptor) {
        return arg_0 -> AbstractHttpHelmChartPublisher.createAuthInterceptor$lambda$4($this$createAuthInterceptor, arg_0);
    }

    private final HeldCertificate createHeldCertificate(SerializableCertificateCredentials $this$createHeldCertificate) {
        String certText = FilesKt.readText$default((File)$this$createHeldCertificate.getCertificateFile(), null, (int)1, null);
        String keyText = FilesKt.readText$default((File)$this$createHeldCertificate.getKeyFile(), null, (int)1, null);
        return HeldCertificate.Companion.decode(certText + '\n' + keyText);
    }

    private static final Response createAuthInterceptor$lambda$4(SerializablePasswordCredentials $this_createAuthInterceptor, Interceptor.Chain chain) {
        Intrinsics.checkNotNullParameter((Object)$this_createAuthInterceptor, (String)"$this_createAuthInterceptor");
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        Request.Builder builder = chain.request().newBuilder();
        String string = $this_createAuthInterceptor.getUsername();
        String string2 = $this_createAuthInterceptor.getPassword();
        if (string2 == null) {
            string2 = "";
        }
        Request request = builder.addHeader("Authorization", Credentials.basic$default((String)string, (String)string2, null, (int)4, null)).build();
        return chain.proceed(request);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0084\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/citi/gradle/plugins/helm/publishing/publishers/AbstractHttpHelmChartPublisher$Companion;", "", "()V", "MEDIA_TYPE_GZIP", "Lokhttp3/MediaType;", "getMEDIA_TYPE_GZIP", "()Lokhttp3/MediaType;", "helm-publish-plugin"})
    protected static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MediaType getMEDIA_TYPE_GZIP() {
            return MEDIA_TYPE_GZIP;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

