/*
 * Decompiled with CFR 0.152.
 */
package com.citi.gradle.plugins.helm.publishing.dsl;

import com.citi.gradle.plugins.helm.dsl.credentials.internal.SerializableCredentials;
import com.citi.gradle.plugins.helm.dsl.credentials.internal.SerializableCredentialsKt;
import com.citi.gradle.plugins.helm.publishing.dsl.AbstractHelmPublishingRepository;
import com.citi.gradle.plugins.helm.publishing.dsl.HarborHelmPublishingRepository;
import com.citi.gradle.plugins.helm.publishing.publishers.AbstractHttpHelmChartPublisher;
import com.citi.gradle.plugins.helm.publishing.publishers.HelmChartPublisher;
import com.citi.gradle.plugins.helm.publishing.publishers.PublisherParams;
import java.io.File;
import java.net.URI;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import org.gradle.api.credentials.Credentials;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0012\u0018\u00002\u00020\u00012\u00020\u0002:\u0002\u0010\u0011B\u0017\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0012"}, d2={"Lcom/citi/gradle/plugins/helm/publishing/dsl/DefaultHarborHelmPublishingRepository;", "Lcom/citi/gradle/plugins/helm/publishing/dsl/AbstractHelmPublishingRepository;", "Lcom/citi/gradle/plugins/helm/publishing/dsl/HarborHelmPublishingRepository;", "name", "", "objects", "Lorg/gradle/api/model/ObjectFactory;", "(Ljava/lang/String;Lorg/gradle/api/model/ObjectFactory;)V", "projectName", "Lorg/gradle/api/provider/Property;", "getProjectName", "()Lorg/gradle/api/provider/Property;", "publisherParams", "Lcom/citi/gradle/plugins/helm/publishing/publishers/PublisherParams;", "getPublisherParams", "()Lcom/citi/gradle/plugins/helm/publishing/publishers/PublisherParams;", "HarborPublisher", "HarborPublisherParams", "helm-publish-plugin"})
@SourceDebugExtension(value={"SMAP\nHarborHelmPublishingRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HarborHelmPublishingRepository.kt\ncom/citi/gradle/plugins/helm/publishing/dsl/DefaultHarborHelmPublishingRepository\n+ 2 ObjectFactoryExtensions.kt\norg/unbrokendome/gradle/pluginutils/ObjectFactoryExtensionsKt\n*L\n1#1,87:1\n17#2:88\n*S KotlinDebug\n*F\n+ 1 HarborHelmPublishingRepository.kt\ncom/citi/gradle/plugins/helm/publishing/dsl/DefaultHarborHelmPublishingRepository\n*L\n36#1:88\n*E\n"})
class DefaultHarborHelmPublishingRepository
extends AbstractHelmPublishingRepository
implements HarborHelmPublishingRepository {
    @NotNull
    private final Property<String> projectName;

    @Inject
    public DefaultHarborHelmPublishingRepository(@NotNull String name, @NotNull ObjectFactory objects) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)objects, (String)"objects");
        super(objects, name);
        ObjectFactory $this$property$iv = objects;
        boolean $i$f$property = false;
        Property property = $this$property$iv.property(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)property, (String)"property(T::class.javaObjectType)");
        Property property2 = property.convention((Object)"library");
        Intrinsics.checkNotNullExpressionValue((Object)property2, (String)"convention(...)");
        this.projectName = property2;
    }

    @Override
    @NotNull
    public Property<String> getProjectName() {
        return this.projectName;
    }

    @Override
    @NotNull
    public PublisherParams getPublisherParams() {
        Object object = this.getUrl().getOrNull();
        if (object == null) {
            boolean $i$a$-requireNotNull-DefaultHarborHelmPublishingRepository$publisherParams$32 = false;
            String $i$a$-requireNotNull-DefaultHarborHelmPublishingRepository$publisherParams$32 = "url is required for Harbor publishing repository";
            throw new IllegalArgumentException($i$a$-requireNotNull-DefaultHarborHelmPublishingRepository$publisherParams$32.toString());
        }
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"requireNotNull(...)");
        URI uRI = (URI)object;
        Object object2 = this.getProjectName().getOrNull();
        if (object2 == null) {
            URI uRI2 = uRI;
            boolean bl = false;
            URI uRI3 = uRI2;
            String string = "projectName is required for Harbor publishing repository";
            throw new IllegalArgumentException(string.toString());
        }
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"requireNotNull(...)");
        Credentials credentials = (Credentials)this.getConfiguredCredentials().getOrNull();
        SerializableCredentials serializableCredentials = credentials != null ? SerializableCredentialsKt.toSerializable((Credentials)credentials) : null;
        String string = (String)object2;
        URI uRI4 = uRI;
        return new HarborPublisherParams(uRI4, string, serializableCredentials);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0018\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0005H\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\u00058TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0013"}, d2={"Lcom/citi/gradle/plugins/helm/publishing/dsl/DefaultHarborHelmPublishingRepository$HarborPublisher;", "Lcom/citi/gradle/plugins/helm/publishing/publishers/AbstractHttpHelmChartPublisher;", "url", "Ljava/net/URI;", "projectName", "", "credentials", "Lcom/citi/gradle/plugins/helm/dsl/credentials/internal/SerializableCredentials;", "(Ljava/net/URI;Ljava/lang/String;Lcom/citi/gradle/plugins/helm/dsl/credentials/internal/SerializableCredentials;)V", "uploadMethod", "getUploadMethod", "()Ljava/lang/String;", "requestBody", "Lokhttp3/RequestBody;", "chartFile", "Ljava/io/File;", "uploadPath", "chartName", "chartVersion", "helm-publish-plugin"})
    private static final class HarborPublisher
    extends AbstractHttpHelmChartPublisher {
        @NotNull
        private final String projectName;

        public HarborPublisher(@NotNull URI url, @NotNull String projectName, @Nullable SerializableCredentials credentials) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)projectName, (String)"projectName");
            super(url, credentials);
            this.projectName = projectName;
        }

        @Override
        @NotNull
        protected String getUploadMethod() {
            return "POST";
        }

        @Override
        @NotNull
        protected String uploadPath(@NotNull String chartName, @NotNull String chartVersion) {
            Intrinsics.checkNotNullParameter((Object)chartName, (String)"chartName");
            Intrinsics.checkNotNullParameter((Object)chartVersion, (String)"chartVersion");
            return "/api/chartrepo/" + this.projectName + "/charts";
        }

        @Override
        @NotNull
        protected RequestBody requestBody(@NotNull File chartFile) {
            Intrinsics.checkNotNullParameter((Object)chartFile, (String)"chartFile");
            MultipartBody.Builder $this$requestBody_u24lambda_u240 = new MultipartBody.Builder(null, 1, null);
            boolean bl = false;
            $this$requestBody_u24lambda_u240.setType(MultipartBody.FORM);
            $this$requestBody_u24lambda_u240.addFormDataPart("chart", chartFile.getName(), RequestBody.Companion.create(chartFile, AbstractHttpHelmChartPublisher.Companion.getMEDIA_TYPE_GZIP()));
            return (RequestBody)$this$requestBody_u24lambda_u240.build();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/citi/gradle/plugins/helm/publishing/dsl/DefaultHarborHelmPublishingRepository$HarborPublisherParams;", "Lcom/citi/gradle/plugins/helm/publishing/publishers/PublisherParams;", "url", "Ljava/net/URI;", "projectName", "", "credentials", "Lcom/citi/gradle/plugins/helm/dsl/credentials/internal/SerializableCredentials;", "(Ljava/net/URI;Ljava/lang/String;Lcom/citi/gradle/plugins/helm/dsl/credentials/internal/SerializableCredentials;)V", "createPublisher", "Lcom/citi/gradle/plugins/helm/publishing/publishers/HelmChartPublisher;", "helm-publish-plugin"})
    private static final class HarborPublisherParams
    implements PublisherParams {
        @NotNull
        private final URI url;
        @NotNull
        private final String projectName;
        @Nullable
        private final SerializableCredentials credentials;

        public HarborPublisherParams(@NotNull URI url, @NotNull String projectName, @Nullable SerializableCredentials credentials) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)projectName, (String)"projectName");
            this.url = url;
            this.projectName = projectName;
            this.credentials = credentials;
        }

        @Override
        @NotNull
        public HelmChartPublisher createPublisher() {
            return new HarborPublisher(this.url, this.projectName, this.credentials);
        }
    }
}

