/*
 * Decompiled with CFR 0.152.
 */
package com.citi.gradle.plugins.helm.publishing.dsl;

import com.citi.gradle.plugins.helm.dsl.credentials.internal.SerializableCredentials;
import com.citi.gradle.plugins.helm.dsl.credentials.internal.SerializableCredentialsKt;
import com.citi.gradle.plugins.helm.publishing.dsl.AbstractHelmPublishingRepository;
import com.citi.gradle.plugins.helm.publishing.dsl.GitlabHelmPublishingRepository;
import com.citi.gradle.plugins.helm.publishing.publishers.AbstractHttpHelmChartPublisher;
import com.citi.gradle.plugins.helm.publishing.publishers.HelmChartPublisher;
import com.citi.gradle.plugins.helm.publishing.publishers.PublisherParams;
import java.io.File;
import java.net.URI;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import org.gradle.api.credentials.Credentials;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0012\u0018\u00002\u00020\u00012\u00020\u0002:\u0002\u0011\u0012B\u0017\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0013"}, d2={"Lcom/citi/gradle/plugins/helm/publishing/dsl/DefaultGitlabHelmPublishingRepository;", "Lcom/citi/gradle/plugins/helm/publishing/dsl/AbstractHelmPublishingRepository;", "Lcom/citi/gradle/plugins/helm/publishing/dsl/GitlabHelmPublishingRepository;", "name", "", "objects", "Lorg/gradle/api/model/ObjectFactory;", "(Ljava/lang/String;Lorg/gradle/api/model/ObjectFactory;)V", "projectId", "Lorg/gradle/api/provider/Property;", "", "getProjectId", "()Lorg/gradle/api/provider/Property;", "publisherParams", "Lcom/citi/gradle/plugins/helm/publishing/publishers/PublisherParams;", "getPublisherParams", "()Lcom/citi/gradle/plugins/helm/publishing/publishers/PublisherParams;", "GitlabPublisher", "GitlabPublisherParams", "helm-publish-plugin"})
@SourceDebugExtension(value={"SMAP\nGitlabHelmPublishingRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitlabHelmPublishingRepository.kt\ncom/citi/gradle/plugins/helm/publishing/dsl/DefaultGitlabHelmPublishingRepository\n+ 2 ObjectFactoryExtensions.kt\norg/unbrokendome/gradle/pluginutils/ObjectFactoryExtensionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,79:1\n17#2:80\n1#3:81\n*S KotlinDebug\n*F\n+ 1 GitlabHelmPublishingRepository.kt\ncom/citi/gradle/plugins/helm/publishing/dsl/DefaultGitlabHelmPublishingRepository\n*L\n34#1:80\n*E\n"})
class DefaultGitlabHelmPublishingRepository
extends AbstractHelmPublishingRepository
implements GitlabHelmPublishingRepository {
    @NotNull
    private final Property<Integer> projectId;

    @Inject
    public DefaultGitlabHelmPublishingRepository(@NotNull String name, @NotNull ObjectFactory objects) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)objects, (String)"objects");
        super(objects, name);
        ObjectFactory $this$property$iv = objects;
        boolean $i$f$property = false;
        Property property = $this$property$iv.property(Integer.class);
        Intrinsics.checkNotNullExpressionValue((Object)property, (String)"property(T::class.javaObjectType)");
        this.projectId = property;
    }

    @Override
    @NotNull
    public Property<Integer> getProjectId() {
        return this.projectId;
    }

    @Override
    @NotNull
    public PublisherParams getPublisherParams() {
        Object object = this.getUrl().getOrNull();
        if (object == null) {
            boolean $i$a$-requireNotNull-DefaultGitlabHelmPublishingRepository$publisherParams$32 = false;
            String $i$a$-requireNotNull-DefaultGitlabHelmPublishingRepository$publisherParams$32 = "url is required for Gitlab publishing repository";
            throw new IllegalArgumentException($i$a$-requireNotNull-DefaultGitlabHelmPublishingRepository$publisherParams$32.toString());
        }
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"requireNotNull(...)");
        URI uRI = (URI)object;
        Credentials credentials = (Credentials)this.getConfiguredCredentials().getOrNull();
        Object object2 = credentials != null ? SerializableCredentialsKt.toSerializable((Credentials)credentials) : null;
        Object object3 = this.getProjectId().getOrNull();
        if (object3 == null) {
            SerializableCredentials serializableCredentials = object2;
            URI uRI2 = uRI;
            boolean bl = false;
            String string = "projectId is required for Gitlab publishing repository";
            URI uRI3 = uRI2;
            SerializableCredentials serializableCredentials2 = serializableCredentials;
            String string2 = string;
            throw new IllegalArgumentException(string2.toString());
        }
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"requireNotNull(...)");
        int n = ((Number)object3).intValue();
        SerializableCredentials serializableCredentials = object2;
        URI uRI4 = uRI;
        return new GitlabPublisherParams(uRI4, serializableCredentials, n);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0018\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\nH\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0014"}, d2={"Lcom/citi/gradle/plugins/helm/publishing/dsl/DefaultGitlabHelmPublishingRepository$GitlabPublisher;", "Lcom/citi/gradle/plugins/helm/publishing/publishers/AbstractHttpHelmChartPublisher;", "url", "Ljava/net/URI;", "credentials", "Lcom/citi/gradle/plugins/helm/dsl/credentials/internal/SerializableCredentials;", "projectId", "", "(Ljava/net/URI;Lcom/citi/gradle/plugins/helm/dsl/credentials/internal/SerializableCredentials;I)V", "uploadMethod", "", "getUploadMethod", "()Ljava/lang/String;", "requestBody", "Lokhttp3/RequestBody;", "chartFile", "Ljava/io/File;", "uploadPath", "chartName", "chartVersion", "helm-publish-plugin"})
    private static final class GitlabPublisher
    extends AbstractHttpHelmChartPublisher {
        private final int projectId;

        public GitlabPublisher(@NotNull URI url, @Nullable SerializableCredentials credentials, int projectId) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            super(url, credentials);
            this.projectId = projectId;
        }

        @Override
        @NotNull
        protected String getUploadMethod() {
            return "POST";
        }

        @Override
        @NotNull
        protected String uploadPath(@NotNull String chartName, @NotNull String chartVersion) {
            Intrinsics.checkNotNullParameter((Object)chartName, (String)"chartName");
            Intrinsics.checkNotNullParameter((Object)chartVersion, (String)"chartVersion");
            return "/projects/" + this.projectId + "/packages/helm/api/stable/charts";
        }

        @Override
        @NotNull
        protected RequestBody requestBody(@NotNull File chartFile) {
            Intrinsics.checkNotNullParameter((Object)chartFile, (String)"chartFile");
            MultipartBody.Builder $this$requestBody_u24lambda_u240 = new MultipartBody.Builder(null, 1, null);
            boolean bl = false;
            $this$requestBody_u24lambda_u240.setType(MultipartBody.FORM);
            $this$requestBody_u24lambda_u240.addFormDataPart("chart", chartFile.getName(), RequestBody.Companion.create(chartFile, AbstractHttpHelmChartPublisher.Companion.getMEDIA_TYPE_GZIP()));
            return (RequestBody)$this$requestBody_u24lambda_u240.build();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/citi/gradle/plugins/helm/publishing/dsl/DefaultGitlabHelmPublishingRepository$GitlabPublisherParams;", "Lcom/citi/gradle/plugins/helm/publishing/publishers/PublisherParams;", "url", "Ljava/net/URI;", "credentials", "Lcom/citi/gradle/plugins/helm/dsl/credentials/internal/SerializableCredentials;", "projectId", "", "(Ljava/net/URI;Lcom/citi/gradle/plugins/helm/dsl/credentials/internal/SerializableCredentials;I)V", "createPublisher", "Lcom/citi/gradle/plugins/helm/publishing/publishers/HelmChartPublisher;", "helm-publish-plugin"})
    private static final class GitlabPublisherParams
    implements PublisherParams {
        @NotNull
        private final URI url;
        @Nullable
        private final SerializableCredentials credentials;
        private int projectId;

        public GitlabPublisherParams(@NotNull URI url, @Nullable SerializableCredentials credentials, int projectId) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            this.url = url;
            this.credentials = credentials;
            this.projectId = projectId;
        }

        @Override
        @NotNull
        public HelmChartPublisher createPublisher() {
            return new GitlabPublisher(this.url, this.credentials, this.projectId);
        }
    }
}

