/*
 * Decompiled with CFR 0.152.
 */
package com.citi.gradle.plugins.helm.publishing.dsl;

import com.citi.gradle.plugins.helm.dsl.credentials.internal.SerializableCredentials;
import com.citi.gradle.plugins.helm.dsl.credentials.internal.SerializableCredentialsKt;
import com.citi.gradle.plugins.helm.publishing.dsl.AbstractHelmPublishingRepository;
import com.citi.gradle.plugins.helm.publishing.dsl.ArtifactoryHelmPublishingRepository;
import com.citi.gradle.plugins.helm.publishing.publishers.AbstractHttpHelmChartPublisher;
import com.citi.gradle.plugins.helm.publishing.publishers.HelmChartPublisher;
import com.citi.gradle.plugins.helm.publishing.publishers.PublisherParams;
import com.citi.gradle.plugins.helm.util.DigestUtilsKt;
import java.io.File;
import java.net.URI;
import java.util.Map;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.credentials.Credentials;
import org.gradle.api.model.ObjectFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0012\u0018\u00002\u00020\u00012\u00020\u0002:\u0002\f\rB\u0017\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lcom/citi/gradle/plugins/helm/publishing/dsl/DefaultArtifactoryHelmPublishingRepository;", "Lcom/citi/gradle/plugins/helm/publishing/dsl/AbstractHelmPublishingRepository;", "Lcom/citi/gradle/plugins/helm/publishing/dsl/ArtifactoryHelmPublishingRepository;", "name", "", "objects", "Lorg/gradle/api/model/ObjectFactory;", "(Ljava/lang/String;Lorg/gradle/api/model/ObjectFactory;)V", "publisherParams", "Lcom/citi/gradle/plugins/helm/publishing/publishers/PublisherParams;", "getPublisherParams", "()Lcom/citi/gradle/plugins/helm/publishing/publishers/PublisherParams;", "ArtifactoryPublisher", "ArtifactoryPublisherParams", "helm-publish-plugin"})
class DefaultArtifactoryHelmPublishingRepository
extends AbstractHelmPublishingRepository
implements ArtifactoryHelmPublishingRepository {
    @Inject
    public DefaultArtifactoryHelmPublishingRepository(@NotNull String name, @NotNull ObjectFactory objects) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)objects, (String)"objects");
        super(objects, name);
    }

    @Override
    @NotNull
    public PublisherParams getPublisherParams() {
        Object object = this.getUrl().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        Credentials credentials = (Credentials)this.getConfiguredCredentials().getOrNull();
        return new ArtifactoryPublisherParams((URI)object, (SerializableCredentials)(credentials != null ? SerializableCredentialsKt.toSerializable((Credentials)credentials) : null));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J,\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\f2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0018\u0010\u0011\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\bH\u0014R\u0014\u0010\u0007\u001a\u00020\b8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0012"}, d2={"Lcom/citi/gradle/plugins/helm/publishing/dsl/DefaultArtifactoryHelmPublishingRepository$ArtifactoryPublisher;", "Lcom/citi/gradle/plugins/helm/publishing/publishers/AbstractHttpHelmChartPublisher;", "url", "Ljava/net/URI;", "credentials", "Lcom/citi/gradle/plugins/helm/dsl/credentials/internal/SerializableCredentials;", "(Ljava/net/URI;Lcom/citi/gradle/plugins/helm/dsl/credentials/internal/SerializableCredentials;)V", "uploadMethod", "", "getUploadMethod", "()Ljava/lang/String;", "additionalHeaders", "", "chartName", "chartVersion", "chartFile", "Ljava/io/File;", "uploadPath", "helm-publish-plugin"})
    private static final class ArtifactoryPublisher
    extends AbstractHttpHelmChartPublisher {
        public ArtifactoryPublisher(@NotNull URI url, @Nullable SerializableCredentials credentials) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            super(url, credentials);
        }

        @Override
        @NotNull
        protected String getUploadMethod() {
            return "PUT";
        }

        @Override
        @NotNull
        protected String uploadPath(@NotNull String chartName, @NotNull String chartVersion) {
            Intrinsics.checkNotNullParameter((Object)chartName, (String)"chartName");
            Intrinsics.checkNotNullParameter((Object)chartVersion, (String)"chartVersion");
            return '/' + chartName + '-' + chartVersion + ".tgz";
        }

        @Override
        @NotNull
        protected Map<String, String> additionalHeaders(@NotNull String chartName, @NotNull String chartVersion, @NotNull File chartFile) {
            Intrinsics.checkNotNullParameter((Object)chartName, (String)"chartName");
            Intrinsics.checkNotNullParameter((Object)chartVersion, (String)"chartVersion");
            Intrinsics.checkNotNullParameter((Object)chartFile, (String)"chartFile");
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"X-Checksum-Sha1", (Object)DigestUtilsKt.calculateDigestHex$default((File)chartFile, (String)"SHA-1", (int)0, (int)2, null)), TuplesKt.to((Object)"X-Checksum-Sha256", (Object)DigestUtilsKt.calculateDigestHex$default((File)chartFile, (String)"SHA-256", (int)0, (int)2, null)), TuplesKt.to((Object)"X-Checksum-Md5", (Object)DigestUtilsKt.calculateDigestHex$default((File)chartFile, (String)"MD5", (int)0, (int)2, null))};
            return MapsKt.mapOf((Pair[])pairArray);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/citi/gradle/plugins/helm/publishing/dsl/DefaultArtifactoryHelmPublishingRepository$ArtifactoryPublisherParams;", "Lcom/citi/gradle/plugins/helm/publishing/publishers/PublisherParams;", "url", "Ljava/net/URI;", "credentials", "Lcom/citi/gradle/plugins/helm/dsl/credentials/internal/SerializableCredentials;", "(Ljava/net/URI;Lcom/citi/gradle/plugins/helm/dsl/credentials/internal/SerializableCredentials;)V", "createPublisher", "Lcom/citi/gradle/plugins/helm/publishing/publishers/HelmChartPublisher;", "helm-publish-plugin"})
    private static final class ArtifactoryPublisherParams
    implements PublisherParams {
        @NotNull
        private final URI url;
        @Nullable
        private final SerializableCredentials credentials;

        public ArtifactoryPublisherParams(@NotNull URI url, @Nullable SerializableCredentials credentials) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            this.url = url;
            this.credentials = credentials;
        }

        @Override
        @NotNull
        public HelmChartPublisher createPublisher() {
            return new ArtifactoryPublisher(this.url, this.credentials);
        }
    }
}

