/*
 * Decompiled with CFR 0.152.
 */
package com.citi.gradle.plugins.helm.command.tasks;

import com.citi.gradle.plugins.helm.command.tasks.AbstractHelmCommandTask;
import com.citi.gradle.plugins.helm.command.tasks.HelmUpdateRepositories;
import com.citi.gradle.plugins.helm.util.FileLockKt;
import java.io.File;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.gradle.api.Task;
import org.gradle.api.file.RegularFile;
import org.gradle.api.logging.Logger;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0007R\u0019\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0019\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/citi/gradle/plugins/helm/command/tasks/HelmUpdateRepositories;", "Lcom/citi/gradle/plugins/helm/command/tasks/AbstractHelmCommandTask;", "()V", "repositoryCacheTtl", "Lorg/gradle/api/provider/Property;", "Ljava/time/Duration;", "getRepositoryCacheTtl", "()Lorg/gradle/api/provider/Property;", "repositoryNames", "Lorg/gradle/api/provider/ListProperty;", "", "getRepositoryNames", "()Lorg/gradle/api/provider/ListProperty;", "taskSyncLockFile", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/RegularFile;", "checkUpToDate", "", "task", "Lorg/gradle/api/Task;", "updateRepositories", "", "helm-plugin"})
@SourceDebugExtension(value={"SMAP\nHelmUpdateRepositories.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HelmUpdateRepositories.kt\ncom/citi/gradle/plugins/helm/command/tasks/HelmUpdateRepositories\n+ 2 ObjectFactoryExtensions.kt\norg/unbrokendome/gradle/pluginutils/ObjectFactoryExtensionsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,141:1\n26#2:142\n17#2:143\n3190#3,10:144\n1549#3:154\n1620#3,3:155\n766#3:158\n857#3,2:159\n1549#3:161\n1620#3,3:162\n*S KotlinDebug\n*F\n+ 1 HelmUpdateRepositories.kt\ncom/citi/gradle/plugins/helm/command/tasks/HelmUpdateRepositories\n*L\n28#1:142\n48#1:143\n110#1:144,10\n115#1:154\n115#1:155,3\n127#1:158\n127#1:159,2\n132#1:161\n132#1:162,3\n*E\n"})
public class HelmUpdateRepositories
extends AbstractHelmCommandTask {
    @NotNull
    private final ListProperty<String> repositoryNames;
    @NotNull
    private final Provider<RegularFile> taskSyncLockFile;
    @NotNull
    private final Property<Duration> repositoryCacheTtl;

    public HelmUpdateRepositories() {
        ObjectFactory objectFactory = this.getProject().getObjects();
        Intrinsics.checkNotNullExpressionValue((Object)objectFactory, (String)"getObjects(...)");
        ObjectFactory $this$listProperty$iv = objectFactory;
        boolean $i$f$listProperty = false;
        ListProperty listProperty = $this$listProperty$iv.listProperty(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)listProperty, (String)"listProperty(T::class.javaObjectType)");
        this.repositoryNames = listProperty;
        Provider provider = this.getRepositoryCacheDir().map(arg_0 -> HelmUpdateRepositories.taskSyncLockFile$lambda$0(taskSyncLockFile.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"map(...)");
        this.taskSyncLockFile = provider;
        ObjectFactory objectFactory2 = this.getProject().getObjects();
        Intrinsics.checkNotNullExpressionValue((Object)objectFactory2, (String)"getObjects(...)");
        ObjectFactory $this$property$iv = objectFactory2;
        boolean $i$f$property = false;
        Property property = $this$property$iv.property(Duration.class);
        Intrinsics.checkNotNullExpressionValue((Object)property, (String)"property(T::class.javaObjectType)");
        Object[] objectArray = property.convention((Object)Duration.ofHours(1L));
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"convention(...)");
        this.repositoryCacheTtl = objectArray;
        this.onlyIf(arg_0 -> HelmUpdateRepositories._init_$lambda$1((Function1)new Function1<Task, Boolean>(){

            @NotNull
            public final Boolean invoke(Task it) {
                Collection collection = (Collection)this.getRepositoryNames().getOrNull();
                return !(collection == null || collection.isEmpty());
            }
        }, arg_0));
        objectArray = new Object[]{this.getRepositoryConfigFile()};
        this.getInputs().files(objectArray).withPropertyName("repositoryConfigFile").skipWhenEmpty();
        this.getOutputs().upToDateWhen(arg_0 -> HelmUpdateRepositories._init_$lambda$2((Function1)new Function1<Task, Boolean>(){

            @NotNull
            public final Boolean invoke(Task task) {
                Intrinsics.checkNotNull((Object)task);
                return this.checkUpToDate(task);
            }
        }, arg_0));
    }

    @Internal
    @NotNull
    public final ListProperty<String> getRepositoryNames() {
        return this.repositoryNames;
    }

    @Internal
    @NotNull
    public final Property<Duration> getRepositoryCacheTtl() {
        return this.repositoryCacheTtl;
    }

    @TaskAction
    public final void updateRepositories() {
        File lockFile = ((RegularFile)this.taskSyncLockFile.get()).getAsFile();
        Intrinsics.checkNotNull((Object)lockFile);
        FileLockKt.withLockFile(lockFile, (Function0)new Function0<Unit>(this){
            final /* synthetic */ HelmUpdateRepositories this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                if (HelmUpdateRepositories.access$checkUpToDate(this.this$0, (Task)this.this$0)) {
                    this.this$0.setDidWork(false);
                } else {
                    AbstractHelmCommandTask.execHelm$default(this.this$0, "repo", "update", null, 4, null);
                }
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final boolean checkUpToDate(Task task) {
        File it;
        void $this$filterTo$iv$iv;
        File repositoryConfigFile2 = this.getProject().file(this.getRepositoryConfigFile());
        if (!repositoryConfigFile2.exists()) {
            this.getLogger().debug("{} is up-to-date because the repository config file does not exist.", (Object)task);
            return true;
        }
        File repositoryCacheDir2 = this.getProject().file(this.getRepositoryCacheDir());
        if (!repositoryCacheDir2.isDirectory()) {
            this.getLogger().debug("{} is not up-to-date because the repository cache directory does not exist.", (Object)task);
            return false;
        }
        if (Intrinsics.areEqual((Object)this.repositoryCacheTtl.get(), (Object)Duration.ZERO)) {
            this.getLogger().debug("{} is not up-to-date because the repository cache TTL is set to 0.", (Object)task);
            return false;
        }
        Object object = this.repositoryNames.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        List filesToCheck2 = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)object)), (Function1)checkUpToDate.filesToCheck.1.INSTANCE), (Function1)((Function1)new Function1<String, File>(repositoryCacheDir2){
            final /* synthetic */ File $repositoryCacheDir;
            {
                this.$repositoryCacheDir = $repositoryCacheDir;
                super(1);
            }

            @NotNull
            public final File invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                File file = this.$repositoryCacheDir;
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"$repositoryCacheDir");
                return FilesKt.resolve((File)file, (String)it);
            }
        })));
        Iterable $this$partition$iv = filesToCheck2;
        boolean $i$f$partition = false;
        Iterable<Object> first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv : $this$partition$iv) {
            File it2 = (File)element$iv;
            boolean bl = false;
            if (it2.exists()) {
                first$iv.add(element$iv);
                continue;
            }
            second$iv.add(element$iv);
        }
        Pair pair = new Pair(first$iv, second$iv);
        List existingFiles = (List)pair.component1();
        List nonExistingFiles = (List)pair.component2();
        if (CollectionsKt.any((Iterable)nonExistingFiles)) {
            if (this.getLogger().isDebugEnabled()) {
                Collection<String> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                first$iv = nonExistingFiles;
                Task task2 = task;
                String string = "{} is not up-to-date because the following repository cache files are not present: {}";
                Logger logger = this.getLogger();
                boolean $i$f$map = false;
                Iterator iterator = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it3;
                    File file = (File)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it3.getName());
                }
                collection = (List)destination$iv$iv;
                logger.debug(string, (Object)task2, (Object)collection);
            }
            return false;
        }
        long minLastModTime = Math.max(System.currentTimeMillis() - ((Duration)this.repositoryCacheTtl.get()).toMillis(), repositoryConfigFile2.lastModified());
        Iterable $this$filter$iv = existingFiles;
        boolean $i$f$filter = false;
        Iterable bl = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (File)element$iv$iv;
            boolean bl2 = false;
            if (!(it.lastModified() < minLastModTime)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List outdatedFiles = (List)destination$iv$iv;
        if (CollectionsKt.any((Iterable)outdatedFiles)) {
            if (this.getLogger().isDebugEnabled()) {
                Collection<String> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                $this$filter$iv = outdatedFiles;
                Task task3 = task;
                String string = "{} is not up-to-date because the following repository cache files are outdated: {}";
                Logger logger = this.getLogger();
                boolean $i$f$map = false;
                $this$filterTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it = (File)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl3 = false;
                    collection.add(it.getName());
                }
                collection = (List)destination$iv$iv;
                logger.debug(string, (Object)task3, (Object)collection);
            }
            return false;
        }
        return true;
    }

    private static final RegularFile taskSyncLockFile$lambda$0(Function1 $tmp0, Object in) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (RegularFile)$tmp0.invoke(in);
    }

    private static final boolean _init_$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean _init_$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }
}

