/*
 * Decompiled with CFR 0.152.
 */
package com.citi.gradle.plugins.helm.command.tasks;

import com.citi.gradle.plugins.helm.command.tasks.HelmExtractClient;
import java.io.File;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;
import org.unbrokendome.gradle.pluginutils.ProjectPropertiesKt;
import org.unbrokendome.gradle.pluginutils.SystemUtils;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0007R\u0013\u0010\u0003\u001a\u00020\u00048G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0013\u0010\u0007\u001a\u00020\b8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u000b\u001a\u00020\b8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0019\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001c\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u000e8AX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0011R\u0019\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00130\u00168G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001b"}, d2={"Lcom/citi/gradle/plugins/helm/command/tasks/HelmExtractClient;", "Lorg/gradle/api/DefaultTask;", "()V", "archiveFile", "Lorg/gradle/api/file/RegularFileProperty;", "getArchiveFile", "()Lorg/gradle/api/file/RegularFileProperty;", "baseDestinationDir", "Lorg/gradle/api/file/DirectoryProperty;", "getBaseDestinationDir", "()Lorg/gradle/api/file/DirectoryProperty;", "destinationDir", "getDestinationDir", "executable", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/RegularFile;", "getExecutable", "()Lorg/gradle/api/provider/Provider;", "osClassifier", "", "getOsClassifier$helm_plugin", "version", "Lorg/gradle/api/provider/Property;", "getVersion", "()Lorg/gradle/api/provider/Property;", "extractClient", "", "helm-plugin"})
@SourceDebugExtension(value={"SMAP\nHelmExtractClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HelmExtractClient.kt\ncom/citi/gradle/plugins/helm/command/tasks/HelmExtractClient\n+ 2 ObjectFactoryExtensions.kt\norg/unbrokendome/gradle/pluginutils/ObjectFactoryExtensionsKt\n*L\n1#1,106:1\n17#2:107\n*S KotlinDebug\n*F\n+ 1 HelmExtractClient.kt\ncom/citi/gradle/plugins/helm/command/tasks/HelmExtractClient\n*L\n35#1:107\n*E\n"})
public class HelmExtractClient
extends DefaultTask {
    @NotNull
    private final Property<String> version;
    @NotNull
    private final RegularFileProperty archiveFile;
    @NotNull
    private final Provider<String> osClassifier;
    @NotNull
    private final DirectoryProperty baseDestinationDir;
    @NotNull
    private final DirectoryProperty destinationDir;
    @NotNull
    private final Provider<RegularFile> executable;

    public HelmExtractClient() {
        this.setGroup("helm");
        ObjectFactory objectFactory = this.getProject().getObjects();
        Intrinsics.checkNotNullExpressionValue((Object)objectFactory, (String)"getObjects(...)");
        ObjectFactory $this$property$iv = objectFactory;
        boolean $i$f$property = false;
        Property property = $this$property$iv.property(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)property, (String)"property(T::class.javaObjectType)");
        this.version = property;
        RegularFileProperty regularFileProperty = this.getProject().getObjects().fileProperty();
        Intrinsics.checkNotNullExpressionValue((Object)regularFileProperty, (String)"fileProperty(...)");
        this.archiveFile = regularFileProperty;
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        this.osClassifier = ProjectPropertiesKt.providerFromProjectProperty$default((Project)project, (String)"helm.client.download.osclassifier", (String)SystemUtils.INSTANCE.getOperatingSystemClassifier(), (boolean)false, (int)4, null);
        DirectoryProperty directoryProperty = this.getProject().getObjects().directoryProperty();
        Intrinsics.checkNotNullExpressionValue((Object)directoryProperty, (String)"directoryProperty(...)");
        this.baseDestinationDir = directoryProperty;
        DirectoryProperty directoryProperty2 = this.getProject().getObjects().directoryProperty().convention(this.baseDestinationDir.dir((Provider)this.version));
        Intrinsics.checkNotNullExpressionValue((Object)directoryProperty2, (String)"convention(...)");
        this.destinationDir = directoryProperty2;
        Provider provider = this.destinationDir.file(this.osClassifier.map(arg_0 -> HelmExtractClient.executable$lambda$0(executable.1.INSTANCE, arg_0)));
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"file(...)");
        this.executable = provider;
    }

    @Input
    @NotNull
    public final Property<String> getVersion() {
        return this.version;
    }

    @InputFile
    @NotNull
    public final RegularFileProperty getArchiveFile() {
        return this.archiveFile;
    }

    @Input
    @NotNull
    public final Provider<String> getOsClassifier$helm_plugin() {
        return this.osClassifier;
    }

    @Internal(value="Represented as part of executable")
    @NotNull
    public final DirectoryProperty getBaseDestinationDir() {
        return this.baseDestinationDir;
    }

    @Internal(value="Represented as part of executable")
    @NotNull
    public final DirectoryProperty getDestinationDir() {
        return this.destinationDir;
    }

    @OutputFile
    @NotNull
    public final Provider<RegularFile> getExecutable() {
        return this.executable;
    }

    @TaskAction
    public final void extractClient() {
        File archiveFile = this.getProject().file((Object)this.archiveFile);
        this.getProject().copy(arg_0 -> HelmExtractClient.extractClient$lambda$1((Function1)new Function1<CopySpec, Unit>(archiveFile, this){
            final /* synthetic */ File $archiveFile;
            final /* synthetic */ HelmExtractClient this$0;
            {
                this.$archiveFile = $archiveFile;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(CopySpec copy) {
                Object[] objectArray = new Object[1];
                File file = this.$archiveFile;
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"$archiveFile");
                objectArray[0] = Intrinsics.areEqual((Object)FilesKt.getExtension((File)file), (Object)"zip") ? this.this$0.getProject().zipTree((Object)this.$archiveFile) : this.this$0.getProject().tarTree((Object)this.$archiveFile);
                copy.from(objectArray);
                copy.into((Object)this.this$0.getDestinationDir());
            }
        }, arg_0));
    }

    private static final String executable$lambda$0(Function1 $tmp0, Object in) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(in);
    }

    private static final void extractClient$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }
}

