ace.define("ace/snippets",["require","exports","module","ace/lib/dom","ace/lib/oop","ace/lib/event_emitter","ace/lib/lang","ace/range","ace/range_list","ace/keyboard/hash_handler","ace/tokenizer","ace/clipboard","ace/editor"],function(f,L,F){"use strict";var k=f("./lib/dom"),_=f("./lib/oop"),M=f("./lib/event_emitter").EventEmitter,w=f("./lib/lang"),v=f("./range").Range,y=f("./range_list").RangeList,$=f("./keyboard/hash_handler").HashHandler,S=f("./tokenizer").Tokenizer,R=f("./clipboard"),P={CURRENT_WORD:function(o){return o.session.getTextRange(o.session.getWordRange())},SELECTION:function(o,t,e){var n=o.session.getTextRange();return e?n.replace(/\n\r?([ \t]*\S)/g,"\n"+e+"$1"):n},CURRENT_LINE:function(o){return o.session.getLine(o.getCursorPosition().row)},PREV_LINE:function(o){return o.session.getLine(o.getCursorPosition().row-1)},LINE_INDEX:function(o){return o.getCursorPosition().row},LINE_NUMBER:function(o){return o.getCursorPosition().row+1},SOFT_TABS:function(o){return o.session.getUseSoftTabs()?"YES":"NO"},TAB_SIZE:function(o){return o.session.getTabSize()},CLIPBOARD:function(o){return R.getText&&R.getText()},FILENAME:function(o){return/[^/\\]*$/.exec(this.FILEPATH(o))[0]},FILENAME_BASE:function(o){return/[^/\\]*$/.exec(this.FILEPATH(o))[0].replace(/\.[^.]*$/,"")},DIRECTORY:function(o){return this.FILEPATH(o).replace(/[^/\\]*$/,"")},FILEPATH:function(o){return"/not implemented.txt"},WORKSPACE_NAME:function(){return"Unknown"},FULLNAME:function(){return"Unknown"},BLOCK_COMMENT_START:function(o){var t=o.session.$mode||{};return t.blockComment&&t.blockComment.start||""},BLOCK_COMMENT_END:function(o){var t=o.session.$mode||{};return t.blockComment&&t.blockComment.end||""},LINE_COMMENT:function(o){return(o.session.$mode||{}).lineCommentStart||""},CURRENT_YEAR:E.bind(null,{year:"numeric"}),CURRENT_YEAR_SHORT:E.bind(null,{year:"2-digit"}),CURRENT_MONTH:E.bind(null,{month:"numeric"}),CURRENT_MONTH_NAME:E.bind(null,{month:"long"}),CURRENT_MONTH_NAME_SHORT:E.bind(null,{month:"short"}),CURRENT_DATE:E.bind(null,{day:"2-digit"}),CURRENT_DAY_NAME:E.bind(null,{weekday:"long"}),CURRENT_DAY_NAME_SHORT:E.bind(null,{weekday:"short"}),CURRENT_HOUR:E.bind(null,{hour:"2-digit",hour12:!1}),CURRENT_MINUTE:E.bind(null,{minute:"2-digit"}),CURRENT_SECOND:E.bind(null,{second:"2-digit"})};function E(o){var t=(new Date).toLocaleString("en-us",o);return 1==t.length?"0"+t:t}P.SELECTED_TEXT=P.SELECTION;var C=function(){function o(){this.snippetMap={},this.snippetNameMap={},this.variables=P}return o.prototype.getTokenizer=function(){return o.$tokenizer||this.createTokenizer()},o.prototype.createTokenizer=function(){function t(i){return i=i.substr(1),/^\d+$/.test(i)?[{tabstopId:parseInt(i,10)}]:[{text:i}]}function e(i){return"(?:[^\\\\"+i+"]|\\\\.)"}var n={regex:"/("+e("/")+"+)/",onMatch:function(i,r,l){var s=l[0];return s.fmtString=!0,s.guard=i.slice(1,-1),s.flag="",""},next:"formatString"};return o.$tokenizer=new S({start:[{regex:/\\./,onMatch:function(i,r,l){var s=i[1];return("}"==s&&l.length||-1!="`$\\".indexOf(s))&&(i=s),[i]}},{regex:/}/,onMatch:function(i,r,l){return[l.length?l.shift():i]}},{regex:/\$(?:\d+|\w+)/,onMatch:t},{regex:/\$\{[\dA-Z_a-z]+/,onMatch:function(i,r,l){var s=t(i.substr(1));return l.unshift(s[0]),s},next:"snippetVar"},{regex:/\n/,token:"newline",merge:!1}],snippetVar:[{regex:"\\|"+e("\\|")+"*\\|",onMatch:function(i,r,l){var s=i.slice(1,-1).replace(/\\[,|\\]|,/g,function(u){return 2==u.length?u[1]:"\0"}).split("\0").map(function(u){return{value:u}});return l[0].choices=s,[s[0]]},next:"start"},n,{regex:"([^:}\\\\]|\\\\.)*:?",token:"",next:"start"}],formatString:[{regex:/:/,onMatch:function(i,r,l){return l.length&&l[0].expectElse?(l[0].expectElse=!1,l[0].ifEnd={elseEnd:l[0]},[l[0].ifEnd]):":"}},{regex:/\\./,onMatch:function(i,r,l){var s=i[1];return"}"==s&&l.length||-1!="`$\\".indexOf(s)?i=s:"n"==s?i="\n":"t"==s?i="\t":-1!="ulULE".indexOf(s)&&(i={changeCase:s,local:s>"a"}),[i]}},{regex:"/\\w*}",onMatch:function(i,r,l){var s=l.shift();return s&&(s.flag=i.slice(1,-1)),this.next=s&&s.tabstopId?"start":"",[s||i]},next:"start"},{regex:/\$(?:\d+|\w+)/,onMatch:function(i,r,l){return[{text:i.slice(1)}]}},{regex:/\${\w+/,onMatch:function(i,r,l){var s={text:i.slice(2)};return l.unshift(s),[s]},next:"formatStringVar"},{regex:/\n/,token:"newline",merge:!1},{regex:/}/,onMatch:function(i,r,l){var s=l.shift();return this.next=s&&s.tabstopId?"start":"",[s||i]},next:"start"}],formatStringVar:[{regex:/:\/\w+}/,onMatch:function(i,r,l){return l[0].formatFunction=i.slice(2,-1),[l.shift()]},next:"formatString"},n,{regex:/:[\?\-+]?/,onMatch:function(i,r,l){"+"==i[1]&&(l[0].ifEnd=l[0]),"?"==i[1]&&(l[0].expectElse=!0)},next:"formatString"},{regex:"([^:}\\\\]|\\\\.)*:?",token:"",next:"formatString"}]})},o.prototype.tokenizeTmSnippet=function(t,e){return this.getTokenizer().getLineTokens(t,e).tokens.map(function(n){return n.value||n})},o.prototype.getVariableValue=function(t,e,n){if(/^\d+$/.test(e))return(this.variables.__||{})[e]||"";if(/^[A-Z]\d+$/.test(e))return(this.variables[e[0]+"__"]||{})[e.substr(1)]||"";if(e=e.replace(/^TM_/,""),!this.variables.hasOwnProperty(e))return"";var i=this.variables[e];return"function"==typeof i&&(i=this.variables[e](t,e,n)),null==i?"":i},o.prototype.tmStrFormat=function(t,e,n){if(!e.fmt)return t;var r=e.guard;r=new RegExp(r,(e.flag||"").replace(/[^gim]/g,""));var l="string"==typeof e.fmt?this.tokenizeTmSnippet(e.fmt,"formatString"):e.fmt,s=this,u=t.replace(r,function(){var p=s.variables.__;s.variables.__=[].slice.call(arguments);for(var m=s.resolveVariables(l,n),g="E",x=0;x<m.length;x++){var b=m[x];if("object"==typeof b)if(m[x]="",b.changeCase&&b.local){var T=m[x+1];T&&"string"==typeof T&&(m[x]="u"==b.changeCase?T[0].toUpperCase():T[0].toLowerCase(),m[x+1]=T.substr(1))}else b.changeCase&&(g=b.changeCase);else"U"==g?m[x]=b.toUpperCase():"L"==g&&(m[x]=b.toLowerCase())}return s.variables.__=p,m.join("")});return u},o.prototype.tmFormatFunction=function(t,e,n){return"upcase"==e.formatFunction?t.toUpperCase():"downcase"==e.formatFunction?t.toLowerCase():t},o.prototype.resolveVariables=function(t,e){for(var n=[],i="",r=!0,l=0;l<t.length;l++){var s=t[l];if("string"!=typeof s){if(s){if(r=!1,s.fmtString){var u=t.indexOf(s,l+1);-1==u&&(u=t.length),s.fmt=t.slice(l+1,u),l=u}if(s.text){var p=this.getVariableValue(e,s.text,i)+"";s.fmtString&&(p=this.tmStrFormat(p,s,e)),s.formatFunction&&(p=this.tmFormatFunction(p,s,e)),p&&!s.ifEnd?(n.push(p),m(s)):!p&&s.ifEnd&&m(s.ifEnd)}else s.elseEnd?m(s.elseEnd):(null!=s.tabstopId||null!=s.changeCase)&&n.push(s)}}else n.push(s),"\n"==s?(r=!0,i=""):r&&(i=/^\t*/.exec(s)[0],r=/\S/.test(s))}function m(g){var x=t.indexOf(g,l+1);-1!=x&&(l=x)}return n},o.prototype.getDisplayTextForSnippet=function(t,e){return O.call(this,t,e).text},o.prototype.insertSnippetForSelection=function(t,e,n){void 0===n&&(n={});var i=O.call(this,t,e,n),r=t.getSelectionRange(),l=t.session.replace(r,i.text);new h(t).addTabstops(i.tabstops,r.start,l,t.inVirtualSelectionMode&&t.selection.index)},o.prototype.insertSnippet=function(t,e,n){void 0===n&&(n={});var i=this;if(t.inVirtualSelectionMode)return i.insertSnippetForSelection(t,e,n);t.forEachSelection(function(){i.insertSnippetForSelection(t,e,n)},null,{keepOrder:!0}),t.tabstopManager&&t.tabstopManager.tabNext()},o.prototype.$getScope=function(t){var e=t.session.$mode.$id||"";if("html"===(e=e.split("/").pop())||"php"===e){"php"===e&&!t.session.$mode.inlinePhp&&(e="html");var n=t.getCursorPosition(),i=t.session.getState(n.row);"object"==typeof i&&(i=i[0]),i.substring&&("js-"==i.substring(0,3)?e="javascript":"css-"==i.substring(0,4)?e="css":"php-"==i.substring(0,4)&&(e="php"))}return e},o.prototype.getActiveScopes=function(t){var e=this.$getScope(t),n=[e],i=this.snippetMap;return i[e]&&i[e].includeScopes&&n.push.apply(n,i[e].includeScopes),n.push("_"),n},o.prototype.expandWithTab=function(t,e){var n=this,i=t.forEachSelection(function(){return n.expandSnippetForSelection(t,e)},null,{keepOrder:!0});return i&&t.tabstopManager&&t.tabstopManager.tabNext(),i},o.prototype.expandSnippetForSelection=function(t,e){var u,n=t.getCursorPosition(),i=t.session.getLine(n.row),r=i.substring(0,n.column),l=i.substr(n.column),s=this.snippetMap;return this.getActiveScopes(t).some(function(p){var m=s[p];return m&&(u=this.findMatchingSnippet(m,r,l)),!!u},this),!!u&&(e&&e.dryRun||(t.session.doc.removeInLine(n.row,n.column-u.replaceBefore.length,n.column+u.replaceAfter.length),this.variables.M__=u.matchBefore,this.variables.T__=u.matchAfter,this.insertSnippetForSelection(t,u.content),this.variables.M__=this.variables.T__=null),!0)},o.prototype.findMatchingSnippet=function(t,e,n){for(var i=t.length;i--;){var r=t[i];if((!r.startRe||r.startRe.test(e))&&(!r.endRe||r.endRe.test(n))&&(r.startRe||r.endRe))return r.matchBefore=r.startRe?r.startRe.exec(e):[""],r.matchAfter=r.endRe?r.endRe.exec(n):[""],r.replaceBefore=r.triggerRe?r.triggerRe.exec(e)[0]:"",r.replaceAfter=r.endTriggerRe?r.endTriggerRe.exec(n)[0]:"",r}},o.prototype.register=function(t,e){var n=this.snippetMap,i=this.snippetNameMap,r=this;function l(p){return p&&!/^\^?\(.*\)\$?$|^\\b$/.test(p)&&(p="(?:"+p+")"),p||""}function s(p,m,g){return p=l(p),m=l(m),g?(p=m+p)&&"$"!=p[p.length-1]&&(p+="$"):(p+=m)&&"^"!=p[0]&&(p="^"+p),new RegExp(p)}function u(p){p.scope||(p.scope=e||"_"),n[e=p.scope]||(n[e]=[],i[e]={});var m=i[e];if(p.name){var g=m[p.name];g&&r.unregister(g),m[p.name]=p}n[e].push(p),p.prefix&&(p.tabTrigger=p.prefix),!p.content&&p.body&&(p.content=Array.isArray(p.body)?p.body.join("\n"):p.body),p.tabTrigger&&!p.trigger&&(!p.guard&&/^\w/.test(p.tabTrigger)&&(p.guard="\\b"),p.trigger=w.escapeRegExp(p.tabTrigger)),(p.trigger||p.guard||p.endTrigger||p.endGuard)&&(p.startRe=s(p.trigger,p.guard,!0),p.triggerRe=new RegExp(p.trigger),p.endRe=s(p.endTrigger,p.endGuard,!0),p.endTriggerRe=new RegExp(p.endTrigger))}t||(t=[]),Array.isArray(t)?t.forEach(u):Object.keys(t).forEach(function(p){u(t[p])}),this._signal("registerSnippets",{scope:e})},o.prototype.unregister=function(t,e){var n=this.snippetMap,i=this.snippetNameMap;function r(l){var s=i[l.scope||e];if(s&&s[l.name]){delete s[l.name];var u=n[l.scope||e],p=u&&u.indexOf(l);p>=0&&u.splice(p,1)}}t.content?r(t):Array.isArray(t)&&t.forEach(r)},o.prototype.parseSnippetFile=function(t){t=t.replace(/\r/g,"");for(var r,e=[],n={},i=/^#.*|^({[\s\S]*})\s*$|^(\S+) (.*)$|^((?:\n*\t.*)+)/gm;r=i.exec(t);){if(r[1])try{n=JSON.parse(r[1]),e.push(n)}catch(p){}if(r[4])n.content=r[4].replace(/^\t/gm,""),e.push(n),n={};else{var l=r[2],s=r[3];if("regex"==l){var u=/\/((?:[^\/\\]|\\.)*)|$/g;n.guard=u.exec(s)[1],n.trigger=u.exec(s)[1],n.endTrigger=u.exec(s)[1],n.endGuard=u.exec(s)[1]}else"snippet"==l?(n.tabTrigger=s.match(/^\S*/)[0],n.name||(n.name=s)):l&&(n[l]=s)}}return e},o.prototype.getSnippetByName=function(t,e){var i,n=this.snippetNameMap;return this.getActiveScopes(e).some(function(r){var l=n[r];return l&&(i=l[t]),!!i},this),i},o}();_.implement(C.prototype,M);var O=function(o,t,e){void 0===e&&(e={});var n=o.getCursorPosition(),i=o.session.getLine(n.row),r=o.session.getTabString(),l=i.match(/^\s*/)[0];n.column<l.length&&(l=l.slice(0,n.column)),t=t.replace(/\r/g,"");var s=this.tokenizeTmSnippet(t);s=(s=this.resolveVariables(s,o)).map(function(A){return"\n"!=A||e.excludeExtraIndent?"string"==typeof A?A.replace(/\t/g,r):A:A+l});var u=[];s.forEach(function(A,D){if("object"==typeof A){var U=A.tabstopId,N=u[U];if(N||((N=u[U]=[]).index=U,N.value="",N.parents={}),-1===N.indexOf(A)){A.choices&&!N.choices&&(N.choices=A.choices),N.push(A);var V=s.indexOf(A,D+1);if(-1!==V){var W=s.slice(D+1,V);W.some(function(Z){return"object"==typeof Z})&&!N.value?N.value=W:W.length&&(!N.value||"string"!=typeof N.value)&&(N.value=W.join(""))}}}}),u.forEach(function(A){A.length=0});var p={};function m(A){for(var D=[],U=0;U<A.length;U++){var N=A[U];if("object"==typeof N){if(p[N.tabstopId])continue;N=D[A.lastIndexOf(N,U-1)]||{tabstopId:N.tabstopId}}D[U]=N}return D}for(var g=0;g<s.length;g++){var x=s[g];if("object"==typeof x){var b=x.tabstopId,T=u[b],H=s.indexOf(x,g+1);if(p[b]){p[b]===x&&(delete p[b],Object.keys(p).forEach(function(A){T.parents[A]=!0}));continue}p[b]=x;var I=T.value;"string"!=typeof I?I=m(I):x.fmt&&(I=this.tmStrFormat(I,x,o)),s.splice.apply(s,[g+1,Math.max(0,H-g)].concat(I,x)),-1===T.indexOf(x)&&T.push(x)}}var z=0,B=0,j="";return s.forEach(function(A){if("string"==typeof A){var D=A.split("\n");D.length>1?(B=D[D.length-1].length,z+=D.length-1):B+=A.length,j+=A}else A&&(A.start?A.end={row:z,column:B}:A.start={row:z,column:B})}),{text:j,tabstops:u,tokens:s}},h=function(){function o(t){if(this.index=0,this.ranges=[],this.tabstops=[],t.tabstopManager)return t.tabstopManager;t.tabstopManager=this,this.$onChange=this.onChange.bind(this),this.$onChangeSelection=w.delayedCall(this.onChangeSelection.bind(this)).schedule,this.$onChangeSession=this.onChangeSession.bind(this),this.$onAfterExec=this.onAfterExec.bind(this),this.attach(t)}return o.prototype.attach=function(t){this.$openTabstops=null,this.selectedTabstop=null,this.editor=t,this.session=t.session,this.editor.on("change",this.$onChange),this.editor.on("changeSelection",this.$onChangeSelection),this.editor.on("changeSession",this.$onChangeSession),this.editor.commands.on("afterExec",this.$onAfterExec),this.editor.keyBinding.addKeyboardHandler(this.keyboardHandler)},o.prototype.detach=function(){this.tabstops.forEach(this.removeTabstopMarkers,this),this.ranges.length=0,this.tabstops.length=0,this.selectedTabstop=null,this.editor.off("change",this.$onChange),this.editor.off("changeSelection",this.$onChangeSelection),this.editor.off("changeSession",this.$onChangeSession),this.editor.commands.off("afterExec",this.$onAfterExec),this.editor.keyBinding.removeKeyboardHandler(this.keyboardHandler),this.editor.tabstopManager=null,this.session=null,this.editor=null},o.prototype.onChange=function(t){for(var e="r"==t.action[0],n=this.selectedTabstop||{},i=n.parents||{},r=this.tabstops.slice(),l=0;l<r.length;l++){var s=r[l];if(s.rangeList.$bias=s==n||i[s.index]?0:1,"remove"==t.action&&s!==n){var p=s.parents&&s.parents[n.index],m=s.rangeList.pointIndex(t.start,p);m=m<0?-m-1:m+1;for(var g=s.rangeList.pointIndex(t.end,p),x=s.rangeList.ranges.slice(m,g=g<0?-g-1:g-1),b=0;b<x.length;b++)this.removeRange(x[b])}s.rangeList.$onChange(t)}var T=this.session;!this.$inChange&&e&&1==T.getLength()&&!T.getValue()&&this.detach()},o.prototype.updateLinkedFields=function(){var t=this.selectedTabstop;if(t&&t.hasLinkedRanges&&t.firstNonLinked){this.$inChange=!0;for(var e=this.session,n=e.getTextRange(t.firstNonLinked),i=0;i<t.length;i++){var r=t[i];if(r.linked){var s=L.snippetManager.tmStrFormat(n,r.original,this.editor);e.replace(r,s)}}this.$inChange=!1}},o.prototype.onAfterExec=function(t){t.command&&!t.command.readOnly&&this.updateLinkedFields()},o.prototype.onChangeSelection=function(){if(this.editor){for(var t=this.editor.selection.lead,e=this.editor.selection.anchor,n=this.editor.selection.isEmpty(),i=0;i<this.ranges.length;i++)if(!this.ranges[i].linked){var r=this.ranges[i].contains(t.row,t.column),l=n||this.ranges[i].contains(e.row,e.column);if(r&&l)return}this.detach()}},o.prototype.onChangeSession=function(){this.detach()},o.prototype.tabNext=function(t){var e=this.tabstops.length,n=this.index+(t||1);(n=Math.min(Math.max(n,1),e))==e&&(n=0),this.selectTabstop(n),0===n&&this.detach()},o.prototype.selectTabstop=function(t){this.$openTabstops=null;var e=this.tabstops[this.index];if(e&&this.addTabstopMarkers(e),this.index=t,(e=this.tabstops[this.index])&&e.length){this.selectedTabstop=e;var n=e.firstNonLinked||e;if(e.choices&&(n.cursor=n.start),this.editor.inVirtualSelectionMode)this.editor.selection.fromOrientedRange(n);else{var i=this.editor.multiSelect;i.toSingleRange(n);for(var r=0;r<e.length;r++)e.hasLinkedRanges&&e[r].linked||i.addRange(e[r].clone(),!0)}this.editor.keyBinding.addKeyboardHandler(this.keyboardHandler),this.selectedTabstop&&this.selectedTabstop.choices&&this.editor.execCommand("startAutocomplete",{matches:this.selectedTabstop.choices})}},o.prototype.addTabstops=function(t,e,n){var i=this.useLink||!this.editor.getOption("enableMultiselect");if(this.$openTabstops||(this.$openTabstops=[]),!t[0]){var r=v.fromPoints(n,n);c(r.start,e),c(r.end,e),t[0]=[r],t[0].index=0}var s=[this.index+1,0],u=this.ranges;t.forEach(function(p,m){for(var g=this.$openTabstops[m]||p,x=0;x<p.length;x++){var b=p[x],T=v.fromPoints(b.start,b.end||b.start);d(T.start,e),d(T.end,e),T.original=b,T.tabstop=g,u.push(T),g!=p?g.unshift(T):g[x]=T,b.fmtString||g.firstNonLinked&&i?(T.linked=!0,g.hasLinkedRanges=!0):g.firstNonLinked||(g.firstNonLinked=T)}g.firstNonLinked||(g.hasLinkedRanges=!1),g===p&&(s.push(g),this.$openTabstops[m]=g),this.addTabstopMarkers(g),g.rangeList=g.rangeList||new y,g.rangeList.$bias=0,g.rangeList.addList(g)},this),s.length>2&&(this.tabstops.length&&s.push(s.splice(2,1)[0]),this.tabstops.splice.apply(this.tabstops,s))},o.prototype.addTabstopMarkers=function(t){var e=this.session;t.forEach(function(n){n.markerId||(n.markerId=e.addMarker(n,"ace_snippet-marker","text"))})},o.prototype.removeTabstopMarkers=function(t){var e=this.session;t.forEach(function(n){e.removeMarker(n.markerId),n.markerId=null})},o.prototype.removeRange=function(t){var e=t.tabstop.indexOf(t);-1!=e&&t.tabstop.splice(e,1),-1!=(e=this.ranges.indexOf(t))&&this.ranges.splice(e,1),-1!=(e=t.tabstop.rangeList.ranges.indexOf(t))&&t.tabstop.splice(e,1),this.session.removeMarker(t.markerId),t.tabstop.length||(-1!=(e=this.tabstops.indexOf(t.tabstop))&&this.tabstops.splice(e,1),this.tabstops.length||this.detach())},o}();h.prototype.keyboardHandler=new $,h.prototype.keyboardHandler.bindKeys({Tab:function(o){L.snippetManager&&L.snippetManager.expandWithTab(o)||(o.tabstopManager.tabNext(1),o.renderer.scrollCursorIntoView())},"Shift-Tab":function(o){o.tabstopManager.tabNext(-1),o.renderer.scrollCursorIntoView()},Esc:function(o){o.tabstopManager.detach()}});var d=function(o,t){0==o.row&&(o.column+=t.column),o.row+=t.row},c=function(o,t){o.row==t.row&&(o.column-=t.column),o.row-=t.row};k.importCssString("\n.ace_snippet-marker {\n    -moz-box-sizing: border-box;\n    box-sizing: border-box;\n    background: rgba(194, 193, 208, 0.09);\n    border: 1px dotted rgba(211, 208, 235, 0.62);\n    position: absolute;\n}","snippets.css",!1),L.snippetManager=new C;var a=f("./editor").Editor;(function(){this.insertSnippet=function(o,t){return L.snippetManager.insertSnippet(this,o,t)},this.expandSnippet=function(o){return L.snippetManager.expandWithTab(this,o)}}).call(a.prototype)}),ace.define("ace/autocomplete/inline_screenreader",["require","exports","module"],function(f,L,F){"use strict";var k=function(){function _(M){this.editor=M,this.screenReaderDiv=document.createElement("div"),this.screenReaderDiv.classList.add("ace_screenreader-only"),this.editor.container.appendChild(this.screenReaderDiv)}return _.prototype.setScreenReaderContent=function(M){for(!this.popup&&this.editor.completer&&this.editor.completer.popup&&(this.popup=this.editor.completer.popup,this.popup.renderer.on("afterRender",function(){var v=this.popup.getRow(),y=this.popup.renderer.$textLayer,$=y.element.childNodes[v-y.config.firstRow];if($){for(var S="doc-tooltip ",R=0;R<this._lines.length;R++)S+="ace-inline-screenreader-line-".concat(R," ");$.setAttribute("aria-describedby",S)}}.bind(this)));this.screenReaderDiv.firstChild;)this.screenReaderDiv.removeChild(this.screenReaderDiv.firstChild);this._lines=M.split(/\r\n|\r|\n/);var w=this.createCodeBlock();this.screenReaderDiv.appendChild(w)},_.prototype.destroy=function(){this.screenReaderDiv.remove()},_.prototype.createCodeBlock=function(){var M=document.createElement("pre");M.setAttribute("id","ace-inline-screenreader");for(var w=0;w<this._lines.length;w++){var v=document.createElement("code");v.setAttribute("id","ace-inline-screenreader-line-".concat(w));var y=document.createTextNode(this._lines[w]);v.appendChild(y),M.appendChild(v)}return M},_}();L.AceInlineScreenReader=k}),ace.define("ace/autocomplete/inline",["require","exports","module","ace/snippets","ace/autocomplete/inline_screenreader"],function(f,L,F){"use strict";var k=f("../snippets").snippetManager,_=f("./inline_screenreader").AceInlineScreenReader,M=function(){function w(){this.editor=null}return w.prototype.show=function(v,y,$){if($=$||"",v&&this.editor&&this.editor!==v&&(this.hide(),this.editor=null,this.inlineScreenReader=null),!v||!y)return!1;this.inlineScreenReader||(this.inlineScreenReader=new _(v));var S=y.snippet?k.getDisplayTextForSnippet(v,y.snippet):y.value;return!(y.hideInlinePreview||!S||!S.startsWith($)||(this.editor=v,this.inlineScreenReader.setScreenReaderContent(S),""===(S=S.slice($.length))?v.removeGhostText():v.setGhostText(S),0))},w.prototype.isOpen=function(){return!!this.editor&&!!this.editor.renderer.$ghostText},w.prototype.hide=function(){return!!this.editor&&(this.editor.removeGhostText(),!0)},w.prototype.destroy=function(){this.hide(),this.editor=null,this.inlineScreenReader&&(this.inlineScreenReader.destroy(),this.inlineScreenReader=null)},w}();L.AceInline=M}),ace.define("ace/autocomplete/popup",["require","exports","module","ace/virtual_renderer","ace/editor","ace/range","ace/lib/event","ace/lib/lang","ace/lib/dom","ace/config"],function(f,L,F){"use strict";var k=f("../virtual_renderer").VirtualRenderer,_=f("../editor").Editor,M=f("../range").Range,w=f("../lib/event"),v=f("../lib/lang"),y=f("../lib/dom"),$=f("../config").nls,S=function(E){return"suggest-aria-id:".concat(E)},R=function(E){var C=new k(E);C.$maxLines=4;var O=new _(C);return O.setHighlightActiveLine(!1),O.setShowPrintMargin(!1),O.renderer.setShowGutter(!1),O.renderer.setHighlightGutterLine(!1),O.$mouseHandler.$focusTimeout=0,O.$highlightTagPending=!0,O};y.importCssString('\n.ace_editor.ace_autocomplete .ace_marker-layer .ace_active-line {\n    background-color: #CAD6FA;\n    z-index: 1;\n}\n.ace_dark.ace_editor.ace_autocomplete .ace_marker-layer .ace_active-line {\n    background-color: #3a674e;\n}\n.ace_editor.ace_autocomplete .ace_line-hover {\n    border: 1px solid #abbffe;\n    margin-top: -1px;\n    background: rgba(233,233,253,0.4);\n    position: absolute;\n    z-index: 2;\n}\n.ace_dark.ace_editor.ace_autocomplete .ace_line-hover {\n    border: 1px solid rgba(109, 150, 13, 0.8);\n    background: rgba(58, 103, 78, 0.62);\n}\n.ace_completion-meta {\n    opacity: 0.5;\n    margin-left: 0.9em;\n}\n.ace_completion-message {\n    margin-left: 0.9em;\n    color: blue;\n}\n.ace_editor.ace_autocomplete .ace_completion-highlight{\n    color: #2d69c7;\n}\n.ace_dark.ace_editor.ace_autocomplete .ace_completion-highlight{\n    color: #93ca12;\n}\n.ace_editor.ace_autocomplete {\n    width: 300px;\n    z-index: 200000;\n    border: 1px lightgray solid;\n    position: fixed;\n    box-shadow: 2px 3px 5px rgba(0,0,0,.2);\n    line-height: 1.4;\n    background: #fefefe;\n    color: #111;\n}\n.ace_dark.ace_editor.ace_autocomplete {\n    border: 1px #484747 solid;\n    box-shadow: 2px 3px 5px rgba(0, 0, 0, 0.51);\n    line-height: 1.4;\n    background: #25282c;\n    color: #c1c1c1;\n}\n.ace_autocomplete .ace_text-layer  {\n    width: calc(100% - 8px);\n}\n.ace_autocomplete .ace_line {\n    display: flex;\n    align-items: center;\n}\n.ace_autocomplete .ace_line > * {\n    min-width: 0;\n    flex: 0 0 auto;\n}\n.ace_autocomplete .ace_line .ace_ {\n    flex: 0 1 auto;\n    overflow: hidden;\n    white-space: nowrap;\n    text-overflow: ellipsis;\n}\n.ace_autocomplete .ace_completion-spacer {\n    flex: 1;\n}\n.ace_autocomplete.ace_loading:after  {\n    content: "";\n    position: absolute;\n    top: 0px;\n    height: 2px;\n    width: 8%;\n    background: blue;\n    z-index: 100;\n    animation: ace_progress 3s infinite linear;\n    animation-delay: 300ms;\n    transform: translateX(-100%) scaleX(1);\n}\n@keyframes ace_progress {\n    0% { transform: translateX(-100%) scaleX(1) }\n    50% { transform: translateX(625%) scaleX(2) } \n    100% { transform: translateX(1500%) scaleX(3) } \n}\n@media (prefers-reduced-motion) {\n    .ace_autocomplete.ace_loading:after {\n        transform: translateX(625%) scaleX(2);\n        animation: none;\n     }\n}\n',"autocompletion.css",!1),L.AcePopup=function E(C){var O=y.createElement("div"),h=new R(O);C&&C.appendChild(O),O.style.display="none",h.renderer.content.style.cursor="default",h.renderer.setStyle("ace_autocomplete"),h.renderer.$textLayer.element.setAttribute("role","listbox"),h.renderer.$textLayer.element.setAttribute("aria-label",$("Autocomplete suggestions")),h.renderer.textarea.setAttribute("aria-hidden","true"),h.setOption("displayIndentGuides",!1),h.setOption("dragDelay",150);var d=function(){};h.focus=d,h.$isFocused=!0,h.renderer.$cursorLayer.restartTimer=d,h.renderer.$cursorLayer.element.style.opacity=0,h.renderer.$maxLines=8,h.renderer.$keepTextAreaAtCursor=!1,h.setHighlightActiveLine(!1),h.session.highlight(""),h.session.$searchHighlight.clazz="ace_highlight-marker",h.on("mousedown",function(i){var r=i.getDocumentPosition();h.selection.moveToPosition(r),o.start.row=o.end.row=r.row,i.stop()});var c,a=new M(-1,0,-1,1/0),o=new M(-1,0,-1,1/0);o.id=h.session.addMarker(o,"ace_active-line","fullLine"),h.setSelectOnHover=function(i){i?a.id&&(h.session.removeMarker(a.id),a.id=null):a.id=h.session.addMarker(a,"ace_line-hover","fullLine")},h.setSelectOnHover(!1),h.on("mousemove",function(i){if(c){if(c.x!=i.x||c.y!=i.y){(c=i).scrollTop=h.renderer.scrollTop,h.isMouseOver=!0;var r=c.getDocumentPosition().row;a.start.row!=r&&(a.id||h.setRow(r),e(r))}}else c=i}),h.renderer.on("beforeRender",function(){if(c&&-1!=a.start.row){c.$pos=null;var i=c.getDocumentPosition().row;a.id||h.setRow(i),e(i,!0)}}),h.renderer.on("afterRender",function(){var i=h.getRow(),r=h.renderer.$textLayer,l=r.element.childNodes[i-r.config.firstRow],s=document.activeElement;if(l!==r.selectedNode&&r.selectedNode&&(y.removeCssClass(r.selectedNode,"ace_selected"),s.removeAttribute("aria-activedescendant"),r.selectedNode.removeAttribute("id")),r.selectedNode=l,l){y.addCssClass(l,"ace_selected");var u=S(i);l.id=u,r.element.setAttribute("aria-activedescendant",u),s.setAttribute("aria-activedescendant",u),l.setAttribute("role","option"),l.setAttribute("aria-label",h.getData(i).value),l.setAttribute("aria-setsize",h.data.length),l.setAttribute("aria-posinset",i+1),l.setAttribute("aria-describedby","doc-tooltip")}});var t=function(){e(-1)},e=function(i,r){i!==a.start.row&&(a.start.row=a.end.row=i,r||h.session._emit("changeBackMarker"),h._emit("changeHoverMarker"))};h.getHoveredRow=function(){return a.start.row},w.addListener(h.container,"mouseout",function(){h.isMouseOver=!1,t()}),h.on("hide",t),h.on("changeSelection",t),h.session.doc.getLength=function(){return h.data.length},h.session.doc.getLine=function(i){var r=h.data[i];return"string"==typeof r?r:r&&r.value||""};var n=h.session.bgTokenizer;return n.$tokenizeRow=function(i){var r=h.data[i],l=[];if(!r)return l;"string"==typeof r&&(r={value:r});var s=r.caption||r.value||r.name;function u(I,z){I&&l.push({type:(r.className||"")+(z||""),value:I})}for(var p=s.toLowerCase(),m=(h.filterText||"").toLowerCase(),g=0,x=0,b=0;b<=m.length;b++)if(b!=x&&(r.matchMask&1<<b||b==m.length)){var T=m.slice(x,b);x=b;var H=p.indexOf(T,g);if(-1==H)continue;u(s.slice(g,H),""),u(s.slice(H,g=H+T.length),"completion-highlight")}return u(s.slice(g,s.length),""),l.push({type:"completion-spacer",value:" "}),r.meta&&l.push({type:"completion-meta",value:r.meta}),r.message&&l.push({type:"completion-message",value:r.message}),l},n.$updateOnChange=d,n.start=d,h.session.$computeWidth=function(){return this.screenWidth=0},h.isOpen=!1,h.isTopdown=!1,h.autoSelect=!0,h.filterText="",h.isMouseOver=!1,h.data=[],h.setData=function(i,r){h.filterText=r||"",h.setValue(v.stringRepeat("\n",i.length),-1),h.data=i||[],h.setRow(0)},h.getData=function(i){return h.data[i]},h.getRow=function(){return o.start.row},h.setRow=function(i){i=Math.max(this.autoSelect?0:-1,Math.min(this.data.length-1,i)),o.start.row!=i&&(h.selection.clearSelection(),o.start.row=o.end.row=i||0,h.session._emit("changeBackMarker"),h.moveCursorTo(i||0,0),h.isOpen&&h._signal("select"))},h.on("changeSelection",function(){h.isOpen&&h.setRow(h.selection.lead.row),h.renderer.scrollCursorIntoView()}),h.hide=function(){this.container.style.display="none",h.anchorPos=null,h.anchor=null,h.isOpen&&(h.isOpen=!1,this._signal("hide"))},h.tryShow=function(i,r,l,s){if(!s&&h.isOpen&&h.anchorPos&&h.anchor&&h.anchorPos.top===i.top&&h.anchorPos.left===i.left&&h.anchor===l)return!0;var u=this.container,p=window.innerHeight,m=window.innerWidth,g=this.renderer,x=g.$maxLines*r*1.4,b={top:0,bottom:0,left:0},T=p-i.top-3*this.$borderSize-r,H=i.top-3*this.$borderSize;l||(l=H<=T||T>=x?"bottom":"top"),"top"===l?(b.bottom=i.top-this.$borderSize,b.top=b.bottom-x):"bottom"===l&&(b.top=i.top+r+this.$borderSize,b.bottom=b.top+x);var I=b.top>=0&&b.bottom<=p;if(!s&&!I)return!1;g.$maxPixelHeight=I?null:"top"===l?H:T,"top"===l?(u.style.top="",u.style.bottom=p-b.bottom+"px",h.isTopdown=!1):(u.style.top=b.top+"px",u.style.bottom="",h.isTopdown=!0),u.style.display="";var z=i.left;return z+u.offsetWidth>m&&(z=m-u.offsetWidth),u.style.left=z+"px",u.style.right="",h.isOpen||(h.isOpen=!0,this._signal("show"),c=null),h.anchorPos=i,h.anchor=l,!0},h.show=function(i,r,l){this.tryShow(i,r,l?"bottom":void 0,!0)},h.goTo=function(i){var r=this.getRow(),l=this.session.getLength()-1;switch(i){case"up":r=r<=0?l:r-1;break;case"down":r=r>=l?-1:r+1;break;case"start":r=0;break;case"end":r=l}this.setRow(r)},h.getTextLeftOffset=function(){return this.$borderSize+this.renderer.$padding+this.$imageSize},h.$imageSize=0,h.$borderSize=1,h},L.$singleLineEditor=R,L.getAriaId=S}),ace.define("ace/autocomplete/util",["require","exports","module"],function(f,L,F){"use strict";L.parForEach=function(_,M,w){var v=0,y=_.length;0===y&&w();for(var $=0;$<y;$++)M(_[$],function(S,R){++v===y&&w(S,R)})};var k=/[a-zA-Z_0-9\$\-\u00A2-\u2000\u2070-\uFFFF]/;L.retrievePrecedingIdentifier=function(_,M,w){w=w||k;for(var v=[],y=M-1;y>=0&&w.test(_[y]);y--)v.push(_[y]);return v.reverse().join("")},L.retrieveFollowingIdentifier=function(_,M,w){w=w||k;for(var v=[],y=M;y<_.length&&w.test(_[y]);y++)v.push(_[y]);return v},L.getCompletionPrefix=function(_){var v,M=_.getCursorPosition(),w=_.session.getLine(M.row);return _.completers.forEach(function(y){y.identifierRegexps&&y.identifierRegexps.forEach(function($){!v&&$&&(v=this.retrievePrecedingIdentifier(w,M.column,$))}.bind(this))}.bind(this)),v||this.retrievePrecedingIdentifier(w,M.column)},L.triggerAutocomplete=function(_){var M=_.getCursorPosition(),y=_.session.getLine(M.row)[0===M.column?0:M.column-1];return _.completers.some(function($){if($.triggerCharacters&&Array.isArray($.triggerCharacters))return $.triggerCharacters.includes(y)})}}),ace.define("ace/autocomplete",["require","exports","module","ace/keyboard/hash_handler","ace/autocomplete/popup","ace/autocomplete/inline","ace/autocomplete/popup","ace/autocomplete/util","ace/lib/lang","ace/lib/dom","ace/snippets","ace/config","ace/lib/event"],function(f,L,F){"use strict";var k=f("./keyboard/hash_handler").HashHandler,_=f("./autocomplete/popup").AcePopup,M=f("./autocomplete/inline").AceInline,w=f("./autocomplete/popup").getAriaId,v=f("./autocomplete/util"),y=f("./lib/lang"),$=f("./lib/dom"),S=f("./snippets").snippetManager,R=f("./config"),P=f("./lib/event"),E=function(d,c){c.completer&&c.completer.destroy()},C=function(){function d(){this.autoInsert=!1,this.autoSelect=!0,this.autoShown=!1,this.exactMatch=!1,this.inlineEnabled=!1,this.keyboardHandler=new k,this.keyboardHandler.bindKeys(this.commands),this.parentNode=null,this.setSelectOnHover=!1,this.showLoadingState=!1,this.stickySelectionDelay=500,this.blurListener=this.blurListener.bind(this),this.changeListener=this.changeListener.bind(this),this.mousedownListener=this.mousedownListener.bind(this),this.mousewheelListener=this.mousewheelListener.bind(this),this.onLayoutChange=this.onLayoutChange.bind(this),this.changeTimer=y.delayedCall(function(){this.updateCompletions(!0)}.bind(this)),this.tooltipTimer=y.delayedCall(this.updateDocTooltip.bind(this),50),this.stickySelectionTimer=y.delayedCall(function(){this.stickySelection=!0}.bind(this),this.stickySelectionDelay),this.$firstOpenTimer=y.delayedCall(function(){var c=this.completionProvider&&this.completionProvider.initialPosition;this.autoShown||this.popup&&this.popup.isOpen||!c||(this.completions=new h(d.completionsForLoading),this.openPopup(this.editor,c.prefix,!1),this.popup.renderer.setStyle("ace_loading",!0))}.bind(this),this.stickySelectionDelay)}return Object.defineProperty(d,"completionsForLoading",{get:function(){return[{caption:R.nls("Loading..."),value:""}]},enumerable:!1,configurable:!0}),d.prototype.$init=function(){return this.popup=new _(this.parentNode||document.body||document.documentElement),this.popup.on("click",function(c){this.insertMatch(),c.stop()}.bind(this)),this.popup.focus=this.editor.focus.bind(this.editor),this.popup.on("show",this.$onPopupShow.bind(this)),this.popup.on("hide",this.$onHidePopup.bind(this)),this.popup.on("select",this.$onPopupChange.bind(this)),P.addListener(this.popup.container,"mouseout",this.mouseOutListener.bind(this)),this.popup.on("changeHoverMarker",this.tooltipTimer.bind(null,null)),this.popup},d.prototype.$initInline=function(){if(this.inlineEnabled&&!this.inlineRenderer)return this.inlineRenderer=new M,this.inlineRenderer},d.prototype.getPopup=function(){return this.popup||this.$init()},d.prototype.$onHidePopup=function(){this.inlineRenderer&&this.inlineRenderer.hide(),this.hideDocTooltip(),this.stickySelectionTimer.cancel(),this.stickySelection=!1},d.prototype.$onPopupChange=function(c){if(this.inlineRenderer&&this.inlineEnabled){var a=c?null:this.popup.getData(this.popup.getRow()),o=v.getCompletionPrefix(this.editor);if(this.inlineRenderer.show(this.editor,a,o)||this.inlineRenderer.hide(),this.popup.isMouseOver&&this.setSelectOnHover)return void this.tooltipTimer.call(null,null)}this.$updatePopupPosition(),this.tooltipTimer.call(null,null)},d.prototype.$onPopupShow=function(c){this.$onPopupChange(c),this.stickySelection=!1,this.stickySelectionDelay>=0&&this.stickySelectionTimer.schedule(this.stickySelectionDelay)},d.prototype.observeLayoutChanges=function(){if(!this.$elements&&this.editor){window.addEventListener("resize",this.onLayoutChange,{passive:!0}),window.addEventListener("wheel",this.mousewheelListener);for(var c=this.editor.container.parentNode,a=[];c;)a.push(c),c.addEventListener("scroll",this.onLayoutChange,{passive:!0}),c=c.parentNode;this.$elements=a}},d.prototype.unObserveLayoutChanges=function(){var c=this;window.removeEventListener("resize",this.onLayoutChange,{passive:!0}),window.removeEventListener("wheel",this.mousewheelListener),this.$elements&&this.$elements.forEach(function(a){a.removeEventListener("scroll",c.onLayoutChange,{passive:!0})}),this.$elements=null},d.prototype.onLayoutChange=function(){if(!this.popup.isOpen)return this.unObserveLayoutChanges();this.$updatePopupPosition(),this.updateDocTooltip()},d.prototype.$updatePopupPosition=function(){var c=this.editor,a=c.renderer,o=a.layerConfig.lineHeight,t=a.$cursorLayer.getPixelPosition(this.base,!0);t.left-=this.popup.getTextLeftOffset();var e=c.container.getBoundingClientRect();t.top+=e.top-a.layerConfig.offset,t.left+=e.left-c.renderer.scrollLeft,t.left+=a.gutterWidth;var n={top:t.top,left:t.left};a.$ghostText&&a.$ghostTextWidget&&this.base.row===a.$ghostText.position.row&&(n.top+=a.$ghostTextWidget.el.offsetHeight),!this.popup.tryShow(n,o,"bottom")&&(this.popup.tryShow(t,o,"top")||this.popup.show(t,o))},d.prototype.openPopup=function(c,a,o){this.$firstOpenTimer.cancel(),this.popup||this.$init(),this.inlineEnabled&&!this.inlineRenderer&&this.$initInline(),this.popup.autoSelect=this.autoSelect,this.popup.setSelectOnHover(this.setSelectOnHover);var n,t=this.popup.getRow(),e=this.popup.data[t];this.popup.setData(this.completions.filtered,this.completions.filterText),this.editor.textInput.setAriaOptions&&this.editor.textInput.setAriaOptions({activeDescendant:w(this.popup.getRow()),inline:this.inlineEnabled}),c.keyBinding.addKeyboardHandler(this.keyboardHandler),this.stickySelection&&(n=this.popup.data.indexOf(e)),(!n||-1===n)&&(n=0),this.popup.setRow(this.autoSelect?n:-1),n===t&&e!==this.completions.filtered[n]&&this.$onPopupChange(),o?o&&!a&&this.detach():(this.popup.setTheme(c.getTheme()),this.popup.setFontSize(c.getFontSize()),this.$updatePopupPosition(),this.tooltipNode&&this.updateDocTooltip()),this.changeTimer.cancel(),this.observeLayoutChanges()},d.prototype.detach=function(){this.editor&&(this.editor.keyBinding.removeKeyboardHandler(this.keyboardHandler),this.editor.off("changeSelection",this.changeListener),this.editor.off("blur",this.blurListener),this.editor.off("mousedown",this.mousedownListener),this.editor.off("mousewheel",this.mousewheelListener)),this.$firstOpenTimer.cancel(),this.changeTimer.cancel(),this.hideDocTooltip(),this.completionProvider&&this.completionProvider.detach(),this.popup&&this.popup.isOpen&&this.popup.hide(),this.base&&this.base.detach(),this.activated=!1,this.completionProvider=this.completions=this.base=null,this.unObserveLayoutChanges()},d.prototype.changeListener=function(c){var a=this.editor.selection.lead;(a.row!=this.base.row||a.column<this.base.column)&&this.detach(),this.activated?this.changeTimer.schedule():this.detach()},d.prototype.blurListener=function(c){var a=document.activeElement,o=this.editor.textInput.getElement(),t=c.relatedTarget&&this.tooltipNode&&this.tooltipNode.contains(c.relatedTarget);a!=o&&a.parentNode!=(this.popup&&this.popup.container)&&!t&&a!=this.tooltipNode&&c.relatedTarget!=o&&this.detach()},d.prototype.mousedownListener=function(c){this.detach()},d.prototype.mousewheelListener=function(c){this.popup.isMouseOver||this.detach()},d.prototype.mouseOutListener=function(c){this.popup.isOpen&&this.$updatePopupPosition()},d.prototype.goTo=function(c){this.popup.goTo(c)},d.prototype.insertMatch=function(c,a){if(c||(c=this.popup.getData(this.popup.getRow())),!c)return!1;if(""===c.value)return this.detach();var o=this.completions,t=this.getCompletionProvider().insertMatch(this.editor,c,o.filterText,a);return this.completions==o&&this.detach(),t},d.prototype.showPopup=function(c,a){this.editor&&this.detach(),this.activated=!0,this.editor=c,c.completer!=this&&(c.completer&&c.completer.detach(),c.completer=this),c.on("changeSelection",this.changeListener),c.on("blur",this.blurListener),c.on("mousedown",this.mousedownListener),c.on("mousewheel",this.mousewheelListener),this.updateCompletions(!1,a)},d.prototype.getCompletionProvider=function(c){return this.completionProvider||(this.completionProvider=new O(c)),this.completionProvider},d.prototype.gatherCompletions=function(c,a){return this.getCompletionProvider().gatherCompletions(c,a)},d.prototype.updateCompletions=function(c,a){if(c&&this.base&&this.completions){var t=this.editor.getCursorPosition();if((e=this.editor.session.getTextRange({start:this.base,end:t}))==this.completions.filterText)return;return this.completions.setFilter(e),this.completions.filtered.length&&(1!=this.completions.filtered.length||this.completions.filtered[0].value!=e||this.completions.filtered[0].snippet)?void this.openPopup(this.editor,e,c):this.detach()}if(a&&a.matches)return t=this.editor.getSelectionRange().start,this.base=this.editor.session.doc.createAnchor(t.row,t.column),this.base.$insertRight=!0,this.completions=new h(a.matches),this.openPopup(this.editor,"",c);var o=this.editor.getSession(),e=(t=this.editor.getCursorPosition(),v.getCompletionPrefix(this.editor));this.base=o.doc.createAnchor(t.row,t.column-e.length),this.base.$insertRight=!0;var n={exactMatch:this.exactMatch,ignoreCaption:this.ignoreCaption};this.getCompletionProvider({prefix:e,pos:t}).provideCompletions(this.editor,n,function(i,r,l){var s=r.filtered,u=v.getCompletionPrefix(this.editor);if(this.$firstOpenTimer.cancel(),l){if(!s.length){var p=!this.autoShown&&this.emptyMessage;return"function"==typeof p&&(p=this.emptyMessage(u)),p?(this.completions=new h([{caption:p,value:""}]),this.openPopup(this.editor,u,c),void this.popup.renderer.setStyle("ace_loading",!1)):this.detach()}if(1==s.length&&s[0].value==u&&!s[0].snippet)return this.detach();if(this.autoInsert&&!this.autoShown&&1==s.length)return this.insertMatch(s[0])}this.completions=!l&&this.showLoadingState?new h(d.completionsForLoading.concat(s),r.filterText):r,this.openPopup(this.editor,u,c),this.popup.renderer.setStyle("ace_loading",!l)}.bind(this)),this.showLoadingState&&!this.autoShown&&(!this.popup||!this.popup.isOpen)&&this.$firstOpenTimer.delay(this.stickySelectionDelay/2)},d.prototype.cancelContextMenu=function(){this.editor.$mouseHandler.cancelContextMenu()},d.prototype.updateDocTooltip=function(){var c=this.popup,a=this.completions.filtered,o=a&&(a[c.getHoveredRow()]||a[c.getRow()]),t=null;if(!o||!this.editor||!this.popup.isOpen)return this.hideDocTooltip();for(var e=this.editor.completers.length,n=0;n<e;n++){var i=this.editor.completers[n];if(i.getDocTooltip&&o.completerId===i.id){t=i.getDocTooltip(o);break}}if(!t&&"string"!=typeof o&&(t=o),"string"==typeof t&&(t={docText:t}),!t||!t.docHTML&&!t.docText)return this.hideDocTooltip();this.showDocTooltip(t)},d.prototype.showDocTooltip=function(c){this.tooltipNode||(this.tooltipNode=$.createElement("div"),this.tooltipNode.style.margin=0,this.tooltipNode.style.pointerEvents="auto",this.tooltipNode.tabIndex=-1,this.tooltipNode.onblur=this.blurListener.bind(this),this.tooltipNode.onclick=this.onTooltipClick.bind(this),this.tooltipNode.id="doc-tooltip",this.tooltipNode.setAttribute("role","tooltip"));var a=this.editor.renderer.theme;this.tooltipNode.className="ace_tooltip ace_doc-tooltip "+(a.isDark?"ace_dark ":"")+(a.cssClass||"");var o=this.tooltipNode;c.docHTML?o.innerHTML=c.docHTML:c.docText&&(o.textContent=c.docText),o.parentNode||this.popup.container.appendChild(this.tooltipNode);var t=this.popup,e=t.container.getBoundingClientRect();o.style.top=t.container.style.top,o.style.bottom=t.container.style.bottom,o.style.display="block",window.innerWidth-e.right<320?e.left<320?t.isTopdown?(o.style.top=e.bottom+"px",o.style.left=e.left+"px",o.style.right="",o.style.bottom=""):(o.style.top=t.container.offsetTop-o.offsetHeight+"px",o.style.left=e.left+"px",o.style.right="",o.style.bottom=""):(o.style.right=window.innerWidth-e.left+"px",o.style.left=""):(o.style.left=e.right+1+"px",o.style.right="")},d.prototype.hideDocTooltip=function(){if(this.tooltipTimer.cancel(),this.tooltipNode){var c=this.tooltipNode;!this.editor.isFocused()&&document.activeElement==c&&this.editor.focus(),this.tooltipNode=null,c.parentNode&&c.parentNode.removeChild(c)}},d.prototype.onTooltipClick=function(c){for(var a=c.target;a&&a!=this.tooltipNode;){if("A"==a.nodeName&&a.href){a.rel="noreferrer",a.target="_blank";break}a=a.parentNode}},d.prototype.destroy=function(){if(this.detach(),this.popup){this.popup.destroy();var c=this.popup.container;c&&c.parentNode&&c.parentNode.removeChild(c)}this.editor&&this.editor.completer==this&&(this.editor.off("destroy",E),this.editor.completer=null),this.inlineRenderer=this.popup=this.editor=null},d}();C.prototype.commands={Up:function(d){d.completer.goTo("up")},Down:function(d){d.completer.goTo("down")},"Ctrl-Up|Ctrl-Home":function(d){d.completer.goTo("start")},"Ctrl-Down|Ctrl-End":function(d){d.completer.goTo("end")},Esc:function(d){d.completer.detach()},Return:function(d){return d.completer.insertMatch()},"Shift-Return":function(d){d.completer.insertMatch(null,{deleteSuffix:!0})},Tab:function(d){var c=d.completer.insertMatch();if(c||d.tabstopManager)return c;d.completer.goTo("down")},PageUp:function(d){d.completer.popup.gotoPageUp()},PageDown:function(d){d.completer.popup.gotoPageDown()}},C.for=function(d){return d.completer instanceof C||(d.completer&&(d.completer.destroy(),d.completer=null),R.get("sharedPopups")?(C.$sharedInstance||(C.$sharedInstance=new C),d.completer=C.$sharedInstance):(d.completer=new C,d.once("destroy",E))),d.completer},C.startCommand={name:"startAutocomplete",exec:function(d,c){var a=C.for(d);a.autoInsert=!1,a.autoSelect=!0,a.autoShown=!1,a.showPopup(d,c),a.cancelContextMenu()},bindKey:"Ctrl-Space|Ctrl-Shift-Space|Alt-Space"};var O=function(){function d(c){this.initialPosition=c,this.active=!0}return d.prototype.insertByIndex=function(c,a,o){return!(!this.completions||!this.completions.filtered)&&this.insertMatch(c,this.completions.filtered[a],o)},d.prototype.insertMatch=function(c,a,o){if(!a)return!1;if(c.startOperation({command:{name:"insertMatch"}}),a.completer&&a.completer.insertMatch)a.completer.insertMatch(c,a);else{if(!this.completions)return!1;var t=this.completions.filterText.length,e=0;if(a.range&&a.range.start.row===a.range.end.row&&(t-=this.initialPosition.prefix.length,t+=this.initialPosition.pos.column-a.range.start.column,e+=a.range.end.column-this.initialPosition.pos.column),t||e){var n;n=c.selection.getAllRanges?c.selection.getAllRanges():[c.getSelectionRange()];for(var r,i=0;r=n[i];i++)r.start.column-=t,r.end.column+=e,c.session.remove(r)}a.snippet?S.insertSnippet(c,a.snippet):this.$insertString(c,a),a.command&&"startAutocomplete"===a.command&&c.execCommand(a.command)}return c.endOperation(),!0},d.prototype.$insertString=function(c,a){c.execCommand("insertstring",a.value||a)},d.prototype.gatherCompletions=function(c,a){var o=c.getSession(),t=c.getCursorPosition(),e=v.getCompletionPrefix(c),n=[];this.completers=c.completers;var i=c.completers.length;return c.completers.forEach(function(r,l){r.getCompletions(c,o,t,e,function(s,u){r.hideInlinePreview&&(u=u.map(function(p){return Object.assign(p,{hideInlinePreview:r.hideInlinePreview})})),!s&&u&&(n=n.concat(u)),a(null,{prefix:v.getCompletionPrefix(c),matches:n,finished:0==--i})})}),!0},d.prototype.provideCompletions=function(c,a,o){var t=function(r){var l=r.prefix;this.completions=new h(r.matches),a.exactMatch&&(this.completions.exactMatch=!0),a.ignoreCaption&&(this.completions.ignoreCaption=!0),this.completions.setFilter(l),(r.finished||this.completions.filtered.length)&&o(null,this.completions,r.finished)}.bind(this),e=!0,n=null;if(this.gatherCompletions(c,function(r,l){if(this.active&&(r&&(o(r,[],!0),this.detach()),0===l.prefix.indexOf(l.prefix))){if(e)return void(n=l);t(l)}}.bind(this)),e=!1,n){var i=n;n=null,t(i)}},d.prototype.detach=function(){this.active=!1,this.completers&&this.completers.forEach(function(c){"function"==typeof c.cancel&&c.cancel()})},d}(),h=function(){function d(c,a){this.all=c,this.filtered=c,this.filterText=a||"",this.exactMatch=!1,this.ignoreCaption=!1}return d.prototype.setFilter=function(c){if(c.length>this.filterText&&0===c.lastIndexOf(this.filterText,0))var a=this.filtered;else a=this.all;this.filterText=c,a=(a=this.filterCompletions(a,this.filterText)).sort(function(t,e){return e.exactMatch-t.exactMatch||e.$score-t.$score||(t.caption||t.value).localeCompare(e.caption||e.value)});var o=null;a=a.filter(function(t){var e=t.snippet||t.caption||t.value;return e!==o&&(o=e,!0)}),this.filtered=a},d.prototype.filterCompletions=function(c,a){var o=[],t=a.toUpperCase(),e=a.toLowerCase();e:for(var i,n=0;i=c[n];n++){var r=!this.ignoreCaption&&i.caption||i.value||i.snippet;if(r){var p,m,l=-1,s=0,u=0;if(this.exactMatch){if(a!==r.substr(0,a.length))continue e}else{var g=r.toLowerCase().indexOf(e);if(g>-1)u=g;else for(var x=0;x<a.length;x++){var b=r.indexOf(e[x],l+1),T=r.indexOf(t[x],l+1);if((p=b>=0&&(T<0||b<T)?b:T)<0)continue e;(m=p-l-1)>0&&(-1===l&&(u+=10),u+=m,s|=1<<x),l=p}}i.matchMask=s,i.exactMatch=u?0:1,i.$score=(i.score||0)-u,o.push(i)}}return o},d}();L.Autocomplete=C,L.CompletionProvider=O,L.FilteredList=h}),ace.define("ace/ext/command_bar",["require","exports","module","ace/tooltip","ace/lib/event_emitter","ace/lib/lang","ace/lib/dom","ace/lib/oop","ace/lib/useragent"],function(f,L,F){var k=this&&this.__values||function(t){var e="function"==typeof Symbol&&Symbol.iterator,n=e&&t[e],i=0;if(n)return n.call(t);if(t&&"number"==typeof t.length)return{next:function(){return t&&i>=t.length&&(t=void 0),{value:t&&t[i++],done:!t}}};throw new TypeError(e?"Object is not iterable.":"Symbol.iterator is not defined.")},_=f("../tooltip").Tooltip,M=f("../lib/event_emitter").EventEmitter,w=f("../lib/lang"),v=f("../lib/dom"),y=f("../lib/oop"),$=f("../lib/useragent"),S="command_bar_tooltip_button",R="command_bar_button_value",P="command_bar_button_caption",E="command_bar_keybinding",C="command_bar_tooltip",O="MoreOptionsButton",c=function(t,e){return e.row>t.row||e.row===t.row&&e.column>t.column?t:e},a={Ctrl:{mac:"^"},Option:{mac:"\u2325"},Command:{mac:"\u2318"},Cmd:{mac:"\u2318"},Shift:"\u21e7",Left:"\u2190",Right:"\u2192",Up:"\u2191",Down:"\u2193"},o=function(){function t(e,n){var i,r;n=n||{},this.parentNode=e,this.tooltip=new _(this.parentNode),this.moreOptions=new _(this.parentNode),this.maxElementsOnTooltip=n.maxElementsOnTooltip||4,this.$alwaysShow=n.alwaysShow||!1,this.eventListeners={},this.elements={},this.commands={},this.tooltipEl=v.buildDom(["div",{class:C}],this.tooltip.getElement()),this.moreOptionsEl=v.buildDom(["div",{class:C+" tooltip_more_options"}],this.moreOptions.getElement()),this.$showTooltipTimer=w.delayedCall(this.$showTooltip.bind(this),n.showDelay||100),this.$hideTooltipTimer=w.delayedCall(this.$hideTooltip.bind(this),n.hideDelay||100),this.$tooltipEnter=this.$tooltipEnter.bind(this),this.$onMouseMove=this.$onMouseMove.bind(this),this.$onChangeScroll=this.$onChangeScroll.bind(this),this.$onEditorChangeSession=this.$onEditorChangeSession.bind(this),this.$scheduleTooltipForHide=this.$scheduleTooltipForHide.bind(this),this.$preventMouseEvent=this.$preventMouseEvent.bind(this);try{for(var l=k(["mousedown","mouseup","click"]),s=l.next();!s.done;s=l.next()){var u=s.value;this.tooltip.getElement().addEventListener(u,this.$preventMouseEvent),this.moreOptions.getElement().addEventListener(u,this.$preventMouseEvent)}}catch(p){i={error:p}}finally{try{s&&!s.done&&(r=l.return)&&r.call(l)}finally{if(i)throw i.error}}}return t.prototype.registerCommand=function(e,n){var i=Object.keys(this.commands).length<this.maxElementsOnTooltip;!i&&!this.elements[O]&&this.$createCommand(O,{name:"\xb7\xb7\xb7",exec:function(){this.$shouldHideMoreOptions=!1,this.$setMoreOptionsVisibility(!this.isMoreOptionsShown())}.bind(this),type:"checkbox",getValue:function(){return this.isMoreOptionsShown()}.bind(this),enabled:!0},!0),this.$createCommand(e,n,i),this.isShown()&&this.updatePosition()},t.prototype.isShown=function(){return!!this.tooltip&&this.tooltip.isOpen},t.prototype.isMoreOptionsShown=function(){return!!this.moreOptions&&this.moreOptions.isOpen},t.prototype.getAlwaysShow=function(){return this.$alwaysShow},t.prototype.setAlwaysShow=function(e){this.$alwaysShow=e,this.$updateOnHoverHandlers(!this.$alwaysShow),this._signal("alwaysShow",this.$alwaysShow)},t.prototype.attach=function(e){!e||this.isShown()&&this.editor===e||(this.detach(),this.editor=e,this.editor.on("changeSession",this.$onEditorChangeSession),this.editor.session&&(this.editor.session.on("changeScrollLeft",this.$onChangeScroll),this.editor.session.on("changeScrollTop",this.$onChangeScroll)),this.getAlwaysShow()?this.$showTooltip():this.$updateOnHoverHandlers(!0))},t.prototype.updatePosition=function(){if(this.editor){var n,e=this.editor.renderer;if((n=this.editor.selection.getAllRanges?this.editor.selection.getAllRanges():[this.editor.getSelectionRange()]).length){for(var l,i=c(n[0].start,n[0].end),r=0;l=n[r];r++)i=c(i,c(l.start,l.end));var s=e.$cursorLayer.getPixelPosition(i,!0),u=this.tooltip.getElement(),p=window.innerWidth,m=window.innerHeight,g=this.editor.container.getBoundingClientRect();s.top+=g.top-e.layerConfig.offset,s.left+=g.left+e.gutterWidth-e.scrollLeft;var x=s.top>=g.top&&s.top<=g.bottom&&s.left>=g.left+e.gutterWidth&&s.left<=g.right;if(!x&&this.isShown())return void this.$hideTooltip();if(x&&!this.isShown()&&this.getAlwaysShow())return void this.$showTooltip();var b=s.top-u.offsetHeight,T=Math.min(p-u.offsetWidth,s.left);if(!(b>=0&&b+u.offsetHeight<=m&&T>=0&&T+u.offsetWidth<=p))return void this.$hideTooltip();if(this.tooltip.setPosition(T,b),this.isMoreOptionsShown()){b+=u.offsetHeight,T=this.elements[O].getBoundingClientRect().left;var I=this.moreOptions.getElement();m=window.innerHeight,b+I.offsetHeight>m&&(b-=u.offsetHeight+I.offsetHeight),T+I.offsetWidth>p&&(T=p-I.offsetWidth),this.moreOptions.setPosition(T,b)}}}},t.prototype.update=function(){Object.keys(this.elements).forEach(this.$updateElement.bind(this))},t.prototype.detach=function(){this.tooltip.hide(),this.moreOptions.hide(),this.$updateOnHoverHandlers(!1),this.editor&&(this.editor.off("changeSession",this.$onEditorChangeSession),this.editor.session&&(this.editor.session.off("changeScrollLeft",this.$onChangeScroll),this.editor.session.off("changeScrollTop",this.$onChangeScroll))),this.$mouseInTooltip=!1,this.editor=null},t.prototype.destroy=function(){this.tooltip&&this.moreOptions&&(this.detach(),this.tooltip.destroy(),this.moreOptions.destroy()),this.eventListeners={},this.commands={},this.elements={},this.tooltip=this.moreOptions=this.parentNode=null},t.prototype.$createCommand=function(e,n,i){var u,r=i?this.tooltipEl:this.moreOptionsEl,l=[],s=n.bindKey;s&&("object"==typeof s&&(s=$.isMac?s.mac:s.win),l=(l=(s=s.split("|")[0]).split("-")).map(function(m){if(a[m]){if("string"==typeof a[m])return a[m];if($.isMac&&a[m].mac)return a[m].mac}return m})),i&&n.iconCssClass?u=["div",{class:["ace_icon_svg",n.iconCssClass].join(" "),"aria-label":n.name+" ("+n.bindKey+")"}]:(u=[["div",{class:R}],["div",{class:P},n.name]],l.length&&u.push(["div",{class:E},l.map(function(m){return["div",m]})])),v.buildDom(["div",{class:[S,n.cssClass||""].join(" "),ref:e},u],r,this.elements),this.commands[e]=n;var p=function(m){this.editor&&this.editor.focus(),this.$shouldHideMoreOptions=this.isMoreOptionsShown(),!this.elements[e].disabled&&n.exec&&n.exec(this.editor),this.$shouldHideMoreOptions&&this.$setMoreOptionsVisibility(!1),this.update(),m.preventDefault()}.bind(this);this.eventListeners[e]=p,this.elements[e].addEventListener("click",p.bind(this)),this.$updateElement(e)},t.prototype.$setMoreOptionsVisibility=function(e){e?(this.moreOptions.setTheme(this.editor.renderer.theme),this.moreOptions.setClassName(C+"_wrapper"),this.moreOptions.show(),this.update(),this.updatePosition()):this.moreOptions.hide()},t.prototype.$onEditorChangeSession=function(e){e.oldSession&&(e.oldSession.off("changeScrollTop",this.$onChangeScroll),e.oldSession.off("changeScrollLeft",this.$onChangeScroll)),this.detach()},t.prototype.$onChangeScroll=function(){this.editor.renderer&&(this.isShown()||this.getAlwaysShow())&&this.editor.renderer.once("afterRender",this.updatePosition.bind(this))},t.prototype.$onMouseMove=function(e){if(!this.$mouseInTooltip){var n=this.editor.getCursorPosition(),i=this.editor.renderer.textToScreenCoordinates(n.row,n.column);e.clientY>=i.pageY&&e.clientY<i.pageY+this.editor.renderer.lineHeight?(!this.isShown()&&!this.$showTooltipTimer.isPending()&&this.$showTooltipTimer.delay(),this.$hideTooltipTimer.isPending()&&this.$hideTooltipTimer.cancel()):(this.isShown()&&!this.$hideTooltipTimer.isPending()&&this.$hideTooltipTimer.delay(),this.$showTooltipTimer.isPending()&&this.$showTooltipTimer.cancel())}},t.prototype.$preventMouseEvent=function(e){this.editor&&this.editor.focus(),e.preventDefault()},t.prototype.$scheduleTooltipForHide=function(){this.$mouseInTooltip=!1,this.$showTooltipTimer.cancel(),this.$hideTooltipTimer.delay()},t.prototype.$tooltipEnter=function(){this.$mouseInTooltip=!0,this.$showTooltipTimer.isPending()&&this.$showTooltipTimer.cancel(),this.$hideTooltipTimer.isPending()&&this.$hideTooltipTimer.cancel()},t.prototype.$updateOnHoverHandlers=function(e){var n=this.tooltip.getElement(),i=this.moreOptions.getElement();e?(this.editor&&(this.editor.on("mousemove",this.$onMouseMove),this.editor.renderer.getMouseEventTarget().addEventListener("mouseout",this.$scheduleTooltipForHide,!0)),n.addEventListener("mouseenter",this.$tooltipEnter),n.addEventListener("mouseleave",this.$scheduleTooltipForHide),i.addEventListener("mouseenter",this.$tooltipEnter),i.addEventListener("mouseleave",this.$scheduleTooltipForHide)):(this.editor&&(this.editor.off("mousemove",this.$onMouseMove),this.editor.renderer.getMouseEventTarget().removeEventListener("mouseout",this.$scheduleTooltipForHide,!0)),n.removeEventListener("mouseenter",this.$tooltipEnter),n.removeEventListener("mouseleave",this.$scheduleTooltipForHide),i.removeEventListener("mouseenter",this.$tooltipEnter),i.removeEventListener("mouseleave",this.$scheduleTooltipForHide))},t.prototype.$showTooltip=function(){this.isShown()||(this.tooltip.setTheme(this.editor.renderer.theme),this.tooltip.setClassName(C+"_wrapper"),this.tooltip.show(),this.update(),this.updatePosition(),this._signal("show"))},t.prototype.$hideTooltip=function(){this.$mouseInTooltip=!1,this.isShown()&&(this.moreOptions.hide(),this.tooltip.hide(),this._signal("hide"))},t.prototype.$updateElement=function(e){var n=this.commands[e];if(n){var i=this.elements[e],r=n.enabled;if("function"==typeof r&&(r=r(this.editor)),"function"==typeof n.getValue){var l=n.getValue(this.editor);if("text"===n.type)i.textContent=l;else if("checkbox"===n.type){var s=l?v.addCssClass:v.removeCssClass,u=i.parentElement===this.tooltipEl;i.ariaChecked=l,u?s(i,"ace_selected"):s(i=i.querySelector("."+R),"ace_checkmark")}}r&&i.disabled?(v.removeCssClass(i,"ace_disabled"),i.ariaDisabled=i.disabled=!1,i.removeAttribute("disabled")):!r&&!i.disabled&&(v.addCssClass(i,"ace_disabled"),i.ariaDisabled=i.disabled=!0,i.setAttribute("disabled",""))}},t}();y.implement(o.prototype,M),v.importCssString("\n.ace_tooltip.".concat(C,"_wrapper {\n    padding: 0;\n}\n\n.ace_tooltip .").concat(C," {\n    padding: 1px 5px;\n    display: flex;\n    pointer-events: auto;\n}\n\n.ace_tooltip .").concat(C,".tooltip_more_options {\n    padding: 1px;\n    flex-direction: column;\n}\n\ndiv.").concat(S," {\n    display: inline-flex;\n    cursor: pointer;\n    margin: 1px;\n    border-radius: 2px;\n    padding: 2px 5px;\n    align-items: center;\n}\n\ndiv.").concat(S,".ace_selected,\ndiv.").concat(S,":hover:not(.ace_disabled) {\n    background-color: rgba(0, 0, 0, 0.1);\n}\n\ndiv.").concat(S,".ace_disabled {\n    color: #777;\n    pointer-events: none;\n}\n\ndiv.").concat(S," .ace_icon_svg {\n    height: 12px;\n    background-color: #000;\n}\n\ndiv.").concat(S,".ace_disabled .ace_icon_svg {\n    background-color: #777;\n}\n\n.").concat(C,".tooltip_more_options .").concat(S," {\n    display: flex;\n}\n\n.").concat(C,".").concat(R," {\n    display: none;\n}\n\n.").concat(C,".tooltip_more_options .").concat(R," {\n    display: inline-block;\n    width: 12px;\n}\n\n.").concat(P," {\n    display: inline-block;\n}\n\n.").concat(E," {\n    margin: 0 2px;\n    display: inline-block;\n    font-size: 8px;\n}\n\n.").concat(C,".tooltip_more_options .").concat(E," {\n    margin-left: auto;\n}\n\n.").concat(E," div {\n    display: inline-block;\n    min-width: 8px;\n    padding: 2px;\n    margin: 0 1px;\n    border-radius: 2px;\n    background-color: #ccc;\n    text-align: center;\n}\n\n.ace_dark.ace_tooltip .").concat(C," {\n    background-color: #373737;\n    color: #eee;\n}\n\n.ace_dark div.").concat(S,".ace_disabled {\n    color: #979797;\n}\n\n.ace_dark div.").concat(S,".ace_selected,\n.ace_dark div.").concat(S,":hover:not(.ace_disabled) {\n    background-color: rgba(255, 255, 255, 0.1);\n}\n\n.ace_dark div.").concat(S," .ace_icon_svg {\n    background-color: #eee;\n}\n\n.ace_dark div.").concat(S,".ace_disabled .ace_icon_svg {\n    background-color: #979797;\n}\n\n.ace_dark .").concat(S,".ace_disabled {\n    color: #979797;\n}\n\n.ace_dark .").concat(E," div {\n    background-color: #575757;\n}\n\n.ace_checkmark::before {\n    content: '\u2713';\n}\n"),"commandbar.css",!1),L.CommandBarTooltip=o,L.TOOLTIP_CLASS_NAME=C,L.BUTTON_CLASS_NAME=S}),ace.define("ace/autocomplete/text_completer",["require","exports","module","ace/range"],function(f,L,F){var k=f("../range").Range,_=/[^a-zA-Z_0-9\$\-\u00C0-\u1FFF\u2C00-\uD7FF\w]+/;L.getCompletions=function(v,y,$,S,R){var P=function w(v,y){var $=function M(v,y){return v.getTextRange(k.fromPoints({row:0,column:0},y)).split(_).length-1}(v,y),S=v.getValue().split(_),R=Object.create(null),P=S[$];return S.forEach(function(E,C){if(E&&E!==P){var O=Math.abs($-C),h=S.length-O;R[E]=R[E]?Math.max(h,R[E]):h}}),R}(y,$);R(null,Object.keys(P).map(function(C){return{caption:C,value:C,score:P[C],meta:"local"}}))}}),ace.define("ace/ext/language_tools",["require","exports","module","ace/snippets","ace/autocomplete","ace/config","ace/lib/lang","ace/autocomplete/util","ace/autocomplete/text_completer","ace/editor","ace/config"],function(f,L,F){"use strict";var k=f("../snippets").snippetManager,_=f("../autocomplete").Autocomplete,M=f("../config"),w=f("../lib/lang"),v=f("../autocomplete/util"),y=f("../autocomplete/text_completer"),$={getCompletions:function(e,n,i,r,l){if(n.$mode.completer)return n.$mode.completer.getCompletions(e,n,i,r,l);var s=e.session.getState(i.row),u=n.$mode.getCompletions(s,n,i,r);l(null,u=u.map(function(p){return p.completerId=$.id,p}))},id:"keywordCompleter"},S=function(e){var n={};return e.replace(/\${(\d+)(:(.*?))?}/g,function(i,r,l,s){return n[r]=s||""}).replace(/\$(\d+?)/g,function(i,r){return n[r]})},R={getCompletions:function(e,n,i,r,l){var s=[],u=n.getTokenAt(i.row,i.column);u&&u.type.match(/(tag-name|tag-open|tag-whitespace|attribute-name|attribute-value)\.xml$/)?s.push("html-tag"):s=k.getActiveScopes(e);var p=k.snippetMap,m=[];s.forEach(function(g){for(var x=p[g]||[],b=x.length;b--;){var T=x[b],H=T.name||T.tabTrigger;!H||m.push({caption:H,snippet:T.content,meta:T.tabTrigger&&!T.name?T.tabTrigger+"\u21e5 ":"snippet",completerId:R.id})}},this),l(null,m)},getDocTooltip:function(e){e.snippet&&!e.docHTML&&(e.docHTML=["<b>",w.escapeHTML(e.caption),"</b>","<hr></hr>",w.escapeHTML(S(e.snippet))].join(""))},id:"snippetCompleter"},P=[R,y,$];L.setCompleters=function(e){P.length=0,e&&P.push.apply(P,e)},L.addCompleter=function(e){P.push(e)},L.textCompleter=y,L.keyWordCompleter=$,L.snippetCompleter=R;var c,E={name:"expandSnippet",exec:function(e){return k.expandWithTab(e)},bindKey:"Tab"},C=function(e,n){O(n.session.$mode)},O=function(e){"string"==typeof e&&(e=M.$modes[e]),e&&(k.files||(k.files={}),h(e.$id,e.snippetFileId),e.modes&&e.modes.forEach(O))},h=function(e,n){!n||!e||k.files[e]||(k.files[e]={},M.loadModule(n,function(i){!i||(k.files[e]=i,!i.snippets&&i.snippetText&&(i.snippets=k.parseSnippetFile(i.snippetText)),k.register(i.snippets||[],i.scope),i.includeScopes&&(k.snippetMap[i.scope].includeScopes=i.includeScopes,i.includeScopes.forEach(function(r){O("ace/mode/"+r)})))}))},d=function(e){var n=e.editor,i=n.completer&&n.completer.activated;if("backspace"===e.command.name)i&&!v.getCompletionPrefix(n)&&n.completer.detach();else if("insertstring"===e.command.name&&!i){c=e;var r=e.editor.$liveAutocompletionDelay;r?a.delay(r):o(e)}},a=w.delayedCall(function(){o(c)},0),o=function(e){var n=e.editor,i=v.getCompletionPrefix(n),r=v.triggerAutocomplete(n);if(i&&i.length>=n.$liveAutocompletionThreshold||r){var l=_.for(n);l.autoShown=!0,l.showPopup(n)}},t=f("../editor").Editor;f("../config").defineOptions(t.prototype,"editor",{enableBasicAutocompletion:{set:function(e){e?(this.completers||(this.completers=Array.isArray(e)?e:P),this.commands.addCommand(_.startCommand)):this.commands.removeCommand(_.startCommand)},value:!1},enableLiveAutocompletion:{set:function(e){e?(this.completers||(this.completers=Array.isArray(e)?e:P),this.commands.on("afterExec",d)):this.commands.off("afterExec",d)},value:!1},liveAutocompletionDelay:{initialValue:0},liveAutocompletionThreshold:{initialValue:0},enableSnippets:{set:function(e){e?(this.commands.addCommand(E),this.on("changeMode",C),C(0,this)):(this.commands.removeCommand(E),this.off("changeMode",C))},value:!1}})}),ace.define("ace/ext/inline_autocomplete",["require","exports","module","ace/keyboard/hash_handler","ace/autocomplete/inline","ace/autocomplete","ace/autocomplete","ace/editor","ace/autocomplete/util","ace/lib/dom","ace/lib/lang","ace/ext/command_bar","ace/ext/command_bar","ace/ext/language_tools","ace/ext/language_tools","ace/ext/language_tools","ace/config"],function(f,L,F){"use strict";var k=f("../keyboard/hash_handler").HashHandler,_=f("../autocomplete/inline").AceInline,M=f("../autocomplete").FilteredList,w=f("../autocomplete").CompletionProvider,v=f("../editor").Editor,y=f("../autocomplete/util"),$=f("../lib/dom"),S=f("../lib/lang"),R=f("./command_bar").CommandBarTooltip,P=f("./command_bar").BUTTON_CLASS_NAME,E=f("./language_tools").snippetCompleter,C=f("./language_tools").textCompleter,O=f("./language_tools").keyWordCompleter,h=function(a,o){o.completer&&o.completer.destroy()},d=function(){function a(o){this.editor=o,this.keyboardHandler=new k(this.commands),this.$index=-1,this.blurListener=this.blurListener.bind(this),this.changeListener=this.changeListener.bind(this),this.changeTimer=S.delayedCall(function(){this.updateCompletions()}.bind(this))}return a.prototype.getInlineRenderer=function(){return this.inlineRenderer||(this.inlineRenderer=new _),this.inlineRenderer},a.prototype.getInlineTooltip=function(){return this.inlineTooltip||(this.inlineTooltip=a.createInlineTooltip(document.body||document.documentElement)),this.inlineTooltip},a.prototype.show=function(o){this.activated=!0,this.editor.completer!==this&&(this.editor.completer&&this.editor.completer.detach(),this.editor.completer=this),this.editor.on("changeSelection",this.changeListener),this.editor.on("blur",this.blurListener),this.updateCompletions(o)},a.prototype.$open=function(){this.editor.textInput.setAriaOptions&&this.editor.textInput.setAriaOptions({}),this.editor.keyBinding.addKeyboardHandler(this.keyboardHandler),this.getInlineTooltip().attach(this.editor),-1===this.$index?this.setIndex(0):this.$showCompletion(),this.changeTimer.cancel()},a.prototype.insertMatch=function(){var o=this.getCompletionProvider().insertByIndex(this.editor,this.$index);return this.detach(),o},a.prototype.changeListener=function(o){var t=this.editor.selection.lead;(t.row!=this.base.row||t.column<this.base.column)&&this.detach(),this.activated?this.changeTimer.schedule():this.detach()},a.prototype.blurListener=function(o){this.detach()},a.prototype.goTo=function(o){if(this.completions&&this.completions.filtered){var t=this.completions.filtered.length;switch(o.toLowerCase()){case"prev":this.setIndex((this.$index-1+t)%t);break;case"next":this.setIndex((this.$index+1+t)%t);break;case"first":this.setIndex(0);break;case"last":this.setIndex(this.completions.filtered.length-1)}}},a.prototype.getLength=function(){return this.completions&&this.completions.filtered?this.completions.filtered.length:0},a.prototype.getData=function(o){return null==o||null===o?this.completions.filtered[this.$index]:this.completions.filtered[o]},a.prototype.getIndex=function(){return this.$index},a.prototype.isOpen=function(){return this.$index>=0},a.prototype.setIndex=function(o){if(this.completions&&this.completions.filtered){var t=Math.max(-1,Math.min(this.completions.filtered.length-1,o));t!==this.$index&&(this.$index=t,this.$showCompletion())}},a.prototype.getCompletionProvider=function(o){return this.completionProvider||(this.completionProvider=new w(o)),this.completionProvider},a.prototype.$showCompletion=function(){this.getInlineRenderer().show(this.editor,this.completions.filtered[this.$index],this.completions.filterText)||this.getInlineRenderer().hide(),this.inlineTooltip&&this.inlineTooltip.isShown()&&this.inlineTooltip.update()},a.prototype.$updatePrefix=function(){var o=this.editor.getCursorPosition(),t=this.editor.session.getTextRange({start:this.base,end:o});return this.completions.setFilter(t),this.completions.filtered.length&&(1!=this.completions.filtered.length||this.completions.filtered[0].value!=t||this.completions.filtered[0].snippet)?(this.$open(this.editor,t),t):this.detach()},a.prototype.updateCompletions=function(i){var n="";if(i&&i.matches){var e=this.editor.getSelectionRange().start;return this.base=this.editor.session.doc.createAnchor(e.row,e.column),this.base.$insertRight=!0,this.completions=new M(i.matches),this.$open(this.editor,"")}this.base&&this.completions&&(n=this.$updatePrefix());var t=this.editor.getSession();e=this.editor.getCursorPosition(),n=y.getCompletionPrefix(this.editor),this.base=t.doc.createAnchor(e.row,e.column-n.length),this.base.$insertRight=!0,i={exactMatch:!0,ignoreCaption:!0},this.getCompletionProvider({prefix:n,base:this.base,pos:e}).provideCompletions(this.editor,i,function(r,l,s){var u=l.filtered,p=y.getCompletionPrefix(this.editor);if(s){if(!u.length)return this.detach();if(1==u.length&&u[0].value==p&&!u[0].snippet)return this.detach()}this.completions=l,this.$open(this.editor,p)}.bind(this))},a.prototype.detach=function(){this.editor&&(this.editor.keyBinding.removeKeyboardHandler(this.keyboardHandler),this.editor.off("changeSelection",this.changeListener),this.editor.off("blur",this.blurListener)),this.changeTimer.cancel(),this.inlineTooltip&&this.inlineTooltip.detach(),this.setIndex(-1),this.completionProvider&&this.completionProvider.detach(),this.inlineRenderer&&this.inlineRenderer.isOpen()&&this.inlineRenderer.hide(),this.base&&this.base.detach(),this.activated=!1,this.completionProvider=this.completions=this.base=null},a.prototype.destroy=function(){this.detach(),this.inlineRenderer&&this.inlineRenderer.destroy(),this.inlineTooltip&&this.inlineTooltip.destroy(),this.editor&&this.editor.completer==this&&(this.editor.off("destroy",h),this.editor.completer=null),this.inlineTooltip=this.editor=this.inlineRenderer=null},a}();d.prototype.commands={Previous:{bindKey:"Alt-[",name:"Previous",exec:function(a){a.completer.goTo("prev")}},Next:{bindKey:"Alt-]",name:"Next",exec:function(a){a.completer.goTo("next")}},Accept:{bindKey:{win:"Tab|Ctrl-Right",mac:"Tab|Cmd-Right"},name:"Accept",exec:function(a){return a.completer.insertMatch()}},Close:{bindKey:"Esc",name:"Close",exec:function(a){a.completer.detach()}}},d.for=function(a){return a.completer instanceof d||(a.completer&&(a.completer.destroy(),a.completer=null),a.completer=new d(a),a.once("destroy",h)),a.completer},d.startCommand={name:"startInlineAutocomplete",exec:function(a,o){d.for(a).show(o)},bindKey:{win:"Alt-C",mac:"Option-C"}};var c=[E,C,O];f("../config").defineOptions(v.prototype,"editor",{enableInlineAutocompletion:{set:function(a){a?(this.completers||(this.completers=Array.isArray(a)?a:c),this.commands.addCommand(d.startCommand)):this.commands.removeCommand(d.startCommand)},value:!1}}),d.createInlineTooltip=function(a){var o=new R(a);return o.registerCommand("Previous",Object.assign({},d.prototype.commands.Previous,{enabled:!0,type:"button",iconCssClass:"ace_arrow_rotated"})),o.registerCommand("Position",{enabled:!1,getValue:function(t){return t?[t.completer.getIndex()+1,t.completer.getLength()].join("/"):""},type:"text",cssClass:"completion_position"}),o.registerCommand("Next",Object.assign({},d.prototype.commands.Next,{enabled:!0,type:"button",iconCssClass:"ace_arrow"})),o.registerCommand("Accept",Object.assign({},d.prototype.commands.Accept,{enabled:function(t){return!!t&&t.completer.getIndex()>=0},type:"button"})),o.registerCommand("ShowTooltip",{name:"Always Show Tooltip",exec:function(){o.setAlwaysShow(!o.getAlwaysShow())},enabled:!0,getValue:function(){return o.getAlwaysShow()},type:"checkbox"}),o},$.importCssString('\n\n.ace_icon_svg.ace_arrow,\n.ace_icon_svg.ace_arrow_rotated {\n    -webkit-mask-image: url("data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMTYiIGhlaWdodD0iMTYiIHZpZXdCb3g9IjAgMCAxNiAxNiIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj48cGF0aCBmaWxsLXJ1bGU9ImV2ZW5vZGQiIGNsaXAtcnVsZT0iZXZlbm9kZCIgZD0iTTUuODM3MDEgMTVMNC41ODc1MSAxMy43MTU1TDEwLjE0NjggOEw0LjU4NzUxIDIuMjg0NDZMNS44MzcwMSAxTDEyLjY0NjUgOEw1LjgzNzAxIDE1WiIgZmlsbD0iYmxhY2siLz48L3N2Zz4=");\n}\n\n.ace_icon_svg.ace_arrow_rotated {\n    transform: rotate(180deg);\n}\n\ndiv.'.concat(P,".completion_position {\n    padding: 0;\n}\n"),"inlineautocomplete.css",!1),L.InlineAutocomplete=d}),ace.require(["ace/ext/inline_autocomplete"],function(f){"object"==typeof module&&"object"==typeof exports&&module&&(module.exports=f)});