/*!-----------------------------------------------------------
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Version: 0.33.0(c722ca6c7eed3d7987c0d5c3df5c45f6b15e77d1)
 * Released under the MIT license
 * https://github.com/microsoft/vscode/blob/main/LICENSE.txt
 *-----------------------------------------------------------*/

define("vs/editor/editor.main.nls.es", {
	"vs/base/browser/ui/actionbar/actionViewItems": [
		"{0} ({1})",
	],
	"vs/base/browser/ui/findinput/findInput": [
		"entrada",
	],
	"vs/base/browser/ui/findinput/findInputCheckboxes": [
		"Coincidir mayúsculas y minúsculas",
		"Solo palabras completas",
		"Usar expresión regular",
	],
	"vs/base/browser/ui/findinput/replaceInput": [
		"entrada",
		"Conservar may/min",
	],
	"vs/base/browser/ui/iconLabel/iconLabelHover": [
		"Cargando...",
	],
	"vs/base/browser/ui/inputbox/inputBox": [
		"Error: {0}",
		"Advertencia: {0}",
		"Información: {0}",
		"para el historial",
	],
	"vs/base/browser/ui/keybindingLabel/keybindingLabel": [
		"Sin enlazar",
	],
	"vs/base/browser/ui/tree/abstractTree": [
		"Borrar",
		"Desactivar filtro en tipo",
		"Activar filtro en el tipo",
		"No se encontraron elementos",
		"{0} de {1} elementos coincidentes",
	],
	"vs/base/common/actions": [
		"(vacío)",
	],
	"vs/base/common/errorMessage": [
		"{0}: {1}",
		"Error del sistema ({0})",
		"Se ha producido un error desconocido. Consulte el registro para obtener más detalles.",
		"Se ha producido un error desconocido. Consulte el registro para obtener más detalles.",
		"{0} ({1} errores en total)",
		"Se ha producido un error desconocido. Consulte el registro para obtener más detalles.",
	],
	"vs/base/common/keybindingLabels": [
		"Ctrl",
		"Mayús",
		"Alt",
		"Windows",
		"Ctrl",
		"Mayús",
		"Alt",
		"Super",
		"Control",
		"Mayús",
		"Opción",
		"Comando",
		"Control",
		"Mayús",
		"Alt",
		"Windows",
		"Control",
		"Mayús",
		"Alt",
		"Super",
	],
	"vs/base/parts/quickinput/browser/quickInput": [
		"Atrás",
		"Presione \"Entrar\" para confirmar su entrada o \"Esc\" para cancelar",
		"{0}/{1}",
		"Escriba para restringir los resultados.",
		"{0} resultados",
		"{0} seleccionados",
		"Aceptar",
		"Personalizado",
		"Atrás ({0})",
		"Atrás",
	],
	"vs/base/parts/quickinput/browser/quickInputList": [
		"Entrada rápida",
	],
	"vs/editor/browser/controller/textAreaHandler": [
		"editor",
		"El editor no es accesible en este momento. Pulse {0} para ver las opciones.",
	],
	"vs/editor/browser/coreCommands": [
		"Anclar al final incluso cuando se vayan a líneas más largas",
		"Anclar al final incluso cuando se vayan a líneas más largas",
		"Cursores secundarios quitados",
	],
	"vs/editor/browser/editorExtensions": [
		"&&Deshacer",
		"Deshacer",
		"&&Rehacer",
		"Rehacer",
		"&&Seleccionar todo",
		"Seleccionar todo",
	],
	"vs/editor/browser/widget/codeEditorWidget": [
		"El número de cursores se ha limitado a {0}.",
	],
	"vs/editor/browser/widget/diffEditorWidget": [
		"Decoración de línea para las inserciones en el editor de diferencias.",
		"Decoración de línea para las eliminaciones en el editor de diferencias.",
		"Los archivos no se pueden comparar porque uno de ellos es demasiado grande.",
	],
	"vs/editor/browser/widget/diffReview": [
		"Icono para \"Insertar\" en la revisión de diferencias.",
		"Icono para \"Quitar\" en la revisión de diferencias.",
		"Icono para \"Cerrar\" en la revisión de diferencias.",
		"Cerrar",
		"no se han cambiado líneas",
		"1 línea cambiada",
		"{0} líneas cambiadas",
		"Diferencia {0} de {1}: línea original {2}, {3}, línea modificada {4}, {5}",
		"vacío",
		"{0} línea sin cambios {1}",
		"{0} línea original {1} línea modificada {2}",
		"+ {0} línea modificada {1}",
		"- {0} línea original {1}",
		"Ir a la siguiente diferencia",
		"Ir a la diferencia anterior",
	],
	"vs/editor/browser/widget/inlineDiffMargin": [
		"Copiar líneas eliminadas",
		"Copiar línea eliminada",
		"Copiar líneas cambiadas",
		"Copiar línea cambiada",
		"Copiar la línea eliminada ({0})",
		"Copiar línea cambiada ({0})",
		"Revertir este cambio",
		"Copiar la línea eliminada ({0})",
		"Copiar línea cambiada ({0})",
	],
	"vs/editor/common/config/editorConfigurationSchema": [
		"Editor",
		"El número de espacios a los que equivale una tabulación. Este valor se invalida en función del contenido del archivo cuando \"#editor.detectIndentation#\" está activado.",
		"Insertar espacios al presionar \"TAB\". Este valor se invalida en función del contenido del archivo cuando \"#editor.detectIndentation#\" está activado. ",
		"Controla si \"#editor.tabSize#\" y \"#editor.insertSpaces#\" se detectarán automáticamente al abrir un archivo en función del contenido de este.",
		"Quitar el espacio en blanco final autoinsertado.",
		"Manejo especial para archivos grandes para desactivar ciertas funciones de memoria intensiva.",
		"Habilita sugerencias basadas en palabras.",
		"Sugerir palabras solo del documento activo.",
		"Sugerir palabras de todos los documentos abiertos del mismo idioma.",
		"Sugerir palabras de todos los documentos abiertos.",
		"Controla de qué documentos se calculan las finalizaciones basadas en palabras.",
		"El resaltado semántico está habilitado para todos los temas de color.",
		"El resaltado semántico está deshabilitado para todos los temas de color.",
		"El resaltado semántico está configurado con el valor \"semanticHighlighting\" del tema de color actual.",
		"Controla si se muestra semanticHighlighting para los idiomas que lo admiten.",
		"Mantiene abiertos los editores interactivos, incluso al hacer doble clic en su contenido o presionar \"Escape\".",
		"Las lineas por encima de esta longitud no se tokenizarán por razones de rendimiento.",
		"Define los corchetes que aumentan o reducen la sangría.",
		"Secuencia de cadena o corchete de apertura.",
		"Secuencia de cadena o corchete de cierre.",
		"Define los pares de corchetes coloreados por su nivel de anidamiento si está habilitada la coloración de par de corchetes.",
		"Secuencia de cadena o corchete de apertura.",
		"Secuencia de cadena o corchete de cierre.",
		"Tiempo de espera en milisegundos después del cual se cancela el cálculo de diferencias. Utilice 0 para no usar tiempo de espera.",
		"Tamaño máximo de archivo en MB para el que calcular diferencias. Use 0 para no limitar.",
		"Controla si el editor de diferencias muestra las diferencias en paralelo o alineadas.",
		"Cuando está habilitado, el editor de diferencias omite los cambios en los espacios en blanco iniciales o finales.",
		"Controla si el editor de diferencias muestra los indicadores +/- para los cambios agregados o quitados.",
		"Controla si el editor muestra CodeLens.",
		"Las líneas no se ajustarán nunca.",
		"Las líneas se ajustarán en el ancho de la ventanilla.",
		"Las líneas se ajustarán en función de la configuración de \"#editor.wordWrap#\".",
	],
	"vs/editor/common/config/editorOptions": [
		"El editor usará API de plataforma para detectar cuándo está conectado un lector de pantalla.",
		"El editor se optimizará de forma permanente para su uso con un lector de pantalla. El ajuste de líneas se deshabilitará.",
		"El editor nunca se optimizará para su uso con un lector de pantalla.",
		"Controla si el editor se debe ejecutar en un modo optimizado para lectores de pantalla. Si se activa, se deshabilitará el ajuste de líneas.",
		"Controla si se inserta un carácter de espacio al comentar.",
		"Controla si las líneas vacías deben ignorarse con la opción de alternar, agregar o quitar acciones para los comentarios de línea.",
		"Controla si al copiar sin selección se copia la línea actual.",
		"Controla si el cursor debe saltar para buscar coincidencias mientras se escribe.",
		"Nunca inicializar la cadena de búsqueda desde la selección del editor.",
		"Siempre inicializar la cadena de búsqueda desde la selección del editor, incluida la palabra en la posición del cursor.",
		"Solo inicializar la cadena de búsqueda desde la selección del editor.",
		"Controla si la cadena de búsqueda del widget de búsqueda se inicializa desde la selección del editor.",
		"No activar nunca Buscar en selección automáticamente (predeterminado).",
		"Activar siempre Buscar en selección automáticamente.",
		"Activar Buscar en la selección automáticamente cuando se seleccionen varias líneas de contenido.",
		"Controla la condición para activar la búsqueda en la selección de forma automática.",
		"Controla si el widget de búsqueda debe leer o modificar el Portapapeles de búsqueda compartido en macOS.",
		"Controla si Encontrar widget debe agregar más líneas en la parte superior del editor. Si es true, puede desplazarse más allá de la primera línea cuando Encontrar widget está visible.",
		"Controla si la búsqueda se reinicia automáticamente desde el principio (o el final) cuando no se encuentran más coincidencias.",
		"Habilita o deshabilita las ligaduras tipográficas (características de fuente \"calt\" y \"liga\"). Cámbielo a una cadena para el control específico de la propiedad de CSS \"font-feature-settings\".",
		"Propiedad de CSS \"font-feature-settings\" explícita. En su lugar, puede pasarse un valor booleano si solo es necesario activar o desactivar las ligaduras.",
		"Configura las ligaduras tipográficas o las características de fuente. Puede ser un valor booleano para habilitar o deshabilitar las ligaduras o bien una cadena para el valor de la propiedad \"font-feature-settings\" de CSS.",
		"Controla el tamaño de fuente en píxeles.",
		"Solo se permiten las palabras clave \"normal\" y \"negrita\" o los números entre 1 y 1000.",
		"Controla el grosor de la fuente. Acepta las palabras clave \"normal\" y \"negrita\" o los números entre 1 y 1000.",
		"Mostrar vista de inspección de los resultados (predeterminado)",
		"Ir al resultado principal y mostrar una vista de inspección",
		"Vaya al resultado principal y habilite la navegación sin peek para otros",
		"Esta configuración está en desuso. Use configuraciones separadas como \"editor.editor.gotoLocation.multipleDefinitions\" o \"editor.editor.gotoLocation.multipleImplementations\" en su lugar.",
		"Controla el comportamiento del comando \"Ir a definición\" cuando existen varias ubicaciones de destino.",
		"Controla el comportamiento del comando \"Ir a definición de tipo\" cuando existen varias ubicaciones de destino.",
		"Controla el comportamiento del comando \"Ir a declaración\" cuando existen varias ubicaciones de destino.",
		"Controla el comportamiento del comando \"Ir a implementaciones\" cuando existen varias ubicaciones de destino.",
		"Controla el comportamiento del comando \"Ir a referencias\" cuando existen varias ubicaciones de destino.",
		"Identificador de comando alternativo que se ejecuta cuando el resultado de \"Ir a definición\" es la ubicación actual.",
		"Id. de comando alternativo que se está ejecutando cuando el resultado de \"Ir a definición de tipo\" es la ubicación actual.",
		"Id. de comando alternativo que se está ejecutando cuando el resultado de \"Ir a declaración\" es la ubicación actual.",
		"Id. de comando alternativo que se está ejecutando cuando el resultado de \"Ir a implementación\" es la ubicación actual.",
		"Identificador de comando alternativo que se ejecuta cuando el resultado de \"Ir a referencia\" es la ubicación actual.",
		"Controla si se muestra la información al mantener el puntero sobre un elemento.",
		"Controla el retardo en milisegundos después del cual se muestra la información al mantener el puntero sobre un elemento.",
		"Controla si la información que aparece al mantener el puntero sobre un elemento permanece visible al mover el mouse sobre este.",
		"Preferir mostrar los desplazamientos por encima de la línea, si hay espacio.",
		"Habilita la bombilla de acción de código en el editor.",
		"Habilita las sugerencias de incrustación en el editor.",
		"Controla el tamaño de fuente de las sugerencias de incrustación en el editor. Se usa un valor predeterminado del 90 % de \"#editor.fontSize#\" cuando el valor configurado es menor que \"5\" o mayor que el tamaño de fuente del editor.",
		"Controla la familia de fuentes de sugerencias de incrustación en el editor. Cuando se establece en vacío, se usa \"#editor.fontFamily#\".",
		"Controla el alto de línea. \r\n - Use 0 para calcular automáticamente el alto de línea a partir del tamaño de la fuente.\r\n - Los valores entre 0 y 8 se usarán como multiplicador con el tamaño de fuente.\r\n - Los valores mayores o igual que 8 se usarán como valores efectivos.",
		"Controla si se muestra el minimapa.",
		"El minimapa tiene el mismo tamaño que el contenido del editor (y podría desplazarse).",
		"El minimapa se estirará o reducirá según sea necesario para ocupar la altura del editor (sin desplazamiento).",
		"El minimapa se reducirá según sea necesario para no ser nunca más grande que el editor (sin desplazamiento).",
		"Controla el tamaño del minimapa.",
		"Controla en qué lado se muestra el minimapa.",
		"Controla cuándo se muestra el control deslizante del minimapa.",
		"Escala del contenido dibujado en el minimapa: 1, 2 o 3.",
		"Represente los caracteres reales en una línea, por oposición a los bloques de color.",
		"Limite el ancho del minimapa para representar como mucho un número de columnas determinado.",
		"Controla la cantidad de espacio entre el borde superior del editor y la primera línea.",
		"Controla el espacio entre el borde inferior del editor y la última línea.",
		"Habilita un elemento emergente que muestra documentación de los parámetros e información de los tipos mientras escribe.",
		"Controla si el menú de sugerencias de parámetros se cicla o se cierra al llegar al final de la lista.",
		"Habilita sugerencias rápidas en las cadenas.",
		"Habilita sugerencias rápidas en los comentarios.",
		"Habilita sugerencias rápidas fuera de las cadenas y los comentarios.",
		"Controla si deben mostrarse sugerencias automáticamente mientras se escribe.",
		"Los números de línea no se muestran.",
		"Los números de línea se muestran como un número absoluto.",
		"Los números de línea se muestran como distancia en líneas a la posición del cursor.",
		"Los números de línea se muestran cada 10 líneas.",
		"Controla la visualización de los números de línea.",
		"Número de caracteres monoespaciales en los que se representará esta regla del editor.",
		"Color de esta regla del editor.",
		"Muestra reglas verticales después de un cierto número de caracteres monoespaciados. Usa múltiples valores para mostrar múltiples reglas. Si la matriz está vacía, no se muestran reglas.",
		"La barra de desplazamiento vertical estará visible solo cuando sea necesario.",
		"La barra de desplazamiento vertical estará siempre visible.",
		"La barra de desplazamiento vertical estará siempre oculta.",
		"Controla la visibilidad de la barra de desplazamiento vertical.",
		"La barra de desplazamiento horizontal estará visible solo cuando sea necesario.",
		"La barra de desplazamiento horizontal estará siempre visible.",
		"La barra de desplazamiento horizontal estará siempre oculta.",
		"Controla la visibilidad de la barra de desplazamiento horizontal.",
		"Ancho de la barra de desplazamiento vertical.",
		"Altura de la barra de desplazamiento horizontal.",
		"Controla si al hacer clic se desplaza por página o salta a la posición donde se hace clic.",
		"Controla si se resaltan todos los caracteres ASCII no básicos. Solo los caracteres entre U+0020 y U+007E, tabulación, avance de línea y retorno de carro se consideran ASCII básicos.",
		"Controla si se resaltan los caracteres que solo reservan espacio o que no tienen ancho.",
		"Controla si se resaltan caracteres que se pueden confundir con caracteres ASCII básicos, excepto los que son comunes en la configuración regional del usuario actual.",
		"Controla si los caracteres de los comentarios también deben estar sujetos al resaltado Unicode.",
		"Controla si los caracteres de las cadenas también deben estar sujetos al resaltado Unicode.",
		"Define los caracteres permitidos que no se resaltan.",
		"Los caracteres Unicode que son comunes en las configuraciones regionales permitidas no se resaltan.",
		"Controla si se deben mostrar automáticamente las sugerencias alineadas en el editor.",
		"Controla si está habilitada o no la coloración de pares de corchetes. Use \"Workbench. colorCustomizations\" para invalidar los colores de resaltado de corchete.",
		"Habilita guías de par de corchetes.",
		"Habilita guías de par de corchetes solo para el par de corchetes activo.",
		"Deshabilita las guías de par de corchetes.",
		"Controla si están habilitadas las guías de pares de corchetes.",
		"Habilita guías horizontales como adición a guías de par de corchetes verticales.",
		"Habilita guías horizontales solo para el par de corchetes activo.",
		"Deshabilita las guías de par de corchetes horizontales.",
		"Controla si están habilitadas las guías de pares de corchetes horizontales.",
		"Controla si el editor debe resaltar el par de corchetes activo.",
		"Controla si el editor debe representar guías de sangría.",
		"Controla si el editor debe resaltar la guía de sangría activa.",
		"Inserte la sugerencia sin sobrescribir el texto a la derecha del cursor.",
		"Inserte la sugerencia y sobrescriba el texto a la derecha del cursor.",
		"Controla si las palabras se sobrescriben al aceptar la finalización. Tenga en cuenta que esto depende de las extensiones que participan en esta característica.",
		"Controla si el filtrado y la ordenación de sugerencias se tienen en cuenta para los errores ortográficos pequeños.",
		"Controla si la ordenación mejora las palabras que aparecen cerca del cursor.",
		"Controla si las selecciones de sugerencias recordadas se comparten entre múltiples áreas de trabajo y ventanas (necesita \"#editor.suggestSelection#\").",
		"Controla si un fragmento de código activo impide sugerencias rápidas.",
		"Controla si mostrar u ocultar iconos en sugerencias.",
		"Controla la visibilidad de la barra de estado en la parte inferior del widget de sugerencias.",
		"Controla si se puede obtener una vista previa del resultado de la sugerencia en el editor.",
		"Controla si los detalles de sugerencia se muestran incorporados con la etiqueta o solo en el widget de detalles.",
		"La configuración está en desuso. Ahora puede cambiarse el tamaño del widget de sugerencias.",
		"Esta configuración está en desuso. Use configuraciones separadas como \"editor.suggest.showKeyword\" o \"editor.suggest.showSnippets\" en su lugar.",
		"Cuando está habilitado, IntelliSense muestra sugerencias de tipo \"method\".",
		"Cuando está habilitado, IntelliSense muestra sugerencias de \"función\".",
		"Cuando está habilitado, IntelliSense muestra sugerencias de tipo \"constructor\".",
		"Cuando se activa IntelliSense muestra sugerencias \"obsoletas\".",
		"Cuando está habilitado, IntelliSense muestra sugerencias de tipo \"field\".",
		"Cuando está habilitado, IntelliSense muestra sugerencias de tipo \"variable\".",
		"Cuando está habilitado, IntelliSense muestra sugerencias de tipo \"class\".",
		"Cuando está habilitado, IntelliSense muestra sugerencias de tipo \"struct\".",
		"Cuando está habilitado, IntelliSense muestra sugerencias de tipo \"interface\".",
		"Cuando está habilitado, IntelliSense muestra sugerencias de tipo \"module\".",
		"Cuando está habilitado, IntelliSense muestra sugerencias de tipo \"property\".",
		"Cuando está habilitado, IntelliSense muestra sugerencias de tipo \"event\".",
		"Cuando está habilitado, IntelliSense muestra sugerencias de tipo \"operator\".",
		"Cuando está habilitado, IntelliSense muestra sugerencias de tipo \"unit\".",
		"Cuando está habilitado, IntelliSense muestra sugerencias de \"value\".",
		"Cuando está habilitado, IntelliSense muestra sugerencias de tipo \"constant\".",
		"Cuando está habilitado, IntelliSense muestra sugerencias de tipo \"enum\".",
		"Cuando está habilitado, IntelliSense muestra sugerencias de tipo \"enumMember\".",
		"Cuando está habilitado, IntelliSense muestra sugerencias de tipo \"keyword\".",
		"Si está habilitado, IntelliSense muestra sugerencias de tipo \"text\".",
		"Cuando está habilitado, IntelliSense muestra sugerencias de \"color\".",
		"Cuando está habilitado, IntelliSense muestra sugerencias de tipo \"file\".",
		"Cuando está habilitado, IntelliSense muestra sugerencias de tipo \"reference\".",
		"Cuando está habilitado, IntelliSense muestra sugerencias de tipo \"customcolor\".",
		"Si está habilitado, IntelliSense muestra sugerencias de tipo \"folder\".",
		"Cuando está habilitado, IntelliSense muestra sugerencias de tipo \"typeParameter\".",
		"Cuando está habilitado, IntelliSense muestra sugerencias de tipo \"snippet\".",
		"Cuando está habilitado, IntelliSense muestra sugerencias del usuario.",
		"Cuando está habilitado IntelliSense muestra sugerencias para problemas.",
		"Indica si los espacios en blanco iniciales y finales deben seleccionarse siempre.",
		"Controla si se deben aceptar sugerencias en los caracteres de confirmación. Por ejemplo, en Javascript, el punto y coma (\";\") puede ser un carácter de confirmación que acepta una sugerencia y escribe ese carácter.",
		"Aceptar solo una sugerencia con \"Entrar\" cuando realiza un cambio textual.",
		"Controla si las sugerencias deben aceptarse con \"Entrar\", además de \"TAB\". Ayuda a evitar la ambigüedad entre insertar nuevas líneas o aceptar sugerencias.",
		"Controla el número de líneas del editor que pueden ser leídas por un lector de pantalla a la vez. Cuando detectamos un lector de pantalla, fijamos automáticamente el valor por defecto en 500. Advertencia: esto tiene una implicación de rendimiento para números mayores que el predeterminado.",
		"Contenido del editor",
		"Utilizar las configuraciones del lenguaje para determinar cuándo cerrar los corchetes automáticamente.",
		"Cerrar automáticamente los corchetes cuando el cursor esté a la izquierda de un espacio en blanco.",
		"Controla si el editor debe cerrar automáticamente los corchetes después de que el usuario agregue un corchete de apertura.",
		"Quite los corchetes o las comillas de cierre adyacentes solo si se insertaron automáticamente.",
		"Controla si el editor debe quitar los corchetes o las comillas de cierre adyacentes al eliminar.",
		"Escriba en las comillas o los corchetes solo si se insertaron automáticamente.",
		"Controla si el editor debe escribir entre comillas o corchetes.",
		"Utilizar las configuraciones del lenguaje para determinar cuándo cerrar las comillas automáticamente. ",
		"Cerrar automáticamente las comillas cuando el cursor esté a la izquierda de un espacio en blanco. ",
		"Controla si el editor debe cerrar automáticamente las comillas después de que el usuario agrega uma comilla de apertura.",
		"El editor no insertará la sangría automáticamente.",
		"El editor mantendrá la sangría de la línea actual.",
		"El editor respetará la sangría de la línea actual y los corchetes definidos por el idioma.",
		"El editor mantendrá la sangría de la línea actual, respetará los corchetes definidos por el idioma e invocará onEnterRules especiales definidos por idiomas.",
		"El editor respetará la sangría de la línea actual, los corchetes definidos por idiomas y las reglas indentationRules definidas por idiomas, además de invocar reglas onEnterRules especiales.",
		"Controla si el editor debe ajustar automáticamente la sangría mientras los usuarios escriben, pegan, mueven o sangran líneas.",
		"Use las configuraciones de idioma para determinar cuándo delimitar las selecciones automáticamente.",
		"Envolver con comillas, pero no con corchetes.",
		"Envolver con corchetes, pero no con comillas.",
		"Controla si el editor debe rodear automáticamente las selecciones al escribir comillas o corchetes.",
		"Emula el comportamiento de selección de los caracteres de tabulación al usar espacios para la sangría. La selección se aplicará a las tabulaciones.",
		"Controla si el editor muestra CodeLens.",
		"Controla la familia de fuentes para CodeLens.",
		"Controla el tamaño de fuente de CodeLens en píxeles. Cuando se establece en \"0\", se usa el 90 % de \"#editor.fontSize#\".",
		"Controla si el editor debe representar el Selector de colores y los elementos Decorator de color en línea.",
		"Habilite que la selección con el mouse y las teclas esté realizando la selección de columnas.",
		"Controla si el resaltado de sintaxis debe ser copiado al portapapeles.",
		"Controla el estilo de animación del cursor.",
		"Controla si la animación suave del cursor debe estar habilitada.",
		"Controla el estilo del cursor.",
		"Controla el número mínimo de líneas iniciales y finales visibles que rodean al cursor. En algunos otros editores, se conoce como \"scrollOff\" o \"scrollOffset\".",
		"Solo se aplica \"cursorSurroundingLines\" cuando se desencadena mediante el teclado o la API.",
		"\"cursorSurroundingLines\" se aplica siempre.",
		"Controla cuando se debe aplicar \"cursorSurroundingLines\".",
		"Controla el ancho del cursor cuando \"#editor.cursorStyle#\" se establece en \"line\".",
		"Controla si el editor debe permitir mover las selecciones mediante arrastrar y colocar.",
		"Multiplicador de la velocidad de desplazamiento al presionar \"Alt\".",
		"Controla si el editor tiene el plegado de código habilitado.",
		"Utilice una estrategia de plegado específica del idioma, si está disponible, de lo contrario la basada en sangría.",
		"Utilice la estrategia de plegado basada en sangría.",
		"Controla la estrategia para calcular rangos de plegado.",
		"Controla si el editor debe destacar los rangos plegados.",
		"Permite controlar si el editor contrae automáticamente los rangos de importación.",
		"Número máximo de regiones plegables. Si aumenta este valor, es posible que el editor tenga menos capacidad de respuesta cuando el origen actual tiene un gran número de regiones plegables.",
		"Controla si al hacer clic en el contenido vacío después de una línea plegada se desplegará la línea.",
		"Controla la familia de fuentes.",
		"Controla si el editor debe dar formato automáticamente al contenido pegado. Debe haber disponible un formateador capaz de aplicar formato a un rango dentro de un documento. ",
		"Controla si el editor debe dar formato a la línea automáticamente después de escribirla.",
		"Controla si el editor debe representar el margen de glifo vertical. El margen de glifo se usa, principalmente, para depuración.",
		"Controla si el cursor debe ocultarse en la regla de información general.",
		"Controla el espacio entre letras en píxeles.",
		"Controla si el editor tiene habilitada la edición vinculada. Dependiendo del lenguaje, los símbolos relacionados (por ejemplo, las etiquetas HTML) se actualizan durante la edición.",
		"Controla si el editor debe detectar vínculos y hacerlos interactivos.",
		"Resaltar paréntesis coincidentes.",
		"Se usará un multiplicador en los eventos de desplazamiento de la rueda del mouse \"deltaX\" y \"deltaY\". ",
		"Ampliar la fuente del editor cuando se use la rueda del mouse mientras se presiona \"Ctrl\".",
		"Combinar varios cursores cuando se solapan.",
		"Se asigna a \"Control\" en Windows y Linux y a \"Comando\" en macOS.",
		"Se asigna a \"Alt\" en Windows y Linux y a \"Opción\" en macOS.",
		"El modificador que se usará para agregar varios cursores con el mouse. Los gestos del mouse Ir a definición y Abrir vínculo se adaptarán de modo que no entren en conflicto con el modificador multicursor. [Más información](https://code.visualstudio.com/docs/editor/codebasics#_multicursor-modifier).",
		"Cada cursor pega una única línea del texto.",
		"Cada cursor pega el texto completo.",
		"Controla el pegado cuando el recuento de líneas del texto pegado coincide con el recuento de cursores.",
		"Controla si el editor debe resaltar las apariciones de símbolos semánticos.",
		"Controla si debe dibujarse un borde alrededor de la regla de información general.",
		"Enfocar el árbol al abrir la inspección",
		"Enfocar el editor al abrir la inspección",
		"Controla si se debe enfocar el editor en línea o el árbol en el widget de vista.",
		"Controla si el gesto del mouse Ir a definición siempre abre el widget interactivo.",
		"Controla el retraso, en milisegundos, tras el cual aparecerán sugerencias rápidas.",
		"Controla si el editor cambia el nombre automáticamente en el tipo.",
		"En desuso. Utilice \"editor.linkedEditing\" en su lugar.",
		"Controla si el editor debe representar caracteres de control.",
		"Representar el número de la última línea cuando el archivo termina con un salto de línea.",
		"Resalta el medianil y la línea actual.",
		"Controla cómo debe representar el editor el resaltado de línea actual.",
		"Controla si el editor debe representar el resaltado de la línea actual solo cuando el editor está enfocado.",
		"Representa caracteres de espacio en blanco, excepto los espacios individuales entre palabras.",
		"Represente los caracteres de espacio en blanco solo en el texto seleccionado.",
		"Representa solo los caracteres de espacio en blanco al final.",
		"Controla la forma en que el editor debe representar los caracteres de espacio en blanco.",
		"Controla si las selecciones deberían tener las esquinas redondeadas.",
		"Controla el número de caracteres adicionales a partir del cual el editor se desplazará horizontalmente.",
		"Controla si el editor seguirá haciendo scroll después de la última línea.",
		"Desplácese solo a lo largo del eje predominante cuando se desplace vertical y horizontalmente al mismo tiempo. Evita la deriva horizontal cuando se desplaza verticalmente en un trackpad.",
		"Controla si el portapapeles principal de Linux debe admitirse.",
		"Controla si el editor debe destacar las coincidencias similares a la selección.",
		"Mostrar siempre los controles de plegado.",
		"Mostrar solo los controles de plegado cuando el mouse está sobre el medianil.",
		"Controla cuándo se muestran los controles de plegado en el medianil.",
		"Controla el fundido de salida del código no usado.",
		"Controla las variables en desuso tachadas.",
		"Mostrar sugerencias de fragmentos de código por encima de otras sugerencias.",
		"Mostrar sugerencias de fragmentos de código por debajo de otras sugerencias.",
		"Mostrar sugerencias de fragmentos de código con otras sugerencias.",
		"No mostrar sugerencias de fragmentos de código.",
		"Controla si se muestran los fragmentos de código con otras sugerencias y cómo se ordenan.",
		"Controla si el editor se desplazará con una animación.",
		"Tamaño de la fuente para el widget de sugerencias. Cuando se establece a `0`, se utilizará el valor `#editor.fontSize#`.",
		"Altura de la línea del widget de sugerencias. Cuando se establece en \"0\", se usa el valor \"#editor.lineHeight#\". El valor mínimo es 8.",
		"Controla si deben aparecer sugerencias de forma automática al escribir caracteres desencadenadores.",
		"Seleccionar siempre la primera sugerencia.",
		"Seleccione sugerencias recientes a menos que al escribir más se seleccione una, por ejemplo, \"console.| -> console.log\" porque \"log\" se ha completado recientemente.",
		"Seleccione sugerencias basadas en prefijos anteriores que han completado esas sugerencias, por ejemplo, \"co -> console\" y \"con -> const\".",
		"Controla cómo se preseleccionan las sugerencias cuando se muestra la lista,",
		"La pestaña se completará insertando la mejor sugerencia de coincidencia encontrada al presionar la pestaña",
		"Deshabilitar los complementos para pestañas.",
		"La pestaña se completa con fragmentos de código cuando su prefijo coincide. Funciona mejor cuando las \'quickSuggestions\' no están habilitadas.",
		"Habilita completar pestañas.",
		"Los terminadores de línea no habituales se quitan automáticamente.",
		"Los terminadores de línea no habituales se omiten.",
		"Advertencia de terminadores de línea inusuales que se quitarán.",
		"Quite los terminadores de línea inusuales que podrían provocar problemas.",
		"La inserción y eliminación del espacio en blanco sigue a las tabulaciones.",
		"Caracteres que se usarán como separadores de palabras al realizar operaciones o navegaciones relacionadas con palabras.",
		"Las líneas no se ajustarán nunca.",
		"Las líneas se ajustarán en el ancho de la ventanilla.",
		"Las líneas se ajustarán al valor de \"#editor.wordWrapColumn#\". ",
		"Las líneas se ajustarán al valor que sea inferior: el tamaño de la ventanilla o el valor de \"#editor.wordWrapColumn#\".",
		"Controla cómo deben ajustarse las líneas.",
		"Controla la columna de ajuste del editor cuando \"#editor.wordWrap#\" es \"wordWrapColumn\" o \"bounded\".",
		"No hay sangría. Las líneas ajustadas comienzan en la columna 1.",
		"A las líneas ajustadas se les aplica la misma sangría que al elemento primario.",
		"A las líneas ajustadas se les aplica una sangría de +1 respecto al elemento primario.",
		"A las líneas ajustadas se les aplica una sangría de +2 respecto al elemento primario.",
		"Controla la sangría de las líneas ajustadas.",
		"Se supone que todos los caracteres son del mismo ancho. Este es un algoritmo rápido que funciona correctamente para fuentes monoespaciales y ciertos scripts (como caracteres latinos) donde los glifos tienen el mismo ancho.",
		"Delega el cálculo de puntos de ajuste en el explorador. Es un algoritmo lento, que podría causar bloqueos para archivos grandes, pero funciona correctamente en todos los casos.",
		"Controla el algoritmo que calcula los puntos de ajuste.",
	],
	"vs/editor/common/core/editorColorRegistry": [
		"Color de fondo para la línea resaltada en la posición del cursor.",
		"Color de fondo del borde alrededor de la línea en la posición del cursor.",
		"Color de fondo de rangos resaltados, como en abrir rápido y encontrar características. El color no debe ser opaco para no ocultar decoraciones subyacentes.",
		"Color de fondo del borde alrededor de los intervalos resaltados.",
		"Color de fondo del símbolo destacado, como Ir a definición o Ir al siguiente/anterior símbolo. El color no debe ser opaco para no ocultar la decoración subyacente.",
		"Color de fondo del borde alrededor de los símbolos resaltados.",
		"Color del cursor del editor.",
		"Color de fondo del cursor de edición. Permite personalizar el color del caracter solapado por el bloque del cursor.",
		"Color de los caracteres de espacio en blanco del editor.",
		"Color de las guías de sangría del editor.",
		"Color de las guías de sangría activas del editor.",
		"Color de números de línea del editor.",
		"Color del número de línea activa en el editor",
		"ID es obsoleto. Usar en lugar \'editorLineNumber.activeForeground\'. ",
		"Color del número de línea activa en el editor",
		"Color de las reglas del editor",
		"Color principal de lentes de código en el editor",
		"Color de fondo tras corchetes coincidentes",
		"Color de bloques con corchetes coincidentes",
		"Color del borde de la regla de visión general.",
		"Color de fondo de la regla de información general del editor. Solo se usa cuando el minimapa está habilitado y está ubicado en el lado derecho del editor.",
		"Color de fondo del margen del editor. Este espacio contiene los márgenes de glifos y los números de línea.",
		"Color del borde de código fuente innecesario (sin usar) en el editor.",
		"Opacidad de código fuente innecesario (sin usar) en el editor. Por ejemplo, \"#000000c0\" representará el código con un 75 % de opacidad. Para temas de alto contraste, utilice el color del tema \'editorUnnecessaryCode.border\' para resaltar el código innecesario en vez de atenuarlo.",
		"Color del borde del texto fantasma en el editor.",
		"Color de primer plano del texto fantasma en el editor.",
		"Color de fondo del texto fantasma en el editor.",
		"Color de marcador de regla general para los destacados de rango. El color no debe ser opaco para no ocultar las decoraciones subyacentes.",
		"Color de marcador de regla de información general para errores. ",
		"Color de marcador de regla de información general para advertencias.",
		"Color de marcador de regla de información general para mensajes informativos. ",
		"Color de primer plano de los corchetes (1). Requiere que se habilite la coloración del par de corchetes.",
		"Color de primer plano de los corchetes (2). Requiere que se habilite la coloración del par de corchetes.",
		"Color de primer plano de los corchetes (3). Requiere que se habilite la coloración del par de corchetes.",
		"Color de primer plano de los corchetes (4). Requiere que se habilite la coloración del par de corchetes.",
		"Color de primer plano de los corchetes (5). Requiere que se habilite la coloración del par de corchetes.",
		"Color de primer plano de los corchetes (6). Requiere que se habilite la coloración del par de corchetes.",
		"Color de primer plano de corchetes inesperados.",
		"Color de fondo de las guías de par de corchetes inactivos (1). Requiere habilitar guías de par de corchetes.",
		"Color de fondo de las guías de par de corchetes inactivos (2). Requiere habilitar guías de par de corchetes.",
		"Color de fondo de las guías de par de corchetes inactivos (3). Requiere habilitar guías de par de corchetes.",
		"Color de fondo de las guías de par de corchetes inactivos (4). Requiere habilitar guías de par de corchetes.",
		"Color de fondo de las guías de par de corchetes inactivos (5). Requiere habilitar guías de par de corchetes.",
		"Color de fondo de las guías de par de corchetes inactivos (6). Requiere habilitar guías de par de corchetes.",
		"Color de fondo de las guías de pares de corchetes activos (1). Requiere habilitar guías de par de corchetes.",
		"Color de fondo de las guías de par de corchetes activos (2). Requiere habilitar guías de par de corchetes.",
		"Color de fondo de las guías de pares de corchetes activos (3). Requiere habilitar guías de par de corchetes.",
		"Color de fondo de las guías de par de corchetes activos (4). Requiere habilitar guías de par de corchetes.",
		"Color de fondo de las guías de par de corchetes activos (5). Requiere habilitar guías de par de corchetes.",
		"Color de fondo de las guías de par de corchetes activos (6). Requiere habilitar guías de par de corchetes.",
		"Color de borde usado para resaltar caracteres Unicode.",
	],
	"vs/editor/common/editorContextKeys": [
		"Si el texto del editor tiene el foco (el cursor parpadea)",
		"Si el editor o un widget del editor tiene el foco (por ejemplo, el foco está en el widget de búsqueda)",
		"Si un editor o una entrada de texto enriquecido tienen el foco (el cursor parpadea)",
		"Si el editor es de solo lectura",
		"Si el contexto es un editor de diferencias",
		"Si \"editor.columnSelection\" se ha habilitado",
		"Si el editor tiene texto seleccionado",
		"Si el editor tiene varias selecciones",
		"Si \"Tabulación\" moverá el foco fuera del editor",
		"Si el mantenimiento del puntero del editor es visible",
		"Si el editor forma parte de otro más grande (por ejemplo, blocs de notas)",
		"Identificador de idioma del editor",
		"Si el editor tiene un proveedor de elementos de finalización",
		"Si el editor tiene un proveedor de acciones de código",
		"Si el editor tiene un proveedor de CodeLens",
		"Si el editor tiene un proveedor de definiciones",
		"Si el editor tiene un proveedor de declaraciones",
		"Si el editor tiene un proveedor de implementación",
		"Si el editor tiene un proveedor de definiciones de tipo",
		"Si el editor tiene un proveedor de contenido con mantenimiento del puntero",
		"Si el editor tiene un proveedor de resaltado de documentos",
		"Si el editor tiene un proveedor de símbolos de documentos",
		"Si el editor tiene un proveedor de referencia",
		"Si el editor tiene un proveedor de cambio de nombre",
		"Si el editor tiene un proveedor de ayuda de signatura",
		"Si el editor tiene un proveedor de sugerencias insertadas",
		"Si el editor tiene un proveedor de formatos de documento",
		"Si el editor tiene un proveedor de formatos de selección de documentos",
		"Si el editor tiene varios proveedores de formatos del documento",
		"Si el editor tiene varios proveedores de formato de la selección de documentos",
	],
	"vs/editor/common/languages/modesRegistry": [
		"Texto sin formato",
	],
	"vs/editor/common/model/editStack": [
		"Escribiendo",
	],
	"vs/editor/common/standaloneStrings": [
		"Sin selección",
		"Línea {0}, columna {1} ({2} seleccionadas)",
		"Línea {0}, columna {1}",
		"{0} selecciones ({1} caracteres seleccionados)",
		"{0} selecciones",
		"Se cambiará ahora el valor \"accessibilitySupport\" a \"activado\".",
		"Se abrirá ahora la página de documentación de accesibilidad del editor.",
		"en un panel de solo lectura de un editor de diferencias.",
		"en un panel de un editor de diferencias.",
		"en un editor de código de solo lectura",
		" en un editor de código",
		"Para configurar el editor de forma que se optimice su uso con un lector de pantalla, presione ahora Comando+E.",
		"Para configurar el editor de forma que se optimice su uso con un lector de pantalla, presione ahora Control+E.",
		"El editor está configurado para optimizarse para su uso con un lector de pantalla.",
		"El editor está configurado para que no se optimice nunca su uso con un lector de pantalla, que en este momento no es el caso.",
		"Al presionar TAB en el editor actual, el foco se mueve al siguiente elemento activable. Presione {0} para activar o desactivar este comportamiento.",
		"Al presionar TAB en el editor actual, el foco se mueve al siguiente elemento activable. El comando {0} no se puede desencadenar actualmente mediante un enlace de teclado.",
		"Al presionar TAB en el editor actual, se insertará el carácter de tabulación. Presione {0} para activar o desactivar este comportamiento.",
		"Al presionar TAB en el editor actual, se insertará el carácter de tabulación. El comando {0} no se puede desencadenar actualmente mediante un enlace de teclado.",
		"Presione ahora Comando+H para abrir una ventana del explorador con más información relacionada con la accesibilidad del editor.",
		"Presione ahora Control+H para abrir una ventana del explorador con más información relacionada con la accesibilidad del editor.",
		"Para descartar esta información sobre herramientas y volver al editor, presione Esc o Mayús+Escape.",
		"Mostrar ayuda de accesibilidad",
		"Desarrollador: inspeccionar tokens",
		"Vaya a Línea/Columna...",
		"Mostrar todos los proveedores de acceso rápido",
		"Paleta de comandos",
		"Mostrar y ejecutar comandos",
		"Ir a símbolo...",
		"Ir a símbolo por categoría...",
		"Contenido del editor",
		"Presione Alt+F1 para ver las opciones de accesibilidad.",
		"Alternar tema de contraste alto",
		"{0} ediciones realizadas en {1} archivos",
	],
	"vs/editor/contrib/anchorSelect/browser/anchorSelect": [
		"Delimitador de la selección",
		"Delimitador establecido en {0}:{1}",
		"Establecer el delimitador de la selección",
		"Ir al delimitador de la selección",
		"Seleccionar desde el delimitador hasta el cursor",
		"Cancelar el delimitador de la selección",
	],
	"vs/editor/contrib/bracketMatching/browser/bracketMatching": [
		"Resumen color de marcador de regla para corchetes.",
		"Ir al corchete",
		"Seleccionar para corchete",
		"Ir al &&corchete",
	],
	"vs/editor/contrib/caretOperations/browser/caretOperations": [
		"Mover el texto seleccionado a la izquierda",
		"Mover el texto seleccionado a la derecha",
	],
	"vs/editor/contrib/caretOperations/browser/transpose": [
		"Transponer letras",
	],
	"vs/editor/contrib/clipboard/browser/clipboard": [
		"Cor&&tar",
		"Cortar",
		"Cortar",
		"Cortar",
		"&&Copiar",
		"Copiar",
		"Copiar",
		"Copiar",
		"Copiar como",
		"Copiar como",
		"&&Pegar",
		"Pegar",
		"Pegar",
		"Pegar",
		"Copiar con resaltado de sintaxis",
	],
	"vs/editor/contrib/codeAction/browser/codeActionCommands": [
		"Tipo de la acción de código que se va a ejecutar.",
		"Controla cuándo se aplican las acciones devueltas.",
		"Aplicar siempre la primera acción de código devuelto.",
		"Aplicar la primera acción de código devuelta si solo hay una.",
		"No aplique las acciones de código devuelto.",
		"Controla si solo se deben devolver las acciones de código preferidas.",
		"Se ha producido un error desconocido al aplicar la acción de código",
		"Corrección Rápida",
		"No hay acciones de código disponibles",
		"No hay acciones de código preferidas para \"{0}\" disponibles",
		"No hay ninguna acción de código para \"{0}\" disponible.",
		"No hay acciones de código preferidas disponibles",
		"No hay acciones de código disponibles",
		"Refactorizar...",
		"No hay refactorizaciones preferidas de \"{0}\" disponibles",
		"No hay refactorizaciones de \"{0}\" disponibles",
		"No hay ninguna refactorización favorita disponible.",
		"No hay refactorizaciones disponibles",
		"Acción de código fuente...",
		"No hay acciones de origen preferidas para \"{0}\" disponibles",
		"No hay ninguna acción de código fuente para \"{0}\" disponible.",
		"No hay ninguna acción de código fuente favorita disponible.",
		"No hay acciones de origen disponibles",
		"Organizar Importaciones",
		"No hay acciones de importación disponibles",
		"Corregir todo",
		"No está disponible la acción de corregir todo",
		"Corregir automáticamente...",
		"No hay autocorrecciones disponibles",
	],
	"vs/editor/contrib/codeAction/browser/lightBulbWidget": [
		"Mostrar acciones de código. Corrección rápida preferida disponible ({0})",
		"Mostrar acciones de código ({0})",
		"Mostrar acciones de código",
	],
	"vs/editor/contrib/codelens/browser/codelensController": [
		"Mostrar comandos de lente de código para la línea actual",
	],
	"vs/editor/contrib/colorPicker/browser/colorPickerWidget": [
		"Haga clic para alternar las opciones de color (rgb/hsl/hex)",
	],
	"vs/editor/contrib/comment/browser/comment": [
		"Alternar comentario de línea",
		"&&Alternar comentario de línea",
		"Agregar comentario de línea",
		"Quitar comentario de línea",
		"Alternar comentario de bloque",
		"Alternar &&bloque de comentario",
	],
	"vs/editor/contrib/contextmenu/browser/contextmenu": [
		"Mostrar menú contextual del editor",
	],
	"vs/editor/contrib/cursorUndo/browser/cursorUndo": [
		"Cursor Deshacer",
		"Cursor Rehacer",
	],
	"vs/editor/contrib/editorState/browser/keybindingCancellation": [
		"Indica si el editor ejecuta una operación que se puede cancelar como, por ejemplo, \"Inspeccionar referencias\"",
	],
	"vs/editor/contrib/find/browser/findController": [
		"Buscar",
		"&&Buscar",
		"Invalida la marca \"Usar expresión regular\".\r\nLa marca no se guardará para el futuro.\r\n0: No hacer nada\r\n1: True\r\n2: False",
		"Invalida la marca \"Hacer coincidir palabra completa”.\r\nLa marca no se guardará para el futuro.\r\n0: No hacer nada\r\n1: True\r\n2: False",
		"Invalida la marca \"Caso matemático\".\r\nLa marca no se guardará para el futuro.\r\n0: No hacer nada\r\n1: True\r\n2: False",
		"Invalida la marca \"Conservar mayúsculas y minúsculas.\r\nLa marca no se guardará para el futuro.\r\n0: No hacer nada\r\n1: True\r\n2: False",
		"Búsqueda con argumentos",
		"Buscar con selección",
		"Buscar siguiente",
		"Buscar anterior",
		"Buscar selección siguiente",
		"Buscar selección anterior",
		"Reemplazar",
		"&&Reemplazar",
	],
	"vs/editor/contrib/find/browser/findWidget": [
		"Icono para \"Buscar en selección\" en el widget de búsqueda del editor.",
		"Icono para indicar que el widget de búsqueda del editor está contraído.",
		"Icono para indicar que el widget de búsqueda del editor está expandido.",
		"Icono para \"Reemplazar\" en el widget de búsqueda del editor.",
		"Icono para \"Reemplazar todo\" en el widget de búsqueda del editor.",
		"Icono para \"Buscar anterior\" en el widget de búsqueda del editor.",
		"Icono para \"Buscar siguiente\" en el widget de búsqueda del editor.",
		"Buscar",
		"Buscar",
		"Coincidencia anterior",
		"Coincidencia siguiente",
		"Buscar en selección",
		"Cerrar",
		"Reemplazar",
		"Reemplazar",
		"Reemplazar",
		"Reemplazar todo",
		"Alternar reemplazar",
		"Sólo los primeros {0} resultados son resaltados, pero todas las operaciones de búsqueda trabajan en todo el texto.",
		"{0} de {1}",
		"No hay resultados",
		"Encontrados: {0}",
		"{0} encontrado para \"{1}\"",
		"{0} encontrado para \"{1}\", en {2}",
		"{0} encontrado para \"{1}\"",
		"Ctrl+Entrar ahora inserta un salto de línea en lugar de reemplazar todo. Puede modificar el enlace de claves para editor.action.replaceAll para invalidar este comportamiento.",
	],
	"vs/editor/contrib/folding/browser/folding": [
		"El número de regiones que se pueden plegar está limitado a un máximo de {0}. Aumente la opción de configuración [\'Plegamiento de regiones máximas\'](command:workbench.action.openSettings?[\" editor.foldingMaximumRegions\"]) para habilitar más.",
		"Desplegar",
		"Desplegar de forma recursiva",
		"Plegar",
		"Alternar plegado",
		"Plegar de forma recursiva",
		"Cerrar todos los comentarios de bloque",
		"Plegar todas las regiones",
		"Desplegar Todas las Regiones",
		"Plegar todas las regiones excepto las seleccionadas",
		"Desplegar todas las regiones excepto las seleccionadas",
		"Plegar todo",
		"Desplegar todo",
		"Ir al plegado primario",
		"Ir al rango de plegado anterior",
		"Ir al rango de plegado siguiente",
		"Nivel de plegamiento {0}",
		"Color de fondo detrás de los rangos plegados. El color no debe ser opaco para no ocultar las decoraciones subyacentes.",
		"Color del control plegable en el medianil del editor.",
	],
	"vs/editor/contrib/folding/browser/foldingDecorations": [
		"Icono de rangos expandidos en el margen de glifo del editor.",
		"Icono de rangos contraídos en el margen de glifo del editor.",
	],
	"vs/editor/contrib/fontZoom/browser/fontZoom": [
		"Acercarse a la tipografía del editor",
		"Alejarse de la tipografía del editor",
		"Restablecer alejamiento de la tipografía del editor",
	],
	"vs/editor/contrib/format/browser/format": [
		"1 edición de formato en la línea {0}",
		"{0} ediciones de formato en la línea {1}",
		"1 edición de formato entre las líneas {0} y {1}",
		"{0} ediciones de formato entre las líneas {1} y {2}",
	],
	"vs/editor/contrib/format/browser/formatActions": [
		"Dar formato al documento",
		"Dar formato a la selección",
	],
	"vs/editor/contrib/gotoError/browser/gotoError": [
		"Ir al siguiente problema (Error, Advertencia, Información)",
		"Icono para ir al marcador siguiente.",
		"Ir al problema anterior (Error, Advertencia, Información)",
		"Icono para ir al marcador anterior.",
		"Ir al siguiente problema en Archivos (Error, Advertencia, Información)",
		"Siguiente &&problema",
		"Ir al problema anterior en Archivos (Error, Advertencia, Información)",
		"Anterior &&problema",
	],
	"vs/editor/contrib/gotoError/browser/gotoErrorWidget": [
		"Error",
		"Advertencia",
		"Información",
		"Sugerencia",
		"{0} en {1}. ",
		"{0} de {1} problemas",
		"{0} de {1} problema",
		"Color de los errores del widget de navegación de marcadores del editor.",
		"Fondo del encabezado del error del widget de navegación del marcador de editor.",
		"Color de las advertencias del widget de navegación de marcadores del editor.",
		"Fondo del encabezado de la advertencia del widget de navegación del marcador de editor.",
		"Color del widget informativo marcador de navegación en el editor.",
		"Fondo del encabezado de información del widget de navegación del marcador de editor.",
		"Fondo del widget de navegación de marcadores del editor.",
	],
	"vs/editor/contrib/gotoSymbol/browser/goToCommands": [
		"Ver",
		"Definiciones",
		"No se encontró ninguna definición para \"{0}\"",
		"No se encontró ninguna definición",
		"Ir a definición",
		"Abrir definición en el lateral",
		"Ver la definición sin salir",
		"Declaraciones",
		"No se encontró ninguna definición para \'{0}\'",
		"No se encontró ninguna declaración",
		"Ir a Definición",
		"No se encontró ninguna definición para \'{0}\'",
		"No se encontró ninguna declaración",
		"Inspeccionar Definición",
		"Definiciones de tipo",
		"No se encontró ninguna definición de tipo para \"{0}\"",
		"No se encontró ninguna definición de tipo",
		"Ir a la definición de tipo",
		"Inspeccionar definición de tipo",
		"Implementaciones",
		"No se encontró ninguna implementación para \"{0}\"",
		"No se encontró ninguna implementación",
		"Ir a Implementaciones",
		"Inspeccionar implementaciones",
		"No se ha encontrado ninguna referencia para \"{0}\".",
		"No se encontraron referencias",
		"Ir a Referencias",
		"Referencias",
		"Inspeccionar Referencias",
		"Referencias",
		"Ir a cualquier símbolo",
		"Ubicaciones",
		"No hay resultados para \"{0}\"",
		"Referencias",
		"Ir a &&definición",
		"Ir a &&declaración",
		"Ir a la definición de &&tipo",
		"Ir a &&implementaciones",
		"Ir a &&referencias",
	],
	"vs/editor/contrib/gotoSymbol/browser/link/goToDefinitionAtPosition": [
		"Haga clic para mostrar {0} definiciones.",
	],
	"vs/editor/contrib/gotoSymbol/browser/peek/referencesController": [
		"Indica si está visible la inspección de referencias, como \"Inspección de referencias\" o \"Ver la definición sin salir\".",
		"Cargando...",
		"{0} ({1})",
	],
	"vs/editor/contrib/gotoSymbol/browser/peek/referencesTree": [
		"{0} referencias",
		"{0} referencia",
		"Referencias",
	],
	"vs/editor/contrib/gotoSymbol/browser/peek/referencesWidget": [
		"vista previa no disponible",
		"No hay resultados",
		"Referencias",
	],
	"vs/editor/contrib/gotoSymbol/browser/referencesModel": [
		"símbolo en {0} linea {1} en la columna {2}",
		"símbolo en {0} línea {1} en la columna {2}, {3}",
		"1 símbolo en {0}, ruta de acceso completa {1}",
		"{0} símbolos en {1}, ruta de acceso completa {2}",
		"No se encontraron resultados",
		"Encontró 1 símbolo en {0}",
		"Encontró {0} símbolos en {1}",
		"Encontró {0} símbolos en {1} archivos",
	],
	"vs/editor/contrib/gotoSymbol/browser/symbolNavigation": [
		"Indica si hay ubicaciones de símbolos a las que se pueda navegar solo con el teclado.",
		"Símbolo {0} de {1}, {2} para el siguiente",
		"Símbolo {0} de {1}",
	],
	"vs/editor/contrib/hover/browser/hover": [
		"Mostrar al mantener el puntero",
		"Mostrar vista previa de la definición que aparece al mover el puntero",
	],
	"vs/editor/contrib/hover/browser/markdownHoverParticipant": [
		"Cargando...",
		"Por motivos de rendimiento, la tokenización se omite con filas largas. Esta opción se puede configurar con \"editor.maxTokenizationLineLength\".",
	],
	"vs/editor/contrib/hover/browser/markerHoverParticipant": [
		"Ver el problema",
		"No hay correcciones rápidas disponibles",
		"Buscando correcciones rápidas...",
		"No hay correcciones rápidas disponibles",
		"Corrección Rápida",
	],
	"vs/editor/contrib/inPlaceReplace/browser/inPlaceReplace": [
		"Reemplazar con el valor anterior",
		"Reemplazar con el valor siguiente",
	],
	"vs/editor/contrib/indentation/browser/indentation": [
		"Convertir sangría en espacios",
		"Convertir sangría en tabulaciones",
		"Tamaño de tabulación configurado",
		"Seleccionar tamaño de tabulación para el archivo actual",
		"Aplicar sangría con tabulaciones",
		"Aplicar sangría con espacios",
		"Detectar sangría del contenido",
		"Volver a aplicar sangría a líneas",
		"Volver a aplicar sangría a líneas seleccionadas",
	],
	"vs/editor/contrib/inlayHints/browser/inlayHintsHover": [
		"cmd + clic",
		"ctrl + clic",
		"opción + clic",
		"alt + clic",
		"Ir a Definición ({0}), haga clic con el botón derecho para obtener más información",
		"Ir a Definición ({0})",
		"Ejecutar comando",
	],
	"vs/editor/contrib/inlineCompletions/browser/ghostTextController": [
		"Si una sugerencia alineada está visible",
		"Si la sugerencia alineada comienza con un espacio en blanco",
		"Si la sugerencia insertada comienza con un espacio en blanco menor que lo que se insertaría mediante tabulación",
		"Mostrar sugerencia alineada siguiente",
		"Mostrar sugerencia alineada anterior",
		"Desencadenar sugerencia alineada",
	],
	"vs/editor/contrib/inlineCompletions/browser/inlineCompletionsHoverParticipant": [
		"Siguiente",
		"Anterior",
		"Aceptar",
		"Sugerencia:",
	],
	"vs/editor/contrib/lineSelection/browser/lineSelection": [
		"Expandir selección de línea",
	],
	"vs/editor/contrib/linesOperations/browser/linesOperations": [
		"Copiar línea arriba",
		"&&Copiar línea arriba",
		"Copiar línea abajo",
		"Co&&piar línea abajo",
		"Selección duplicada",
		"&&Duplicar selección",
		"Mover línea hacia arriba",
		"Mo&&ver línea arriba",
		"Mover línea hacia abajo",
		"Mover &&línea abajo",
		"Ordenar líneas en orden ascendente",
		"Ordenar líneas en orden descendente",
		"Eliminar líneas duplicadas",
		"Recortar espacio final",
		"Eliminar línea",
		"Sangría de línea",
		"Anular sangría de línea",
		"Insertar línea arriba",
		"Insertar línea debajo",
		"Eliminar todo a la izquierda",
		"Eliminar todo lo que está a la derecha",
		"Unir líneas",
		"Transponer caracteres alrededor del cursor",
		"Transformar a mayúsculas",
		"Transformar a minúsculas",
		"Transformar en Title Case",
		"Transformar en Snake Case",
	],
	"vs/editor/contrib/linkedEditing/browser/linkedEditing": [
		"Iniciar edición vinculada",
		"Color de fondo cuando el editor cambia el nombre automáticamente al escribir.",
	],
	"vs/editor/contrib/links/browser/links": [
		"No se pudo abrir este vínculo porque no tiene un formato correcto: {0}",
		"No se pudo abrir este vínculo porque falta el destino.",
		"Ejecutar comando",
		"Seguir vínculo",
		"cmd + clic",
		"ctrl + clic",
		"opción + clic",
		"alt + clic",
		"Ejecutar el comando {0}",
		"Abrir vínculo",
	],
	"vs/editor/contrib/message/browser/messageController": [
		"Indica si el editor muestra actualmente un mensaje insertado",
		"No se puede editar en un editor de sólo lectura",
	],
	"vs/editor/contrib/multicursor/browser/multicursor": [
		"Cursor agregado: {0}",
		"Cursores agregados: {0}",
		"Agregar cursor arriba",
		"&&Agregar cursor arriba",
		"Agregar cursor debajo",
		"A&&gregar cursor abajo",
		"Añadir cursores a finales de línea",
		"Agregar c&&ursores a extremos de línea",
		"Añadir cursores a la parte inferior",
		"Añadir cursores a la parte superior",
		"Agregar selección hasta la siguiente coincidencia de búsqueda",
		"Agregar &&siguiente repetición",
		"Agregar selección hasta la anterior coincidencia de búsqueda",
		"Agregar r&&epetición anterior",
		"Mover última selección hasta la siguiente coincidencia de búsqueda",
		"Mover última selección hasta la anterior coincidencia de búsqueda",
		"Seleccionar todas las repeticiones de coincidencia de búsqueda",
		"Seleccionar todas las &&repeticiones",
		"Cambiar todas las ocurrencias",
	],
	"vs/editor/contrib/parameterHints/browser/parameterHints": [
		"Sugerencias para parámetros Trigger",
	],
	"vs/editor/contrib/parameterHints/browser/parameterHintsWidget": [
		"Icono para mostrar la sugerencia de parámetro siguiente.",
		"Icono para mostrar la sugerencia de parámetro anterior.",
		"{0}, sugerencia",
		"Color de primer plano del elemento activo en la sugerencia de parámetro.",
	],
	"vs/editor/contrib/peekView/browser/peekView": [
		"Indica si el editor de código actual está incrustado en la inspección.",
		"Cerrar",
		"Color de fondo del área de título de la vista de inspección.",
		"Color del título de la vista de inpección.",
		"Color de la información del título de la vista de inspección.",
		"Color de los bordes y la flecha de la vista de inspección.",
		"Color de fondo de la lista de resultados de vista de inspección.",
		"Color de primer plano de los nodos de inspección en la lista de resultados.",
		"Color de primer plano de los archivos de inspección en la lista de resultados.",
		"Color de fondo de la entrada seleccionada en la lista de resultados de vista de inspección.",
		"Color de primer plano de la entrada seleccionada en la lista de resultados de vista de inspección.",
		"Color de fondo del editor de vista de inspección.",
		"Color de fondo del margen en el editor de vista de inspección.",
		"Buscar coincidencia con el color de resaltado de la lista de resultados de vista de inspección.",
		"Buscar coincidencia del color de resultado del editor de vista de inspección.",
		"Hacer coincidir el borde resaltado en el editor de vista previa.",
	],
	"vs/editor/contrib/quickAccess/browser/gotoLineQuickAccess": [
		"Abra primero un editor de texto para ir a una línea.",
		"Vaya a la línea {0} y al carácter {1}.",
		"Ir a la línea {0}.",
		"Línea actual: {0}, Carácter: {1}. Escriba un número de línea entre 1 y {2} a los que navegar.",
		"Línea actual: {0}, Carácter: {1}. Escriba un número de línea al que navegar.",
	],
	"vs/editor/contrib/quickAccess/browser/gotoSymbolQuickAccess": [
		"Para ir a un símbolo, primero abra un editor de texto con información de símbolo.",
		"El editor de texto activo no proporciona información de símbolos.",
		"No hay ningún símbolo del editor coincidente.",
		"No hay símbolos del editor.",
		"Abrir en el lateral",
		"Abrir en la parte inferior",
		"símbolos ({0})",
		"propiedades ({0})",
		"métodos ({0})",
		"funciones ({0})",
		"constructores ({0})",
		"variables ({0})",
		"clases ({0})",
		"estructuras ({0})",
		"eventos ({0})",
		"operadores ({0})",
		"interfaces ({0})",
		"espacios de nombres ({0})",
		"paquetes ({0})",
		"parámetros de tipo ({0})",
		"módulos ({0})",
		"propiedades ({0})",
		"enumeraciones ({0})",
		"miembros de enumeración ({0})",
		"cadenas ({0})",
		"archivos ({0})",
		"matrices ({0})",
		"números ({0})",
		"booleanos ({0})",
		"objetos ({0})",
		"claves ({0})",
		"campos ({0})",
		"constantes ({0})",
	],
	"vs/editor/contrib/rename/browser/rename": [
		"No hay ningún resultado.",
		"Error desconocido al resolver el cambio de nombre de la ubicación",
		"Cambiando el nombre de \"{0}\"",
		"Cambiar el nombre de {0}",
		"Nombre cambiado correctamente de \'{0}\' a \'{1}\'. Resumen: {2}",
		"No se pudo cambiar el nombre a las ediciones de aplicación",
		"No se pudo cambiar el nombre de las ediciones de cálculo",
		"Cambiar el nombre del símbolo",
		"Activar/desactivar la capacidad de previsualizar los cambios antes de cambiar el nombre",
	],
	"vs/editor/contrib/rename/browser/renameInputField": [
		"Indica si el widget de cambio de nombre de entrada está visible.",
		"Cambie el nombre de la entrada. Escriba el nuevo nombre y presione Entrar para confirmar.",
		"{0} para cambiar de nombre, {1} para obtener una vista previa",
	],
	"vs/editor/contrib/smartSelect/browser/smartSelect": [
		"Expandir selección",
		"&&Expandir selección",
		"Reducir la selección",
		"&&Reducir selección",
	],
	"vs/editor/contrib/snippet/browser/snippetController2": [
		"Indica si el editor actual está en modo de fragmentos de código.",
		"Indica si hay una tabulación siguiente cuando se está en modo de fragmentos de código.",
		"Si hay una tabulación anterior cuando se está en modo de fragmentos de código.",
	],
	"vs/editor/contrib/snippet/browser/snippetVariables": [
		"Domingo",
		"Lunes",
		"Martes",
		"Miércoles",
		"Jueves",
		"Viernes",
		"Sábado",
		"Dom",
		"Lun",
		"Mar",
		"Mié",
		"Jue",
		"Vie",
		"Sáb",
		"Enero",
		"Febrero",
		"Marzo",
		"Abril",
		"May",
		"Junio",
		"Julio",
		"Agosto",
		"Septiembre",
		"Octubre",
		"Noviembre",
		"Diciembre",
		"Ene",
		"Feb",
		"Mar",
		"Abr",
		"May",
		"Jun",
		"Jul",
		"Ago",
		"Sep",
		"Oct",
		"Nov",
		"Dic",
	],
	"vs/editor/contrib/suggest/browser/suggest": [
		"Indica si los detalles de las sugerencias están visibles.",
		"Indica si hay varias sugerencias para elegir.",
		"Indica si la inserción de la sugerencia actual genera un cambio o si ya se ha escrito todo.",
		"Indica si se insertan sugerencias al presionar Entrar.",
		"Indica si la sugerencia actual tiene el comportamiento de inserción y reemplazo.",
		"Indica si el comportamiento predeterminado es insertar o reemplazar.",
		"Indica si la sugerencia actual admite la resolución de más detalles.",
	],
	"vs/editor/contrib/suggest/browser/suggestController": [
		"Aceptando \"{0}\" ediciones adicionales de {1} realizadas",
		"Sugerencias para Trigger",
		"Insertar",
		"Insertar",
		"Reemplazar",
		"Reemplazar",
		"Insertar",
		"mostrar menos",
		"mostrar más",
		"Restablecer tamaño del widget de sugerencias",
	],
	"vs/editor/contrib/suggest/browser/suggestWidget": [
		"Color de fondo del widget sugerido.",
		"Color de borde del widget sugerido.",
		"Color de primer plano del widget sugerido.",
		"Color de primer plano de le entrada seleccionada del widget de sugerencias.",
		"Color de primer plano del icono de la entrada seleccionada en el widget de sugerencias.",
		"Color de fondo de la entrada seleccionada del widget sugerido.",
		"Color del resaltado coincidido en el widget sugerido.",
		"Color de los resaltados de coincidencia en el widget de sugerencias cuando se enfoca un elemento.",
		"Color de primer plano del estado del widget sugerido.",
		"Cargando...",
		"No hay sugerencias.",
		"Sugerir",
		"{0}{1}, {2}",
		"{0}{1}",
		"{0}, {1}",
		"{0}, documentos: {1}",
	],
	"vs/editor/contrib/suggest/browser/suggestWidgetDetails": [
		"Cerrar",
		"Cargando...",
	],
	"vs/editor/contrib/suggest/browser/suggestWidgetRenderer": [
		"Icono para obtener más información en el widget de sugerencias.",
		"Leer más",
	],
	"vs/editor/contrib/suggest/browser/suggestWidgetStatus": [
		"{0} ({1})",
	],
	"vs/editor/contrib/symbolIcons/browser/symbolIcons": [
		"Color de primer plano de los símbolos de matriz. Estos símbolos aparecen en el contorno, la ruta de navegación y el widget de sugerencias.",
		"Color de primer plano de los símbolos booleanos. Estos símbolos aparecen en el contorno, la ruta de navegación y el widget de sugerencias.",
		"Color de primer plano de los símbolos de clase. Estos símbolos aparecen en el contorno, la ruta de navegación y el widget de sugerencias.",
		"Color de primer plano de los símbolos de color. Estos símbolos aparecen en el contorno, la ruta de navegación y el widget de sugerencias.",
		"Color de primer plano de los símbolos constantes. Estos símbolos aparecen en el contorno, la ruta de navegación y el widget de sugerencias.",
		"Color de primer plano de los símbolos de constructor. Estos símbolos aparecen en el contorno, la ruta de navegación y el widget de sugerencias.",
		"Color de primer plano de los símbolos de enumerador. Estos símbolos aparecen en el contorno, la ruta de navegación y el widget de sugerencias.",
		"Color de primer plano de los símbolos de miembro del enumerador. Estos símbolos aparecen en el contorno, la ruta de navegación y el widget de sugerencias.",
		"Color de primer plano de los símbolos de evento. Estos símbolos aparecen en el contorno, la ruta de navegación y el widget de sugerencias.",
		"Color de primer plano de los símbolos de campo. Estos símbolos aparecen en el contorno, la ruta de navegación y el widget de sugerencias.",
		"Color de primer plano de los símbolos de archivo. Estos símbolos aparecen en el contorno, la ruta de navegación y el widget de sugerencias.",
		"Color de primer plano de los símbolos de carpeta. Estos símbolos aparecen en el contorno, la ruta de navegación y el widget de sugerencias.",
		"Color de primer plano de los símbolos de función. Estos símbolos aparecen en el contorno, la ruta de navegación y el widget de sugerencias.",
		"Color de primer plano de los símbolos de interfaz. Estos símbolos aparecen en el contorno, la ruta de navegación y el widget de sugerencias.",
		"Color de primer plano de los símbolos de claves. Estos símbolos aparecen en el contorno, la ruta de navegación y el widget de sugerencias.",
		"Color de primer plano de los símbolos de palabra clave. Estos símbolos aparecen en el contorno, la ruta de navegación y el widget de sugerencias.",
		"Color de primer plano de los símbolos de método. Estos símbolos aparecen en el contorno, la ruta de navegación y el widget de sugerencias.",
		"Color de primer plano de los símbolos de módulo. Estos símbolos aparecen en el contorno, la ruta de navegación y el widget de sugerencias.",
		"Color de primer plano de los símbolos de espacio de nombres. Estos símbolos aparecen en el contorno, la ruta de navegación y el widget de sugerencias.",
		"Color de primer plano de los símbolos nulos. Estos símbolos aparecen en el contorno, la ruta de navegación y el widget de sugerencias.",
		"Color de primer plano para los símbolos numéricos. Estos símbolos aparecen en el contorno, la ruta de navegación y el widget de sugerencias.",
		"Color de primer plano de los símbolos de objeto. Estos símbolos aparecen en el contorno, la ruta de navegación y el widget de sugerencias.",
		"Color de primer plano para los símbolos del operador. Estos símbolos aparecen en el contorno, la ruta de navegación y el widget de sugerencias.",
		"Color de primer plano de los símbolos de paquete. Estos símbolos aparecen en el contorno, la ruta de navegación y el widget de sugerencias.",
		"Color de primer plano de los símbolos de propiedad. Estos símbolos aparecen en el contorno, la ruta de navegación y el widget de sugerencias.",
		"Color de primer plano de los símbolos de referencia. Estos símbolos aparecen en el contorno, la ruta de navegación y el widget de sugerencias.",
		"Color de primer plano de los símbolos de fragmento de código. Estos símbolos aparecen en el contorno, la ruta de navegación y el widget de sugerencias.",
		"Color de primer plano de los símbolos de cadena. Estos símbolos aparecen en el contorno, la ruta de navegación y el widget de sugerencias.",
		"Color de primer plano de los símbolos de estructura. Estos símbolos aparecen en el contorno, la ruta de navegación y el widget de sugerencias.",
		"Color de primer plano de los símbolos de texto. Estos símbolos aparecen en el contorno, la ruta de navegación y el widget de sugerencias.",
		"Color de primer plano para los símbolos de parámetro de tipo. Estos símbolos aparecen en el contorno, la ruta de navegación y el widget de sugerencias.",
		"Color de primer plano de los símbolos de unidad. Estos símbolos aparecen en el contorno, la ruta de navegación y el widget de sugerencias.",
		"Color de primer plano de los símbolos variables. Estos símbolos aparecen en el contorno, la ruta de navegación y el widget de sugerencias.",
	],
	"vs/editor/contrib/toggleTabFocusMode/browser/toggleTabFocusMode": [
		"Alternar tecla de tabulación para mover el punto de atención",
		"Presionando la pestaña ahora moverá el foco al siguiente elemento enfocable.",
		"Presionando la pestaña ahora insertará el carácter de tabulación",
	],
	"vs/editor/contrib/tokenization/browser/tokenization": [
		"Desarrollador: forzar nueva aplicación de token",
	],
	"vs/editor/contrib/unicodeHighlighter/browser/unicodeHighlighter": [
		"Icono que se muestra con un mensaje de advertencia en el editor de extensiones.",
		"Este documento contiene muchos caracteres Unicode ASCII no básicos",
		"Este documento contiene muchos caracteres Unicode ambiguos",
		"Este documento contiene muchos caracteres Unicode invisibles",
		"El carácter {0} podría confundirse con el carácter {1}, que es más común en el código fuente.",
		"El carácter {0} es invisible.",
		"El carácter {0} no es un carácter ASCII básico.",
		"Ajustar la configuración",
		"Deshabilitar resaltado en comentarios",
		"Deshabilitar resaltado de caracteres en comentarios",
		"Deshabilitar resaltado en cadenas",
		"Deshabilitar resaltado de caracteres en cadenas",
		"Deshabilitar resaltado ambiguo",
		"Deshabilitar el resaltado de caracteres ambiguos",
		"Deshabilitar resaltado invisible",
		"Deshabilitar el resaltado de caracteres invisibles",
		"Deshabilitar resaltado que no es ASCII",
		"Deshabilitar el resaltado de caracteres ASCII no básicos",
		"Mostrar opciones de exclusión",
		"Excluir {0} (carácter invisible) de que se resalte",
		"Excluir {0} de ser resaltado",
		"Permite caracteres Unicode más comunes en el idioma \"{0}\".",
		"Configurar opciones de resaltado Unicode",
	],
	"vs/editor/contrib/unusualLineTerminators/browser/unusualLineTerminators": [
		"Terminadores de línea inusuales",
		"Se han detectado terminadores de línea inusuales",
		"Este archivo \"{0}\" contiene uno o más caracteres de terminación de línea inusuales, como el separador de línea (LS) o el separador de párrafo (PS).\r\n\r\nSe recomienda eliminarlos del archivo. Esto puede configurarse mediante \"editor.unusualLineTerminators\".",
		"Quitar terminadores de línea inusuales",
		"Omitir",
	],
	"vs/editor/contrib/wordHighlighter/browser/wordHighlighter": [
		"Color de fondo de un símbolo durante el acceso de lectura, como la lectura de una variable. El color no debe ser opaco para no ocultar decoraciones subyacentes.",
		"Color de fondo de un símbolo durante el acceso de escritura, como escribir en una variable. El color no debe ser opaco para no ocultar las decoraciones subyacentes.",
		"Color de fondo de un símbolo durante el acceso de lectura; por ejemplo, cuando se lee una variable.",
		"Color de fondo de un símbolo durante el acceso de escritura; por ejemplo, cuando se escribe una variable.",
		"Color del marcador de regla general para destacados de símbolos. El color no debe ser opaco para no ocultar decoraciones subyacentes.",
		"Color de marcador de regla general para destacados de símbolos de acceso de escritura. El color no debe ser opaco para no ocultar las decoraciones subyacentes.",
		"Ir al siguiente símbolo destacado",
		"Ir al símbolo destacado anterior",
		"Desencadenar los símbolos destacados",
	],
	"vs/editor/contrib/wordOperations/browser/wordOperations": [
		"Eliminar palabra",
	],
	"vs/platform/actions/browser/menuEntryActionViewItem": [
		"{0} ({1})",
		"{0} ({1})",
	],
	"vs/platform/configuration/common/configurationRegistry": [
		"La configuración del lenguaje predeterminada se reemplaza",
		"Establece los valores de configuración que se reemplazarán para el lenguaje {0}.",
		"Establecer los valores de configuración que se reemplazarán para un lenguaje.",
		"Esta configuración no admite la configuración por idioma.",
		"Establecer los valores de configuración que se reemplazarán para un lenguaje.",
		"Esta configuración no admite la configuración por idioma.",
		"No se puede registrar una propiedad vacía.",
		"No se puede registrar \"{0}\". Coincide con el patrón de propiedad \'\\\\[.*\\\\]$\' para describir la configuración del editor específica del lenguaje. Utilice la contribución \"configurationDefaults\".",
		"No se puede registrar \"{0}\". Esta propiedad ya está registrada.",
	],
	"vs/platform/contextkey/browser/contextKeyService": [
		"Comando que devuelve información sobre las claves de contexto",
	],
	"vs/platform/contextkey/common/contextkeys": [
		"Si el sistema operativo es macOS",
		"Si el sistema operativo es Linux",
		"Si el sistema operativo es Windows",
		"Si la plataforma es un explorador web",
		"Si el sistema operativo es macOS en una plataforma que no es de explorador",
		"Si el sistema operativo es IOS",
		"Si el foco del teclado está dentro de un cuadro de entrada",
	],
	"vs/platform/history/browser/contextScopedHistoryWidget": [
		"Indica si las sugerencias están visibles.",
	],
	"vs/platform/keybinding/common/abstractKeybindingService": [
		"Se presionó ({0}). Esperando la siguiente tecla...",
		"La combinación de claves ({0}, {1}) no es un comando.",
	],
	"vs/platform/list/browser/listService": [
		"Área de trabajo",
		"Se asigna a \"Control\" en Windows y Linux y a \"Comando\" en macOS.",
		"Se asigna a \"Alt\" en Windows y Linux y a \"Opción\" en macOS.",
		"El modificador que se utilizará para agregar un elemento en los árboles y listas para una selección múltiple con el ratón (por ejemplo en el explorador, abiertos editores y vista de scm). Los gestos de ratón \'Abrir hacia\' - si están soportados - se adaptarán de forma tal que no tenga conflicto con el modificador múltiple.",
		"Controla cómo abrir elementos en los árboles y las listas mediante el mouse (si se admite). Tenga en cuenta que algunos árboles y listas pueden optar por ignorar esta configuración si no es aplicable.",
		"Controla si las listas y los árboles admiten el desplazamiento horizontal en el área de trabajo. Advertencia: La activación de esta configuración repercute en el rendimiento.",
		"Controla la sangría de árbol en píxeles.",
		"Controla si el árbol debe representar guías de sangría.",
		"Controla si las listas y los árboles tienen un desplazamiento suave.",
		"Se usará un multiplicador en los eventos de desplazamiento de la rueda del mouse \"deltaX\" y \"deltaY\". ",
		"Multiplicador de la velocidad de desplazamiento al presionar \"Alt\".",
		"La navegación simple del teclado se centra en elementos que coinciden con la entrada del teclado. El emparejamiento se hace solo en prefijos.",
		"Destacar la navegación del teclado resalta los elementos que coinciden con la entrada del teclado. Más arriba y abajo la navegación atravesará solo los elementos destacados.",
		"La navegación mediante el teclado de filtro filtrará y ocultará todos los elementos que no coincidan con la entrada del teclado.",
		"Controla el estilo de navegación del teclado para listas y árboles en el área de trabajo. Puede ser simple, resaltar y filtrar.",
		"Controla si la navegación del teclado en listas y árboles se activa automáticamente simplemente escribiendo. Si se establece en \"false\", la navegación con el teclado solo se activa al ejecutar el comando \"list.toggleKeyboardNavigation\", para el cual puede asignar un método abreviado de teclado.",
		"Controla cómo se expanden las carpetas de árbol al hacer clic en sus nombres. Tenga en cuenta que algunos árboles y listas pueden optar por omitir esta configuración si no es aplicable.",
	],
	"vs/platform/markers/common/markers": [
		"Error",
		"Advertencia",
		"Información",
	],
	"vs/platform/quickinput/browser/commandsQuickAccess": [
		"{0}, {1}",
		"usado recientemente",
		"otros comandos",
		"El comando \"{0}\" dio lugar a un error ({1})",
	],
	"vs/platform/quickinput/browser/helpQuickAccess": [
		"comandos globales",
		"comandos del editor",
		"{0}, {1}",
	],
	"vs/platform/theme/common/colorRegistry": [
		"Color de primer plano general. Este color solo se usa si un componente no lo invalida.",
		"Color de primer plano general para los mensajes de erroe. Este color solo se usa si un componente no lo invalida.",
		"Color de primer plano para el texto descriptivo que proporciona información adicional, por ejemplo para una etiqueta.",
		"El color predeterminado para los iconos en el área de trabajo.",
		"Color de borde de los elementos con foco. Este color solo se usa si un componente no lo invalida.",
		"Un borde adicional alrededor de los elementos para separarlos unos de otros y así mejorar el contraste.",
		"Un borde adicional alrededor de los elementos activos para separarlos unos de otros y así mejorar el contraste.",
		"El color de fondo del texto seleccionado en el área de trabajo (por ejemplo, campos de entrada o áreas de texto). Esto no se aplica a las selecciones dentro del editor.",
		"Color para los separadores de texto.",
		"Color de primer plano para los vínculos en el texto.",
		"Color de primer plano para los enlaces de texto, al hacer clic o pasar el mouse sobre ellos.",
		"Color de primer plano para los segmentos de texto con formato previo.",
		"Color de fondo para los bloques en texto.",
		"Color de borde para los bloques en texto.",
		"Color de fondo para los bloques de código en el texto.",
		"Color de sombra de los widgets dentro del editor, como buscar/reemplazar",
		"Fondo de cuadro de entrada.",
		"Primer plano de cuadro de entrada.",
		"Borde de cuadro de entrada.",
		"Color de borde de opciones activadas en campos de entrada.",
		"Color de fondo de las opciones activadas en los campos de entrada.",
		"Color de fondo al pasar por encima de las opciones en los campos de entrada.",
		"Color de primer plano de las opciones activadas en los campos de entrada.",
		"Color de primer plano para el marcador de posición de texto",
		"Color de fondo de validación de entrada para gravedad de información.",
		"Color de primer plano de validación de entrada para información de gravedad.",
		"Color de borde de validación de entrada para gravedad de información.",
		"Color de fondo de validación de entrada para gravedad de advertencia.",
		"Color de primer plano de validación de entrada para información de advertencia.",
		"Color de borde de validación de entrada para gravedad de advertencia.",
		"Color de fondo de validación de entrada para gravedad de error.",
		"Color de primer plano de validación de entrada para información de error.",
		"Color de borde de valdación de entrada para gravedad de error.",
		"Fondo de lista desplegable.",
		"Fondo de la lista desplegable.",
		"Primer plano de lista desplegable.",
		"Borde de lista desplegable.",
		"Color de fondo de la casilla de verificación del widget.",
		"Color de primer plano del widget de la casilla de verificación.",
		"Color del borde del widget de la casilla de verificación.",
		"Color de primer plano del botón.",
		"Color de fondo del botón.",
		"Color de fondo del botón al mantener el puntero.",
		"Color del borde del botón",
		"Color de primer plano del botón secundario.",
		"Color de fondo del botón secundario.",
		"Color de fondo del botón secundario al mantener el mouse.",
		"Color de fondo de la insignia. Las insignias son pequeñas etiquetas de información, por ejemplo los resultados de un número de resultados.",
		"Color de primer plano de la insignia. Las insignias son pequeñas etiquetas de información, por ejemplo los resultados de un número de resultados.",
		"Sombra de la barra de desplazamiento indica que la vista se ha despazado.",
		"Color de fondo de control deslizante de barra de desplazamiento.",
		"Color de fondo de barra de desplazamiento cursor cuando se pasar sobre el control.",
		"Color de fondo de la barra de desplazamiento al hacer clic.",
		"Color de fondo para la barra de progreso que se puede mostrar para las operaciones de larga duración.",
		"Color de fondo del texto de error del editor. El color no debe ser opaco para no ocultar las decoraciones subyacentes.",
		"Color de primer plano de squigglies de error en el editor.",
		"Color del borde de los cuadros de error en el editor.",
		"Color de fondo del texto de advertencia del editor. El color no debe ser opaco para no ocultar las decoraciones subyacentes.",
		"Color de primer plano de squigglies de advertencia en el editor.",
		"Color del borde de los cuadros de advertencia en el editor.",
		"Color de fondo del texto de información del editor. El color no debe ser opaco para no ocultar las decoraciones subyacentes.",
		"Color de primer plano de los subrayados ondulados informativos en el editor.",
		"Color del borde de los cuadros de información en el editor.",
		"Color de primer plano de pista squigglies en el editor.",
		"Color del borde de los cuadros de sugerencia en el editor.",
		"Color de borde de los marcos activos.",
		"Color de fondo del editor.",
		"Color de primer plano predeterminado del editor.",
		"Color de fondo del editor de widgets como buscar/reemplazar",
		"Color de primer plano de los widgets del editor, como buscar y reemplazar.",
		"Color de borde de los widgets del editor. El color solo se usa si el widget elige tener un borde y no invalida el color.",
		"Color del borde de la barra de cambio de tamaño de los widgets del editor. El color se utiliza solo si el widget elige tener un borde de cambio de tamaño y si un widget no invalida el color.",
		"Color de fondo del selector rápido. El widget del selector rápido es el contenedor para selectores como la paleta de comandos.",
		"Color de primer plano del selector rápido. El widget del selector rápido es el contenedor para selectores como la paleta de comandos.",
		"Color de fondo del título del selector rápido. El widget del selector rápido es el contenedor para selectores como la paleta de comandos.",
		"Selector de color rápido para la agrupación de etiquetas.",
		"Selector de color rápido para la agrupación de bordes.",
		"Color de fondo de etiqueta de enlace de teclado. La etiqueta enlace de teclado se usa para representar un método abreviado de teclado.",
		"Color de primer plano de etiqueta de enlace de teclado. La etiqueta enlace de teclado se usa para representar un método abreviado de teclado.",
		"Color del borde de la etiqueta de enlace de teclado. La etiqueta enlace de teclado se usa para representar un método abreviado de teclado.",
		"Color del borde inferior de la etiqueta de enlace de teclado. La etiqueta enlace de teclado se usa para representar un método abreviado de teclado.",
		"Color de la selección del editor.",
		"Color del texto seleccionado para alto contraste.",
		"Color de la selección en un editor inactivo. El color no debe ser opaco para no ocultar decoraciones subyacentes.",
		"Color en las regiones con el mismo contenido que la selección. El color no debe ser opaco para no ocultar decoraciones subyacentes.",
		"Color de borde de las regiones con el mismo contenido que la selección.",
		"Color de la coincidencia de búsqueda actual.",
		"Color de los otros resultados de la búsqueda. El color no debe ser opaco para no ocultar las decoraciones subyacentes.",
		"Color de la gama que limita la búsqueda. El color no debe ser opaco para no ocultar decoraciones subyacentes.",
		"Color de borde de la coincidencia de búsqueda actual.",
		"Color de borde de otra búsqueda que coincide.",
		"Color del borde de la gama que limita la búsqueda. El color no debe ser opaco para no ocultar las decoraciones subyacentes.",
		"Color de las consultas coincidentes del Editor de búsqueda.",
		"Color de borde de las consultas coincidentes del Editor de búsqueda.",
		"Destacar debajo de la palabra para la que se muestra un mensaje al mantener el mouse. El color no debe ser opaco para no ocultar decoraciones subyacentes.",
		"Color de fondo al mantener el puntero en el editor.",
		"Color de primer plano al mantener el puntero en el editor.",
		"Color del borde al mantener el puntero en el editor.",
		"Color de fondo de la barra de estado al mantener el puntero en el editor.",
		"Color de los vínculos activos.",
		"Color de primer plano de las sugerencias insertadas",
		"Color de fondo de las sugerencias insertadas",
		"Color de primer plano de las sugerencias insertadas para los tipos de letra",
		"Color de fondo de las sugerencias insertadas para los tipos de letra",
		"Color de primer plano de las sugerencias insertadas para los parámetros",
		"Color de fondo de las sugerencias insertadas para los parámetros",
		"El color utilizado para el icono de bombilla de acciones.",
		"El color utilizado para el icono de la bombilla de acciones de corrección automática.",
		"Color de fondo para el texto que se insertó. El color no debe ser opaco para no ocultar las decoraciones subyacentes.",
		"Color de fondo para el texto que se eliminó. El color no debe ser opaco para no ocultar decoraciones subyacentes.",
		"Color de fondo de las líneas insertadas. El color no debe ser opaco para no ocultar las decoraciones subyacentes.",
		"Color de fondo de las líneas que se quitaron. El color no debe ser opaco para no ocultar las decoraciones subyacentes.",
		"Color de fondo del margen donde se insertaron las líneas.",
		"Color de fondo del margen donde se quitaron las líneas.",
		"Primer plano de la regla de información general de diferencias para el contenido insertado.",
		"Primer plano de la regla de información general de diferencias para el contenido quitado.",
		"Color de contorno para el texto insertado.",
		"Color de contorno para el texto quitado.",
		"Color del borde entre ambos editores de texto.",
		"Color de relleno diagonal del editor de diferencias. El relleno diagonal se usa en las vistas de diferencias en paralelo.",
		"Color de fondo de la lista o el árbol del elemento con el foco cuando la lista o el árbol están activos. Una lista o un árbol tienen el foco del teclado cuando están activos, cuando están inactivos no.",
		"Color de primer plano de la lista o el árbol del elemento con el foco cuando la lista o el árbol están activos. Una lista o un árbol tienen el foco del teclado cuando están activos, cuando están inactivos no.",
		"Color de contorno de la lista o el árbol del elemento con el foco cuando la lista o el árbol están activos. Una lista o un árbol tienen el foco del teclado cuando están activos, pero no cuando están inactivos.",
		"Color de fondo de la lista o el árbol del elemento seleccionado cuando la lista o el árbol están activos. Una lista o un árbol tienen el foco del teclado cuando están activos, cuando están inactivos no.",
		"Color de primer plano de la lista o el árbol del elemento seleccionado cuando la lista o el árbol están activos. Una lista o un árbol tienen el foco del teclado cuando están activos, cuando están inactivos no.",
		"Color de primer plano del icono de lista o árbol del elemento seleccionado cuando la lista o el árbol están activos. Una lista o un árbol tienen el foco del teclado cuando están activos, cuando están inactivos no.",
		"Color de fondo de la lista o el árbol del elemento seleccionado cuando la lista o el árbol están inactivos. Una lista o un árbol tienen el foco del teclado cuando están activos, cuando están inactivos no.",
		"Color de primer plano de la lista o el árbol del elemento con el foco cuando la lista o el árbol esta inactiva. Una lista o un árbol tiene el foco del teclado cuando está activo, cuando esta inactiva no.",
		"Color de primer plano del icono de lista o árbol del elemento seleccionado cuando la lista o el árbol están inactivos. Una lista o un árbol tienen el foco del teclado cuando están activos, cuando están inactivos no.",
		"Color de fondo de la lista o el árbol del elemento con el foco cuando la lista o el árbol están inactivos. Una lista o un árbol tienen el foco del teclado cuando están activos, pero no cuando están inactivos.",
		"Color de contorno de la lista o el árbol del elemento con el foco cuando la lista o el árbol están inactivos. Una lista o un árbol tienen el foco del teclado cuando están activos, pero no cuando están inactivos.",
		"Fondo de la lista o el árbol al mantener el mouse sobre los elementos.",
		"Color de primer plano de la lista o el árbol al pasar por encima de los elementos con el ratón.",
		"Fondo de arrastrar y colocar la lista o el árbol al mover los elementos con el mouse.",
		"Color de primer plano de la lista o el árbol de las coincidencias resaltadas al buscar dentro de la lista o el ábol.",
		"Color de primer plano de la lista o árbol de los elementos coincidentes en los elementos enfocados activamente cuando se busca dentro de la lista o árbol.",
		"Color de primer plano de una lista o árbol para los elementos inválidos, por ejemplo una raiz sin resolver en el explorador.",
		"Color del primer plano de elementos de lista que contienen errores.",
		"Color del primer plano de elementos de lista que contienen advertencias.",
		"Color de fondo del widget de filtro de tipo en listas y árboles.",
		"Color de contorno del widget de filtro de tipo en listas y árboles.",
		"Color de contorno del widget de filtro de tipo en listas y árboles, cuando no hay coincidencias.",
		"Color de fondo de la coincidencia filtrada.",
		"Color de borde de la coincidencia filtrada.",
		"Color de trazo de árbol para las guías de sangría.",
		"Color de borde de la tabla entre columnas.",
		"Color de fondo para las filas de tabla impares.",
		"Color de primer plano de lista/árbol para los elementos no enfatizados.",
		"Use quickInputList.focusBackground en su lugar.",
		"Selector rápido del color de primer plano para el elemento con el foco.",
		"Color de primer plano del icono del selector rápido para el elemento con el foco.",
		"Color de fondo del selector rápido para el elemento con el foco.",
		"Color del borde de los menús.",
		"Color de primer plano de los elementos de menú.",
		"Color de fondo de los elementos de menú.",
		"Color de primer plano del menu para el elemento del menú seleccionado.",
		"Color de fondo del menu para el elemento del menú seleccionado.",
		"Color del borde del elemento seleccionado en los menús.",
		"Color del separador del menu para un elemento del menú.",
		"El fondo de la barra de herramientas se perfila al pasar por encima de las acciones con el mouse.",
		"La barra de herramientas se perfila al pasar por encima de las acciones con el mouse.",
		"Fondo de la barra de herramientas al mantener el mouse sobre las acciones",
		"Resaltado del color de fondo para una ficha de un fragmento de código.",
		"Resaltado del color del borde para una ficha de un fragmento de código.",
		"Resaltado del color de fondo para la última ficha de un fragmento de código.",
		"Resaltado del color del borde para la última tabulación de un fragmento de código.",
		"Color de los elementos de ruta de navegación que reciben el foco.",
		"Color de fondo de los elementos de ruta de navegación",
		"Color de los elementos de ruta de navegación que reciben el foco.",
		"Color de los elementos de ruta de navegación seleccionados.",
		"Color de fondo del selector de elementos de ruta de navegación.",
		"Fondo del encabezado actual en los conflictos de combinación en línea. El color no debe ser opaco para no ocultar las decoraciones subyacentes.",
		"Fondo de contenido actual en los conflictos de combinación en línea. El color no debe ser opaco para no ocultar las decoraciones subyacentes.",
		"Fondo de encabezado entrante en los conflictos de combinación en línea. El color no debe ser opaco para no ocultar las decoraciones subyacentes.",
		"Fondo de contenido entrante en los conflictos de combinación en línea. El color no debe ser opaco para no ocultar las decoraciones subyacentes.",
		"Fondo de cabecera de elemento antecesor común en conflictos de fusión en línea. El color no debe ser opaco para no ocultar decoraciones subyacentes.",
		"Fondo de contenido antecesor común en conflictos de combinación en línea. El color no debe ser opaco para no ocultar las decoraciones subyacentes.",
		"Color del borde en los encabezados y el divisor en conflictos de combinación alineados.",
		"Primer plano de la regla de visión general actual para conflictos de combinación alineados.",
		"Primer plano de regla de visión general de entrada para conflictos de combinación alineados.",
		"Primer plano de la regla de visión general de ancestros comunes para conflictos de combinación alineados.",
		"Color del marcador de regla general para buscar actualizaciones. El color no debe ser opaco para no ocultar las decoraciones subyacentes.",
		"Color del marcador de la regla general para los destacados de la selección. El color no debe ser opaco para no ocultar las decoraciones subyacentes.",
		"Color de marcador de minimapa para coincidencias de búsqueda.",
		"Color de marcador de minimapa para las selecciones del editor que se repiten.",
		"Color del marcador de minimapa para la selección del editor.",
		"Color del marcador de minimapa para errores.",
		"Color del marcador de minimapa para advertencias.",
		"Color de fondo del minimapa.",
		"Opacidad de los elementos de primer plano representados en el minimapa. Por ejemplo, \"#000000c0\" representará los elementos con 75% de opacidad.",
		"Color de fondo del deslizador del minimapa.",
		"Color de fondo del deslizador del minimapa al pasar el puntero.",
		"Color de fondo del deslizador de minimapa al hacer clic en él.",
		"Color utilizado para el icono de error de problemas.",
		"Color utilizado para el icono de advertencia de problemas.",
		"Color utilizado para el icono de información de problemas.",
		"Color de primer plano que se usa en los gráficos.",
		"Color que se usa para las líneas horizontales en los gráficos.",
		"Color rojo que se usa en las visualizaciones de gráficos.",
		"Color azul que se usa en las visualizaciones de gráficos.",
		"Color amarillo que se usa en las visualizaciones de gráficos.",
		"Color naranja que se usa en las visualizaciones de gráficos.",
		"Color verde que se usa en las visualizaciones de gráficos.",
		"Color púrpura que se usa en las visualizaciones de gráficos.",
	],
	"vs/platform/theme/common/iconRegistry": [
		"Identificador de la fuente que se va a usar. Si no se establece, se usa la fuente definida en primer lugar.",
		"Carácter de fuente asociado a la definición del icono.",
		"Icono de la acción de cierre en los widgets.",
		"Icono para ir a la ubicación del editor anterior.",
		"Icono para ir a la ubicación del editor siguiente.",
	],
	"vs/platform/undoRedo/common/undoRedoService": [
		"Se han cerrado los siguientes archivos y se han modificado en el disco: {0}.",
		"Los siguientes archivos se han modificado de forma incompatible: {0}.",
		"No se pudo deshacer \"{0}\" en todos los archivos. {1}",
		"No se pudo deshacer \"{0}\" en todos los archivos. {1}",
		"No se pudo deshacer \"{0}\" en todos los archivos porque se realizaron cambios en {1}",
		"No se pudo deshacer \"{0}\" en todos los archivos porque ya hay una operación de deshacer o rehacer en ejecución en {1}",
		"No se pudo deshacer \"{0}\" en todos los archivos porque se produjo una operación de deshacer o rehacer mientras tanto",
		"¿Desea deshacer \"{0}\" en todos los archivos?",
		"Deshacer en {0} archivos",
		"Deshacer este archivo",
		"Cancelar",
		"No se pudo deshacer \"{0}\" porque ya hay una operación de deshacer o rehacer en ejecución.",
		"¿Quiere deshacer \"{0}\"?",
		"Sí",
		"No",
		"No se pudo rehacer \"{0}\" en todos los archivos. {1}",
		"No se pudo rehacer \"{0}\" en todos los archivos. {1}",
		"No se pudo volver a hacer \"{0}\" en todos los archivos porque se realizaron cambios en {1}",
		"No se pudo rehacer \"{0}\" en todos los archivos porque ya hay una operación de deshacer o rehacer en ejecución en {1}",
		"No se pudo rehacer \"{0}\" en todos los archivos porque se produjo una operación de deshacer o rehacer mientras tanto",
		"No se pudo rehacer \"{0}\" porque ya hay una operación de deshacer o rehacer en ejecución.",
	],
	"vs/platform/workspace/common/workspace": [
		"Área de trabajo de código",
	]
});