/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.task.sql.core;

import com.chutneytesting.task.sql.core.Column;
import java.util.Objects;
import java.util.Optional;

public class Cell {
    static final Cell NONE = new Cell(Column.NONE, Optional.empty());
    public final Column column;
    public final Object value;

    public Cell(Column column, Object value) {
        this.column = column;
        this.value = value;
    }

    String print(int maxLength) {
        return this.value.toString() + " ".repeat(maxLength - this.value.toString().length());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Cell cell = (Cell)o;
        return this.column.equals(cell.column) && this.value.equals(cell.value);
    }

    public int hashCode() {
        return Objects.hash(this.column, this.value);
    }

    public String toString() {
        return "Cell{column=" + this.column.name + ", value=" + this.value + "}";
    }
}

