/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.task.radius;

import com.chutneytesting.task.radius.RadiusHelper;
import com.chutneytesting.task.spi.Task;
import com.chutneytesting.task.spi.TaskExecutionResult;
import com.chutneytesting.task.spi.injectable.Input;
import com.chutneytesting.task.spi.injectable.Logger;
import com.chutneytesting.task.spi.injectable.Target;
import com.chutneytesting.task.spi.validation.TaskValidatorsUtils;
import com.chutneytesting.task.spi.validation.Validator;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.tinyradius.packet.AccountingRequest;
import org.tinyradius.packet.RadiusPacket;
import org.tinyradius.util.RadiusClient;
import org.tinyradius.util.RadiusException;

public class RadiusAccountingTask
implements Task {
    private final Logger logger;
    private final Target target;
    private final String userName;
    private final Map<String, String> attributes;
    private final Integer accountingType;

    public RadiusAccountingTask(Logger logger, Target target, @Input(value="userName") String userName, @Input(value="attributes") Map<String, String> attributes, @Input(value="accountingType") Integer accountingType) {
        this.logger = logger;
        this.target = target;
        this.userName = userName;
        this.accountingType = accountingType;
        this.attributes = Optional.ofNullable(attributes).orElse(Collections.emptyMap());
    }

    public List<String> validateInputs() {
        return Validator.getErrorsFrom((Validator[])new Validator[]{TaskValidatorsUtils.targetValidation((Target)this.target), RadiusHelper.radiusTargetPropertiesValidation(this.target), RadiusHelper.radiusTargetPortPropertiesValidation(this.target), TaskValidatorsUtils.notBlankStringValidation((String)this.userName, (String)"userName"), this.accountingTypeValidation()});
    }

    public TaskExecutionResult execute() {
        AccountingRequest accessRequest = new AccountingRequest(this.userName, this.accountingType.intValue());
        this.attributes.forEach((arg_0, arg_1) -> ((AccountingRequest)accessRequest).addAttribute(arg_0, arg_1));
        RadiusClient client = RadiusHelper.createRadiusClient(this.target);
        try {
            RadiusPacket response = client.account(accessRequest);
            if (response == null) {
                this.logger.error("Accounting failed. Response is null");
                return TaskExecutionResult.ko();
            }
            HashMap<String, RadiusPacket> outputs = new HashMap<String, RadiusPacket>();
            outputs.put("radiusResponse", response);
            this.logger.info("Accounting request as [" + this.userName + "] response type : " + response.getPacketTypeName());
            return TaskExecutionResult.ok(outputs);
        }
        catch (IOException | RadiusException e) {
            this.logger.error(e);
            return TaskExecutionResult.ko();
        }
    }

    private Validator<Integer> accountingTypeValidation() {
        return Validator.of((Object)this.accountingType).validate(at -> at >= 1 && at <= 15, "Invalid accountingType (by default start = 1, stop = 2, interim = 3, on = 7, off = 8)");
    }
}

