/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.task.mongo;

import com.chutneytesting.task.mongo.DefaultMongoDatabaseFactory;
import com.chutneytesting.task.mongo.MongoDatabaseFactory;
import com.chutneytesting.task.mongo.MongoTaskValidatorsUtils;
import com.chutneytesting.task.spi.Task;
import com.chutneytesting.task.spi.TaskExecutionResult;
import com.chutneytesting.task.spi.injectable.Input;
import com.chutneytesting.task.spi.injectable.Logger;
import com.chutneytesting.task.spi.injectable.Target;
import com.chutneytesting.task.spi.validation.TaskValidatorsUtils;
import com.chutneytesting.task.spi.validation.Validator;
import com.chutneytesting.tools.CloseableResource;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.result.UpdateResult;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.bson.BsonDocument;
import org.bson.conversions.Bson;

public class MongoUpdateTask
implements Task {
    private final MongoDatabaseFactory mongoDatabaseFactory = new DefaultMongoDatabaseFactory();
    private final Target target;
    private final Logger logger;
    private final String collection;
    private final String filter;
    private final String update;
    private final List<String> arrayFilters;

    public MongoUpdateTask(Target target, Logger logger, @Input(value="collection") String collection, @Input(value="filter") String filter, @Input(value="update") String update, @Input(value="arrayFilters") List<String> arrayFilters) {
        this.target = target;
        this.logger = logger;
        this.collection = collection;
        this.filter = filter;
        this.update = update;
        this.arrayFilters = Optional.ofNullable(arrayFilters).orElse(Collections.emptyList());
    }

    public List<String> validateInputs() {
        return Validator.getErrorsFrom((Validator[])new Validator[]{TaskValidatorsUtils.notBlankStringValidation((String)this.collection, (String)"collection"), TaskValidatorsUtils.notBlankStringValidation((String)this.update, (String)"update"), MongoTaskValidatorsUtils.mongoTargetValidation(this.target)});
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TaskExecutionResult execute() {
        try (CloseableResource<MongoDatabase> database = this.mongoDatabaseFactory.create(this.target);){
            UpdateResult updateResult;
            TaskExecutionResult arrayFilterDocuments;
            MongoCollection collection = ((MongoDatabase)database.getResource()).getCollection(this.collection);
            if (!this.arrayFilters.isEmpty()) {
                arrayFilterDocuments = this.arrayFilters.stream().map(BsonDocument::parse).collect(Collectors.toList());
                updateResult = collection.updateMany((Bson)BsonDocument.parse((String)this.filter), (Bson)BsonDocument.parse((String)this.update), new UpdateOptions().arrayFilters((List)arrayFilterDocuments));
            } else {
                updateResult = collection.updateMany((Bson)BsonDocument.parse((String)this.filter), (Bson)BsonDocument.parse((String)this.update));
            }
            if (!updateResult.wasAcknowledged()) {
                this.logger.error("Update was not acknowledged");
                arrayFilterDocuments = TaskExecutionResult.ko();
                return arrayFilterDocuments;
            }
            long modifiedCount = updateResult.getModifiedCount();
            this.logger.info("Modified in Mongo collection '" + this.collection + "': " + modifiedCount + " documents");
            TaskExecutionResult taskExecutionResult = TaskExecutionResult.ok(Collections.singletonMap("modifiedCount", modifiedCount));
            return taskExecutionResult;
        }
        catch (IllegalArgumentException e) {
            this.logger.error(e.getMessage());
            return TaskExecutionResult.ko();
        }
    }
}

