/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.task.mongo;

import com.chutneytesting.task.mongo.DefaultMongoDatabaseFactory;
import com.chutneytesting.task.mongo.MongoDatabaseFactory;
import com.chutneytesting.task.mongo.MongoTaskValidatorsUtils;
import com.chutneytesting.task.spi.Task;
import com.chutneytesting.task.spi.TaskExecutionResult;
import com.chutneytesting.task.spi.injectable.Input;
import com.chutneytesting.task.spi.injectable.Logger;
import com.chutneytesting.task.spi.injectable.Target;
import com.chutneytesting.task.spi.validation.TaskValidatorsUtils;
import com.chutneytesting.task.spi.validation.Validator;
import com.chutneytesting.tools.CloseableResource;
import com.google.common.base.Ascii;
import com.mongodb.client.MongoDatabase;
import java.util.List;
import org.bson.Document;

public class MongoInsertTask
implements Task {
    private final MongoDatabaseFactory mongoDatabaseFactory = new DefaultMongoDatabaseFactory();
    private final Target target;
    private final Logger logger;
    private final String collection;
    private final String document;

    public MongoInsertTask(Target target, Logger logger, @Input(value="collection") String collection, @Input(value="document") String document) {
        this.target = target;
        this.logger = logger;
        this.collection = collection;
        this.document = document;
    }

    public List<String> validateInputs() {
        return Validator.getErrorsFrom((Validator[])new Validator[]{TaskValidatorsUtils.notBlankStringValidation((String)this.collection, (String)"collection"), TaskValidatorsUtils.notBlankStringValidation((String)this.document, (String)"document"), MongoTaskValidatorsUtils.mongoTargetValidation(this.target)});
    }

    public TaskExecutionResult execute() {
        TaskExecutionResult taskExecutionResult;
        block8: {
            CloseableResource<MongoDatabase> database = this.mongoDatabaseFactory.create(this.target);
            try {
                ((MongoDatabase)database.getResource()).getCollection(this.collection).insertOne((Object)Document.parse((String)this.document));
                this.logger.info("Inserted in Mongo collection '" + this.collection + "':\n\t" + Ascii.truncate((CharSequence)this.document.replace("\n", "\n\t"), (int)50, (String)"..."));
                taskExecutionResult = TaskExecutionResult.ok();
                if (database == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (database != null) {
                        try {
                            database.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IllegalArgumentException e) {
                    this.logger.error(e.getMessage());
                    return TaskExecutionResult.ko();
                }
            }
            database.close();
        }
        return taskExecutionResult;
    }
}

