/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.task.micrometer;

import com.chutneytesting.task.micrometer.MicrometerTaskHelper;
import com.chutneytesting.task.spi.Task;
import com.chutneytesting.task.spi.TaskExecutionResult;
import com.chutneytesting.task.spi.injectable.Input;
import com.chutneytesting.task.spi.injectable.Logger;
import com.chutneytesting.task.spi.validation.Validator;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class MicrometerSummaryTask
implements Task {
    protected static final String OUTPUT_SUMMARY = "micrometerSummary";
    private final Logger logger;
    private final String name;
    private final String description;
    private final String unit;
    private final List<String> tags;
    private final String bufferLength;
    private final String expiry;
    private final String maxValue;
    private final String minValue;
    private final String percentilePrecision;
    private final Boolean publishPercentilesHistogram;
    private final String percentiles;
    private final String scale;
    private final String sla;
    private DistributionSummary distributionSummary;
    private final MeterRegistry registry;
    private final String record;

    public MicrometerSummaryTask(Logger logger, @Input(value="name") String name, @Input(value="description") String description, @Input(value="unit") String unit, @Input(value="tags") List<String> tags, @Input(value="bufferLength") String bufferLength, @Input(value="expiry") String expiry, @Input(value="maxValue") String maxValue, @Input(value="minValue") String minValue, @Input(value="percentilePrecision") String percentilePrecision, @Input(value="publishPercentilesHistogram") Boolean publishPercentilesHistogram, @Input(value="percentiles") String percentiles, @Input(value="scale") String scale, @Input(value="sla") String sla, @Input(value="distributionSummary") DistributionSummary distributionSummary, @Input(value="registry") MeterRegistry registry, @Input(value="record") String record) {
        this.logger = logger;
        this.name = name;
        this.description = description;
        this.unit = unit;
        this.tags = tags;
        this.publishPercentilesHistogram = publishPercentilesHistogram;
        this.distributionSummary = distributionSummary;
        this.registry = Optional.ofNullable(registry).orElse((MeterRegistry)Metrics.globalRegistry);
        this.bufferLength = bufferLength;
        this.percentilePrecision = percentilePrecision;
        this.expiry = expiry;
        this.maxValue = maxValue;
        this.minValue = minValue;
        this.scale = scale;
        this.record = record;
        this.percentiles = percentiles;
        this.sla = sla;
    }

    public List<String> validateInputs() {
        Validator metricNameValidation = Validator.of(null).validate(a -> this.name != null || this.distributionSummary != null, "name and distributionSummary cannot be both null");
        return Validator.getErrorsFrom((Validator[])new Validator[]{metricNameValidation, MicrometerTaskHelper.integerStringValidation(this.bufferLength, "bufferLength"), MicrometerTaskHelper.integerStringValidation(this.percentilePrecision, "percentilePrecision"), MicrometerTaskHelper.doubleStringValidation(this.maxValue, "maxValue"), MicrometerTaskHelper.doubleStringValidation(this.minValue, "minValue"), MicrometerTaskHelper.doubleStringValidation(this.scale, "scale"), MicrometerTaskHelper.doubleStringValidation(this.record, "record"), MicrometerTaskHelper.durationStringValidation(this.expiry, "expiry"), MicrometerTaskHelper.percentilesListValidation(this.percentiles), MicrometerTaskHelper.slaListToDoublesValidation(this.sla)});
    }

    public TaskExecutionResult execute() {
        try {
            this.distributionSummary = Optional.ofNullable(this.distributionSummary).orElseGet(() -> this.retrieveSummary(this.registry));
            if (this.record != null) {
                this.distributionSummary.record(MicrometerTaskHelper.parseDoubleOrNull(this.record).doubleValue());
                this.logger.info("Distribution summary updated by " + this.record);
            }
            this.logger.info("Distribution summary current total is " + this.distributionSummary.totalAmount());
            this.logger.info("Distribution summary current max is " + this.distributionSummary.max());
            this.logger.info("Distribution summary current mean is " + this.distributionSummary.mean());
            this.logger.info("Distribution summary current count is " + this.distributionSummary.count());
            return TaskExecutionResult.ok(MicrometerTaskHelper.toOutputs(OUTPUT_SUMMARY, this.distributionSummary));
        }
        catch (Exception e) {
            this.logger.error((Throwable)e);
            return TaskExecutionResult.ko();
        }
    }

    private DistributionSummary retrieveSummary(MeterRegistry registry) {
        DistributionSummary.Builder builder = DistributionSummary.builder((String)Objects.requireNonNull(this.name)).description(this.description).baseUnit(this.unit).distributionStatisticBufferLength(MicrometerTaskHelper.parseIntOrNull(this.bufferLength)).distributionStatisticExpiry(MicrometerTaskHelper.parseDurationOrNull(this.expiry)).maximumExpectedValue(MicrometerTaskHelper.parseDoubleOrNull(this.maxValue)).minimumExpectedValue(MicrometerTaskHelper.parseDoubleOrNull(this.minValue)).percentilePrecision(MicrometerTaskHelper.parseIntOrNull(this.percentilePrecision)).publishPercentileHistogram(this.publishPercentilesHistogram).publishPercentiles(MicrometerTaskHelper.parseMapOrNull(this.percentiles, MicrometerTaskHelper::parsePercentilesList)).serviceLevelObjectives(MicrometerTaskHelper.parseMapOrNull(this.sla, MicrometerTaskHelper::parseSlaListToDoubles));
        Optional.ofNullable(this.scale).ifPresent(t -> builder.scale(MicrometerTaskHelper.parseDoubleOrNull(this.scale).doubleValue()));
        Optional.ofNullable(this.tags).ifPresent(t -> builder.tags(t.toArray(new String[0])));
        return builder.register(registry);
    }
}

