/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.task.micrometer;

import com.chutneytesting.task.micrometer.MicrometerTaskHelper;
import com.chutneytesting.task.spi.Task;
import com.chutneytesting.task.spi.TaskExecutionResult;
import com.chutneytesting.task.spi.injectable.Input;
import com.chutneytesting.task.spi.injectable.Logger;
import com.chutneytesting.task.spi.validation.Validator;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class MicrometerCounterTask
implements Task {
    protected static final String OUTPUT_COUNTER = "micrometerCounter";
    private final Logger logger;
    private final String name;
    private final String description;
    private final String unit;
    private final List<String> tags;
    private Counter counter;
    private final MeterRegistry registry;
    private final String increment;

    public MicrometerCounterTask(Logger logger, @Input(value="name") String name, @Input(value="description") String description, @Input(value="unit") String unit, @Input(value="tags") List<String> tags, @Input(value="counter") Counter counter, @Input(value="registry") MeterRegistry registry, @Input(value="increment") String increment) {
        this.logger = logger;
        this.name = name;
        this.description = description;
        this.unit = unit;
        this.tags = tags;
        this.increment = increment;
        this.counter = counter;
        this.registry = Optional.ofNullable(registry).orElse((MeterRegistry)Metrics.globalRegistry);
    }

    public List<String> validateInputs() {
        Validator metricNameValidation = Validator.of(null).validate(a -> this.name != null || this.counter != null, "name and counter cannot be both null");
        return Validator.getErrorsFrom((Validator[])new Validator[]{metricNameValidation, MicrometerTaskHelper.doubleStringValidation(this.increment, "increment")});
    }

    public TaskExecutionResult execute() {
        try {
            this.counter = Optional.ofNullable(this.counter).orElseGet(() -> this.retrieveCounter(this.registry));
            if (this.increment != null) {
                this.counter.increment(MicrometerTaskHelper.parseDoubleOrNull(this.increment).doubleValue());
                this.logger.info("Counter incremented by " + this.increment);
            }
            this.logger.info("Counter current count is " + this.counter.count());
            return TaskExecutionResult.ok(MicrometerTaskHelper.toOutputs(OUTPUT_COUNTER, this.counter));
        }
        catch (Exception e) {
            this.logger.error((Throwable)e);
            return TaskExecutionResult.ko();
        }
    }

    private Counter retrieveCounter(MeterRegistry registry) {
        Counter.Builder builder = Counter.builder((String)Objects.requireNonNull(this.name)).description(this.description).baseUnit(this.unit);
        Optional.ofNullable(this.tags).ifPresent(t -> builder.tags(t.toArray(new String[0])));
        return builder.register(registry);
    }
}

