/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.task.kafka;

import com.chutneytesting.task.spi.Task;
import com.chutneytesting.task.spi.TaskExecutionResult;
import com.chutneytesting.task.spi.injectable.Input;
import com.chutneytesting.task.spi.injectable.Logger;
import com.chutneytesting.task.spi.validation.Validator;
import java.util.List;
import java.util.Objects;
import org.springframework.kafka.test.EmbeddedKafkaBroker;

public class KafkaBrokerStopTask
implements Task {
    private final Logger logger;
    private final EmbeddedKafkaBroker broker;

    public KafkaBrokerStopTask(Logger logger, @Input(value="broker") EmbeddedKafkaBroker broker) {
        this.logger = logger;
        this.broker = broker;
    }

    public List<String> validateInputs() {
        Validator embeddedKafkaBrokerValidation = Validator.of((Object)this.broker).validate(Objects::nonNull, "No broker provided");
        return Validator.getErrorsFrom((Validator[])new Validator[]{embeddedKafkaBrokerValidation});
    }

    public TaskExecutionResult execute() {
        this.logger.info("Call Kafka broker shutdown");
        this.broker.destroy();
        return TaskExecutionResult.ok();
    }
}

