/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.task.jms.consumer;

import com.chutneytesting.task.spi.injectable.Input;
import com.chutneytesting.task.spi.validation.TaskValidatorsUtils;
import com.chutneytesting.task.spi.validation.Validator;
import java.util.Optional;

public class JmsListenerParameters {
    private static final String DESTINATION = "destination";
    private static final String MESSAGE_SELECTOR = "selector";
    private static final String MESSAGE_BODY_SELECTOR = "bodySelector";
    private static final String BROWSER_MAX_DEPTH = "browserMaxDepth";
    private static final int DEFAULT_BROWSER_MAX_DEPTH = 30;
    private static final String TIMEOUT = "timeOut";
    private static final String DEFAULT_TIMEOUT = "500 ms";
    public final String destination;
    public final String selector;
    public final String bodySelector;
    public final Integer browserMaxDepth;
    public final String timeout;

    public JmsListenerParameters(@Input(value="destination") String destination, @Input(value="selector") String selector, @Input(value="bodySelector") String bodySelector, @Input(value="browserMaxDepth") Integer browserMaxDepth, @Input(value="timeOut") String timeout) {
        this.destination = destination;
        this.selector = selector;
        this.bodySelector = bodySelector;
        this.browserMaxDepth = Optional.ofNullable(browserMaxDepth).orElse(30);
        this.timeout = Optional.ofNullable(timeout).orElse(DEFAULT_TIMEOUT);
    }

    public static Validator[] validateJmsListenerParameters(JmsListenerParameters listenerJmsParameters) {
        return new Validator[]{TaskValidatorsUtils.notBlankStringValidation((String)listenerJmsParameters.destination, (String)DESTINATION), TaskValidatorsUtils.durationValidation((String)listenerJmsParameters.timeout, (String)"timeout")};
    }
}

