/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.task.jms;

import com.chutneytesting.task.spi.FinallyAction;
import com.chutneytesting.task.spi.Task;
import com.chutneytesting.task.spi.TaskExecutionResult;
import com.chutneytesting.task.spi.injectable.FinallyActionRegistry;
import com.chutneytesting.task.spi.injectable.Input;
import com.chutneytesting.task.spi.injectable.Logger;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.activemq.broker.BrokerFactory;
import org.apache.activemq.broker.BrokerService;

public class JmsBrokerStartTask
implements Task {
    private final Logger logger;
    private final FinallyActionRegistry finallyActionRegistry;
    private final String configurationUri;

    public JmsBrokerStartTask(Logger logger, FinallyActionRegistry finallyActionRegistry, @Input(value="config-uri") String configUri) {
        this.logger = logger;
        this.finallyActionRegistry = finallyActionRegistry;
        this.configurationUri = Optional.ofNullable(configUri).orElseGet(this::defaultConfiguration);
    }

    public TaskExecutionResult execute() {
        try {
            BrokerService brokerService = BrokerFactory.createBroker((String)this.configurationUri);
            this.logger.info("Try to start jms broker");
            brokerService.start();
            this.createQuitFinallyAction(brokerService);
            return TaskExecutionResult.ok(this.toOutputs(brokerService));
        }
        catch (Exception e) {
            this.logger.error((Throwable)e);
            return TaskExecutionResult.ko();
        }
    }

    private String defaultConfiguration() {
        return "broker:(tcp://localhost:61616)?useJmx=false&persistent=false";
    }

    private Map<String, Object> toOutputs(BrokerService brokerService) {
        HashMap<String, Object> outputs = new HashMap<String, Object>();
        outputs.put("jmsBrokerService", brokerService);
        return outputs;
    }

    private void createQuitFinallyAction(BrokerService brokerService) {
        this.finallyActionRegistry.registerFinallyAction(FinallyAction.Builder.forAction((String)"jms-broker-stop", JmsBrokerStartTask.class).withInput("jms-broker-service", (Object)brokerService).build());
        this.logger.info("JmsBrokerStop finally action registered");
    }
}

