/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.task.http;

import com.chutneytesting.task.spi.FinallyAction;
import com.chutneytesting.task.spi.Task;
import com.chutneytesting.task.spi.TaskExecutionResult;
import com.chutneytesting.task.spi.injectable.FinallyActionRegistry;
import com.chutneytesting.task.spi.injectable.Input;
import com.chutneytesting.task.spi.injectable.Logger;
import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.math.NumberUtils;

public class HttpsServerStartTask
implements Task {
    private static final int DEFAULT_HTTPS_PORT = 8443;
    private final Logger logger;
    private final FinallyActionRegistry finallyActionRegistry;
    private final int port;
    private final Optional<String> trustStorePath;
    private final Optional<String> trustStorePassword;
    private final Optional<String> keyStorePath;
    private final Optional<String> keyStorePassword;
    private final Optional<String> keyPassword;

    public HttpsServerStartTask(Logger logger, FinallyActionRegistry finallyActionRegistry, @Input(value="port") String port, @Input(value="truststore-path") String trustStorePath, @Input(value="truststore-password") String trustStorePassword, @Input(value="keystore-path") String keyStorePath, @Input(value="keystore-password") String keyStorePassword, @Input(value="key-password") String keyPassword) {
        this.logger = logger;
        this.finallyActionRegistry = finallyActionRegistry;
        this.port = NumberUtils.toInt((String)port, (int)8443);
        this.trustStorePath = Optional.ofNullable(trustStorePath);
        this.trustStorePassword = Optional.ofNullable(trustStorePassword);
        this.keyStorePath = Optional.ofNullable(keyStorePath);
        this.keyStorePassword = Optional.ofNullable(keyStorePassword);
        this.keyPassword = Optional.ofNullable(keyPassword);
    }

    public TaskExecutionResult execute() {
        WireMockConfiguration wireMockConfiguration = WireMockConfiguration.wireMockConfig().dynamicPort().httpsPort(Integer.valueOf(this.port)).containerThreads(Integer.valueOf(7)).asynchronousResponseThreads(1).jettyAcceptors(Integer.valueOf(1));
        this.trustStorePath.ifPresent(ts -> wireMockConfiguration.needClientAuth(true).trustStorePath(this.trustStorePath.orElse("")).trustStorePassword(this.trustStorePassword.orElse("")));
        this.keyStorePath.ifPresent(s -> wireMockConfiguration.keystorePath(s).keystorePassword(this.keyStorePassword.orElse("")).keyManagerPassword(this.keyPassword.orElse("")));
        WireMockServer wireMockServer = new WireMockServer((Options)wireMockConfiguration);
        this.logger.info("Try to start https server on port " + this.port);
        wireMockServer.start();
        wireMockServer.stubFor(WireMock.any((UrlPattern)WireMock.anyUrl()).willReturn(WireMock.aResponse().withStatus(200)));
        this.createQuitFinallyAction(wireMockServer);
        return TaskExecutionResult.ok(this.toOutputs(wireMockServer));
    }

    private Map<String, Object> toOutputs(WireMockServer httpsServer) {
        HashMap<String, Object> outputs = new HashMap<String, Object>();
        outputs.put("httpsServer", httpsServer);
        return outputs;
    }

    private void createQuitFinallyAction(WireMockServer httpsServer) {
        this.finallyActionRegistry.registerFinallyAction(FinallyAction.Builder.forAction((String)"https-server-stop", HttpsServerStartTask.class).withInput("https-server", (Object)httpsServer).build());
        this.logger.info("HttpsServerStop finally action registered");
    }
}

