/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.task.context;

import com.chutneytesting.task.spi.FinallyAction;
import com.chutneytesting.task.spi.Task;
import com.chutneytesting.task.spi.TaskExecutionResult;
import com.chutneytesting.task.spi.injectable.FinallyActionRegistry;
import com.chutneytesting.task.spi.injectable.Input;
import com.chutneytesting.task.spi.injectable.Logger;
import com.chutneytesting.task.spi.injectable.Target;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class FinalTask
implements Task {
    private final Logger logger;
    private final FinallyActionRegistry finallyActionRegistry;
    private final String type;
    private final String name;
    private final Target target;
    private final Map<String, Object> inputs;
    private Map<String, Object> validations;
    private final String strategyType;
    private final Map<String, Object> strategyProperties;

    public FinalTask(Logger logger, FinallyActionRegistry finallyActionRegistry, @Input(value="type") String type, @Input(value="name") String name, Target target, @Input(value="inputs") Map<String, Object> inputs, @Input(value="validations") Map<String, Object> validations, @Input(value="strategy-type") String strategyType, @Input(value="strategy-properties") Map<String, Object> strategyProperties) {
        this.logger = logger;
        this.finallyActionRegistry = finallyActionRegistry;
        this.type = Objects.requireNonNull(type, "type is mandatory");
        this.name = Objects.requireNonNull(name, "name is mandatory");
        this.target = target;
        this.inputs = inputs;
        this.validations = validations;
        this.strategyType = strategyType;
        this.strategyProperties = strategyProperties;
    }

    public TaskExecutionResult execute() {
        FinallyAction.Builder finallyActionBuilder = FinallyAction.Builder.forAction((String)this.type, (String)this.name);
        Optional.ofNullable(this.target).ifPresent(arg_0 -> ((FinallyAction.Builder)finallyActionBuilder).withTarget(arg_0));
        Optional.ofNullable(this.inputs).map(Map::entrySet).ifPresent(entries -> entries.forEach(e -> finallyActionBuilder.withInput((String)e.getKey(), e.getValue())));
        Optional.ofNullable(this.validations).map(Map::entrySet).ifPresent(entries -> entries.forEach(e -> finallyActionBuilder.withValidation((String)e.getKey(), e.getValue())));
        Optional.ofNullable(this.strategyType).ifPresent(st -> {
            finallyActionBuilder.withStrategyType(st);
            Optional.ofNullable(this.strategyProperties).ifPresent(arg_0 -> ((FinallyAction.Builder)finallyActionBuilder).withStrategyProperties(arg_0));
        });
        this.finallyActionRegistry.registerFinallyAction(finallyActionBuilder.build());
        this.logger.info(this.name + " (" + this.type + ") as finally action registered");
        return TaskExecutionResult.ok();
    }
}

