/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.task.assertion.placeholder;

import com.chutneytesting.task.assertion.placeholder.PlaceholderAsserter;
import com.chutneytesting.task.common.JsonUtils;
import com.chutneytesting.task.spi.injectable.Logger;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;

public class LenientEqualAsserter
implements PlaceholderAsserter {
    private static final String IS_LENIENT_EQUAL = "$lenientEqual:";

    @Override
    public boolean canApply(String value) {
        return value.startsWith(IS_LENIENT_EQUAL);
    }

    @Override
    public boolean assertValue(Logger logger, Object actual, Object expected) {
        String expect = expected.toString().substring(IS_LENIENT_EQUAL.length());
        Object expectedRead = JsonPath.parse((String)expect).read("$", new Predicate[0]);
        return JsonUtils.lenientEqual(actual, expectedRead, true);
    }
}

