/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.task.assertion;

import com.chutneytesting.task.spi.Task;
import com.chutneytesting.task.spi.TaskExecutionResult;
import com.chutneytesting.task.spi.injectable.Input;
import com.chutneytesting.task.spi.injectable.Logger;
import com.chutneytesting.task.spi.validation.Validator;
import java.util.List;
import java.util.Objects;
import org.everit.json.schema.Schema;
import org.everit.json.schema.ValidationException;
import org.everit.json.schema.loader.SchemaLoader;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class JsonValidationTask
implements Task {
    private final String json;
    private final String schema;
    private final Logger logger;

    public JsonValidationTask(Logger logger, @Input(value="json") String json, @Input(value="schema") String schema) {
        this.logger = logger;
        this.json = json;
        this.schema = schema;
    }

    public List<String> validateInputs() {
        Validator jsonValidation = Validator.of((Object)this.json).validate(Objects::nonNull, "No json provided").validate(j -> new JSONObject(new JSONTokener(j)), noException -> true, "Cannot parse json");
        Validator schemaValidation = Validator.of((Object)this.schema).validate(Objects::nonNull, "No schema provided").validate(s -> new JSONObject(new JSONTokener(s)), noException -> true, "Cannot parse schema");
        return Validator.getErrorsFrom((Validator[])new Validator[]{jsonValidation, schemaValidation});
    }

    public TaskExecutionResult execute() {
        try {
            JSONObject schemaJson = new JSONObject(new JSONTokener(this.schema));
            JSONObject document = new JSONObject(new JSONTokener(this.json));
            Schema createdSchema = SchemaLoader.load((JSONObject)schemaJson);
            createdSchema.validate((Object)document);
        }
        catch (ValidationException validationException) {
            validationException.getAllMessages().forEach(message -> this.logger.error(message));
            return TaskExecutionResult.ko();
        }
        catch (JSONException jsonException) {
            this.logger.error("Exception: " + jsonException.getMessage());
            return TaskExecutionResult.ko();
        }
        return TaskExecutionResult.ok();
    }
}

