/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.task.amqp;

import com.chutneytesting.task.common.SecurityUtils;
import com.chutneytesting.task.spi.injectable.Target;
import com.rabbitmq.client.Address;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import java.io.IOException;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.util.Optional;
import java.util.concurrent.TimeoutException;
import java.util.function.Predicate;
import javax.net.ssl.SSLContext;

public class ConnectionFactoryFactory {
    private final ConnectionFactory connectionFactory;

    ConnectionFactoryFactory() {
        this.connectionFactory = new ConnectionFactory();
    }

    ConnectionFactoryFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public Connection newConnection(Target target) throws IOException, TimeoutException {
        try {
            if ("amqps".equalsIgnoreCase(target.uri().getScheme())) {
                SSLContext sslContext = SecurityUtils.buildSslContext(target).build();
                this.connectionFactory.useSslProtocol(sslContext);
            }
        }
        catch (GeneralSecurityException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        target.user().ifPresent(arg_0 -> ((ConnectionFactory)this.connectionFactory).setUsername(arg_0));
        target.userPassword().ifPresent(arg_0 -> ((ConnectionFactory)this.connectionFactory).setPassword(arg_0));
        Optional<String> singleHost = Optional.ofNullable(target.host());
        Optional amqpAddresses = target.property("addresses");
        if (singleHost.isPresent() && amqpAddresses.isEmpty()) {
            try {
                this.connectionFactory.setUri(target.uri());
            }
            catch (URISyntaxException | GeneralSecurityException e) {
                throw new IllegalArgumentException(e.getMessage(), e);
            }
            return this.connectionFactory.newConnection();
        }
        Address[] adresses = Address.parseAddresses((String)amqpAddresses.filter(Predicate.not(String::isBlank)).orElseGet(() -> target.uri().getAuthority()));
        return this.connectionFactory.newConnection(adresses);
    }
}

