/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.task.ssh;

import com.chutneytesting.task.spi.injectable.Target;
import com.chutneytesting.task.ssh.Connection;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.client.auth.UserAuthFactory;
import org.apache.sshd.client.auth.password.UserAuthPasswordFactory;
import org.apache.sshd.client.auth.pubkey.UserAuthPublicKeyFactory;
import org.apache.sshd.client.future.ConnectFuture;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.config.keys.FilePasswordProvider;
import org.apache.sshd.common.keyprovider.FileKeyPairProvider;
import org.apache.sshd.common.keyprovider.KeyIdentityProvider;

public class SshClientFactory {
    public static String DEFAULT_TIMEOUT = "5 s";

    public static ClientSession buildSSHClientSession(Target target, long timeout) throws IOException {
        Connection connection = Connection.from(target);
        SshClient defaultClient = SshClientFactory.createDefaultClient();
        defaultClient.setUserAuthFactories(SshClientFactory.getAuthFactory(connection));
        ClientSession session = SshClientFactory.getConnectedSession(defaultClient, connection);
        session.auth().verify(timeout);
        return session;
    }

    private static SshClient createDefaultClient() {
        SshClient defaultClient = SshClient.setUpDefaultClient();
        defaultClient.start();
        return defaultClient;
    }

    private static List<UserAuthFactory> getAuthFactory(Connection connection) {
        if (connection.usePrivateKey()) {
            return Collections.singletonList(UserAuthPublicKeyFactory.INSTANCE);
        }
        return Collections.singletonList(UserAuthPasswordFactory.INSTANCE);
    }

    private static ClientSession getConnectedSession(SshClient client, Connection connection) throws IOException {
        ConnectFuture connectFuture = (ConnectFuture)client.connect(connection.username, connection.serverHost, connection.serverPort).verify();
        return SshClientFactory.configureSessionAuthMethod((ClientSession)connectFuture.getSession(), connection);
    }

    private static ClientSession configureSessionAuthMethod(ClientSession session, Connection connection) {
        if (connection.usePrivateKey()) {
            FileKeyPairProvider provider = new FileKeyPairProvider(new File(connection.privateKey).toPath());
            provider.setPasswordFinder(FilePasswordProvider.of((String)connection.passphrase));
            session.setKeyIdentityProvider((KeyIdentityProvider)provider);
        } else {
            session.addPasswordIdentity(connection.password);
        }
        return session;
    }
}

