/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.task.amqp;

import com.chutneytesting.task.amqp.ConnectionFactoryFactory;
import com.chutneytesting.task.spi.FinallyAction;
import com.chutneytesting.task.spi.Task;
import com.chutneytesting.task.spi.TaskExecutionResult;
import com.chutneytesting.task.spi.injectable.FinallyActionRegistry;
import com.chutneytesting.task.spi.injectable.Input;
import com.chutneytesting.task.spi.injectable.Logger;
import com.chutneytesting.task.spi.injectable.Target;
import com.chutneytesting.task.spi.validation.TaskValidatorsUtils;
import com.chutneytesting.task.spi.validation.Validator;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeoutException;

public class AmqpCreateBoundTemporaryQueueTask
implements Task {
    private final ConnectionFactoryFactory connectionFactoryFactory = new ConnectionFactoryFactory();
    private final Target target;
    private final String exchangeName;
    private final String routingKey;
    private final String queueName;
    private final Logger logger;
    private final FinallyActionRegistry finallyActionRegistry;

    public AmqpCreateBoundTemporaryQueueTask(Target target, @Input(value="exchange-name") String exchangeName, @Input(value="routing-key") String routingKey, @Input(value="queue-name") String queueName, Logger logger, FinallyActionRegistry finallyActionRegistry) {
        this.target = target;
        this.exchangeName = exchangeName;
        this.routingKey = routingKey;
        this.queueName = queueName;
        this.logger = logger;
        this.finallyActionRegistry = finallyActionRegistry;
    }

    public List<String> validateInputs() {
        return Validator.getErrorsFrom((Validator[])new Validator[]{TaskValidatorsUtils.notBlankStringValidation((String)this.queueName, (String)"queue-name"), TaskValidatorsUtils.notBlankStringValidation((String)this.queueName, (String)"exchange-name"), TaskValidatorsUtils.targetValidation((Target)this.target)});
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public TaskExecutionResult execute() {
        try (Connection connection = this.connectionFactoryFactory.newConnection(this.target);){
            TaskExecutionResult taskExecutionResult;
            block14: {
                Channel channel = connection.createChannel();
                try {
                    this.createQueue(this.queueName, channel);
                    this.bindQueue(channel, this.queueName);
                    this.createQuitFinallyActions();
                    taskExecutionResult = TaskExecutionResult.ok(Collections.singletonMap("queueName", this.queueName));
                    if (channel == null) break block14;
                }
                catch (Throwable throwable) {
                    if (channel != null) {
                        try {
                            channel.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                channel.close();
            }
            return taskExecutionResult;
        }
        catch (IOException | TimeoutException e) {
            this.logger.error("Unable to establish connection to RabbitMQ: " + e.getMessage());
            return TaskExecutionResult.ko();
        }
    }

    private void bindQueue(Channel channel, String queueName) throws IOException {
        String routingKey = Optional.ofNullable(this.routingKey).orElse(queueName);
        channel.queueBind(queueName, this.exchangeName, routingKey);
        this.logger.info("Created AMQP binding " + this.exchangeName + " (with " + this.routingKey + ") -> " + queueName);
    }

    private void createQueue(String queueName, Channel channel) throws IOException {
        channel.queueDeclare(queueName, true, false, false, null);
        this.logger.info("Created AMQP Queue with name: " + queueName);
    }

    private void createQuitFinallyActions() {
        this.finallyActionRegistry.registerFinallyAction(FinallyAction.Builder.forAction((String)"amqp-unbind-queue", AmqpCreateBoundTemporaryQueueTask.class).withTarget(this.target).withInput("queue-name", (Object)this.queueName).withInput("exchange-name", (Object)this.exchangeName).withInput("routing-key", (Object)this.routingKey).build());
        this.logger.info("Registered unbinding queue finally action");
        this.finallyActionRegistry.registerFinallyAction(FinallyAction.Builder.forAction((String)"amqp-delete-queue", (String)AmqpCreateBoundTemporaryQueueTask.class.getSimpleName()).withTarget(this.target).withInput("queue-name", (Object)this.queueName).build());
        this.logger.info("Registered delete queue finally action");
    }
}

