/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.task.mongo;

import com.chutneytesting.task.mongo.DefaultMongoDatabaseFactory;
import com.chutneytesting.task.mongo.MongoDatabaseFactory;
import com.chutneytesting.task.spi.Task;
import com.chutneytesting.task.spi.TaskExecutionResult;
import com.chutneytesting.task.spi.injectable.Input;
import com.chutneytesting.task.spi.injectable.Logger;
import com.chutneytesting.task.spi.injectable.Target;
import com.chutneytesting.tools.CloseableResource;
import com.mongodb.client.MongoDatabase;
import java.util.Collections;
import org.bson.BsonDocument;
import org.bson.conversions.Bson;

public class MongoCountTask
implements Task {
    private final MongoDatabaseFactory mongoDatabaseFactory = new DefaultMongoDatabaseFactory();
    private final Target target;
    private final Logger logger;
    private final String collection;
    private final String query;

    public MongoCountTask(Target target, Logger logger, @Input(value="collection") String collection, @Input(value="query") String query) {
        this.target = target;
        this.logger = logger;
        this.collection = collection;
        this.query = query;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TaskExecutionResult execute() {
        try (CloseableResource<MongoDatabase> database = this.mongoDatabaseFactory.create(this.target);){
            long count = ((MongoDatabase)database.getResource()).getCollection(this.collection).countDocuments((Bson)BsonDocument.parse((String)this.query));
            this.logger.info("Found " + count + " objects matching query:\n\t" + this.query.replace("\n", "\n\t"));
            TaskExecutionResult taskExecutionResult = TaskExecutionResult.ok(Collections.singletonMap("count", count));
            return taskExecutionResult;
        }
        catch (IllegalArgumentException e) {
            this.logger.error(e.getMessage());
            return TaskExecutionResult.ko();
        }
    }
}

