/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.task.micrometer;

import com.chutneytesting.task.micrometer.MicrometerTaskHelper;
import com.chutneytesting.task.spi.Task;
import com.chutneytesting.task.spi.TaskExecutionResult;
import com.chutneytesting.task.spi.injectable.Input;
import com.chutneytesting.task.spi.injectable.Logger;
import com.chutneytesting.tools.Try;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class MicrometerGaugeTask
implements Task {
    protected static final String OUTPUT_GAUGE = "micrometerGaugeObject";
    private final Logger logger;
    private final String name;
    private final String description;
    private final String unit;
    private final List<String> tags;
    private final Object gaugeObject;
    private final String gaugeFunction;
    private final MeterRegistry registry;
    private boolean strongReference;

    public MicrometerGaugeTask(Logger logger, @Input(value="name") String name, @Input(value="description") String description, @Input(value="unit") String unit, @Input(value="strongReference") Boolean strongReference, @Input(value="tags") List<String> tags, @Input(value="gaugeObject") Object gaugeObject, @Input(value="gaugeFunction") String gaugeFunction, @Input(value="registry") MeterRegistry registry) {
        this.logger = logger;
        this.name = Objects.requireNonNull(name);
        this.description = description;
        this.unit = unit;
        this.strongReference = Optional.ofNullable(strongReference).orElse(Boolean.FALSE);
        this.tags = tags;
        if (gaugeObject == null && gaugeFunction == null) {
            throw new IllegalArgumentException("gaugeObject and gaugeFunction cannot be both null");
        }
        this.gaugeObject = gaugeObject;
        this.gaugeFunction = gaugeFunction;
        this.registry = registry;
    }

    public TaskExecutionResult execute() {
        try {
            Gauge gauge = this.retrieveGauge(this.registry);
            this.logger.info("Gauge current value is " + gauge.value());
            return TaskExecutionResult.ok(MicrometerTaskHelper.toOutputs(OUTPUT_GAUGE, this.gaugeObject));
        }
        catch (Exception e) {
            this.logger.error((Throwable)e);
            return TaskExecutionResult.ko();
        }
    }

    private Gauge retrieveGauge(MeterRegistry registry) {
        MeterRegistry registryToUse = MicrometerTaskHelper.checkRegistry(registry);
        Gauge.Builder builder = this.createGaugeBuilder().description(this.description).strongReference(this.strongReference).baseUnit(this.unit);
        Optional.ofNullable(this.tags).ifPresent(t -> builder.tags(t.toArray(new String[0])));
        return builder.register(registryToUse);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Gauge.Builder<?> createGaugeBuilder() {
        if (this.gaugeObject != null && this.gaugeFunction == null) {
            if (this.gaugeObject instanceof Number) {
                return Gauge.builder((String)this.name, (Object)((Number)this.gaugeObject), Number::doubleValue);
            }
            if (this.gaugeObject instanceof Collection) {
                return Gauge.builder((String)this.name, (Object)((Collection)this.gaugeObject), Collection::size);
            }
            if (!(this.gaugeObject instanceof Map)) throw new IllegalArgumentException("gaugeObject must be a Number, a Collection or a Map if no gaugeFunction supplied");
            return Gauge.builder((String)this.name, (Object)((Map)this.gaugeObject), Map::size);
        }
        if (this.gaugeObject != null) {
            Method method = this.retrieveMethod(this.gaugeFunction, this.gaugeObject.getClass());
            return Gauge.builder((String)this.name, (Object)this.gaugeObject, o -> {
                try {
                    return ((Number)method.invoke(o, new Object[0])).doubleValue();
                }
                catch (Exception e) {
                    return Double.MIN_VALUE;
                }
            });
        }
        Method method = this.retrieveMethod(this.gaugeFunction, null);
        return Gauge.builder((String)this.name, () -> {
            try {
                return ((Number)method.invoke(null, new Object[0])).doubleValue();
            }
            catch (Exception e) {
                return Double.MIN_VALUE;
            }
        });
    }

    private Method retrieveMethod(String methodPath, Class clazz) {
        if (clazz == null && !methodPath.contains(".")) {
            throw new IllegalArgumentException("Method " + methodPath + " cannot be resolved");
        }
        Class methodClass = clazz;
        String methodName = methodPath;
        if (methodClass == null) {
            methodClass = (Class)Try.unsafe(() -> Class.forName(methodPath.substring(0, methodPath.lastIndexOf("."))));
        }
        String finalMethodName = methodName = methodPath.substring(methodPath.lastIndexOf(".") + 1);
        Class finalMethodClass = methodClass;
        Method method = Arrays.stream(Objects.requireNonNull(methodClass).getMethods()).filter(m -> m.getName().equals(finalMethodName)).findFirst().orElseThrow(() -> new IllegalArgumentException("Cannot find method " + finalMethodName + " in class " + finalMethodClass));
        if (this.gaugeObject == null && !Modifier.isStatic(method.getModifiers())) {
            throw new IllegalArgumentException("Method " + finalMethodName + " must be static");
        }
        if (method.getParameterTypes().length != 0) {
            throw new IllegalArgumentException("Method " + finalMethodName + " must not have parameters");
        }
        Class<Number> returnType = method.getReturnType();
        if (!(returnType.isAssignableFrom(Number.class) || returnType.isPrimitive() && Arrays.asList("int", "long", "float", "double").contains(returnType.getName()))) {
            throw new IllegalArgumentException("Method " + finalMethodName + " must return a Number");
        }
        return method;
    }
}

