/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.task.mongo;

import com.chutneytesting.task.mongo.DefaultMongoDatabaseFactory;
import com.chutneytesting.task.mongo.MongoDatabaseFactory;
import com.chutneytesting.task.spi.Task;
import com.chutneytesting.task.spi.TaskExecutionResult;
import com.chutneytesting.task.spi.injectable.Input;
import com.chutneytesting.task.spi.injectable.Logger;
import com.chutneytesting.task.spi.injectable.Target;
import com.chutneytesting.tools.CloseableResource;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.MongoIterable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import org.bson.BsonDocument;
import org.bson.Document;
import org.bson.conversions.Bson;

public class MongoFindTask
implements Task {
    private final MongoDatabaseFactory mongoDatabaseFactory = new DefaultMongoDatabaseFactory();
    private final Target target;
    private final Logger logger;
    private final String collection;
    private final String query;
    private final Integer limit;

    public MongoFindTask(Target target, Logger logger, @Input(value="collection") String collection, @Input(value="query") String query, @Input(value="limit") Integer limit) {
        this.target = target;
        this.logger = logger;
        this.collection = collection;
        this.query = query;
        this.limit = limit;
    }

    public TaskExecutionResult execute() {
        TaskExecutionResult taskExecutionResult;
        block8: {
            CloseableResource<MongoDatabase> database = this.mongoDatabaseFactory.create(this.target);
            try {
                MongoIterable documents = ((MongoDatabase)database.getResource()).getCollection(this.collection).find((Bson)BsonDocument.parse((String)this.query)).limit(Optional.ofNullable(this.limit).orElse(20).intValue()).map(Document::toJson);
                ArrayList documentList = new ArrayList();
                documents.iterator().forEachRemaining(documentList::add);
                this.logger.info("Found " + documentList.size() + " document(s)");
                taskExecutionResult = TaskExecutionResult.ok(Collections.singletonMap("documents", documentList));
                if (database == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (database != null) {
                        try {
                            database.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IllegalArgumentException e) {
                    this.logger.error(e.getMessage());
                    return TaskExecutionResult.ko();
                }
            }
            database.close();
        }
        return taskExecutionResult;
    }
}

