/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.task.mongo;

import com.chutneytesting.task.mongo.MongoDatabaseFactory;
import com.chutneytesting.task.spi.injectable.SecurityInfo;
import com.chutneytesting.task.spi.injectable.Target;
import com.chutneytesting.tools.CloseableResource;
import com.mongodb.MongoClient;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import com.mongodb.client.MongoDatabase;
import java.util.Collections;
import org.springframework.util.StringUtils;

public class DefaultMongoDatabaseFactory
implements MongoDatabaseFactory {
    @Override
    public CloseableResource<MongoDatabase> create(Target target) throws IllegalArgumentException {
        MongoClient mongoClient;
        String databaseName = (String)target.properties().get("databaseName");
        if (StringUtils.isEmpty((Object)databaseName)) {
            throw new IllegalArgumentException("Missing Target property 'databaseName'");
        }
        ServerAddress serverAddress = new ServerAddress(target.getUrlAsURI().getHost(), target.getUrlAsURI().getPort());
        if (target.security().credential().isPresent()) {
            MongoCredential credential = MongoCredential.createCredential((String)((SecurityInfo.Credential)target.security().credential().get()).username(), (String)databaseName, (char[])((SecurityInfo.Credential)target.security().credential().get()).password().toCharArray());
            mongoClient = new MongoClient(serverAddress, Collections.singletonList(credential));
        } else {
            mongoClient = new MongoClient(serverAddress);
        }
        return CloseableResource.build((Object)mongoClient.getDatabase(databaseName), () -> ((MongoClient)mongoClient).close());
    }
}

