/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.task.assertion;

import com.chutneytesting.task.assertion.json.JsonUtils;
import com.chutneytesting.task.spi.Task;
import com.chutneytesting.task.spi.TaskExecutionResult;
import com.chutneytesting.task.spi.injectable.Input;
import com.chutneytesting.task.spi.injectable.Logger;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.JsonPathException;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.ReadContext;
import java.util.Map;

public class JsonCompareTask
implements Task {
    private final Logger logger;
    private final String document1;
    private final String document2;
    private final Map<String, String> comparingPaths;

    public JsonCompareTask(Logger logger, @Input(value="document1") String document1, @Input(value="document2") String document2, @Input(value="comparingPaths") Map<String, String> comparingPaths) {
        this.checkInputs(document1, document2, comparingPaths);
        this.logger = logger;
        this.document1 = JsonUtils.jsonStringify(document1);
        this.document2 = JsonUtils.jsonStringify(document2);
        this.comparingPaths = comparingPaths;
    }

    private void checkInputs(String doc1, String doc2, Map<String, String> comparingPaths) throws IllegalStateException {
        if (doc1 == null) {
            this.logger.error("'document1' argument is required");
            throw new IllegalStateException("'document1' argument is required");
        }
        if (doc2 == null) {
            this.logger.error("'document2' argument is required");
            throw new IllegalStateException("'document2' argument is required");
        }
        if (comparingPaths == null || comparingPaths.isEmpty()) {
            this.logger.error("'comparingPaths' argument is required");
            throw new IllegalStateException("'comparingPaths' argument is required");
        }
    }

    public TaskExecutionResult execute() {
        DocumentContext doc1 = JsonPath.parse((String)this.document1);
        DocumentContext doc2 = JsonPath.parse((String)this.document2);
        boolean matchesOk = this.comparingPaths.entrySet().stream().allMatch(arg_0 -> this.lambda$execute$0((ReadContext)doc1, (ReadContext)doc2, arg_0));
        if (!matchesOk) {
            return TaskExecutionResult.ko();
        }
        return TaskExecutionResult.ok();
    }

    private /* synthetic */ boolean lambda$execute$0(ReadContext doc1, ReadContext doc2, Map.Entry cp) {
        boolean result = false;
        try {
            Object read1 = doc1.read((String)cp.getKey(), new Predicate[0]);
            Object read2 = doc2.read((String)cp.getValue(), new Predicate[0]);
            result = read1.equals(read2);
            if (!result) {
                this.logger.error("Value [" + read1 + "] at path [" + (String)cp.getKey() + "] is not equal to value [" + read2 + "] at path [" + (String)cp.getValue() + "]");
            } else {
                this.logger.info(read1.toString());
                this.logger.info(read2.toString());
            }
        }
        catch (JsonPathException ex) {
            this.logger.error(ex.getMessage());
        }
        return result;
    }
}

