/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.task.selenium;

import com.chutneytesting.task.selenium.SeleniumFindBehavior;
import com.chutneytesting.task.selenium.SeleniumTask;
import com.chutneytesting.task.spi.TaskExecutionResult;
import com.chutneytesting.task.spi.injectable.Input;
import com.chutneytesting.task.spi.injectable.Logger;
import java.util.Optional;
import java.util.function.Function;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedConditions;

public class SeleniumClickTask
extends SeleniumTask
implements SeleniumFindBehavior {
    private final String selector;
    private final String by;
    private final Integer wait;

    public SeleniumClickTask(Logger logger, @Input(value="web-driver") WebDriver webDriver, @Input(value="selector") String selector, @Input(value="by") String by, @Input(value="wait") Integer wait) {
        super(logger, webDriver);
        this.selector = selector;
        this.by = by;
        this.wait = wait;
    }

    @Override
    public TaskExecutionResult executeSeleniumTask() {
        Optional webElement = this.findElement(this.logger, this.webDriver, this.selector, this.by, this.wait);
        if (webElement.isPresent()) {
            try {
                ((WebElement)webElement.get()).click();
            }
            catch (Exception e) {
                this.logger.error("Simple click failed, try JS click");
                try {
                    ((JavascriptExecutor)this.webDriver).executeScript("arguments[0].click();", new Object[]{webElement.get()});
                }
                catch (ClassCastException cc) {
                    this.logger.error("WebDriver cannot execute JS scripts");
                    return TaskExecutionResult.ko();
                }
            }
            this.logger.info("Click on element : " + webElement.get());
            return TaskExecutionResult.ok();
        }
        this.takeScreenShot();
        this.logger.error("Cannot retrieve element to click.");
        return TaskExecutionResult.ko();
    }

    @Override
    public Function<WebDriver, WebElement> findExpectation(By by) {
        return ExpectedConditions.elementToBeClickable((By)by);
    }
}

