/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.task.sql.core;

import com.chutneytesting.task.sql.core.Records;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SqlClient {
    private final HikariDataSource dataSource;

    public SqlClient(HikariDataSource dataSource) {
        this.dataSource = dataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Records execute(String query) throws SQLException {
        Records records;
        Connection connection = null;
        try {
            connection = this.dataSource.getConnection();
            try (Statement statement = connection.createStatement();){
                statement.execute(query);
                records = StatementConverter.createRecords(statement);
            }
        }
        finally {
            this.silentClose(connection);
        }
        return records;
    }

    public void closeDatasource() {
        this.dataSource.close();
    }

    public Records emptyRecords() {
        return new Records(0, Collections.emptyList(), Collections.emptyList());
    }

    private void silentClose(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static class StatementConverter {
        private StatementConverter() {
        }

        private static Records createRecords(Statement statement) throws SQLException {
            int affectedRows = statement.getUpdateCount();
            List<String> headers = Collections.emptyList();
            List<List<Object>> rows = Collections.emptyList();
            if (StatementConverter.isSelectQuery(affectedRows)) {
                try (ResultSet rs = statement.getResultSet();){
                    ResultSetMetaData md = rs.getMetaData();
                    headers = StatementConverter.createHeaders(md, md.getColumnCount());
                    rows = StatementConverter.createRows(rs, md.getColumnCount());
                }
            }
            return new Records(affectedRows, headers, rows);
        }

        private static boolean isSelectQuery(int affectedRows) {
            return affectedRows == -1;
        }

        private static List<String> createHeaders(ResultSetMetaData md, int columnCount) throws SQLException {
            ArrayList<String> headers = new ArrayList<String>(columnCount);
            for (int i = 1; i <= columnCount; ++i) {
                headers.add(md.getColumnName(i));
            }
            return headers;
        }

        private static List<List<Object>> createRows(ResultSet rs, int columnCount) throws SQLException {
            ArrayList<List<Object>> rows = new ArrayList<List<Object>>();
            while (rs.next()) {
                ArrayList<Object> row = new ArrayList<Object>(columnCount);
                for (int i = 1; i <= columnCount; ++i) {
                    row.add(rs.getObject(i));
                }
                rows.add(row);
            }
            return rows;
        }
    }
}

