/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.task.mongo;

import com.chutneytesting.task.mongo.DefaultMongoDatabaseFactory;
import com.chutneytesting.task.mongo.MongoDatabaseFactory;
import com.chutneytesting.task.spi.Task;
import com.chutneytesting.task.spi.TaskExecutionResult;
import com.chutneytesting.task.spi.injectable.Input;
import com.chutneytesting.task.spi.injectable.Logger;
import com.chutneytesting.task.spi.injectable.Target;
import com.chutneytesting.tools.CloseableResource;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.result.DeleteResult;
import java.util.Collections;
import org.bson.BsonDocument;
import org.bson.conversions.Bson;

public class MongoDeleteTask
implements Task {
    private final MongoDatabaseFactory mongoDatabaseFactory = new DefaultMongoDatabaseFactory();
    private final Target target;
    private final Logger logger;
    private final String collection;
    private final String query;

    public MongoDeleteTask(Target target, Logger logger, @Input(value="collection") String collection, @Input(value="query") String query) {
        this.target = target;
        this.logger = logger;
        this.collection = collection;
        this.query = query;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TaskExecutionResult execute() {
        try (CloseableResource<MongoDatabase> database = this.mongoDatabaseFactory.create(this.target);){
            DeleteResult deleteResult = ((MongoDatabase)database.getResource()).getCollection(this.collection).deleteMany((Bson)BsonDocument.parse((String)this.query));
            if (!deleteResult.wasAcknowledged()) {
                this.logger.error("Deletion was not acknowledged");
                TaskExecutionResult taskExecutionResult2 = TaskExecutionResult.ko();
                return taskExecutionResult2;
            }
            long deletedCount = deleteResult.getDeletedCount();
            this.logger.info("Deleted " + deletedCount + " document(s)");
            TaskExecutionResult taskExecutionResult = TaskExecutionResult.ok(Collections.singletonMap("deletedCount", deletedCount));
            return taskExecutionResult;
        }
        catch (IllegalArgumentException e) {
            this.logger.error(e.getMessage());
            return TaskExecutionResult.ko();
        }
    }
}

