/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.task.assertion;

import com.chutneytesting.task.assertion.placeholder.PlaceholderAsserter;
import com.chutneytesting.task.assertion.placeholder.PlaceholderAsserterUtils;
import com.chutneytesting.task.assertion.xml.XmlUtils;
import com.chutneytesting.task.jms.domain.XmlContent;
import com.chutneytesting.task.spi.Task;
import com.chutneytesting.task.spi.TaskExecutionResult;
import com.chutneytesting.task.spi.injectable.Input;
import com.chutneytesting.task.spi.injectable.Logger;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jdom2.Attribute;
import org.jdom2.CDATA;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Text;
import org.jdom2.filter.ContentFilter;
import org.jdom2.filter.Filter;
import org.jdom2.input.SAXBuilder;
import org.jdom2.xpath.XPathExpression;

public class XmlAssertTask
implements Task {
    private final Logger logger;
    private final String documentAsString;
    private final Map<String, Object> xpathsAndExpectedResults;

    public XmlAssertTask(Logger logger, @Input(value="document") String documentAsString, @Input(value="expected") Map<String, Object> xpathsAndExpectedResults) {
        this.logger = logger;
        this.documentAsString = documentAsString;
        this.xpathsAndExpectedResults = xpathsAndExpectedResults;
    }

    public TaskExecutionResult execute() {
        try {
            SAXBuilder saxBuilder = new SAXBuilder();
            Document document = new XmlContent(saxBuilder, this.documentAsString).buildDocumentWithoutNamespaces();
            boolean assertTrue = true;
            for (Map.Entry<String, Object> xpathAndExpected : this.xpathsAndExpectedResults.entrySet()) {
                String xpath = xpathAndExpected.getKey();
                Object expected = xpathAndExpected.getValue();
                try {
                    assertTrue = assertTrue && this.assertXpathMatchExpectation(document, xpath, expected);
                }
                catch (XmlUtils.InvalidXPathException e) {
                    this.logger.error(e.getMessage());
                    return TaskExecutionResult.ko();
                }
            }
            return assertTrue ? TaskExecutionResult.ok() : TaskExecutionResult.ko();
        }
        catch (XmlContent.InvalidXmlDocumentException e) {
            this.logger.error(e.getMessage());
            return TaskExecutionResult.ko();
        }
    }

    private boolean assertXpathMatchExpectation(Document document, String xpath, Object expectedResult) throws XmlUtils.InvalidXPathException {
        XPathExpression<Object> xpathExpression = XmlUtils.compileXPath(xpath);
        String actualResult = this.convertEvaluationResultToString(xpathExpression.evaluateFirst((Object)document));
        Optional<PlaceholderAsserter> asserts = PlaceholderAsserterUtils.getAsserterMatching(expectedResult);
        if (asserts.isPresent()) {
            return asserts.get().assertValue(this.logger, actualResult, expectedResult);
        }
        if (String.valueOf(expectedResult).equals(actualResult)) {
            this.logger.info(xpath + " = " + actualResult);
            return true;
        }
        this.logger.error(xpath + " != " + expectedResult + " (found " + actualResult + ")");
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String convertEvaluationResultToString(Object evaluationResult) {
        if (evaluationResult == null) {
            return null;
        }
        if (evaluationResult instanceof Text) {
            return ((Text)evaluationResult).getText();
        }
        if (evaluationResult instanceof Element) {
            List contents = ((Element)evaluationResult).getContent(new ContentFilter(8).negate());
            List cdata = ((Element)evaluationResult).getContent((Filter)new ContentFilter(2));
            if (contents.size() == 1) {
                return this.convertEvaluationResultToString(contents.get(0));
            }
            if (cdata.size() == 1) {
                return ((CDATA)cdata.get(0)).getText();
            }
            if (contents.size() != 0) return "!!!MULTIPLE!";
            return null;
        }
        if (!(evaluationResult instanceof Attribute)) return String.valueOf(evaluationResult);
        return ((Attribute)evaluationResult).getValue();
    }
}

